/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx.skins;

import eu.hansolo.tilesfx.Tile;
import eu.hansolo.tilesfx.events.TileEvt;
import eu.hansolo.tilesfx.fonts.Fonts;
import eu.hansolo.tilesfx.skins.TileSkin;
import eu.hansolo.tilesfx.tools.Helper;
import eu.hansolo.toolbox.evt.EvtType;
import eu.hansolo.toolboxfx.geom.Bounds;
import eu.hansolo.toolboxfx.geom.CornerRadii;
import java.util.List;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.value.WritableValue;
import javafx.geometry.VPos;
import javafx.scene.CacheHint;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.TextAlignment;
import javafx.scene.transform.Rotate;
import javafx.util.Duration;

public class FlipTileSkin
extends TileSkin {
    private final TileEvt FLIP_FINISHED = new TileEvt((Object)this, (EvtType<? extends TileEvt>)TileEvt.FLIP_FINISHED);
    private List<String> characters;
    private int currentSelectionIndex;
    private int nextSelectionIndex;
    private double flapHeight;
    private Canvas upperBackground;
    private GraphicsContext upperBackgroundCtx;
    private Canvas upperBackgroundText;
    private GraphicsContext upperBackgroundTextCtx;
    private Canvas lowerBackground;
    private GraphicsContext lowerBackgroundCtx;
    private Canvas lowerBackgroundText;
    private GraphicsContext lowerBackgroundTextCtx;
    private Canvas flap;
    private GraphicsContext flapCtx;
    private Canvas flapTextFront;
    private GraphicsContext flapTextFrontCtx;
    private Canvas flapTextBack;
    private GraphicsContext flapTextBackCtx;
    private Rotate rotateFlap;
    private Font font;
    private double centerX;
    private double centerY;
    private Timeline timeline;

    public FlipTileSkin(Tile TILE) {
        super(TILE);
    }

    @Override
    protected void initGraphics() {
        super.initGraphics();
        this.timeline = new Timeline();
        this.characters = this.tile.getCharacterList();
        this.currentSelectionIndex = 0;
        this.nextSelectionIndex = 1;
        this.centerX = 125.0;
        this.centerY = 125.0;
        this.pane.setBackground(null);
        this.pane.setBorder(null);
        this.rotateFlap = new Rotate();
        this.rotateFlap.setAxis(Rotate.X_AXIS);
        this.rotateFlap.setAngle(0.0);
        this.flapHeight = 123.75;
        this.upperBackground = new Canvas(250.0, 123.75);
        this.upperBackgroundCtx = this.upperBackground.getGraphicsContext2D();
        this.upperBackgroundText = new Canvas(250.0, 123.75);
        this.upperBackgroundTextCtx = this.upperBackgroundText.getGraphicsContext2D();
        this.upperBackgroundTextCtx.setTextBaseline(VPos.CENTER);
        this.upperBackgroundTextCtx.setTextAlign(TextAlignment.CENTER);
        this.lowerBackground = new Canvas(250.0, 123.75);
        this.lowerBackgroundCtx = this.lowerBackground.getGraphicsContext2D();
        this.lowerBackgroundText = new Canvas(250.0, 123.75);
        this.lowerBackgroundTextCtx = this.lowerBackgroundText.getGraphicsContext2D();
        this.lowerBackgroundTextCtx.setTextBaseline(VPos.CENTER);
        this.lowerBackgroundTextCtx.setTextAlign(TextAlignment.CENTER);
        this.flap = new Canvas(250.0, 123.75);
        this.flap.getTransforms().add((Object)this.rotateFlap);
        this.flapCtx = this.flap.getGraphicsContext2D();
        this.flapTextFront = new Canvas();
        this.flapTextFront.getTransforms().add((Object)this.rotateFlap);
        this.flapTextFrontCtx = this.flapTextFront.getGraphicsContext2D();
        this.flapTextFrontCtx.setTextBaseline(VPos.CENTER);
        this.flapTextFrontCtx.setTextAlign(TextAlignment.CENTER);
        this.flapTextBack = new Canvas();
        this.flapTextBack.getTransforms().add((Object)this.rotateFlap);
        this.flapTextBack.setOpacity(0.0);
        this.flapTextBackCtx = this.flapTextBack.getGraphicsContext2D();
        this.flapTextBackCtx.setTextBaseline(VPos.CENTER);
        this.flapTextBackCtx.setTextAlign(TextAlignment.CENTER);
        this.pane.getChildren().addAll((Object[])new Node[]{this.upperBackground, this.lowerBackground, this.upperBackgroundText, this.lowerBackgroundText, this.flap, this.flapTextFront, this.flapTextBack});
    }

    @Override
    protected void registerListeners() {
        super.registerListeners();
        this.rotateFlap.angleProperty().addListener((o, ov, nv) -> {
            if (nv.doubleValue() > 90.0) {
                this.flapTextFront.setOpacity(0.0);
                this.flapTextBack.setOpacity(1.0);
            }
        });
        this.timeline.setOnFinished(EVENT -> {
            this.tile.fireTileEvt(this.FLIP_FINISHED);
            if (Double.compare(this.rotateFlap.getAngle(), 180.0) == 0) {
                this.rotateFlap.setAngle(0.0);
                this.flapTextBack.setOpacity(0.0);
                this.flapTextFront.setOpacity(1.0);
                this.drawText();
                if (!this.tile.getFlipText().equals(this.characters.get(this.currentSelectionIndex))) {
                    this.flipForward();
                }
            } else if (Double.compare(this.rotateFlap.getAngle(), 0.0) == 0) {
                this.rotateFlap.setAngle(180.0);
            }
        });
    }

    @Override
    protected void handleEvents(String EVENT_TYPE) {
        super.handleEvents(EVENT_TYPE);
        if (EVENT_TYPE.equals("FLIP_START")) {
            this.flipForward();
        }
    }

    private void flipForward() {
        this.timeline.stop();
        this.flap.setCache(true);
        this.flap.setCacheHint(CacheHint.ROTATE);
        ++this.currentSelectionIndex;
        if (this.currentSelectionIndex >= this.characters.size()) {
            this.currentSelectionIndex = 0;
        }
        this.nextSelectionIndex = this.currentSelectionIndex + 1;
        if (this.nextSelectionIndex >= this.characters.size()) {
            this.nextSelectionIndex = 0;
        }
        KeyValue keyValueFlap = new KeyValue((WritableValue)this.rotateFlap.angleProperty(), (Object)180, Interpolator.SPLINE((double)0.5, (double)0.4, (double)0.4, (double)1.0));
        KeyFrame keyFrame = new KeyFrame(Duration.millis((double)this.tile.getFlipTimeInMS()), new KeyValue[]{keyValueFlap});
        this.timeline.getKeyFrames().setAll((Object[])new KeyFrame[]{keyFrame});
        this.timeline.play();
    }

    private void drawFlaps() {
        double cornerRadius = this.tile.getRoundedCorners() ? this.size * 0.025 : 0.0;
        this.upperBackground.setCache(false);
        this.upperBackgroundCtx.clearRect(0.0, 0.0, this.width, this.flapHeight);
        Helper.drawRoundedRect(this.upperBackgroundCtx, new Bounds(0.0, 0.0, this.width, this.flapHeight), new CornerRadii(cornerRadius, cornerRadius, 0.0, 0.0));
        this.upperBackgroundCtx.setFill((Paint)this.tile.getBackgroundColor());
        this.upperBackgroundCtx.fill();
        this.upperBackground.setCache(true);
        this.upperBackground.setCacheHint(CacheHint.SPEED);
        this.lowerBackground.setCache(false);
        this.lowerBackgroundCtx.clearRect(0.0, 0.0, this.width, this.flapHeight);
        Helper.drawRoundedRect(this.lowerBackgroundCtx, new Bounds(0.0, 0.0, this.width, this.flapHeight), new CornerRadii(0.0, 0.0, cornerRadius, cornerRadius));
        this.lowerBackgroundCtx.setFill((Paint)this.tile.getBackgroundColor());
        this.lowerBackgroundCtx.fill();
        this.lowerBackground.setCache(true);
        this.lowerBackground.setCacheHint(CacheHint.SPEED);
        this.flap.setCache(false);
        this.flapCtx.clearRect(0.0, 0.0, this.width, this.flapHeight);
        Helper.drawRoundedRect(this.flapCtx, new Bounds(0.0, 0.0, this.width, this.flapHeight), new CornerRadii(cornerRadius, cornerRadius, 0.0, 0.0));
        this.flapCtx.setFill((Paint)this.tile.getBackgroundColor());
        this.flapCtx.fill();
        this.flap.setCache(true);
        this.flap.setCacheHint(CacheHint.SPEED);
    }

    private void drawText() {
        if (this.characters.isEmpty()) {
            return;
        }
        String CURRENT_TEXT = this.characters.get(this.currentSelectionIndex);
        String NEXT_TEXT = this.characters.get(this.nextSelectionIndex);
        Color TEXT_COLOR = this.tile.getForegroundColor();
        this.upperBackgroundTextCtx.clearRect(0.0, 0.0, this.width, this.flapHeight);
        this.upperBackgroundTextCtx.setFill((Paint)TEXT_COLOR);
        this.upperBackgroundTextCtx.fillText(NEXT_TEXT, this.centerX, this.centerY, this.width);
        this.lowerBackgroundTextCtx.clearRect(0.0, 0.0, this.width, this.flapHeight);
        this.lowerBackgroundTextCtx.setFill((Paint)TEXT_COLOR);
        this.lowerBackgroundTextCtx.fillText(CURRENT_TEXT, this.centerX, 0.0, this.width);
        this.flapTextFrontCtx.clearRect(0.0, 0.0, this.width, this.flapHeight);
        this.flapTextFrontCtx.setFill((Paint)TEXT_COLOR);
        this.flapTextFrontCtx.fillText(CURRENT_TEXT, this.centerX, this.centerY, this.width);
        this.flapTextBackCtx.clearRect(0.0, 0.0, this.width, this.flapHeight);
        this.flapTextBackCtx.save();
        this.flapTextBackCtx.scale(1.0, -1.0);
        this.flapTextBackCtx.setFill((Paint)TEXT_COLOR);
        this.flapTextBackCtx.fillText(NEXT_TEXT, this.centerX, -this.centerY, this.width);
        this.flapTextBackCtx.restore();
    }

    @Override
    protected void resize() {
        super.resize();
        this.centerX = this.width * 0.5;
        this.centerY = this.height * 0.5;
        this.flapHeight = this.height * 0.495;
        this.upperBackground.setWidth(this.width);
        this.upperBackground.setHeight(this.flapHeight);
        this.lowerBackground.setWidth(this.width);
        this.lowerBackground.setHeight(this.flapHeight);
        this.lowerBackground.setTranslateY(this.height - this.flapHeight);
        this.upperBackgroundText.setWidth(this.width);
        this.upperBackgroundText.setHeight(this.flapHeight);
        this.lowerBackgroundText.setWidth(this.width);
        this.lowerBackgroundText.setHeight(this.flapHeight);
        this.lowerBackgroundText.setTranslateY(this.height - this.flapHeight);
        this.flap.setWidth(this.width);
        this.flap.setHeight(this.flapHeight);
        this.rotateFlap.setPivotY(this.centerY);
        this.flapTextFront.setWidth(this.width);
        this.flapTextFront.setHeight(this.flapHeight);
        this.flapTextBack.setWidth(this.width);
        this.flapTextBack.setHeight(this.flapHeight);
        this.font = Fonts.latoBold(this.height * 0.75);
        this.upperBackgroundTextCtx.setFont(this.font);
        this.lowerBackgroundTextCtx.setFont(this.font);
        this.flapTextFrontCtx.setFont(this.font);
        this.flapTextBackCtx.setFont(this.font);
        this.redraw();
    }

    @Override
    protected void redraw() {
        this.drawFlaps();
        this.drawText();
    }
}

