/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.tabs.tab_film;

import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.collections.ObservableList;
import javax.swing.table.TableModel;
import mediathek.config.Daten;
import mediathek.controller.history.SeenHistoryController;
import mediathek.daten.DatenFilm;
import mediathek.daten.ListeFilme;
import mediathek.gui.tabs.tab_film.searchfilters.FinalStageFilterNoPattern;
import mediathek.gui.tabs.tab_film.searchfilters.FinalStageFilterNoPatternWithDescription;
import mediathek.gui.tabs.tab_film.searchfilters.FinalStagePatternFilter;
import mediathek.gui.tabs.tab_film.searchfilters.FinalStagePatternFilterWithDescription;
import mediathek.javafx.filterpanel.FilmActionPanel;
import mediathek.tool.Filter;
import mediathek.tool.models.TModelFilm;
import org.jetbrains.annotations.NotNull;

public class GuiFilmeModelHelper {
    private final FilmActionPanel filmActionPanel;
    private TModelFilm filmModel;
    private final ListeFilme listeFilme;
    private final SeenHistoryController historyController;
    private boolean searchThroughDescriptions;
    private boolean showNewOnly;
    private boolean showBookmarkedOnly;
    private boolean showSubtitlesOnly;
    private boolean showHqOnly;
    private boolean dontShowSeen;
    private boolean dontShowAbos;
    private boolean showLivestreamsOnly;
    private boolean dontShowTrailers;
    private boolean dontShowGebaerdensprache;
    private boolean dontShowAudioVersions;
    private long maxLength;
    private String[] arrIrgendwo;
    private long minLengthInSeconds;
    private long maxLengthInSeconds;

    public GuiFilmeModelHelper(@NotNull FilmActionPanel filmActionPanel, @NotNull SeenHistoryController historyController) {
        this.filmActionPanel = filmActionPanel;
        this.historyController = historyController;
        this.listeFilme = Daten.getInstance().getListeFilmeNachBlackList();
    }

    private String getFilterThema() {
        String filterThema = (String)this.filmActionPanel.themaBox.getSelectionModel().getSelectedItem();
        if (filterThema == null) {
            filterThema = "";
        }
        return filterThema;
    }

    private String[] evaluateThemaTitel() {
        String[] arrThemaTitel;
        String filterThemaTitel = this.filmActionPanel.roSearchStringProperty.getValueSafe();
        if (Filter.isPattern(filterThemaTitel)) {
            arrThemaTitel = new String[]{filterThemaTitel};
        } else {
            arrThemaTitel = filterThemaTitel.split(",");
            for (int i = 0; i < arrThemaTitel.length; ++i) {
                arrThemaTitel[i] = arrThemaTitel[i].trim().toLowerCase();
            }
        }
        return arrThemaTitel;
    }

    private boolean noFiltersAreSet() {
        return this.filmActionPanel.getViewSettingsPane().senderCheckList.getCheckModel().isEmpty() && this.getFilterThema().isEmpty() && this.filmActionPanel.roSearchStringProperty.getValueSafe().isEmpty() && (int)this.filmActionPanel.filmLengthSlider.getLowValue() == 0 && (int)this.filmActionPanel.filmLengthSlider.getHighValue() == 110 && this.filmActionPanel.dontShowAbos.getValue() == false && this.filmActionPanel.showUnseenOnly.getValue() == false && this.filmActionPanel.showOnlyHd.getValue() == false && this.filmActionPanel.showSubtitlesOnly.getValue() == false && this.filmActionPanel.showLivestreamsOnly.getValue() == false && this.filmActionPanel.showNewOnly.getValue() == false && this.filmActionPanel.showBookMarkedOnly.getValue() == false && this.filmActionPanel.dontShowTrailers.getValue() == false && this.filmActionPanel.dontShowSignLanguage.getValue() == false && this.filmActionPanel.dontShowAudioVersions.getValue() == false;
    }

    private void updateFilterVars() {
        this.showNewOnly = this.filmActionPanel.showNewOnly.getValue();
        this.showBookmarkedOnly = this.filmActionPanel.showBookMarkedOnly.getValue();
        this.showSubtitlesOnly = this.filmActionPanel.showSubtitlesOnly.getValue();
        this.showHqOnly = this.filmActionPanel.showOnlyHd.getValue();
        this.dontShowSeen = this.filmActionPanel.showUnseenOnly.getValue();
        this.dontShowAbos = this.filmActionPanel.dontShowAbos.getValue();
        this.showLivestreamsOnly = this.filmActionPanel.showLivestreamsOnly.getValue();
        this.dontShowTrailers = this.filmActionPanel.dontShowTrailers.getValue();
        this.dontShowGebaerdensprache = this.filmActionPanel.dontShowSignLanguage.getValue();
        this.dontShowAudioVersions = this.filmActionPanel.dontShowAudioVersions.getValue();
        this.searchThroughDescriptions = this.filmActionPanel.searchThroughDescription.getValue();
        this.arrIrgendwo = this.evaluateThemaTitel();
    }

    private void calculateFilmLengthSliderValues() {
        long minLength = (long)this.filmActionPanel.filmLengthSlider.getLowValue();
        this.maxLength = (long)this.filmActionPanel.filmLengthSlider.getHighValue();
        this.minLengthInSeconds = TimeUnit.SECONDS.convert(minLength, TimeUnit.MINUTES);
        this.maxLengthInSeconds = TimeUnit.SECONDS.convert(this.maxLength, TimeUnit.MINUTES);
    }

    private void performTableFiltering() {
        boolean searchFieldEmpty;
        this.updateFilterVars();
        this.calculateFilmLengthSliderValues();
        String filterThema = this.getFilterThema();
        ObservableList selectedSenders = this.filmActionPanel.getViewSettingsPane().senderCheckList.getCheckModel().getCheckedItems();
        if (this.dontShowSeen) {
            this.historyController.prepareMemoryCache();
        }
        Stream<Object> stream = this.listeFilme.parallelStream();
        if (!selectedSenders.isEmpty()) {
            HashSet senderSet = new HashSet(selectedSenders.size());
            senderSet.addAll(selectedSenders);
            stream = stream.filter(f -> senderSet.contains(f.getSender()));
        }
        if (this.showNewOnly) {
            stream = stream.filter(DatenFilm::isNew);
        }
        if (this.showBookmarkedOnly) {
            stream = stream.filter(DatenFilm::isBookmarked);
        }
        if (this.showLivestreamsOnly) {
            stream = stream.filter(DatenFilm::isLivestream);
        }
        if (this.showHqOnly) {
            stream = stream.filter(DatenFilm::isHighQuality);
        }
        if (this.dontShowTrailers) {
            stream = stream.filter(film -> !film.isTrailerTeaser());
        }
        if (this.dontShowGebaerdensprache) {
            stream = stream.filter(film -> !film.isSignLanguage());
        }
        if (this.dontShowAudioVersions) {
            stream = stream.filter(film -> !film.isAudioVersion());
        }
        if (this.dontShowAbos) {
            stream = stream.filter(film -> film.getAbo() == null);
        }
        if (this.showSubtitlesOnly) {
            stream = stream.filter(this::subtitleCheck);
        }
        if (!filterThema.isEmpty()) {
            stream = stream.filter(film -> film.getThema().equalsIgnoreCase(filterThema));
        }
        if (this.maxLength < 110L) {
            stream = stream.filter(this::maxLengthCheck);
        }
        if (this.dontShowSeen) {
            stream = stream.filter(this::seenCheck);
        }
        stream = stream.filter(this::minLengthCheck);
        boolean bl = searchFieldEmpty = this.arrIrgendwo.length == 0;
        if (!searchFieldEmpty) {
            stream = stream.filter(this.createFinalStageFilter());
        }
        List<DatenFilm> list = stream.collect(Collectors.toList());
        stream.close();
        this.filmModel = new TModelFilm(list.size());
        this.filmModel.addAll(list);
        list.clear();
        if (this.dontShowSeen) {
            this.historyController.emptyMemoryCache();
        }
    }

    private Predicate<DatenFilm> createFinalStageFilter() {
        boolean isPattern;
        boolean bl = isPattern = Filter.isPattern(this.arrIrgendwo[0]) || this.arrIrgendwo.length > 1;
        Predicate<DatenFilm> filter = this.searchThroughDescriptions ? (isPattern ? new FinalStagePatternFilterWithDescription(this.arrIrgendwo) : new FinalStageFilterNoPatternWithDescription(this.arrIrgendwo)) : (isPattern ? new FinalStagePatternFilter(this.arrIrgendwo) : new FinalStageFilterNoPattern(this.arrIrgendwo));
        return filter;
    }

    private boolean subtitleCheck(DatenFilm film) {
        return film.hasSubtitle() || film.hasBurnedInSubtitles();
    }

    private boolean maxLengthCheck(DatenFilm film) {
        return film.getFilmLength() < this.maxLengthInSeconds;
    }

    private boolean seenCheck(DatenFilm film) {
        return !this.historyController.hasBeenSeenFromCache(film);
    }

    private boolean minLengthCheck(DatenFilm film) {
        long filmLength = film.getFilmLength();
        if (filmLength == 0L) {
            return true;
        }
        return filmLength >= this.minLengthInSeconds;
    }

    public TableModel getFilteredTableModel() {
        if (!this.listeFilme.isEmpty()) {
            if (this.noFiltersAreSet()) {
                this.filmModel = new TModelFilm(this.listeFilme.size());
                this.filmModel.addAll(this.listeFilme);
            } else {
                this.performTableFiltering();
            }
        } else {
            return new TModelFilm();
        }
        return this.filmModel;
    }
}

