/*
 * Decompiled with CFR 0.152.
 */
package mediathek.mainwindow;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.Taskbar;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javafx.application.Platform;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.ObservableList;
import javafx.embed.swing.JFXPanel;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.HBox;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import mediathek.Main;
import mediathek.config.Config;
import mediathek.config.Daten;
import mediathek.config.Icons;
import mediathek.config.Konstanten;
import mediathek.controller.history.SeenHistoryController;
import mediathek.controller.starter.Start;
import mediathek.daten.DatenDownload;
import mediathek.filmeSuchen.ListenerFilmeLaden;
import mediathek.filmeSuchen.ListenerFilmeLadenEvent;
import mediathek.filmlisten.FilmeLaden;
import mediathek.gui.MVTray;
import mediathek.gui.TabPaneIndex;
import mediathek.gui.actions.CreateNewAboAction;
import mediathek.gui.actions.DeleteLocalFilmlistAction;
import mediathek.gui.actions.LoadFilmListAction;
import mediathek.gui.actions.ManageAboAction;
import mediathek.gui.actions.MemoryMonitorAction;
import mediathek.gui.actions.QuitAction;
import mediathek.gui.actions.ResetSettingsAction;
import mediathek.gui.actions.SearchProgramUpdateAction;
import mediathek.gui.actions.SetAppMemoryAction;
import mediathek.gui.actions.SettingsAction;
import mediathek.gui.actions.ShowAboHistoryAction;
import mediathek.gui.actions.ShowAboutAction;
import mediathek.gui.actions.ShowFilmInformationAction;
import mediathek.gui.actions.ShowOnlineHelpAction;
import mediathek.gui.actions.ShowProgramInfosAction;
import mediathek.gui.actions.export.FilmListExportAction;
import mediathek.gui.actions.import_actions.ImportOldAbosAction;
import mediathek.gui.actions.import_actions.ImportOldBlacklistAction;
import mediathek.gui.actions.import_actions.ImportOldReplacementListAction;
import mediathek.gui.bandwidth.BandwidthMonitorController;
import mediathek.gui.dialog.DialogBeenden;
import mediathek.gui.dialog.LoadFilmListDialog;
import mediathek.gui.dialogEinstellungen.DialogEinstellungen;
import mediathek.gui.filmInformation.InfoDialog;
import mediathek.gui.history.ResetAboHistoryAction;
import mediathek.gui.history.ResetDownloadHistoryAction;
import mediathek.gui.messages.BandwidthMonitorStateChangedEvent;
import mediathek.gui.messages.BaseEvent;
import mediathek.gui.messages.DownloadFinishedEvent;
import mediathek.gui.messages.DownloadStartEvent;
import mediathek.gui.messages.InstallTabSwitchListenerEvent;
import mediathek.gui.messages.NotificationCenterChangeEvent;
import mediathek.gui.messages.TabVisualSettingsChangedEvent;
import mediathek.gui.messages.TableModelChangeEvent;
import mediathek.gui.messages.UpdateStateChangedEvent;
import mediathek.gui.tabs.tab_downloads.GuiDownloads;
import mediathek.gui.tabs.tab_film.GuiFilme;
import mediathek.javafx.FilmListFilterTask;
import mediathek.javafx.FilmListNetworkReaderTask;
import mediathek.javafx.FilmListReaderTask;
import mediathek.javafx.SelectedItemsLabel;
import mediathek.javafx.ShutdownDialog;
import mediathek.javafx.StatusBarController;
import mediathek.javafx.VerticalSeparator;
import mediathek.javafx.tool.FXProgressPane;
import mediathek.javafx.tool.JFXHiddenApplication;
import mediathek.javafx.tool.JavaFxUtils;
import mediathek.mainwindow.MenuTabSwitchListener;
import mediathek.mainwindow.WindowLocationConfigSaverListener;
import mediathek.res.GetIcon;
import mediathek.tool.ApplicationConfiguration;
import mediathek.tool.FileUtils;
import mediathek.tool.FilmListUpdateType;
import mediathek.tool.Filter;
import mediathek.tool.GuiFunktionen;
import mediathek.tool.Log4jShutdownCallbackRegistry;
import mediathek.tool.MessageBus;
import mediathek.tool.RuntimeStatistics;
import mediathek.tool.ShutdownState;
import mediathek.tool.TABS;
import mediathek.tool.TimerPool;
import mediathek.tool.UIProgressState;
import mediathek.tool.http.ByteCounter;
import mediathek.tool.http.MVHttpClient;
import mediathek.tool.notification.GenericNotificationCenter;
import mediathek.tool.notification.INotificationCenter;
import mediathek.tool.notification.NullNotificationCenter;
import mediathek.tool.threads.IndicatorThread;
import mediathek.update.AutomaticFilmlistUpdate;
import mediathek.update.ProgramUpdateCheck;
import net.engio.mbassy.bus.MBassador;
import net.engio.mbassy.listener.Handler;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.sync.LockMode;
import org.apache.commons.lang3.SystemUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.controlsfx.control.StatusBar;
import org.jetbrains.annotations.NotNull;

public class MediathekGui
extends JFrame {
    protected static final Logger logger = LogManager.getLogger(MediathekGui.class);
    private static final String ICON_NAME = "MediathekView.png";
    private static final String ICON_PATH = "/mediathek/res/";
    private static final int ICON_WIDTH = 58;
    private static final int ICON_HEIGHT = 58;
    private static final String KEY_F10 = "F10";
    private static final String NONE = "none";
    private static final int MIN_WINDOW_WIDTH = 800;
    private static final int MIN_WINDOW_HEIGHT = 600;
    private static MediathekGui ui;
    protected final AtomicInteger numDownloadsStarted = new AtomicInteger(0);
    protected final Daten daten = Daten.getInstance();
    protected final JTabbedPane tabbedPane = new JTabbedPane();
    protected final JMenu jMenuHilfe = new JMenu();
    private final JMenu jMenuDatei = new JMenu();
    private final JMenu jMenuFilme = new JMenu();
    private final JMenuBar jMenuBar = new JMenuBar();
    private final JMenu jMenuDownload = new JMenu();
    private final JMenu jMenuAbos = new JMenu();
    private final JMenu jMenuAnsicht = new JMenu();
    private final IntegerProperty selectedItemsProperty = new SimpleIntegerProperty(0);
    private final ObjectProperty<TabPaneIndex> tabPaneIndexProperty = new SimpleObjectProperty((Object)TabPaneIndex.NONE);
    private final HashMap<JMenu, MenuTabSwitchListener> menuListeners = new HashMap();
    private final JCheckBoxMenuItem cbBandwidthDisplay = new JCheckBoxMenuItem("Bandbreitennutzung");
    private final JFXPanel statusBarPanel = new JFXPanel();
    private final LoadFilmListAction loadFilmListAction;
    private final SearchProgramUpdateAction searchProgramUpdateAction;
    private final MemoryMonitorAction showMemoryMonitorAction = new MemoryMonitorAction();
    private final InfoDialog filmInfo;
    public GuiFilme tabFilme;
    public GuiDownloads tabDownloads;
    protected Configuration config = ApplicationConfiguration.getConfiguration();
    private BandwidthMonitorController bandwidthMonitor;
    private MVTray tray;
    private DialogEinstellungen dialogEinstellungen;
    private StatusBarController statusBarController;
    private ProgramUpdateCheck programUpdateChecker;
    private IndicatorThread progressIndicatorThread;
    private ManageAboAction manageAboAction;
    private AutomaticFilmlistUpdate automaticFilmlistUpdate;
    private WeakReference<HBox> indicatorLayout;

    public MediathekGui() {
        ui = this;
        this.setDefaultCloseOperation(0);
        this.loadFilmListAction = new LoadFilmListAction(this);
        this.searchProgramUpdateAction = new SearchProgramUpdateAction();
        Main.splashScreen.ifPresent(s2 -> s2.update(UIProgressState.LOAD_MAINWINDOW));
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)this.statusBarPanel, "Last");
        this.setIconAndWindowImage();
        this.createMenuBar();
        this.remapF10Key();
        Main.splashScreen.ifPresent(s2 -> s2.update(UIProgressState.WAIT_FOR_HISTORY_DATA));
        try {
            this.daten.waitForHistoryDataLoadingToComplete();
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error("waitForHistoryDataLoadingToComplete()", (Throwable)e);
        }
        Main.splashScreen.ifPresent(s2 -> s2.update(UIProgressState.CREATE_STATUS_BAR));
        this.createStatusBar();
        Main.splashScreen.ifPresent(s2 -> s2.update(UIProgressState.SETUP_FILM_LISTENERS));
        this.setupFilmListListener();
        Main.splashScreen.ifPresent(s2 -> s2.update(UIProgressState.LOAD_TABS));
        this.initTabs();
        Main.splashScreen.ifPresent(s2 -> s2.update(UIProgressState.INIT_MENUS));
        this.initMenus();
        Main.splashScreen.ifPresent(s2 -> s2.update(UIProgressState.LOAD_MEMORY_MONITOR));
        this.createMemoryMonitor();
        this.setupNotificationCenter();
        Main.splashScreen.ifPresent(s2 -> s2.update(UIProgressState.FINISHED));
        this.workaroundJavaFxInitializationBug();
        MBassador<BaseEvent> messageBus = MessageBus.getMessageBus();
        messageBus.publishAsync(new TableModelChangeEvent(true));
        messageBus.subscribe(this);
        SwingUtilities.invokeLater(() -> {
            if (Taskbar.isTaskbarSupported()) {
                this.setupTaskbarMenu();
            }
        });
        this.setupSystemTray();
        SwingUtilities.invokeLater(this::setApplicationWindowSize);
        this.loadFilmlist();
        this.setupUpdateCheck(this.config.getBoolean("application.automatic_update_check", true));
        this.setupShutdownHook();
        this.checkInvalidRegularExpressions();
        logger.trace("Loading bandwidth monitor");
        if (this.config.getBoolean("application.ui.bandwidth_monitor.visible", false)) {
            this.getBandwidthMonitorController().setVisibility();
        }
        logger.trace("Finished loading bandwidth monitor");
        logger.trace("Loading info dialog");
        this.filmInfo = new InfoDialog((Window)this);
        logger.trace("Finished loading info dialog");
    }

    public static MediathekGui ui() {
        return ui;
    }

    private void checkInvalidRegularExpressions() {
        TimerPool.getTimerPool().schedule(() -> {
            if (Filter.regExpErrorsOccured()) {
                String regexStr = Filter.regExpErrorList.stream().reduce("", (p, e) -> p + "\n" + e);
                String message = String.format("W\u00e4hrend des Starts wurden ung\u00fcltige regul\u00e4re Ausdr\u00fccke (RegExp) in Ihrer Blacklist und/oder Abos entdeckt.\nSie m\u00fcssen diese korrigieren, ansonsten funktioniert das Programm nicht fehlerfrei!\n\nNachfolgende Ausdr\u00fccke sind fehlerbehaftet: %s\n", regexStr);
                Filter.regExpErrorList.clear();
                Platform.runLater(() -> {
                    Alert alert = new Alert(Alert.AlertType.ERROR);
                    alert.setTitle("MediathekView");
                    alert.setHeaderText("Ung\u00fcltige regul\u00e4re Ausdr\u00fccke gefunden");
                    alert.setContentText(message);
                    alert.initModality(Modality.APPLICATION_MODAL);
                    alert.show();
                });
            }
        }, 30L, TimeUnit.SECONDS);
    }

    private void setupNotificationCenter() {
        INotificationCenter notificationCenter = this.daten.notificationCenter();
        boolean showNotifications = this.config.getBoolean("application.notifications.show", true);
        if (notificationCenter != null) {
            try {
                notificationCenter.close();
            }
            catch (IOException e) {
                logger.error("Failed to close old notification center", (Throwable)e);
            }
        }
        if (!showNotifications) {
            this.daten.setNotificationCenter(new NullNotificationCenter());
        } else {
            this.daten.setNotificationCenter(this.getNotificationCenter());
        }
    }

    protected INotificationCenter getNotificationCenter() {
        return new GenericNotificationCenter();
    }

    @Handler
    protected void handleNotificationCenterChangeEvent(NotificationCenterChangeEvent e) {
        this.setupNotificationCenter();
    }

    protected void closeNotificationCenter() {
        try {
            INotificationCenter center = this.daten.notificationCenter();
            if (center != null) {
                center.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setupShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new ShutdownHookThread());
    }

    private void setupSystemTray() {
        SwingUtilities.invokeLater(() -> {
            this.initializeSystemTray();
            this.initWindowListenerForTray();
        });
    }

    public JTabbedPane getTabbedPane() {
        return this.tabbedPane;
    }

    private BandwidthMonitorController getBandwidthMonitorController() {
        if (this.bandwidthMonitor == null) {
            this.bandwidthMonitor = new BandwidthMonitorController(this);
        }
        return this.bandwidthMonitor;
    }

    private void setupTaskbarMenu() {
        Taskbar taskbar = Taskbar.getTaskbar();
        if (taskbar.isSupported(Taskbar.Feature.MENU)) {
            PopupMenu popupMenu = taskbar.getMenu();
            if (popupMenu == null) {
                popupMenu = new PopupMenu();
            }
            MenuItem miLoadNewFilmlist = new MenuItem("Neue Filmliste laden");
            miLoadNewFilmlist.addActionListener(e -> this.performFilmListLoadOperation(false));
            popupMenu.addSeparator();
            popupMenu.add(miLoadNewFilmlist);
            taskbar.setMenu(popupMenu);
        }
    }

    private void setIconAndWindowImage() {
        this.setWindowTitle();
        this.setIconImage(GetIcon.getIcon(ICON_NAME, ICON_PATH, 58, 58).getImage());
    }

    private void remapF10Key() {
        InputMap im = this.jMenuBar.getInputMap(2);
        im.put(KeyStroke.getKeyStroke(KEY_F10), NONE);
    }

    private void createMenuBar() {
        this.jMenuDatei.setMnemonic('d');
        this.jMenuDatei.setText("Datei");
        this.jMenuBar.add(this.jMenuDatei);
        this.jMenuFilme.setMnemonic('F');
        this.jMenuFilme.setText("Filme");
        this.jMenuBar.add(this.jMenuFilme);
        this.jMenuDownload.setMnemonic('O');
        this.jMenuDownload.setText("Downloads");
        this.jMenuBar.add(this.jMenuDownload);
        this.jMenuAbos.setMnemonic('b');
        this.jMenuAbos.setText("Abos");
        this.jMenuBar.add(this.jMenuAbos);
        this.jMenuAnsicht.setMnemonic('a');
        this.jMenuAnsicht.setText("Ansicht");
        this.jMenuBar.add(this.jMenuAnsicht);
        this.jMenuHilfe.setMnemonic('h');
        this.jMenuHilfe.setText("Hilfe");
        this.jMenuBar.add(this.jMenuHilfe);
        this.setJMenuBar(this.jMenuBar);
    }

    protected void workaroundJavaFxInitializationBug() {
        JavaFxUtils.invokeInFxThreadAndWait(() -> {
            Stage window = new Stage();
            window.setWidth(10.0);
            window.setHeight(10.0);
            window.show();
            window.hide();
        });
    }

    private void createMemoryMonitor() {
        if (Config.isDebugModeEnabled()) {
            this.showMemoryMonitorAction.showMemoryMonitor();
        }
    }

    private void loadFilmlist() {
        Platform.runLater(() -> {
            boolean writeCondition = GuiFunktionen.getFilmListUpdateType() != FilmListUpdateType.AUTOMATIC || !this.daten.getListeFilme().needsUpdate();
            Daten.dontWriteFilmlistOnStartup.set(writeCondition);
            FXProgressPane progressPane = new FXProgressPane();
            FilmListReaderTask filmListReaderTask = new FilmListReaderTask();
            filmListReaderTask.setOnRunning(e -> {
                this.statusBarController.getStatusBar().getRightItems().add((Object)progressPane);
                progressPane.bindTask(filmListReaderTask);
            });
            FilmListNetworkReaderTask networkTask = new FilmListNetworkReaderTask();
            networkTask.setOnRunning(e -> progressPane.bindTask(networkTask));
            FilmListFilterTask filterTask = new FilmListFilterTask(true);
            filterTask.setOnRunning(e -> progressPane.bindTask(filterTask));
            EventHandler workerStateEventEventHandler = e -> this.statusBarController.getStatusBar().getRightItems().remove((Object)progressPane);
            filterTask.setOnSucceeded(workerStateEventEventHandler);
            filterTask.setOnFailed(workerStateEventEventHandler);
            ((CompletableFuture)CompletableFuture.runAsync((Runnable)((Object)filmListReaderTask)).thenRun((Runnable)((Object)networkTask))).thenRun((Runnable)((Object)filterTask));
            Daten.dontWriteFilmlistOnStartup.set(false);
        });
    }

    public IntegerProperty getSelectedItemsProperty() {
        return this.selectedItemsProperty;
    }

    private void createStatusBar() {
        this.statusBarController = new StatusBarController(this.daten);
        JavaFxUtils.invokeInFxThreadAndWait(() -> {
            this.statusBarPanel.setScene(new Scene((Parent)this.statusBarController.createStatusBar()));
            this.installSelectedItemsLabel();
        });
    }

    private void installSelectedItemsLabel() {
        ObservableList<Node> leftItems = this.statusBarController.getStatusBar().getLeftItems();
        leftItems.add(0, (Object)new SelectedItemsLabel(this.selectedItemsProperty));
        leftItems.add(1, (Object)new VerticalSeparator());
    }

    public StatusBarController getStatusBarController() {
        return this.statusBarController;
    }

    public ObjectProperty<TabPaneIndex> tabPaneIndexProperty() {
        return this.tabPaneIndexProperty;
    }

    public InfoDialog getFilmInfoDialog() {
        return this.filmInfo;
    }

    @Handler
    private void handleTabVisualSettingsChangedEvent(TabVisualSettingsChangedEvent e) {
        SwingUtilities.invokeLater(() -> {
            this.configureTabPlacement();
            this.configureTabIcons();
        });
    }

    @Handler
    private void handleTableModelChangeEvent(TableModelChangeEvent evt) {
        Platform.runLater(() -> {
            StatusBar statusBar = this.statusBarController.getStatusBar();
            ObservableList<Node> rightItems = statusBar.getRightItems();
            if (evt.active) {
                HBox hb = new HBox();
                ProgressIndicator progressIndicator = new ProgressIndicator();
                progressIndicator.setTooltip(new Tooltip("Filmdaten werden verarbeitet"));
                hb.getChildren().add((Object)progressIndicator);
                rightItems.add((Object)hb);
                this.indicatorLayout = new WeakReference<HBox>(hb);
            } else {
                rightItems.remove(this.indicatorLayout.get());
            }
        });
    }

    @Handler
    private void handleBandwidthMonitorStateChangedEvent(BandwidthMonitorStateChangedEvent e) {
        boolean vis = this.config.getBoolean("application.ui.bandwidth_monitor.visible", false);
        SwingUtilities.invokeLater(() -> this.cbBandwidthDisplay.setSelected(vis));
    }

    private void setWindowTitle() {
        this.setTitle("MediathekView " + Konstanten.MVVERSION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreSizeFromConfig() {
        Configuration config = ApplicationConfiguration.getConfiguration();
        try {
            config.lock(LockMode.READ);
            int width = config.getInt("application.ui.mainwindow.width", 800);
            int height = config.getInt("application.ui.mainwindow.height", 600);
            int x = config.getInt("application.ui.mainwindow.location.x");
            int y = config.getInt("application.ui.mainwindow.location.y");
            if (width < 800) {
                width = 800;
            }
            if (height < 600) {
                height = 600;
            }
            this.setBounds(x, y, width, height);
        }
        catch (NoSuchElementException e) {
            this.setExtendedState(6);
        }
        finally {
            config.unlock(LockMode.READ);
        }
    }

    private void setApplicationWindowSize() {
        if (Config.isStartMaximized() || ApplicationConfiguration.getConfiguration().getBoolean("application.ui.mainwindow.maximized", true)) {
            this.setExtendedState(6);
        } else {
            this.restoreSizeFromConfig();
        }
        SwingUtilities.invokeLater(() -> this.addComponentListener(new WindowLocationConfigSaverListener()));
    }

    private void setupFilmListListener() {
        this.daten.getFilmeLaden().addAdListener(new ListenerFilmeLaden(){

            @Override
            public void start(ListenerFilmeLadenEvent event) {
                MediathekGui.this.loadFilmListAction.setEnabled(false);
            }

            @Override
            public void fertig(ListenerFilmeLadenEvent event) {
                MediathekGui.this.loadFilmListAction.setEnabled(true);
                MediathekGui.this.daten.allesSpeichern();
            }

            @Override
            public void fertigOnlyOne(ListenerFilmeLadenEvent event) {
                MediathekGui.this.setupAutomaticFilmlistReload();
            }
        });
    }

    private void setupAutomaticFilmlistReload() {
        AutomaticFilmlistUpdate.IUpdateAction performUpdate = () -> {
            if (GuiFunktionen.getFilmListUpdateType() == FilmListUpdateType.AUTOMATIC) {
                this.loadFilmListAction.setEnabled(false);
                if (this.daten.getListeDownloads().unfinishedDownloads() == 0L) {
                    this.performFilmListLoadOperation(false);
                }
                this.loadFilmListAction.setEnabled(true);
            }
        };
        this.automaticFilmlistUpdate = new AutomaticFilmlistUpdate(performUpdate);
        this.automaticFilmlistUpdate.start();
    }

    protected void initWindowListenerForTray() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                if (MediathekGui.this.tray != null && MediathekGui.this.config.getBoolean("application.ui.tray.use", false)) {
                    MediathekGui.this.setVisible(false);
                } else {
                    MediathekGui.this.beenden(false, false);
                }
            }
        });
    }

    @Handler
    private void handleUpdateStateChanged(UpdateStateChangedEvent e) {
        SwingUtilities.invokeLater(() -> this.setupUpdateCheck(e.isActive()));
    }

    private void setupUpdateCheck(boolean newState) {
        if (newState) {
            this.programUpdateChecker = new ProgramUpdateCheck();
            this.programUpdateChecker.start();
        } else {
            this.endProgramUpdateChecker();
        }
    }

    private void endProgramUpdateChecker() {
        if (this.programUpdateChecker != null) {
            this.programUpdateChecker.close();
            this.programUpdateChecker = null;
        }
    }

    public void initializeSystemTray() {
        boolean useTray = this.config.getBoolean("application.ui.tray.use", false);
        if (this.tray == null && useTray) {
            this.tray = new MVTray().systemTray();
        } else if (this.tray != null && !useTray) {
            this.tray.beenden();
            this.tray = null;
        }
    }

    protected JPanel createTabFilme(@NotNull Daten daten) {
        return new GuiFilme(daten, this);
    }

    protected JPanel createTabDownloads(@NotNull Daten daten) {
        return new GuiDownloads(daten, this);
    }

    private void initTabs() {
        Container contentPane = this.getContentPane();
        contentPane.add((Component)this.tabbedPane, "Center");
        Main.splashScreen.ifPresent(s2 -> s2.update(UIProgressState.LOAD_DOWNLOAD_TAB));
        this.tabDownloads = (GuiDownloads)this.createTabDownloads(this.daten);
        Main.splashScreen.ifPresent(s2 -> s2.update(UIProgressState.LOAD_FILM_TAB));
        this.tabFilme = (GuiFilme)this.createTabFilme(this.daten);
        Main.splashScreen.ifPresent(s2 -> s2.update(UIProgressState.ADD_TABS_TO_UI));
        this.tabbedPane.addTab("Filme", this.tabFilme);
        this.tabbedPane.addTab("Downloads", this.tabDownloads);
        this.tabbedPane.setSelectedComponent(this.tabFilme);
        Main.splashScreen.ifPresent(s2 -> s2.update(UIProgressState.CONFIGURE_TABS));
        this.configureTabPlacement();
        this.configureTabIcons();
    }

    public void enableUpdateMenuItem(boolean enable) {
        this.searchProgramUpdateAction.setEnabled(enable);
    }

    private void configureTabPlacement() {
        boolean topPosition = this.config.getBoolean("application.ui.tab_position.top", true);
        if (topPosition) {
            this.tabbedPane.setTabPlacement(1);
        } else {
            this.tabbedPane.setTabPlacement(2);
        }
    }

    private void configureTabIcons() {
        boolean icon = this.config.getBoolean("application.ui.mainwindow.tab_icons", false);
        if (!icon) {
            this.setTabIcon(this.tabFilme, null);
            this.setTabIcon(this.tabDownloads, null);
        } else {
            this.setTabIcon(this.tabFilme, Icons.ICON_TAB_FILM);
            this.setTabIcon(this.tabDownloads, Icons.ICON_TAB_DOWNLOAD);
        }
    }

    private void setTabIcon(Component tab, Icon icon) {
        int index = this.tabbedPane.indexOfComponent(tab);
        this.tabbedPane.setIconAt(index, icon);
    }

    protected IndicatorThread createProgressIndicatorThread() throws Exception {
        throw new Exception("Unsupported Platform");
    }

    @Handler
    protected void handleDownloadStart(DownloadStartEvent msg) {
        this.numDownloadsStarted.incrementAndGet();
        if (this.progressIndicatorThread == null) {
            try {
                this.progressIndicatorThread = this.createProgressIndicatorThread();
                this.progressIndicatorThread.start();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Handler
    protected void handleDownloadFinishedEvent(DownloadFinishedEvent msg) {
        int numDL = this.numDownloadsStarted.decrementAndGet();
        if (numDL == 0 && this.progressIndicatorThread != null) {
            this.progressIndicatorThread.interrupt();
            this.progressIndicatorThread = null;
        }
    }

    protected void installMenuTabSwitchListener() {
        this.menuListeners.put(this.jMenuFilme, new MenuTabSwitchListener(this, TABS.TAB_FILME));
        this.menuListeners.put(this.jMenuDownload, new MenuTabSwitchListener(this, TABS.TAB_DOWNLOADS));
        if (this.config.getBoolean("application.ui.install_tab_listeners", true)) {
            this.jMenuFilme.addMenuListener(this.menuListeners.get(this.jMenuFilme));
            this.jMenuDownload.addMenuListener(this.menuListeners.get(this.jMenuDownload));
        }
    }

    @Handler
    protected void handleInstallTabSwitchListenerEvent(InstallTabSwitchListenerEvent msg) {
        switch (msg.event) {
            case INSTALL: {
                SwingUtilities.invokeLater(() -> {
                    this.jMenuFilme.addMenuListener(this.menuListeners.get(this.jMenuFilme));
                    this.jMenuDownload.addMenuListener(this.menuListeners.get(this.jMenuDownload));
                });
                break;
            }
            case REMOVE: {
                SwingUtilities.invokeLater(() -> {
                    this.jMenuFilme.removeMenuListener(this.menuListeners.get(this.jMenuFilme));
                    this.jMenuDownload.removeMenuListener(this.menuListeners.get(this.jMenuDownload));
                });
            }
        }
    }

    private void createFileMenu() {
        this.jMenuDatei.add(this.loadFilmListAction);
        this.jMenuDatei.addSeparator();
        JMenu exportMenu = new JMenu("Export");
        exportMenu.add(new FilmListExportAction(this));
        JMenu importMenu = new JMenu("Import");
        importMenu.add(new ImportOldAbosAction());
        importMenu.add(new ImportOldBlacklistAction());
        importMenu.add(new ImportOldReplacementListAction());
        this.jMenuDatei.add(exportMenu);
        this.jMenuDatei.add(importMenu);
        if (!SystemUtils.IS_OS_MAC_OSX) {
            this.jMenuDatei.addSeparator();
            this.jMenuDatei.add(new SettingsAction(this));
            this.jMenuDatei.addSeparator();
            this.jMenuDatei.add(new QuitAction(this));
        }
    }

    private void createViewMenu() {
        this.cbBandwidthDisplay.setSelected(this.config.getBoolean("application.ui.bandwidth_monitor.visible", false));
        this.cbBandwidthDisplay.addActionListener(e -> {
            this.config.setProperty("application.ui.bandwidth_monitor.visible", this.cbBandwidthDisplay.isSelected());
            this.getBandwidthMonitorController().setVisibility();
        });
        JMenuItem showFilmFilterDialog = new JMenuItem("Filterdialog anzeigen");
        showFilmFilterDialog.setAccelerator(KeyStroke.getKeyStroke(123, 0));
        showFilmFilterDialog.addActionListener(l -> {
            JDialog dlg = this.tabFilme.filmActionPanel.filterDialog;
            if (dlg != null && !dlg.isVisible()) {
                dlg.setVisible(true);
            }
        });
        JMenuItem showBookmarkList = new JMenuItem("Merkliste anzeigen");
        showBookmarkList.addActionListener(l -> JavaFxUtils.invokeInFxThreadAndWait(() -> this.tabFilme.showBookmarkWindow()));
        this.jMenuAnsicht.addSeparator();
        this.jMenuAnsicht.add(this.showMemoryMonitorAction);
        this.jMenuAnsicht.add(this.cbBandwidthDisplay);
        this.jMenuAnsicht.addSeparator();
        this.jMenuAnsicht.add(showFilmFilterDialog);
        this.jMenuAnsicht.addSeparator();
        this.jMenuAnsicht.add(new ShowFilmInformationAction(true));
        this.jMenuAnsicht.addSeparator();
        this.jMenuAnsicht.add(showBookmarkList);
    }

    private void createHelpMenu() {
        this.jMenuHilfe.add(new ShowOnlineHelpAction());
        this.jMenuHilfe.addSeparator();
        this.jMenuHilfe.add(new ResetSettingsAction(this, this.daten));
        this.jMenuHilfe.add(new ResetDownloadHistoryAction(this));
        this.jMenuHilfe.add(new ResetAboHistoryAction(this));
        this.jMenuHilfe.add(new DeleteLocalFilmlistAction(this));
        this.jMenuHilfe.addSeparator();
        String externalUpdateCheck = System.getProperty("externalUpdateCheck");
        if (externalUpdateCheck == null || !externalUpdateCheck.equalsIgnoreCase("true")) {
            this.jMenuHilfe.add(this.searchProgramUpdateAction);
        }
        this.jMenuHilfe.add(new ShowProgramInfosAction());
        if (this.officialLauncherInUse() && !SystemUtils.IS_OS_MAC_OSX) {
            this.jMenuHilfe.addSeparator();
            this.jMenuHilfe.add(new SetAppMemoryAction());
        }
        this.installAdditionalHelpEntries();
    }

    protected boolean officialLauncherInUse() {
        boolean winBinaryInUse = true;
        String externalUpdateCheck = System.getProperty("externalUpdateCheck");
        if (externalUpdateCheck == null || !externalUpdateCheck.equalsIgnoreCase("true")) {
            winBinaryInUse = false;
        }
        return winBinaryInUse;
    }

    protected void installChangeGlobalFontSettingMenuEntry() {
    }

    protected void installAdditionalHelpEntries() {
        this.installChangeGlobalFontSettingMenuEntry();
        this.jMenuHilfe.addSeparator();
        this.jMenuHilfe.add(new ShowAboutAction());
    }

    protected void initMenus() {
        this.installMenuTabSwitchListener();
        this.createFileMenu();
        this.tabFilme.installMenuEntries(this.jMenuFilme);
        this.tabDownloads.installMenuEntries(this.jMenuDownload);
        this.createViewMenu();
        this.tabFilme.installViewMenuEntry(this.jMenuAnsicht);
        this.createAboMenu();
        this.createHelpMenu();
    }

    private void createAboMenu() {
        this.jMenuAbos.add(new CreateNewAboAction(this.daten.getListeAbo()));
        this.jMenuAbos.add(new ShowAboHistoryAction(MediathekGui.ui()));
        this.jMenuAbos.addSeparator();
        this.tabFilme.filmActionPanel.manageAboAction = this.manageAboAction = new ManageAboAction();
        this.jMenuAbos.add(this.manageAboAction);
    }

    public void performFilmListLoadOperation(boolean manualMode) {
        if (manualMode || GuiFunktionen.getFilmListUpdateType() == FilmListUpdateType.MANUAL) {
            LoadFilmListDialog dlg = new LoadFilmListDialog(this);
            dlg.setVisible(true);
        } else {
            FilmeLaden filmeLaden = new FilmeLaden(this.daten);
            filmeLaden.loadFilmlist("", false);
        }
    }

    public DialogEinstellungen getSettingsDialog() {
        if (this.dialogEinstellungen == null) {
            this.dialogEinstellungen = new DialogEinstellungen();
        }
        return this.dialogEinstellungen;
    }

    public boolean beenden(boolean showOptionTerminate, boolean shutDown) {
        if (this.daten.getListeDownloads().unfinishedDownloads() > 0L) {
            DialogBeenden dialogBeenden = new DialogBeenden(this);
            if (showOptionTerminate) {
                dialogBeenden.setComboWaitAndTerminate();
            }
            dialogBeenden.setVisible(true);
            if (!dialogBeenden.applicationCanTerminate()) {
                return false;
            }
            shutDown = dialogBeenden.isShutdownRequested();
        }
        if (this.automaticFilmlistUpdate != null) {
            this.automaticFilmlistUpdate.close();
        }
        this.showMemoryMonitorAction.closeMemoryMonitor();
        if (this.bandwidthMonitor != null) {
            this.bandwidthMonitor.close();
        }
        this.endProgramUpdateChecker();
        ShutdownDialog dialog = new ShutdownDialog(this);
        dialog.show();
        dialog.setStatusText(ShutdownState.TERMINATE_STARTER_THREAD);
        this.daten.getStarterClass().getStarterThread().interrupt();
        dialog.setStatusText(ShutdownState.SHUTDOWN_NOTIFICATION_CENTER);
        this.closeNotificationCenter();
        this.manageAboAction.closeDialog();
        this.tabFilme.saveSettings();
        dialog.setStatusText(ShutdownState.SHUTDOWN_THREAD_POOL);
        this.shutdownTimerPool();
        this.waitForCommonPoolToComplete();
        dialog.setStatusText(ShutdownState.PERFORM_SEEN_HISTORY_MAINTENANCE);
        try (SeenHistoryController history = new SeenHistoryController();){
            history.performMaintenance();
        }
        dialog.setStatusText(ShutdownState.SAVE_FILM_DATA);
        this.tabFilme.tabelleSpeichern();
        dialog.setStatusText(ShutdownState.SAVE_DOWNLOAD_DATA);
        this.tabDownloads.tabelleSpeichern();
        dialog.setStatusText(ShutdownState.STOP_DOWNLOADS);
        this.stopDownloads();
        dialog.setStatusText(ShutdownState.SAVE_BOOKMARKS);
        this.daten.getListeBookmarkList().saveToFile(Daten.getBookmarkFilePath());
        dialog.setStatusText(ShutdownState.SAVE_APP_DATA);
        this.daten.allesSpeichern();
        dialog.setStatusText(ShutdownState.COMPLETE);
        dialog.hide();
        this.tabFilme.filmActionPanel.filterDialog.dispose();
        RuntimeStatistics.printRuntimeStatistics();
        this.dispose();
        JavaFxUtils.invokeInFxThreadAndWait(() -> JFXHiddenApplication.getPrimaryStage().close());
        ApplicationConfiguration.getInstance().writeConfiguration();
        Platform.exit();
        if (shutDown) {
            this.shutdownComputer();
        }
        ByteCounter byteCounter = MVHttpClient.getInstance().getByteCounter();
        logger.trace("total data sent: {}", (Object)FileUtils.humanReadableByteCountBinary(byteCounter.totalBytesWritten()));
        logger.trace("total data received: {}", (Object)FileUtils.humanReadableByteCountBinary(byteCounter.totalBytesRead()));
        System.exit(0);
        return false;
    }

    private void shutdownTimerPool() {
        ScheduledThreadPoolExecutor timerPool = TimerPool.getTimerPool();
        timerPool.shutdown();
        try {
            if (!timerPool.awaitTermination(3L, TimeUnit.SECONDS)) {
                logger.warn("Time out occured before pool final termination");
            }
        }
        catch (InterruptedException e) {
            logger.warn("timerPool shutdown exception", (Throwable)e);
        }
        List<Runnable> taskList = timerPool.shutdownNow();
        if (!taskList.isEmpty()) {
            logger.trace("timerPool taskList was not empty");
            logger.trace(taskList.toString());
        }
    }

    private void stopDownloads() {
        if (this.daten.getListeDownloads() != null) {
            for (DatenDownload download : this.daten.getListeDownloads()) {
                Start s2 = download.start;
                if (s2 == null) continue;
                s2.stoppen = true;
            }
        }
    }

    private void waitForCommonPoolToComplete() {
        while (ForkJoinPool.commonPool().hasQueuedSubmissions()) {
            try {
                logger.debug("POOL SUBMISSIONS: {}", (Object)ForkJoinPool.commonPool().getQueuedSubmissionCount());
                TimeUnit.MILLISECONDS.sleep(500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    protected void shutdownComputer() {
    }

    static class ShutdownHookThread
    extends Thread {
        ShutdownHookThread() {
        }

        @Override
        public void run() {
            ApplicationConfiguration.getInstance().writeConfiguration();
            Log4jShutdownCallbackRegistry.Companion.execute();
        }
    }
}

