/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool.table;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

class WidthAdjuster
extends MouseAdapter {
    private static final int EPSILON = 5;
    private final JTable table;
    private List<? extends RowSorter.SortKey> listeSortKeys = null;

    protected WidthAdjuster(JTable table) {
        this.table = table;
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        if (evt.getClickCount() == 1) {
            this.listeSortKeys = this.table.getRowSorter() != null ? this.table.getRowSorter().getSortKeys() : null;
        }
        if (evt.getClickCount() > 1 && this.isUsingResizeCursor()) {
            this.resizeColumn(this.getLeftColumn(evt.getPoint()));
        }
    }

    private boolean isUsingResizeCursor() {
        Cursor cursor = this.table.getTableHeader().getCursor();
        return cursor.equals(Cursor.getPredefinedCursor(11)) || cursor.equals(Cursor.getPredefinedCursor(10));
    }

    private int getLeftColumn(Point pt) {
        pt.x -= 5;
        return this.table.getTableHeader().columnAtPoint(pt);
    }

    private void resizeColumn(int col) {
        TableColumn tc = this.table.getColumnModel().getColumn(col);
        TableCellRenderer tcr = tc.getHeaderRenderer();
        if (tcr == null) {
            tcr = this.table.getTableHeader().getDefaultRenderer();
        }
        Object obj = tc.getHeaderValue();
        Component comp = tcr.getTableCellRendererComponent(this.table, obj, false, false, 0, 0);
        int maxWidth = comp.getPreferredSize().width;
        int ub = this.table.getRowCount();
        for (int i = 0; i != ub; ++i) {
            tcr = this.table.getCellRenderer(i, col);
            obj = this.table.getValueAt(i, col);
            comp = tcr.getTableCellRendererComponent(this.table, obj, false, false, i, col);
            int w = comp.getPreferredSize().width;
            if (w <= maxWidth) continue;
            maxWidth = w;
        }
        tc.setPreferredWidth(maxWidth += 10);
        tc.setWidth(maxWidth);
        if (this.listeSortKeys != null && !this.listeSortKeys.isEmpty()) {
            this.table.getRowSorter().setSortKeys(this.listeSortKeys);
        }
    }
}

