/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.inject;

import org.opensearch.common.inject.ConfigurationException;
import org.opensearch.common.inject.ConstructorInjector;
import org.opensearch.common.inject.DefaultConstructionProxyFactory;
import org.opensearch.common.inject.InjectorImpl;
import org.opensearch.common.inject.MembersInjectorImpl;
import org.opensearch.common.inject.SingleParameterInjector;
import org.opensearch.common.inject.TypeLiteral;
import org.opensearch.common.inject.internal.Errors;
import org.opensearch.common.inject.internal.ErrorsException;
import org.opensearch.common.inject.internal.FailableCache;
import org.opensearch.common.inject.spi.InjectionPoint;

class ConstructorInjectorStore {
    private final InjectorImpl injector;
    private final FailableCache<TypeLiteral<?>, ConstructorInjector<?>> cache = new FailableCache<TypeLiteral<?>, ConstructorInjector<?>>(){

        @Override
        protected ConstructorInjector<?> create(TypeLiteral<?> type, Errors errors) throws ErrorsException {
            return ConstructorInjectorStore.this.createConstructor(type, errors);
        }
    };

    ConstructorInjectorStore(InjectorImpl injector) {
        this.injector = injector;
    }

    public <T> ConstructorInjector<T> get(TypeLiteral<T> key, Errors errors) throws ErrorsException {
        return this.cache.get(key, errors);
    }

    private <T> ConstructorInjector<T> createConstructor(TypeLiteral<T> type, Errors errors) throws ErrorsException {
        InjectionPoint injectionPoint;
        int numErrorsBefore = errors.size();
        try {
            injectionPoint = InjectionPoint.forConstructorOf(type);
        }
        catch (ConfigurationException e) {
            errors.merge(e.getErrorMessages());
            throw errors.toException();
        }
        SingleParameterInjector<?>[] constructorParameterInjectors = this.injector.getParametersInjectors(injectionPoint.getDependencies(), errors);
        MembersInjectorImpl<T> membersInjector = this.injector.membersInjectorStore.get(type, errors);
        DefaultConstructionProxyFactory factory = new DefaultConstructionProxyFactory(injectionPoint);
        errors.throwIfNewErrors(numErrorsBefore);
        return new ConstructorInjector(membersInjector.getInjectionPoints(), factory.create(), constructorParameterInjectors, membersInjector);
    }
}

