/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.store.remote.file;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.IndexInput;
import org.opensearch.index.snapshots.blobstore.BlobStoreIndexShardSnapshot;
import org.opensearch.index.store.remote.file.OnDemandBlockIndexInput;
import org.opensearch.index.store.remote.utils.BlobFetchRequest;
import org.opensearch.index.store.remote.utils.TransferManager;

public class OnDemandBlockSnapshotIndexInput
extends OnDemandBlockIndexInput {
    private static final Logger logger = LogManager.getLogger(OnDemandBlockSnapshotIndexInput.class);
    final TransferManager transferManager;
    protected final BlobStoreIndexShardSnapshot.FileInfo fileInfo;
    protected final FSDirectory directory;
    protected final String fileName;
    protected final long partSize;
    protected final long originalFileSize;

    public OnDemandBlockSnapshotIndexInput(BlobStoreIndexShardSnapshot.FileInfo fileInfo, FSDirectory directory, TransferManager transferManager) {
        this("BlockedSnapshotIndexInput(path=\"" + directory.getDirectory().toString() + "/" + fileInfo.physicalName() + "\", offset=0, length= " + fileInfo.length() + ")", fileInfo, 0L, fileInfo.length(), false, directory, transferManager);
    }

    public OnDemandBlockSnapshotIndexInput(String resourceDescription, BlobStoreIndexShardSnapshot.FileInfo fileInfo, long offset, long length, boolean isClone, FSDirectory directory, TransferManager transferManager) {
        this(OnDemandBlockIndexInput.builder().resourceDescription(resourceDescription).isClone(isClone).offset(offset).length(length), fileInfo, directory, transferManager);
    }

    OnDemandBlockSnapshotIndexInput(OnDemandBlockIndexInput.Builder builder, BlobStoreIndexShardSnapshot.FileInfo fileInfo, FSDirectory directory, TransferManager transferManager) {
        super(builder);
        this.transferManager = transferManager;
        this.fileInfo = fileInfo;
        this.partSize = fileInfo.partSize().getBytes();
        this.fileName = fileInfo.physicalName();
        this.directory = directory;
        this.originalFileSize = fileInfo.length();
    }

    @Override
    protected OnDemandBlockSnapshotIndexInput buildSlice(String sliceDescription, long offset, long length) {
        return new OnDemandBlockSnapshotIndexInput(OnDemandBlockIndexInput.builder().blockSizeShift(this.blockSizeShift).isClone(true).offset(this.offset + offset).length(length).resourceDescription(sliceDescription), this.fileInfo, this.directory, this.transferManager);
    }

    @Override
    protected IndexInput fetchBlock(int blockId) throws IOException {
        String blockFileName = this.fileName + "." + blockId;
        long blockStart = this.getBlockStart(blockId);
        long blockEnd = blockStart + this.getActualBlockSize(blockId);
        int part = (int)(blockStart / this.partSize);
        long partStart = (long)part * this.partSize;
        long position = blockStart - partStart;
        long length = blockEnd - blockStart;
        BlobFetchRequest blobFetchRequest = BlobFetchRequest.builder().position(position).length(length).blobName(this.fileInfo.partName(part)).directory(this.directory).fileName(blockFileName).build();
        try {
            return this.transferManager.asyncFetchBlob(blobFetchRequest).get();
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error(() -> new ParameterizedMessage("unexpected failure while fetching [{}]", (Object)blobFetchRequest), (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    @Override
    public OnDemandBlockSnapshotIndexInput clone() {
        OnDemandBlockSnapshotIndexInput clone = this.buildSlice("clone", 0L, this.length);
        if (this.currentBlock != null) {
            clone.currentBlock = this.currentBlock.clone();
            clone.currentBlockId = this.currentBlockId;
        }
        return clone;
    }

    protected long getActualBlockSize(int blockId) {
        return blockId != this.getBlock(this.originalFileSize - 1L) ? (long)this.blockSize : (long)(this.getBlockOffset(this.originalFileSize - 1L) + 1);
    }
}

