/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.translog.transfer;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Objects;
import org.opensearch.common.Nullable;
import org.opensearch.common.io.stream.BytesStreamInput;
import org.opensearch.common.io.stream.InputStreamStreamInput;
import org.opensearch.core.internal.io.IOUtils;
import org.opensearch.index.translog.BufferedChecksumStreamInput;

public class FileSnapshot
implements Closeable {
    private final String name;
    @Nullable
    private final FileChannel fileChannel;
    @Nullable
    private Path path;
    @Nullable
    private byte[] content;

    private FileSnapshot(Path path) throws IOException {
        Objects.requireNonNull(path);
        this.name = path.getFileName().toString();
        this.path = path;
        this.fileChannel = FileChannel.open(path, StandardOpenOption.READ);
    }

    private FileSnapshot(String name, byte[] content) {
        Objects.requireNonNull(name);
        this.name = name;
        this.content = content;
        this.fileChannel = null;
    }

    public Path getPath() {
        return this.path;
    }

    public String getName() {
        return this.name;
    }

    public long getContentLength() throws IOException {
        return this.fileChannel == null ? (long)this.content.length : this.fileChannel.size();
    }

    public InputStream inputStream() throws IOException {
        return this.fileChannel != null ? new BufferedChecksumStreamInput(new InputStreamStreamInput(Channels.newInputStream(this.fileChannel), this.fileChannel.size()), this.path.toString()) : new BufferedChecksumStreamInput(new BytesStreamInput(this.content), this.name);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.content, this.path);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileSnapshot other = (FileSnapshot)o;
        return Objects.equals(this.name, other.name) && Objects.equals(this.content, other.content) && Objects.equals(this.path, other.path);
    }

    public String toString() {
        return "FileInfo [" + " name = " + this.name + ", path = " + this.path.toUri() + "]";
    }

    @Override
    public void close() throws IOException {
        IOUtils.close((Closeable)this.fileChannel);
    }

    public static final class CheckpointFileSnapshot
    extends TransferFileSnapshot {
        private final long generation;
        private final long minTranslogGeneration;

        public CheckpointFileSnapshot(long primaryTerm, long generation, long minTranslogGeneration, Path path) throws IOException {
            super(path, primaryTerm);
            this.minTranslogGeneration = minTranslogGeneration;
            this.generation = generation;
        }

        public long getGeneration() {
            return this.generation;
        }

        public long getMinTranslogGeneration() {
            return this.minTranslogGeneration;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.generation, this.minTranslogGeneration, super.hashCode());
        }

        @Override
        public boolean equals(Object o) {
            if (super.equals(o)) {
                if (this == o) {
                    return true;
                }
                if (this.getClass() != o.getClass()) {
                    return false;
                }
                CheckpointFileSnapshot other = (CheckpointFileSnapshot)o;
                return Objects.equals(this.minTranslogGeneration, other.minTranslogGeneration) && Objects.equals(this.generation, other.generation);
            }
            return false;
        }
    }

    public static final class TranslogFileSnapshot
    extends TransferFileSnapshot {
        private final long generation;

        public TranslogFileSnapshot(long primaryTerm, long generation, Path path) throws IOException {
            super(path, primaryTerm);
            this.generation = generation;
        }

        public long getGeneration() {
            return this.generation;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.generation, super.hashCode());
        }

        @Override
        public boolean equals(Object o) {
            if (super.equals(o)) {
                if (this == o) {
                    return true;
                }
                if (this.getClass() != o.getClass()) {
                    return false;
                }
                TranslogFileSnapshot other = (TranslogFileSnapshot)o;
                return Objects.equals(this.generation, other.generation);
            }
            return false;
        }
    }

    public static class TransferFileSnapshot
    extends FileSnapshot {
        private final long primaryTerm;

        public TransferFileSnapshot(Path path, long primaryTerm) throws IOException {
            super(path);
            this.primaryTerm = primaryTerm;
        }

        public TransferFileSnapshot(String name, byte[] content, long primaryTerm) throws IOException {
            super(name, content);
            this.primaryTerm = primaryTerm;
        }

        public long getPrimaryTerm() {
            return this.primaryTerm;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.primaryTerm, super.hashCode());
        }

        @Override
        public boolean equals(Object o) {
            if (super.equals(o)) {
                if (this == o) {
                    return true;
                }
                if (this.getClass() != o.getClass()) {
                    return false;
                }
                TransferFileSnapshot other = (TransferFileSnapshot)o;
                return Objects.equals(this.primaryTerm, other.primaryTerm);
            }
            return false;
        }
    }
}

