/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices.replication.common;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Map;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.store.ByteBuffersDataOutput;
import org.apache.lucene.store.ByteBuffersIndexOutput;
import org.apache.lucene.store.IndexOutput;
import org.opensearch.common.concurrent.GatedCloseable;
import org.opensearch.common.util.concurrent.AbstractRefCounted;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.index.store.StoreFileMetadata;
import org.opensearch.indices.replication.checkpoint.ReplicationCheckpoint;

public class CopyState
extends AbstractRefCounted {
    private final GatedCloseable<SegmentInfos> segmentInfosRef;
    private final ReplicationCheckpoint requestedReplicationCheckpoint;
    private final ReplicationCheckpoint replicationCheckpoint;
    private final Map<String, StoreFileMetadata> metadataMap;
    private final byte[] infosBytes;
    private GatedCloseable<IndexCommit> commitRef;
    private final IndexShard shard;

    public CopyState(ReplicationCheckpoint requestedReplicationCheckpoint, IndexShard shard) throws IOException {
        super("CopyState-" + shard.shardId());
        this.requestedReplicationCheckpoint = requestedReplicationCheckpoint;
        this.shard = shard;
        this.segmentInfosRef = shard.getSegmentInfosSnapshot();
        SegmentInfos segmentInfos = this.segmentInfosRef.get();
        this.metadataMap = shard.store().getSegmentMetadataMap(segmentInfos);
        this.replicationCheckpoint = new ReplicationCheckpoint(shard.shardId(), shard.getOperationPrimaryTerm(), segmentInfos.getGeneration(), shard.getProcessedLocalCheckpoint(), segmentInfos.getVersion());
        this.commitRef = shard.acquireLastIndexCommit(false);
        ByteBuffersDataOutput buffer = new ByteBuffersDataOutput();
        try (ByteBuffersIndexOutput indexOutput = new ByteBuffersIndexOutput(buffer, "", null);){
            segmentInfos.write((IndexOutput)indexOutput);
        }
        this.infosBytes = buffer.toArrayCopy();
    }

    protected void closeInternal() {
        try {
            this.segmentInfosRef.close();
            if (this.commitRef != null) {
                this.commitRef.close();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public ReplicationCheckpoint getCheckpoint() {
        return this.replicationCheckpoint;
    }

    public Map<String, StoreFileMetadata> getMetadataMap() {
        return this.metadataMap;
    }

    public byte[] getInfosBytes() {
        return this.infosBytes;
    }

    public IndexShard getShard() {
        return this.shard;
    }

    public ReplicationCheckpoint getRequestedReplicationCheckpoint() {
        return this.requestedReplicationCheckpoint;
    }
}

