/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.profile;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import org.opensearch.search.profile.AbstractProfileBreakdown;
import org.opensearch.search.profile.ProfileResult;

public abstract class AbstractInternalProfileTree<PB extends AbstractProfileBreakdown<?>, E> {
    protected ArrayList<PB> breakdowns = new ArrayList(10);
    protected ArrayList<ArrayList<Integer>> tree;
    protected ArrayList<E> elements;
    protected ArrayList<Integer> roots;
    protected Deque<Integer> stack = new ArrayDeque<Integer>(10);
    private int currentToken = 0;

    public AbstractInternalProfileTree() {
        this.tree = new ArrayList(10);
        this.elements = new ArrayList(10);
        this.roots = new ArrayList(10);
    }

    public PB getProfileBreakdown(E query) {
        int token = this.currentToken++;
        boolean stackEmpty = this.stack.isEmpty();
        if (stackEmpty) {
            this.roots.add(token);
            this.stack.add(token);
            return this.addDependencyNode(query, token);
        }
        this.updateParent(token);
        ++this.currentToken;
        this.stack.add(token);
        return this.addDependencyNode(query, token);
    }

    private PB addDependencyNode(E element, int token) {
        this.tree.add(new ArrayList(5));
        this.elements.add(element);
        PB breakdown = this.createProfileBreakdown();
        this.breakdowns.add(token, breakdown);
        return breakdown;
    }

    protected abstract PB createProfileBreakdown();

    public void pollLast() {
        this.stack.pollLast();
    }

    public List<ProfileResult> getTree() {
        ArrayList<ProfileResult> results = new ArrayList<ProfileResult>(this.roots.size());
        for (Integer root : this.roots) {
            results.add(this.doGetTree(root));
        }
        return results;
    }

    private ProfileResult doGetTree(int token) {
        E element = this.elements.get(token);
        AbstractProfileBreakdown breakdown = (AbstractProfileBreakdown)this.breakdowns.get(token);
        List children = this.tree.get(token);
        List<ProfileResult> childrenProfileResults = Collections.emptyList();
        if (children != null) {
            childrenProfileResults = new ArrayList(children.size());
            for (Integer child : children) {
                ProfileResult childNode = this.doGetTree(child);
                childrenProfileResults.add(childNode);
            }
        }
        String type = this.getTypeFromElement(element);
        String description = this.getDescriptionFromElement(element);
        return new ProfileResult(type, description, breakdown.toBreakdownMap(), breakdown.toDebugMap(), breakdown.toNodeTime(), childrenProfileResults);
    }

    protected abstract String getTypeFromElement(E var1);

    protected abstract String getDescriptionFromElement(E var1);

    private void updateParent(int childToken) {
        Integer parent = this.stack.peekLast();
        ArrayList<Integer> parentNode = this.tree.get(parent);
        parentNode.add(childToken);
        this.tree.set(parent, parentNode);
    }
}

