/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.profile;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.opensearch.LegacyESVersion;
import org.opensearch.common.ParseField;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.io.stream.Writeable;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.ConstructingObjectParser;
import org.opensearch.common.xcontent.InstantiatingObjectParser;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.ToXContentObject;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentParser;

public final class ProfileResult
implements Writeable,
ToXContentObject {
    static final ParseField TYPE = new ParseField("type", new String[0]);
    static final ParseField DESCRIPTION = new ParseField("description", new String[0]);
    static final ParseField BREAKDOWN = new ParseField("breakdown", new String[0]);
    static final ParseField DEBUG = new ParseField("debug", new String[0]);
    static final ParseField NODE_TIME = new ParseField("time", new String[0]);
    static final ParseField NODE_TIME_RAW = new ParseField("time_in_nanos", new String[0]);
    static final ParseField CHILDREN = new ParseField("children", new String[0]);
    private final String type;
    private final String description;
    private final Map<String, Long> breakdown;
    private final Map<String, Object> debug;
    private final long nodeTime;
    private final List<ProfileResult> children;
    private static final InstantiatingObjectParser<ProfileResult, Void> PARSER;

    public ProfileResult(String type, String description, Map<String, Long> breakdown, Map<String, Object> debug, long nodeTime, List<ProfileResult> children) {
        this.type = type;
        this.description = description;
        this.breakdown = Objects.requireNonNull(breakdown, "required breakdown argument missing");
        this.debug = debug == null ? org.opensearch.common.collect.Map.of() : debug;
        this.children = children == null ? org.opensearch.common.collect.List.of() : children;
        this.nodeTime = nodeTime;
    }

    public ProfileResult(StreamInput in) throws IOException {
        this.type = in.readString();
        this.description = in.readString();
        this.nodeTime = in.readLong();
        this.breakdown = in.readMap(StreamInput::readString, StreamInput::readLong);
        this.debug = in.getVersion().onOrAfter(LegacyESVersion.V_7_9_0) ? in.readMap(StreamInput::readString, StreamInput::readGenericValue) : org.opensearch.common.collect.Map.of();
        this.children = in.readList(ProfileResult::new);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.type);
        out.writeString(this.description);
        out.writeLong(this.nodeTime);
        out.writeMap(this.breakdown, StreamOutput::writeString, StreamOutput::writeLong);
        if (out.getVersion().onOrAfter(LegacyESVersion.V_7_9_0)) {
            out.writeMap(this.debug, StreamOutput::writeString, StreamOutput::writeGenericValue);
        }
        out.writeList(this.children);
    }

    public String getLuceneDescription() {
        return this.description;
    }

    public String getQueryName() {
        return this.type;
    }

    public Map<String, Long> getTimeBreakdown() {
        return Collections.unmodifiableMap(this.breakdown);
    }

    public Map<String, Object> getDebugInfo() {
        return Collections.unmodifiableMap(this.debug);
    }

    public long getTime() {
        return this.nodeTime;
    }

    public List<ProfileResult> getProfiledChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(TYPE.getPreferredName(), this.type);
        builder.field(DESCRIPTION.getPreferredName(), this.description);
        if (builder.humanReadable()) {
            builder.field(NODE_TIME.getPreferredName(), new TimeValue(this.getTime(), TimeUnit.NANOSECONDS).toString());
        }
        builder.field(NODE_TIME_RAW.getPreferredName(), this.getTime());
        builder.field(BREAKDOWN.getPreferredName(), this.breakdown);
        if (!this.debug.isEmpty()) {
            builder.field(DEBUG.getPreferredName(), this.debug);
        }
        if (!this.children.isEmpty()) {
            builder.startArray(CHILDREN.getPreferredName());
            for (ProfileResult child : this.children) {
                builder = child.toXContent(builder, params);
            }
            builder.endArray();
        }
        return builder.endObject();
    }

    public static ProfileResult fromXContent(XContentParser p) throws IOException {
        return (ProfileResult)PARSER.parse(p, null);
    }

    static {
        InstantiatingObjectParser.Builder parser = InstantiatingObjectParser.builder((String)"profile_result", (boolean)true, ProfileResult.class);
        parser.declareString(ConstructingObjectParser.constructorArg(), TYPE);
        parser.declareString(ConstructingObjectParser.constructorArg(), DESCRIPTION);
        parser.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> p.map(), BREAKDOWN);
        parser.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.map(), DEBUG);
        parser.declareLong(ConstructingObjectParser.constructorArg(), NODE_TIME_RAW);
        parser.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ProfileResult.fromXContent(p), CHILDREN);
        PARSER = parser.build();
    }
}

