/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce;

import javax.crypto.SecretKey;
import org.bouncycastle.jcajce.AgreedKeyWithMacKey;
import org.bouncycastle.jcajce.ZeroizableSecretKey;
import org.bouncycastle.util.Arrays;

public final class KTSKeyWithEncapsulation
implements SecretKey {
    private final SecretKey secretKey;
    private final byte[] encapsulation;

    public KTSKeyWithEncapsulation(SecretKey secretKey, byte[] byArray) {
        this.secretKey = secretKey;
        this.encapsulation = Arrays.clone(byArray);
    }

    public String getAlgorithm() {
        return this.secretKey.getAlgorithm();
    }

    public String getFormat() {
        return this.secretKey.getFormat();
    }

    public byte[] getEncoded() {
        return this.secretKey.getEncoded();
    }

    public byte[] getEncapsulation() {
        return Arrays.clone(this.encapsulation);
    }

    public ZeroizableSecretKey getMacKey() {
        if (this.secretKey instanceof AgreedKeyWithMacKey) {
            return ((AgreedKeyWithMacKey)this.secretKey).getMacKey();
        }
        return null;
    }

    public boolean equals(Object object) {
        return this.secretKey.equals(object);
    }

    public int hashCode() {
        return this.secretKey.hashCode();
    }
}

