/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.geospatial.geojson;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.opensearch.geospatial.GeospatialParser;

public final class FeatureCollection {
    public static final String TYPE = "FeatureCollection";
    public static final String FEATURES_KEY = "features";
    public static final String TYPE_KEY = "type";
    private final List<Map<String, Object>> features = new ArrayList<Map<String, Object>>();

    private FeatureCollection() {
    }

    public void addFeature(@NonNull Map<String, Object> featureMap) {
        if (featureMap == null) {
            throw new NullPointerException("featureMap is marked non-null but is null");
        }
        this.features.add(featureMap);
    }

    public static FeatureCollection create(@NonNull Map<String, Object> input) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        Object geoJSONType = input.get(TYPE_KEY);
        if (geoJSONType == null) {
            throw new IllegalArgumentException("type cannot be null");
        }
        if (!TYPE.equalsIgnoreCase(geoJSONType.toString())) {
            throw new IllegalArgumentException("Unknown type [ " + geoJSONType + " ], expected type [ FeatureCollection ]");
        }
        return FeatureCollection.extract(input);
    }

    private static FeatureCollection extract(Map<String, Object> input) {
        FeatureCollection collection = new FeatureCollection();
        Object featureObject = input.get(FEATURES_KEY);
        if (featureObject == null) {
            return collection;
        }
        if (!(featureObject instanceof List)) {
            throw new IllegalArgumentException("features is not an instance of type List, but of type [ " + featureObject.getClass().getName() + " ]");
        }
        List featureArray = (List)featureObject;
        featureArray.stream().map(GeospatialParser::toStringObjectMap).forEach(collection::addFeature);
        return collection;
    }

    public List<Map<String, Object>> getFeatures() {
        return this.features;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FeatureCollection)) {
            return false;
        }
        FeatureCollection other = (FeatureCollection)o;
        List<Map<String, Object>> this$features = this.getFeatures();
        List<Map<String, Object>> other$features = other.getFeatures();
        return !(this$features == null ? other$features != null : !((Object)this$features).equals(other$features));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Map<String, Object>> $features = this.getFeatures();
        result = result * 59 + ($features == null ? 43 : ((Object)$features).hashCode());
        return result;
    }

    public String toString() {
        return "FeatureCollection(features=" + this.getFeatures() + ")";
    }
}

