/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.dataframe;

import java.io.IOException;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.Writeable;
import org.opensearch.ml.common.dataframe.BooleanValue;
import org.opensearch.ml.common.dataframe.ColumnType;
import org.opensearch.ml.common.dataframe.ColumnValue;
import org.opensearch.ml.common.dataframe.DoubleValue;
import org.opensearch.ml.common.dataframe.FloatValue;
import org.opensearch.ml.common.dataframe.IntValue;
import org.opensearch.ml.common.dataframe.LongValue;
import org.opensearch.ml.common.dataframe.NullValue;
import org.opensearch.ml.common.dataframe.ShortValue;
import org.opensearch.ml.common.dataframe.StringValue;

public class ColumnValueReader
implements Writeable.Reader<ColumnValue> {
    public ColumnValue read(StreamInput in) throws IOException {
        ColumnType columnType = (ColumnType)in.readEnum(ColumnType.class);
        switch (columnType) {
            case SHORT: {
                return new ShortValue(in.readShort());
            }
            case INTEGER: {
                return new IntValue(in.readInt());
            }
            case LONG: {
                return new LongValue(in.readLong());
            }
            case DOUBLE: {
                return new DoubleValue(in.readDouble());
            }
            case STRING: {
                return new StringValue(in.readString());
            }
            case BOOLEAN: {
                return new BooleanValue(in.readBoolean());
            }
            case FLOAT: {
                return new FloatValue(in.readFloat());
            }
            case NULL: {
                return new NullValue();
            }
        }
        throw new IllegalArgumentException("unknown type:" + columnType);
    }
}

