/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import org.firebirdsql.encodings.Encoding;
import org.firebirdsql.encodings.EncodingDefinition;
import org.firebirdsql.encodings.IEncodingFactory;
import org.firebirdsql.extern.decimal.Decimal128;
import org.firebirdsql.extern.decimal.Decimal64;

public interface DatatypeCoder {
    public static final int NANOSECONDS_PER_FRACTION = 100000;
    public static final int FRACTIONS_PER_MILLISECOND = 10;
    public static final int FRACTIONS_PER_SECOND = 10000;
    public static final int FRACTIONS_PER_MINUTE = 600000;
    public static final int FRACTIONS_PER_HOUR = 36000000;

    public int sizeOfShort();

    public byte[] encodeShort(short var1);

    public byte[] encodeShort(int var1);

    public void encodeShort(int var1, byte[] var2, int var3);

    public short decodeShort(byte[] var1);

    public short decodeShort(byte[] var1, int var2);

    public byte[] encodeInt(int var1);

    public void encodeInt(int var1, byte[] var2, int var3);

    public int decodeInt(byte[] var1);

    public int decodeInt(byte[] var1, int var2);

    public byte[] encodeLong(long var1);

    public long decodeLong(byte[] var1);

    public byte[] encodeFloat(float var1);

    public float decodeFloat(byte[] var1);

    public byte[] encodeDouble(double var1);

    public double decodeDouble(byte[] var1);

    public byte[] encodeString(String var1);

    public Writer createWriter(OutputStream var1);

    public String decodeString(byte[] var1);

    public Reader createReader(InputStream var1);

    public Timestamp encodeTimestamp(Timestamp var1, Calendar var2);

    public Timestamp encodeTimestamp(Timestamp var1, Calendar var2, boolean var3);

    public byte[] encodeTimestamp(Timestamp var1);

    public byte[] encodeTimestampRaw(RawDateTimeStruct var1);

    public byte[] encodeTimestampCalendar(Timestamp var1, Calendar var2);

    public Timestamp decodeTimestamp(Timestamp var1, Calendar var2);

    public Timestamp decodeTimestamp(Timestamp var1, Calendar var2, boolean var3);

    public Timestamp decodeTimestamp(byte[] var1);

    public RawDateTimeStruct decodeTimestampRaw(byte[] var1);

    public Timestamp decodeTimestampCalendar(byte[] var1, Calendar var2);

    public Time encodeTime(Time var1, Calendar var2, boolean var3);

    public byte[] encodeTime(Time var1);

    public byte[] encodeTimeRaw(RawDateTimeStruct var1);

    public byte[] encodeTimeCalendar(Time var1, Calendar var2);

    public Time decodeTime(Time var1, Calendar var2, boolean var3);

    public Time decodeTime(byte[] var1);

    public RawDateTimeStruct decodeTimeRaw(byte[] var1);

    public Time decodeTimeCalendar(byte[] var1, Calendar var2);

    public Date encodeDate(Date var1, Calendar var2);

    public byte[] encodeDate(Date var1);

    public byte[] encodeDateRaw(RawDateTimeStruct var1);

    public byte[] encodeDateCalendar(Date var1, Calendar var2);

    public Date decodeDate(Date var1, Calendar var2);

    public Date decodeDate(byte[] var1);

    public RawDateTimeStruct decodeDateRaw(byte[] var1);

    public Date decodeDateCalendar(byte[] var1, Calendar var2);

    public boolean decodeBoolean(byte[] var1);

    public byte[] encodeBoolean(boolean var1);

    public byte[] encodeLocalTime(int var1, int var2, int var3, int var4);

    public byte[] encodeLocalDate(int var1, int var2, int var3);

    public byte[] encodeLocalDateTime(int var1, int var2, int var3, int var4, int var5, int var6, int var7);

    public Decimal64 decodeDecimal64(byte[] var1);

    public byte[] encodeDecimal64(Decimal64 var1);

    public Decimal128 decodeDecimal128(byte[] var1);

    public byte[] encodeDecimal128(Decimal128 var1);

    public BigInteger decodeInt128(byte[] var1);

    public byte[] encodeInt128(BigInteger var1);

    public IEncodingFactory getEncodingFactory();

    public EncodingDefinition getEncodingDefinition();

    public Encoding getEncoding();

    public DatatypeCoder forEncodingDefinition(EncodingDefinition var1);

    public DatatypeCoder unwrap();

    public boolean equals(Object var1);

    public int hashCode();

    public static final class RawDateTimeStruct {
        public int year;
        public int month;
        public int day;
        public int hour;
        public int minute;
        public int second;
        public int fractions;

        public RawDateTimeStruct() {
        }

        public RawDateTimeStruct(int encodedDate, boolean hasDate, int encodedTime, boolean hasTime) {
            if (hasDate) {
                this.decodeDate(encodedDate);
            }
            if (hasTime) {
                this.decodeTime(encodedTime);
            }
        }

        public RawDateTimeStruct(RawDateTimeStruct raw) {
            this.year = raw.year;
            this.month = raw.month;
            this.day = raw.day;
            this.hour = raw.hour;
            this.minute = raw.minute;
            this.second = raw.second;
            this.fractions = raw.fractions;
        }

        public int getFractionsAsNanos() {
            return this.fractions * 100000;
        }

        public void setFractionsFromNanos(long nanos) {
            this.fractions = (int)(nanos / 100000L % 10000L);
        }

        public int getEncodedDate() {
            int cpMonth = this.month;
            int cpYear = this.year;
            if (cpMonth > 2) {
                cpMonth -= 3;
            } else {
                cpMonth += 9;
                --cpYear;
            }
            int c = cpYear / 100;
            int ya = cpYear - 100 * c;
            return 146097 * c / 4 + 1461 * ya / 4 + (153 * cpMonth + 2) / 5 + this.day + 1721119 - 2400001;
        }

        private void decodeDate(int encodedDate) {
            int sql_date = encodedDate - 1721119 + 2400001;
            int century = (4 * sql_date - 1) / 146097;
            sql_date = 4 * sql_date - 1 - 146097 * century;
            this.day = sql_date / 4;
            sql_date = (4 * this.day + 3) / 1461;
            this.day = 4 * this.day + 3 - 1461 * sql_date;
            this.day = (this.day + 4) / 4;
            this.month = (5 * this.day - 3) / 153;
            this.day = 5 * this.day - 3 - 153 * this.month;
            this.day = (this.day + 5) / 5;
            this.year = 100 * century + sql_date;
            if (this.month < 10) {
                this.month += 3;
            } else {
                this.month -= 9;
                ++this.year;
            }
        }

        public int getEncodedTime() {
            return this.hour * 36000000 + this.minute * 600000 + this.second * 10000 + this.fractions;
        }

        private void decodeTime(int encodedTime) {
            int fractionsInDay = encodedTime;
            this.hour = fractionsInDay / 36000000;
            this.minute = (fractionsInDay -= this.hour * 36000000) / 600000;
            this.second = (fractionsInDay -= this.minute * 600000) / 10000;
            this.fractions = fractionsInDay - this.second * 10000;
        }
    }
}

