/*
 * Decompiled with CFR 0.152.
 */
package us.fatehi.utility.ioresource;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import us.fatehi.utility.ioresource.InputResourceUtility;
import us.fatehi.utility.ioresource.OutputResource;
import us.fatehi.utility.string.StringFormat;

public final class FileOutputResource
implements OutputResource {
    private static final Logger LOGGER = Logger.getLogger(FileOutputResource.class.getName());
    private final Path outputFile;

    public FileOutputResource(Path filePath) {
        this.outputFile = Objects.requireNonNull(filePath, "No file path provided").normalize().toAbsolutePath();
    }

    public Path getOutputFile() {
        return this.outputFile;
    }

    @Override
    public Writer openNewOutputWriter(Charset charset, boolean appendOutput) throws IOException {
        Objects.requireNonNull(charset, "No output charset provided");
        OpenOption[] openOptions = appendOutput ? new OpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.APPEND} : new OpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING};
        BufferedWriter writer = Files.newBufferedWriter(this.outputFile, charset, openOptions);
        LOGGER.log(Level.FINE, new StringFormat("Opened output writer to file <%s>", this.outputFile));
        return InputResourceUtility.wrapWriter(this.getDescription(), writer, true);
    }

    public String toString() {
        return this.outputFile.toString();
    }
}

