"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.mochaHooks = void 0;
const chai = require("chai");
const consoleOutput_1 = require("./consoleOutput");
chai.config.truncateThreshold = 0; // disable truncating
const mochaHooks = () => {
    const consoleOutput = new consoleOutput_1.ConsoleOutput();
    return {
        beforeEach() {
            consoleOutput.capture();
        },
        afterEach() {
            if (this.currentTest.state !== "passed") {
                consoleOutput.release();
            }
        },
    };
};
exports.mochaHooks = mochaHooks;
//# sourceMappingURL=rootMochaHooks.js.map