"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const vscode_languageserver_textdocument_1 = require("vscode-languageserver-textdocument");
const parser_js_1 = require("./parser.js");
const binder_js_1 = require("./binder.js");
const checker_js_1 = require("./checker.js");
const completion_js_1 = require("./service/completion.js");
const text = `graph {
	node_name_a -- node_name_b [color=blue,
	];
}`;
function main() {
    const parser = new parser_js_1.Parser();
    const sf = parser.parse(text);
    (0, binder_js_1.bindSourceFile)(sf);
    (0, checker_js_1.checkSourceFile)(sf);
    const doc = vscode_languageserver_textdocument_1.TextDocument.create("inmemory://model.json", "DOT", 0, text);
    const requestOffset = text.indexOf("color=blue,\n\t") + "color=blue,\n\t".length;
    const completions = (0, completion_js_1.getCompletions)(doc, sf, doc.positionAt(requestOffset));
    console.dir(completions);
}
main();
//# sourceMappingURL=tester.js.map