/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.toolboxfx.geom;

import eu.hansolo.toolboxfx.ValueObject;
import eu.hansolo.toolboxfx.geom.Location;
import eu.hansolo.toolboxfx.geom.LocationBuilder;
import eu.hansolo.toolboxfx.geom.PoiSize;
import eu.hansolo.toolboxfx.geom.Point;
import javafx.geometry.Dimension2D;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;

public class Poi {
    private double lat;
    private double lon;
    private String name;
    private String info;
    private ValueObject valueObject;
    private PoiSize poiSize;
    private Color fill;
    private Color stroke;
    private Image image;
    private String svgPath;
    private Dimension2D svgPathDim;

    public Poi() {
        this(0.0, 0.0, "", "", null, PoiSize.NORMAL, null, null, null, null, null);
    }

    public Poi(double lat, double lon, String name, String info, ValueObject valueObject, PoiSize poiSize, Color fill, Color stroke, Image image, String svgPath, Dimension2D svgPathDim) {
        this.lat = lat;
        this.lon = lon;
        this.name = name;
        this.info = info;
        this.valueObject = valueObject;
        this.poiSize = poiSize;
        this.fill = fill;
        this.stroke = stroke;
        this.image = image;
        this.svgPath = svgPath;
        this.svgPathDim = svgPathDim;
        if (null == svgPathDim && svgPath != null) {
            throw new IllegalArgumentException("svgPathDim cannot be null");
        }
    }

    public double getLat() {
        return this.lat;
    }

    public void setLat(double lat) {
        this.lat = lat;
    }

    public double getLon() {
        return this.lon;
    }

    public void setLon(double lon) {
        this.lon = lon;
    }

    public Point getLonLat() {
        return new Point(this.lon, this.lat);
    }

    public void setLonLat(Point lonlat) {
        this.lon = lonlat.getX();
        this.lat = lonlat.getY();
    }

    public Point getLatLon() {
        return new Point(this.lat, this.lon);
    }

    public void setLatLon(Point latlon) {
        this.lat = latlon.getY();
        this.lon = latlon.getX();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getInfo() {
        return this.info;
    }

    public void setInfo(String info) {
        this.info = info;
    }

    public ValueObject getValueObject() {
        return this.valueObject;
    }

    public void setValueObject(ValueObject valueObject) {
        this.valueObject = valueObject;
    }

    public PoiSize getPoiSize() {
        return this.poiSize;
    }

    public void setPoiSize(PoiSize poiSize) {
        this.poiSize = poiSize;
    }

    public Color getFill() {
        return this.fill;
    }

    public void setFill(Color fill) {
        this.fill = fill;
    }

    public Color getStroke() {
        return this.stroke;
    }

    public void setStroke(Color stroke) {
        this.stroke = stroke;
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public String getSvgPath() {
        return this.svgPath;
    }

    public void setSvgPath(String svgPath) {
        this.svgPath = svgPath;
    }

    public Dimension2D getSvgPathDim() {
        return this.svgPathDim;
    }

    public void setSvgPathDim(Dimension2D svgPathDim) {
        this.svgPathDim = svgPathDim;
    }

    public Location toLocation() {
        return ((LocationBuilder)((LocationBuilder)((LocationBuilder)((LocationBuilder)((LocationBuilder)LocationBuilder.create().name(this.getName())).fill(this.getFill())).stroke(this.getStroke())).latitude(this.getLat())).longitude(this.getLon())).build();
    }

    public static Poi fromLocation(Location location) {
        return new Poi(location.getLatitude(), location.getLongitude(), location.getName(), "", null, PoiSize.NORMAL, location.getFill(), location.getStroke(), null, null, null);
    }
}

