/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool;

import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001J\u0006\u0010\u0013\u001a\u00020\u0010J\u000e\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0000J\b\u0010\u0015\u001a\u00020\u0003H\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0019"}, d2={"Lmediathek/tool/Version;", "", "major", "", "minor", "patch", "(III)V", "getMajor", "()I", "getMinor", "getPatch", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "isInvalid", "isOlderThan", "toNumber", "toString", "", "Companion", "MediathekView"})
public final class Version {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int major;
    private final int minor;
    private final int patch;
    @NotNull
    private static final Version INVALID_VERSION = new Version(0, 0, 0);
    private static final Logger logger = LogManager.getLogger();

    public Version(int major, int minor, int patch) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
    }

    public final int getMajor() {
        return this.major;
    }

    public final int getMinor() {
        return this.minor;
    }

    public final int getPatch() {
        return this.patch;
    }

    @NotNull
    public String toString() {
        String string = "%d.%d.%d";
        Object[] objectArray = new Object[]{this.major, this.minor, this.patch};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(format, *args)");
        return string2;
    }

    private final int toNumber() {
        return this.major * 100 + this.minor * 10 + this.patch;
    }

    public final boolean isOlderThan(@NotNull Version other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return other.toNumber() > this.toNumber();
    }

    public final boolean isInvalid() {
        return Intrinsics.areEqual(this, INVALID_VERSION);
    }

    public final int component1() {
        return this.major;
    }

    public final int component2() {
        return this.minor;
    }

    public final int component3() {
        return this.patch;
    }

    @NotNull
    public final Version copy(int major, int minor, int patch) {
        return new Version(major, minor, patch);
    }

    public static /* synthetic */ Version copy$default(Version version, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 1) != 0) {
            n = version.major;
        }
        if ((n4 & 2) != 0) {
            n2 = version.minor;
        }
        if ((n4 & 4) != 0) {
            n3 = version.patch;
        }
        return version.copy(n, n2, n3);
    }

    public int hashCode() {
        int result = Integer.hashCode(this.major);
        result = result * 31 + Integer.hashCode(this.minor);
        result = result * 31 + Integer.hashCode(this.patch);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Version)) {
            return false;
        }
        Version version = (Version)other;
        if (this.major != version.major) {
            return false;
        }
        if (this.minor != version.minor) {
            return false;
        }
        return this.patch == version.patch;
    }

    @JvmStatic
    @NotNull
    public static final Version fromString(@NotNull String versionsstring) {
        return Companion.fromString(versionsstring);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0007R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lmediathek/tool/Version$Companion;", "", "()V", "INVALID_VERSION", "Lmediathek/tool/Version;", "getINVALID_VERSION", "()Lmediathek/tool/Version;", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "fromString", "versionsstring", "", "MediathekView"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Version getINVALID_VERSION() {
            return INVALID_VERSION;
        }

        @JvmStatic
        @NotNull
        public final Version fromString(@NotNull String versionsstring) {
            Object object;
            Intrinsics.checkNotNullParameter(versionsstring, "versionsstring");
            Object object2 = new String[]{"."};
            List versions = StringsKt.split$default((CharSequence)StringsKt.replace$default(versionsstring, "-SNAPSHOT", "", false, 4, null), object2, true, 0, 4, null);
            if (versions.size() == 3) {
                try {
                    object2 = new Version(Integer.parseInt((String)versions.get(0)), Integer.parseInt((String)versions.get(1)), Integer.parseInt((String)versions.get(2)));
                }
                catch (Exception ex) {
                    logger.error("Fehler beim Parsen der Version: {}", (Object)versionsstring, (Object)ex);
                    object2 = this.getINVALID_VERSION();
                }
                object = object2;
            } else {
                object = this.getINVALID_VERSION();
            }
            return object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

