/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.replication.task.autofollow;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.OpenSearchException;
import org.opensearch.OpenSearchSecurityException;
import org.opensearch.action.ActionListener;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.admin.indices.get.GetIndexRequest;
import org.opensearch.action.admin.indices.get.GetIndexResponse;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.client.Client;
import org.opensearch.client.IndicesAdminClient;
import org.opensearch.client.OpenSearchClient;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.logging.Loggers;
import org.opensearch.persistent.PersistentTaskState;
import org.opensearch.replication.ReplicationException;
import org.opensearch.replication.ReplicationSettings;
import org.opensearch.replication.action.index.ReplicateIndexAction;
import org.opensearch.replication.action.index.ReplicateIndexRequest;
import org.opensearch.replication.action.index.ReplicateIndexResponse;
import org.opensearch.replication.action.status.ReplicationStatusAction;
import org.opensearch.replication.action.status.ReplicationStatusResponse;
import org.opensearch.replication.action.status.ShardInfoRequest;
import org.opensearch.replication.metadata.ReplicationMetadataManager;
import org.opensearch.replication.metadata.store.ReplicationMetadata;
import org.opensearch.replication.task.CrossClusterReplicationTask;
import org.opensearch.replication.task.ReplicationState;
import org.opensearch.replication.task.autofollow.AutoFollowParams;
import org.opensearch.replication.task.autofollow.AutoFollowStat;
import org.opensearch.replication.task.autofollow.AutoFollowTask;
import org.opensearch.replication.util.CoroutinesKt;
import org.opensearch.replication.util.ExtensionsKt;
import org.opensearch.rest.RestStatus;
import org.opensearch.tasks.TaskId;
import org.opensearch.threadpool.Scheduler;
import org.opensearch.threadpool.ThreadPool;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u001c\n\u0002\b\u0003\u0018\u00002\u00020\u0001By\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u000b\u0012\u0006\u0010\f\u001a\u00020\u0005\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u0012\u0006\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\u0002\u0010\u0019J\b\u00105\u001a\u000206H\u0002J\u0011\u00107\u001a\u000206H\u0094@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00108J#\u00109\u001a\u0002062\u0006\u0010:\u001a\u00020;2\b\u0010<\u001a\u0004\u0018\u00010=H\u0094@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010>J\b\u0010?\u001a\u00020.H\u0016J\u0011\u0010@\u001a\u000206H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00108J\b\u0010A\u001a\u00020BH\u0014J\u0011\u0010C\u001a\u000206H\u0094@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00108J\u0019\u0010D\u001a\u0002062\u0006\u0010E\u001a\u00020\u0005H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010FJ\u001f\u0010G\u001a\u0002062\f\u0010H\u001a\b\u0012\u0004\u0012\u00020\u00050IH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010JJ\b\u0010K\u001a\u00020\u0005H\u0016R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00050\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\u00020\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001eR\u001c\u0010!\u001a\n #*\u0004\u0018\u00010\"0\"X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0011\u0010(\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\u001eR\u0014\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00050\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010+\u001a\u0004\u0018\u00010,X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010-\u001a\u00020.X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u00100\"\u0004\b1\u00102R\u0014\u00103\u001a\b\u0012\u0004\u0012\u00020\u000504X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006L"}, d2={"Lorg/opensearch/replication/task/autofollow/AutoFollowTask;", "Lorg/opensearch/replication/task/CrossClusterReplicationTask;", "id", "", "type", "", "action", "description", "parentTask", "Lorg/opensearch/tasks/TaskId;", "headers", "", "executor", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "threadPool", "Lorg/opensearch/threadpool/ThreadPool;", "client", "Lorg/opensearch/client/Client;", "replicationMetadataManager", "Lorg/opensearch/replication/metadata/ReplicationMetadataManager;", "params", "Lorg/opensearch/replication/task/autofollow/AutoFollowParams;", "replicationSettings", "Lorg/opensearch/replication/ReplicationSettings;", "(JLjava/lang/String;Ljava/lang/String;Ljava/lang/String;Lorg/opensearch/tasks/TaskId;Ljava/util/Map;Ljava/lang/String;Lorg/opensearch/cluster/service/ClusterService;Lorg/opensearch/threadpool/ThreadPool;Lorg/opensearch/client/Client;Lorg/opensearch/replication/metadata/ReplicationMetadataManager;Lorg/opensearch/replication/task/autofollow/AutoFollowParams;Lorg/opensearch/replication/ReplicationSettings;)V", "failedIndices", "Ljava/util/concurrent/ConcurrentSkipListSet;", "followerIndexName", "getFollowerIndexName", "()Ljava/lang/String;", "leaderAlias", "getLeaderAlias", "log", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Lorg/apache/logging/log4j/Logger;", "getParams", "()Lorg/opensearch/replication/task/autofollow/AutoFollowParams;", "patternName", "getPatternName", "replicationJobsQueue", "retryScheduler", "Lorg/opensearch/threadpool/Scheduler$ScheduledCancellable;", "stat", "Lorg/opensearch/replication/task/autofollow/AutoFollowStat;", "getStat", "()Lorg/opensearch/replication/task/autofollow/AutoFollowStat;", "setStat", "(Lorg/opensearch/replication/task/autofollow/AutoFollowStat;)V", "trackingIndicesOnTheCluster", "", "addRetryScheduler", "", "cleanup", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "execute", "scope", "Lkotlinx/coroutines/CoroutineScope;", "initialState", "Lorg/opensearch/persistent/PersistentTaskState;", "(Lkotlinx/coroutines/CoroutineScope;Lorg/opensearch/persistent/PersistentTaskState;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getStatus", "pollForIndices", "replicationTaskResponse", "Lorg/opensearch/replication/task/CrossClusterReplicationTask$CrossClusterReplicationTaskResponse;", "setReplicationMetadata", "startReplication", "leaderIndex", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "startReplicationJobs", "remoteIndices", "", "(Ljava/lang/Iterable;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "toString", "opensearch-cross-cluster-replication"})
public final class AutoFollowTask
extends CrossClusterReplicationTask {
    @NotNull
    private final AutoFollowParams params;
    @NotNull
    private final String leaderAlias;
    @NotNull
    private final String patternName;
    @NotNull
    private final String followerIndexName;
    private final Logger log;
    @NotNull
    private Set<String> trackingIndicesOnTheCluster;
    @NotNull
    private ConcurrentSkipListSet<String> failedIndices;
    @NotNull
    private ConcurrentSkipListSet<String> replicationJobsQueue;
    @Nullable
    private Scheduler.ScheduledCancellable retryScheduler;
    public AutoFollowStat stat;

    public AutoFollowTask(long id, @NotNull String type, @NotNull String action, @NotNull String description, @NotNull TaskId parentTask, @NotNull Map<String, String> headers, @NotNull String executor, @NotNull ClusterService clusterService, @NotNull ThreadPool threadPool, @NotNull Client client, @NotNull ReplicationMetadataManager replicationMetadataManager, @NotNull AutoFollowParams params, @NotNull ReplicationSettings replicationSettings) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter((Object)parentTask, (String)"parentTask");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)threadPool, (String)"threadPool");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)replicationMetadataManager, (String)"replicationMetadataManager");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)replicationSettings, (String)"replicationSettings");
        super(id, type, action, description, parentTask, headers, executor, clusterService, threadPool, client, replicationMetadataManager, replicationSettings);
        this.params = params;
        this.leaderAlias = this.params.getLeaderCluster();
        this.patternName = this.params.getPatternName();
        this.followerIndexName = this.params.getPatternName();
        String[] stringArray = new String[]{this.getLeaderAlias()};
        this.log = Loggers.getLogger(((Object)((Object)this)).getClass(), (String[])stringArray);
        this.trackingIndicesOnTheCluster = SetsKt.emptySet();
        this.failedIndices = new ConcurrentSkipListSet();
        this.replicationJobsQueue = new ConcurrentSkipListSet();
    }

    @NotNull
    public final AutoFollowParams getParams() {
        return this.params;
    }

    @Override
    @NotNull
    protected String getLeaderAlias() {
        return this.leaderAlias;
    }

    @NotNull
    public final String getPatternName() {
        return this.patternName;
    }

    @Override
    @NotNull
    protected String getFollowerIndexName() {
        return this.followerIndexName;
    }

    @Override
    protected Logger getLog() {
        return this.log;
    }

    @NotNull
    public final AutoFollowStat getStat() {
        AutoFollowStat autoFollowStat = this.stat;
        if (autoFollowStat != null) {
            return autoFollowStat;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"stat");
        return null;
    }

    public final void setStat(@NotNull AutoFollowStat autoFollowStat) {
        Intrinsics.checkNotNullParameter((Object)autoFollowStat, (String)"<set-?>");
        this.stat = autoFollowStat;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    protected Object execute(@NotNull CoroutineScope var1_1, @Nullable PersistentTaskState var2_2, @NotNull Continuation<? super Unit> var3_3) {
        if (!(var3_3 instanceof execute.1)) ** GOTO lbl-1000
        var7_4 = var3_3;
        if ((var7_4.label & -2147483648) != 0) {
            var7_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ AutoFollowTask this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.execute(null, null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var8_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                this.setStat(new AutoFollowStat(this.getParams().getPatternName(), this.getReplicationMetadata().getLeaderContext().getResource()));
lbl13:
                // 5 sources

                while (CoroutineScopeKt.isActive((CoroutineScope)scope)) {
                    this.addRetryScheduler();
                    $continuation.L$0 = this;
                    $continuation.L$1 = scope;
                    $continuation.label = 1;
                    v0 = this.pollForIndices((Continuation<? super Unit>)$continuation);
                    ** if (v0 != var8_6) goto lbl23
lbl22:
                    // 1 sources

                    return var8_6;
lbl23:
                    // 1 sources

                    ** GOTO lbl32
                }
                break;
            }
            case 1: {
                scope = (CoroutineScope)$continuation.L$1;
                this = (AutoFollowTask)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl32:
                // 2 sources

                this.getStat().setLastExecutionTime(System.currentTimeMillis());
                $continuation.L$0 = this;
                $continuation.L$1 = scope;
                $continuation.label = 2;
                v1 = DelayKt.delay((long)this.getReplicationSettings().getAutofollowFetchPollDuration().getMillis(), (Continuation)$continuation);
                if (v1 != var8_6) ** GOTO lbl13
                return var8_6;
            }
            case 2: {
                scope = (CoroutineScope)$continuation.L$1;
                this = (AutoFollowTask)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
                    ** GOTO lbl13
                }
                catch (OpenSearchException e) {
                    status = e.status().getStatus();
                    if (status < 500 && status != RestStatus.TOO_MANY_REQUESTS.getStatus()) {
                        this.getLog().error("Exiting autofollow task", (Throwable)e);
                        throw e;
                    }
                    this.getLog().debug("Encountered transient error while running autofollow task", (Throwable)e);
                    $continuation.L$0 = this;
                    $continuation.L$1 = scope;
                    $continuation.label = 3;
                    v2 = DelayKt.delay((long)this.getReplicationSettings().getAutofollowFetchPollDuration().getMillis(), (Continuation)$continuation);
                    if (v2 != var8_6) ** GOTO lbl13
                    return var8_6;
                }
            }
            case 3: {
                scope = (CoroutineScope)$continuation.L$1;
                this = (AutoFollowTask)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
                ** GOTO lbl13
            }
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void addRetryScheduler() {
        Scheduler.ScheduledCancellable scheduledCancellable;
        AutoFollowTask autoFollowTask;
        if (this.retryScheduler != null) {
            Scheduler.ScheduledCancellable scheduledCancellable2 = this.retryScheduler;
            Intrinsics.checkNotNull((Object)scheduledCancellable2);
            if (!scheduledCancellable2.isCancelled()) {
                return;
            }
        }
        AutoFollowTask autoFollowTask2 = this;
        try {
            autoFollowTask = autoFollowTask2;
            scheduledCancellable = this.getThreadPool().schedule(() -> AutoFollowTask.addRetryScheduler$lambda-0(this), this.getReplicationSettings().getAutofollowRetryPollDuration(), "generic");
        }
        catch (Exception e) {
            autoFollowTask = autoFollowTask2;
            this.getLog().error(Intrinsics.stringPlus((String)"Error scheduling retry on failed autofollow indices ", (Object)ExtensionsKt.stackTraceToString(e)));
            scheduledCancellable = null;
        }
        autoFollowTask.retryScheduler = scheduledCancellable;
    }

    @Override
    @Nullable
    protected Object cleanup(@NotNull Continuation<? super Unit> $completion) {
        Scheduler.ScheduledCancellable scheduledCancellable = this.retryScheduler;
        Boolean bl = scheduledCancellable == null ? null : Boxing.boxBoolean((boolean)scheduledCancellable.cancel());
        if (bl == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return bl;
        }
        return Unit.INSTANCE;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final Object pollForIndices(Continuation<? super Unit> var1_1) {
        if (!(var1_1 instanceof pollForIndices.1)) ** GOTO lbl-1000
        var9_2 = var1_1;
        if ((var9_2.label & -2147483648) != 0) {
            var9_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ AutoFollowTask this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return AutoFollowTask.access$pollForIndices(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var10_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                this.getLog().debug("Checking " + this.getLeaderAlias() + " under pattern name " + this.getPatternName() + " for new indices to auto follow");
                entry = this.getReplicationMetadata().getLeaderContext().getResource();
                remoteIndices = new Iterable<String>(){

                    @NotNull
                    public Iterator<String> iterator() {
                        boolean bl = false;
                        boolean $i$f$emptyArray = false;
                        return ArrayIteratorKt.iterator((Object[])new String[0]);
                    }
                };
                remoteClient = this.getClient().getRemoteClusterClient(this.getLeaderAlias());
                $i$f$emptyArray = false;
                var6_11 /* !! */  = new GetIndexRequest.Feature[]{};
                v0 = new GetIndexRequest().features(Arrays.copyOf(var6_11 /* !! */ , var6_11 /* !! */ .length));
                var6_11 /* !! */  = new String[]{entry};
                indexReq = (GetIndexRequest)((GetIndexRequest)v0.indices((String[])var6_11 /* !! */ )).indicesOptions(IndicesOptions.lenientExpandOpen());
                Intrinsics.checkNotNullExpressionValue((Object)remoteClient, (String)"remoteClient");
                var7_10 = remoteClient.admin().indices();
                Intrinsics.checkNotNullExpressionValue((Object)var7_10, (String)"remoteClient.admin().indices()");
                $continuation.L$0 = this;
                $continuation.L$1 = remoteIndices;
                $continuation.L$2 = indexReq;
                $continuation.label = 1;
                v1 = CoroutinesKt.suspending$default(remoteClient, (Function2)new Function2<GetIndexRequest, ActionListener<GetIndexResponse>, Unit>((Object)var7_10){

                    public final void invoke(GetIndexRequest p0, ActionListener<GetIndexResponse> p1) {
                        ((IndicesAdminClient)this.receiver).getIndex(p0, p1);
                    }
                }, true, false, (Continuation)$continuation, 4, null);
                ** if (v1 != var10_4) goto lbl33
lbl32:
                // 1 sources

                return var10_4;
lbl33:
                // 1 sources

                ** GOTO lbl42
            }
            case 1: {
                indexReq = (GetIndexRequest)$continuation.L$2;
                remoteIndices = (Iterable)$continuation.L$1;
                this = (AutoFollowTask)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl42:
                // 2 sources

                $continuation.L$0 = this;
                $continuation.L$1 = remoteIndices;
                $continuation.L$2 = null;
                $continuation.label = 2;
                v2 = ((Function2)v1).invoke((Object)indexReq, (Object)$continuation);
                ** if (v2 != var10_4) goto lbl49
lbl48:
                // 1 sources

                return var10_4;
lbl49:
                // 1 sources

                ** GOTO lbl57
            }
            case 2: {
                remoteIndices = (Iterable)$continuation.L$1;
                this = (AutoFollowTask)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl57:
                    // 2 sources

                    response = (GetIndexResponse)v2;
                    var7_10 = response.getIndices();
                    Intrinsics.checkNotNullExpressionValue((Object)var7_10, (String)"response.indices");
                    remoteIndices = ArraysKt.asIterable((Object[])((Object[])var7_10));
                }
                catch (Exception e) {
                    var5_13 = this.getStat();
                    var6_12 = var5_13.getFailedLeaderCall();
                    var5_13.setFailedLeaderCall(var6_12 + 1L);
                    if (this.getStat().getFailedLeaderCall() <= 0L || this.getStat().getFailedLeaderCall() % (long)10 != 0L) ** GOTO lbl68
                    this.getLog().error(Intrinsics.stringPlus((String)"Fetching remote indices failed with error - ", (Object)ExtensionsKt.stackTraceToString(e)));
                }
lbl68:
                // 3 sources

                var5_13 = this.getClusterService().state().metadata().getConcreteAllIndices();
                Intrinsics.checkNotNullExpressionValue((Object)var5_13, (String)"clusterService.state().m\u2026data().concreteAllIndices");
                currentIndices = ArraysKt.asIterable((Object[])var5_13);
                if (((Collection)CollectionsKt.intersect((Iterable)remoteIndices, (Iterable)currentIndices)).isEmpty() == false && !Intrinsics.areEqual((Object)CollectionsKt.toSet((Iterable)currentIndices), this.trackingIndicesOnTheCluster)) {
                    this.getLog().info("Cannot initiate replication for the following indices from leader (" + this.getLeaderAlias() + ") as indices with same name already exists on the cluster " + CollectionsKt.intersect((Iterable)remoteIndices, (Iterable)currentIndices));
                    this.trackingIndicesOnTheCluster = CollectionsKt.toSet((Iterable)currentIndices);
                }
                remoteIndices = CollectionsKt.minus((Iterable)CollectionsKt.minus((Iterable)CollectionsKt.minus((Iterable)remoteIndices, (Iterable)currentIndices), (Iterable)this.failedIndices), (Iterable)this.replicationJobsQueue);
                this.getStat().setFailCounterForRun(0L);
                $continuation.L$0 = this;
                $continuation.L$1 = null;
                $continuation.L$2 = null;
                $continuation.label = 3;
                v3 = this.startReplicationJobs(remoteIndices, (Continuation<? super Unit>)$continuation);
                if (v3 == var10_4) {
                    return var10_4;
                }
                ** GOTO lbl88
            }
            case 3: {
                this = (AutoFollowTask)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl88:
                // 2 sources

                this.getStat().setFailCount(this.getStat().getFailCounterForRun());
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object startReplicationJobs(Iterable<String> var1_1, Continuation<? super Unit> var2_2) {
        block15: {
            if (!(var2_2 instanceof startReplicationJobs.1)) ** GOTO lbl-1000
            var10_3 = var2_2;
            if ((var10_3.label & -2147483648) != 0) {
                var10_3.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var2_2){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    Object L$4;
                    int I$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ AutoFollowTask this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return AutoFollowTask.access$startReplicationJobs(this.this$0, null, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var11_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    completedJobs = new ConcurrentSkipListSet();
                    var4_7 = this.replicationJobsQueue.iterator();
lbl14:
                    // 4 sources

                    while (var4_7.hasNext()) {
                        index = var4_7.next();
                        Intrinsics.checkNotNullExpressionValue((Object)index, (String)"index");
                        statusReq = new ShardInfoRequest(index, false);
                        $continuation.L$0 = this;
                        $continuation.L$1 = remoteIndices;
                        $continuation.L$2 = completedJobs;
                        $continuation.L$3 = var4_7;
                        $continuation.L$4 = index;
                        $continuation.label = 1;
                        v0 = CoroutinesKt.suspendExecute$default((OpenSearchClient)this.getClient(), ReplicationStatusAction.Companion.getINSTANCE(), (ActionRequest)statusReq, true, false, (Continuation)$continuation, 8, null);
                        ** if (v0 != var11_5) goto lbl29
lbl28:
                        // 1 sources

                        return var11_5;
lbl29:
                        // 1 sources

                        ** GOTO lbl41
                    }
                    break;
                }
                case 1: {
                    index = (String)$continuation.L$4;
                    var4_7 = (Iterator<String>)$continuation.L$3;
                    completedJobs = (ConcurrentSkipListSet)$continuation.L$2;
                    remoteIndices = (Iterable)$continuation.L$1;
                    this = (AutoFollowTask)$continuation.L$0;
                    try {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl41:
                        // 2 sources

                        if (Intrinsics.areEqual((Object)(statusRes = (ReplicationStatusResponse)v0).getStatus(), (Object)"BOOTSTRAPPING")) ** GOTO lbl14
                        completedJobs.add(index);
                    }
                    catch (Exception ex) {
                        this.getLog().error(Intrinsics.stringPlus((String)"Error while fetching the status for index ", (Object)index), (Throwable)ex);
                    }
                    ** GOTO lbl14
                }
            }
            this.replicationJobsQueue.removeAll(completedJobs);
            concurrentJobsAllowed = this.getReplicationSettings().getAutofollowConcurrentJobsTriggerSize();
            if (this.replicationJobsQueue.size() >= concurrentJobsAllowed) {
                this.getLog().debug("Max concurrent replication jobs already in the queue for autofollow task[" + this.getParams().getPatternName() + ']');
                return Unit.INSTANCE;
            }
            totalJobsToTrigger = concurrentJobsAllowed - this.replicationJobsQueue.size();
            var6_11 = remoteIndices.iterator();
lbl56:
            // 2 sources

            while (var6_11.hasNext()) {
                newRemoteIndex = (String)var6_11.next();
                if (totalJobsToTrigger <= 0) break block15;
                $continuation.L$0 = this;
                $continuation.L$1 = var6_11;
                $continuation.L$2 = newRemoteIndex;
                $continuation.L$3 = null;
                $continuation.L$4 = null;
                $continuation.I$0 = totalJobsToTrigger;
                $continuation.label = 2;
                v1 = this.startReplication(newRemoteIndex, (Continuation<? super Unit>)$continuation);
                if (v1 == var11_5) {
                    return var11_5;
                }
                ** GOTO lbl78
            }
            {
                break;
                case 2: {
                    totalJobsToTrigger = $continuation.I$0;
                    newRemoteIndex = (String)$continuation.L$2;
                    var6_11 = (Iterator<T>)$continuation.L$1;
                    this = (AutoFollowTask)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl78:
                    // 2 sources

                    this.replicationJobsQueue.add(newRemoteIndex);
                    var8_14 = totalJobsToTrigger;
                    totalJobsToTrigger = var8_14 + -1;
                    ** GOTO lbl56
                }
            }
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final Object startReplication(String var1_1, Continuation<? super Unit> var2_2) {
        if (!(var2_2 instanceof startReplication.1)) ** GOTO lbl-1000
        var10_3 = var2_2;
        if ((var10_3.label & -2147483648) != 0) {
            var10_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                Object L$1;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ AutoFollowTask this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return AutoFollowTask.access$startReplication(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var11_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (this.getClusterService().state().metadata().hasIndex(leaderIndex)) {
                    this.getLog().info(StringsKt.trimMargin$default((String)("Cannot replicate " + this.getLeaderAlias() + ':' + leaderIndex + " as an index with the same name already \n                        |exists."), null, (int)1, null));
                    return Unit.INSTANCE;
                }
                successStart = 0;
                this.getLog().info("Auto follow starting replication from " + this.getLeaderAlias() + ':' + leaderIndex + " -> " + leaderIndex);
                request = new ReplicateIndexRequest(leaderIndex, this.getLeaderAlias(), leaderIndex, null, 8, null);
                request.setAutoFollowRequest(true);
                v0 = this.getReplicationMetadata().getFollowerContext().getUser();
                if (v0 == null) {
                    v1 = null;
                } else {
                    v2 = v0.getRoles();
                    v1 = v2 == null ? null : (String)v2.get(0);
                }
                followerRole = v1;
                v3 = this.getReplicationMetadata().getLeaderContext().getUser();
                if (v3 == null) {
                    v4 = null;
                } else {
                    v5 = v3.getRoles();
                    v4 = leaderRole = v5 == null ? null : (String)v5.get(0);
                }
                if (followerRole != null && leaderRole != null) {
                    request.setUseRoles(new HashMap<String, String>());
                    v6 = request.getUseRoles();
                    Intrinsics.checkNotNull(v6);
                    var7_26 = v6;
                    var8_27 = "follower_cluster_role";
                    var7_26.put(var8_27, followerRole);
                    v7 = request.getUseRoles();
                    Intrinsics.checkNotNull(v7);
                    var7_26 = v7;
                    var8_27 = "leader_cluster_role";
                    var7_26.put(var8_27, leaderRole);
                }
                request.setSettings(this.getReplicationMetadata().getSettings());
                $continuation.L$0 = this;
                $continuation.L$1 = leaderIndex;
                $continuation.I$0 = successStart;
                $continuation.label = 1;
                v8 = CoroutinesKt.suspendExecute$default((OpenSearchClient)this.getClient(), this.getReplicationMetadata(), ReplicateIndexAction.Companion.getINSTANCE(), (ActionRequest)request, false, (Continuation)$continuation, 8, null);
                ** if (v8 != var11_5) goto lbl56
lbl55:
                // 1 sources

                return var11_5;
lbl56:
                // 1 sources

                ** GOTO lbl65
            }
            case 1: {
                successStart = $continuation.I$0;
                leaderIndex = (String)$continuation.L$1;
                this = (AutoFollowTask)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v8 = $result;
lbl65:
                    // 2 sources

                    if (!(response = (ReplicateIndexResponse)v8).isAcknowledged()) {
                        throw new ReplicationException(Intrinsics.stringPlus((String)"Failed to auto follow leader index ", (Object)leaderIndex), new Object[0]);
                    }
                    successStart = 1;
                }
                catch (OpenSearchSecurityException e) {
                    this.getLog().trace("Cannot start replication on " + leaderIndex + " due to missing permissions " + (Object)e);
                    this.failedIndices.add(leaderIndex);
                }
                catch (Exception e) {
                    this.getLog().warn("Failed to start replication for " + this.getLeaderAlias() + ':' + leaderIndex + " -> " + leaderIndex + '.', (Throwable)e);
                    {
                        catch (Throwable var4_14) {
                            throw var4_14;
                        }
                    }
                }
                request = this.getStat();
                var5_16 = request.getSuccessCount();
                request.setSuccessCount(var5_16 + 1L);
                this.getStat().getFailedIndices().remove(leaderIndex);
                ** GOTO lbl101
            }
            {
                finally {
                    if (successStart != 0) {
                        e = this.getStat();
                        var5_17 = e.getSuccessCount();
                        e.setSuccessCount(var5_17 + 1L);
                        this.getStat().getFailedIndices().remove(leaderIndex);
                    } else {
                        e = this.getStat();
                        var5_18 = e.getFailCounterForRun();
                        e.setFailCounterForRun(var5_18 + 1L);
                        this.getStat().getFailedIndices().add(leaderIndex);
                    }
                }
            }
lbl101:
            // 3 sources

            return Unit.INSTANCE;
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @NotNull
    public String toString() {
        return "AutoFollowTask(from=" + this.getLeaderAlias() + " with pattern=" + this.params.getPatternName() + ')';
    }

    @Override
    @NotNull
    protected CrossClusterReplicationTask.CrossClusterReplicationTaskResponse replicationTaskResponse() {
        return new CrossClusterReplicationTask.CrossClusterReplicationTaskResponse(ReplicationState.COMPLETED.name());
    }

    @NotNull
    public AutoFollowStat getStatus() {
        return this.getStat();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    protected Object setReplicationMetadata(@NotNull Continuation<? super Unit> var1_1) {
        if (!(var1_1 instanceof setReplicationMetadata.1)) ** GOTO lbl-1000
        var4_2 = var1_1;
        if ((var4_2.label & -2147483648) != 0) {
            var4_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ AutoFollowTask this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.setReplicationMetadata((Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var5_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var2_5 = this;
                $continuation.L$0 = var2_5;
                $continuation.label = 1;
                v0 = this.getReplicationMetadataManager().getAutofollowMetadata(this.getFollowerIndexName(), this.getLeaderAlias(), true, (Continuation<? super ReplicationMetadata>)$continuation);
                if (v0 == var5_4) {
                    return var5_4;
                }
                ** GOTO lbl23
            }
            case 1: {
                var2_5 = (AutoFollowTask)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl23:
                // 2 sources

                var2_5.setReplicationMetadata((ReplicationMetadata)v0);
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private static final void addRetryScheduler$lambda-0(AutoFollowTask this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.failedIndices.clear();
    }

    public static final /* synthetic */ Object access$pollForIndices(AutoFollowTask $this, Continuation $completion) {
        return $this.pollForIndices((Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$startReplicationJobs(AutoFollowTask $this, Iterable remoteIndices, Continuation $completion) {
        return $this.startReplicationJobs(remoteIndices, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$startReplication(AutoFollowTask $this, String leaderIndex, Continuation $completion) {
        return $this.startReplication(leaderIndex, (Continuation<? super Unit>)$completion);
    }
}

