/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.rca.samplers;

import java.util.Objects;
import org.opensearch.performanceanalyzer.AppContext;
import org.opensearch.performanceanalyzer.rca.framework.metrics.ReaderMetrics;
import org.opensearch.performanceanalyzer.rca.framework.util.InstanceDetails;
import org.opensearch.performanceanalyzer.rca.stats.collectors.SampleAggregator;
import org.opensearch.performanceanalyzer.rca.stats.emitters.ISampler;
import org.opensearch.performanceanalyzer.reader.ReaderMetricsProcessor;

public class BatchMetricsEnabledSampler
implements ISampler {
    private final AppContext appContext;

    public BatchMetricsEnabledSampler(AppContext appContext) {
        Objects.requireNonNull(appContext);
        this.appContext = appContext;
    }

    @Override
    public void sample(SampleAggregator sampleCollector) {
        sampleCollector.updateStat(ReaderMetrics.BATCH_METRICS_ENABLED, "", this.isBatchMetricsEnabled() ? 1 : 0);
    }

    boolean isBatchMetricsEnabled() {
        InstanceDetails currentNode = this.appContext.getMyInstanceDetails();
        if (currentNode != null && currentNode.getIsClusterManager()) {
            return ReaderMetricsProcessor.getInstance().getBatchMetricsEnabled();
        }
        return false;
    }
}

