/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.output.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.io.stream.Writeable;

public class ModelResultFilter
implements Writeable {
    protected final boolean returnBytes;
    protected final boolean returnNumber;
    protected final List<String> targetResponse;
    protected final List<Integer> targetResponsePositions;

    public ModelResultFilter(boolean returnBytes, boolean returnNumber, List<String> targetResponse, List<Integer> targetResponsePositions) {
        this.returnBytes = returnBytes;
        this.returnNumber = returnNumber;
        this.targetResponse = targetResponse;
        this.targetResponsePositions = targetResponsePositions;
    }

    public ModelResultFilter(StreamInput streamInput) throws IOException {
        this.returnBytes = streamInput.readBoolean();
        this.returnNumber = streamInput.readBoolean();
        this.targetResponse = streamInput.readOptionalStringList();
        if (streamInput.readBoolean()) {
            int size = streamInput.readInt();
            this.targetResponsePositions = new ArrayList<Integer>();
            for (int i = 0; i < size; ++i) {
                this.targetResponsePositions.add(streamInput.readInt());
            }
        } else {
            this.targetResponsePositions = null;
        }
    }

    public void writeTo(StreamOutput streamOutput) throws IOException {
        streamOutput.writeBoolean(this.returnBytes);
        streamOutput.writeBoolean(this.returnNumber);
        streamOutput.writeOptionalStringCollection(this.targetResponse);
        if (this.targetResponsePositions != null && this.targetResponsePositions.size() > 0) {
            streamOutput.writeBoolean(true);
            streamOutput.writeInt(this.targetResponsePositions.size());
            for (Integer value : this.targetResponsePositions) {
                streamOutput.writeInt(value.intValue());
            }
        } else {
            streamOutput.writeBoolean(false);
        }
    }

    @Generated
    public static ModelResultFilterBuilder builder() {
        return new ModelResultFilterBuilder();
    }

    @Generated
    public boolean isReturnBytes() {
        return this.returnBytes;
    }

    @Generated
    public boolean isReturnNumber() {
        return this.returnNumber;
    }

    @Generated
    public List<String> getTargetResponse() {
        return this.targetResponse;
    }

    @Generated
    public List<Integer> getTargetResponsePositions() {
        return this.targetResponsePositions;
    }

    @Generated
    public static class ModelResultFilterBuilder {
        @Generated
        private boolean returnBytes;
        @Generated
        private boolean returnNumber;
        @Generated
        private List<String> targetResponse;
        @Generated
        private List<Integer> targetResponsePositions;

        @Generated
        ModelResultFilterBuilder() {
        }

        @Generated
        public ModelResultFilterBuilder returnBytes(boolean returnBytes) {
            this.returnBytes = returnBytes;
            return this;
        }

        @Generated
        public ModelResultFilterBuilder returnNumber(boolean returnNumber) {
            this.returnNumber = returnNumber;
            return this;
        }

        @Generated
        public ModelResultFilterBuilder targetResponse(List<String> targetResponse) {
            this.targetResponse = targetResponse;
            return this;
        }

        @Generated
        public ModelResultFilterBuilder targetResponsePositions(List<Integer> targetResponsePositions) {
            this.targetResponsePositions = targetResponsePositions;
            return this;
        }

        @Generated
        public ModelResultFilter build() {
            return new ModelResultFilter(this.returnBytes, this.returnNumber, this.targetResponse, this.targetResponsePositions);
        }

        @Generated
        public String toString() {
            return "ModelResultFilter.ModelResultFilterBuilder(returnBytes=" + this.returnBytes + ", returnNumber=" + this.returnNumber + ", targetResponse=" + this.targetResponse + ", targetResponsePositions=" + this.targetResponsePositions + ")";
        }
    }
}

