/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.nio;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketOption;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.NetworkChannel;
import java.nio.channels.SocketChannel;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.opensearch.common.concurrent.CompletableContext;
import org.opensearch.core.internal.net.NetUtils;
import org.opensearch.nio.ChannelContext;
import org.opensearch.nio.Config;
import org.opensearch.nio.FlushOperation;
import org.opensearch.nio.InboundChannelBuffer;
import org.opensearch.nio.NioChannelHandler;
import org.opensearch.nio.NioSelector;
import org.opensearch.nio.NioSocketChannel;
import org.opensearch.nio.WriteOperation;
import org.opensearch.nio.utils.ByteBufferUtils;
import org.opensearch.nio.utils.ExceptionsHelper;

public abstract class SocketChannelContext
extends ChannelContext<SocketChannel> {
    protected final NioSocketChannel channel;
    protected final InboundChannelBuffer channelBuffer;
    protected final AtomicBoolean isClosing = new AtomicBoolean(false);
    private final NioChannelHandler channelHandler;
    private final NioSelector selector;
    private final Config.Socket socketConfig;
    private final CompletableContext<Void> connectContext = new CompletableContext();
    private final LinkedList<FlushOperation> pendingFlushes = new LinkedList();
    private boolean closeNow;
    private boolean socketOptionsSet;
    private Exception connectException;
    private static final int WRITE_LIMIT = 65536;

    protected SocketChannelContext(NioSocketChannel channel, NioSelector selector, Config.Socket socketConfig, Consumer<Exception> exceptionHandler, NioChannelHandler channelHandler, InboundChannelBuffer channelBuffer) {
        super(channel.getRawChannel(), exceptionHandler);
        this.selector = selector;
        this.channel = channel;
        this.socketConfig = socketConfig;
        this.channelHandler = channelHandler;
        this.channelBuffer = channelBuffer;
    }

    @Override
    public NioSelector getSelector() {
        return this.selector;
    }

    @Override
    public NioSocketChannel getChannel() {
        return this.channel;
    }

    @Override
    protected void register() throws IOException {
        super.register();
        this.configureSocket(((SocketChannel)this.rawChannel).socket(), false);
        if (!this.socketConfig.isAccepted()) {
            InetSocketAddress remoteAddress = this.socketConfig.getRemoteAddress();
            try {
                SocketChannelContext.connect((SocketChannel)this.rawChannel, remoteAddress);
            }
            catch (IOException e) {
                throw new IOException("Failed to initiate socket channel connection {remoteAddress=" + remoteAddress + "}.", e);
            }
        }
    }

    public void addConnectListener(BiConsumer<Void, Exception> listener) {
        this.connectContext.addListener(listener);
    }

    public boolean isConnectComplete() {
        return this.connectContext.isDone() && !this.connectContext.isCompletedExceptionally();
    }

    public boolean connect() throws IOException {
        if (this.isConnectComplete()) {
            return true;
        }
        if (this.connectContext.isCompletedExceptionally()) {
            Exception exception = this.connectException;
            if (exception == null) {
                throw new AssertionError((Object)"Should have received connection exception");
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw (RuntimeException)exception;
        }
        boolean isConnected = ((SocketChannel)this.rawChannel).isConnected();
        if (!isConnected) {
            try {
                isConnected = ((SocketChannel)this.rawChannel).finishConnect();
            }
            catch (IOException | RuntimeException e) {
                this.connectException = e;
                this.connectContext.completeExceptionally(e);
                throw e;
            }
        }
        if (isConnected) {
            this.connectContext.complete(null);
            this.configureSocket(((SocketChannel)this.rawChannel).socket(), true);
        }
        return isConnected;
    }

    public void sendMessage(Object message, BiConsumer<Void, Exception> listener) {
        if (this.isClosing.get()) {
            listener.accept(null, new ClosedChannelException());
            return;
        }
        WriteOperation writeOperation = this.channelHandler.createWriteOperation(this, message, listener);
        this.getSelector().queueWrite(writeOperation);
    }

    public void queueWriteOperation(WriteOperation writeOperation) {
        this.getSelector().assertOnSelectorThread();
        this.pendingFlushes.addAll(this.channelHandler.writeToBytes(writeOperation));
    }

    public abstract int read() throws IOException;

    public abstract void flushChannel() throws IOException;

    protected void currentFlushOperationFailed(IOException e) {
        FlushOperation flushOperation = this.pendingFlushes.pollFirst();
        this.getSelector().executeFailedListener(flushOperation.getListener(), e);
    }

    protected void currentFlushOperationComplete() {
        FlushOperation flushOperation = this.pendingFlushes.pollFirst();
        this.getSelector().executeListener(flushOperation.getListener(), null);
    }

    protected FlushOperation getPendingFlush() {
        return this.pendingFlushes.peekFirst();
    }

    @Override
    protected void channelActive() throws IOException {
        this.channelHandler.channelActive();
    }

    @Override
    public void closeFromSelector() throws IOException {
        this.getSelector().assertOnSelectorThread();
        if (this.isOpen()) {
            FlushOperation flushOperation;
            ArrayList<IOException> closingExceptions = new ArrayList<IOException>(3);
            try {
                super.closeFromSelector();
            }
            catch (IOException e) {
                closingExceptions.add(e);
            }
            this.isClosing.set(true);
            this.pendingFlushes.addAll(this.channelHandler.pollFlushOperations());
            while ((flushOperation = this.pendingFlushes.pollFirst()) != null) {
                this.selector.executeFailedListener(flushOperation.getListener(), new ClosedChannelException());
            }
            try {
                this.channelHandler.close();
            }
            catch (IOException e) {
                closingExceptions.add(e);
            }
            this.channelBuffer.close();
            if (!closingExceptions.isEmpty()) {
                ExceptionsHelper.rethrowAndSuppress(closingExceptions);
            }
        }
    }

    protected void handleReadBytes() throws IOException {
        int bytesConsumed = Integer.MAX_VALUE;
        while (this.isOpen() && bytesConsumed > 0 && this.channelBuffer.getIndex() > 0L) {
            bytesConsumed = this.channelHandler.consumeReads(this.channelBuffer);
            this.channelBuffer.release(bytesConsumed);
        }
        this.pendingFlushes.addAll(this.channelHandler.pollFlushOperations());
    }

    public boolean readyForFlush() {
        this.getSelector().assertOnSelectorThread();
        return !this.pendingFlushes.isEmpty();
    }

    public abstract boolean selectorShouldClose();

    protected boolean closeNow() {
        return this.closeNow || this.channelHandler.closeNow();
    }

    protected void setCloseNow() {
        this.closeNow = true;
    }

    protected int readFromChannel(InboundChannelBuffer channelBuffer) throws IOException {
        int bytesRead;
        ByteBuffer ioBuffer = this.getSelector().getIoBuffer();
        try {
            bytesRead = ((SocketChannel)this.rawChannel).read(ioBuffer);
        }
        catch (IOException e) {
            this.closeNow = true;
            throw e;
        }
        if (bytesRead < 0) {
            this.closeNow = true;
            return 0;
        }
        ioBuffer.flip();
        channelBuffer.ensureCapacity(channelBuffer.getIndex() + (long)ioBuffer.remaining());
        ByteBuffer[] buffers = channelBuffer.sliceBuffersFrom(channelBuffer.getIndex());
        int j = 0;
        while (j < buffers.length && ioBuffer.remaining() > 0) {
            ByteBuffer buffer = buffers[j++];
            ByteBufferUtils.copyBytes(ioBuffer, buffer);
        }
        channelBuffer.incrementIndex(bytesRead);
        return bytesRead;
    }

    protected int flushToChannel(FlushOperation flushOperation) throws IOException {
        ByteBuffer ioBuffer = this.getSelector().getIoBuffer();
        boolean continueFlush = !flushOperation.isFullyFlushed();
        int totalBytesFlushed = 0;
        while (continueFlush) {
            int bytesFlushed;
            ioBuffer.clear();
            ioBuffer.limit(Math.min(65536, ioBuffer.limit()));
            ByteBuffer[] buffers = flushOperation.getBuffersToWrite(65536);
            ByteBufferUtils.copyBytes(buffers, ioBuffer);
            ioBuffer.flip();
            try {
                bytesFlushed = ((SocketChannel)this.rawChannel).write(ioBuffer);
            }
            catch (IOException e) {
                this.closeNow = true;
                throw e;
            }
            flushOperation.incrementIndex(bytesFlushed);
            totalBytesFlushed += bytesFlushed;
            continueFlush = !ioBuffer.hasRemaining() && !flushOperation.isFullyFlushed();
        }
        return totalBytesFlushed;
    }

    private void configureSocket(Socket socket, boolean isConnectComplete) throws IOException {
        block9: {
            if (this.socketOptionsSet) {
                return;
            }
            try {
                int tcpReceiveBufferSize;
                socket.setReuseAddress(this.socketConfig.tcpReuseAddress());
                socket.setKeepAlive(this.socketConfig.tcpKeepAlive());
                if (this.socketConfig.tcpKeepAlive()) {
                    SocketOption keepCountOption;
                    SocketOption keepIntervalOption;
                    SocketOption keepIdleOption;
                    Set<SocketOption<?>> supportedOptions = socket.getChannel().supportedOptions();
                    if (this.socketConfig.tcpKeepIdle() >= 0 && (keepIdleOption = NetUtils.getTcpKeepIdleSocketOptionOrNull()) != null && supportedOptions.contains(keepIdleOption)) {
                        socket.getChannel().setOption(keepIdleOption, (Object)this.socketConfig.tcpKeepIdle());
                    }
                    if (this.socketConfig.tcpKeepInterval() >= 0 && (keepIntervalOption = NetUtils.getTcpKeepIntervalSocketOptionOrNull()) != null && supportedOptions.contains(keepIntervalOption)) {
                        socket.getChannel().setOption(keepIntervalOption, (Object)this.socketConfig.tcpKeepInterval());
                    }
                    if (this.socketConfig.tcpKeepCount() >= 0 && (keepCountOption = NetUtils.getTcpKeepCountSocketOptionOrNull()) != null && supportedOptions.contains(keepCountOption)) {
                        socket.getChannel().setOption(keepCountOption, (Object)this.socketConfig.tcpKeepCount());
                    }
                }
                NetUtils.tryEnsureReasonableKeepAliveConfig((NetworkChannel)socket.getChannel());
                socket.setTcpNoDelay(this.socketConfig.tcpNoDelay());
                int tcpSendBufferSize = this.socketConfig.tcpSendBufferSize();
                if (tcpSendBufferSize > 0) {
                    socket.setSendBufferSize(tcpSendBufferSize);
                }
                if ((tcpReceiveBufferSize = this.socketConfig.tcpReceiveBufferSize()) > 0) {
                    socket.setReceiveBufferSize(tcpReceiveBufferSize);
                }
                this.socketOptionsSet = true;
            }
            catch (IOException e) {
                if (!isConnectComplete) break block9;
                throw e;
            }
        }
    }

    private static void connect(SocketChannel socketChannel, InetSocketAddress remoteAddress) throws IOException {
        try {
            AccessController.doPrivileged(() -> socketChannel.connect(remoteAddress));
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getCause();
        }
    }
}

