/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.explanation.io;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import org.protege.editor.core.Disposable;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.OWLEditorKitHook;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.ui.explanation.io.InconsistentOntologyPlugin;
import org.protege.editor.owl.ui.explanation.io.InconsistentOntologyPluginInstance;
import org.protege.editor.owl.ui.explanation.io.IntroductoryPanel;
import org.slf4j.LoggerFactory;

public class InconsistentOntologyManager
extends OWLEditorKitHook {
    public static final String EXPLAIN = "Explain";
    private InconsistentOntologyPlugin lastSelectedPlugin;
    private final List<InconsistentOntologyPluginInstance> explanations = new ArrayList<InconsistentOntologyPluginInstance>();

    public static InconsistentOntologyManager get(OWLModelManager modelManager) {
        return (InconsistentOntologyManager)modelManager.get(InconsistentOntologyManager.class);
    }

    public void initialise() throws Exception {
        OWLEditorKit editorKit = this.getEditorKit();
        OWLModelManager p4Manager = editorKit.getModelManager();
        p4Manager.put(InconsistentOntologyManager.class, (Disposable)this);
    }

    public void explain() {
        try {
            Object[] options = new Object[]{EXPLAIN, "Cancel"};
            OWLEditorKit owlEditorKit = this.getEditorKit();
            IntroductoryPanel intro = new IntroductoryPanel(owlEditorKit, this.lastSelectedPlugin);
            int ret = JOptionPane.showOptionDialog((Component)((Object)owlEditorKit.getOWLWorkspace()), intro, "Help for inconsistent ontologies", 1, 3, null, options, EXPLAIN);
            if (ret == 0) {
                this.lastSelectedPlugin = intro.getSelectedPlugin();
                InconsistentOntologyPluginInstance i = this.lastSelectedPlugin.newInstance();
                i.initialise();
                i.setup(owlEditorKit);
                i.explain(owlEditorKit.getOWLModelManager().getActiveOntology());
                this.explanations.add(i);
            }
        }
        catch (Exception ioe) {
            LoggerFactory.getLogger(InconsistentOntologyManager.class).warn("An error occurred whilst generating an explanation for the inconsistent ontology: {}", (Throwable)ioe);
        }
    }

    public void dispose() throws Exception {
        for (InconsistentOntologyPluginInstance e : this.explanations) {
            e.dispose();
        }
        this.explanations.clear();
    }
}

