/* Dock.c generated by valac 0.56.3, the Vala compiler
 * generated from Dock.vala, do not modify */

/*
* Copyright (c) 2016 elementary LLC. (https://elementary.io)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include "pantheon-desktop.h"
#include <gtk/gtk.h>
#include <plank.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gdk/gdk.h>
#include <libgnome-desktop/gnome-rr.h>
#include <glib/gi18n-lib.h>
#include <glib-object.h>
#include <granite.h>
#include <handy.h>
#include <gio/gio.h>

#define PANTHEON_SHELL_DOCK_PANEL_SCHEMA "io.elementary.desktop.wingpanel"
#define PANTHEON_SHELL_DOCK_TRANSLUCENCY_KEY "use-transparency"

enum  {
	PANTHEON_SHELL_DOCK_0_PROPERTY,
	PANTHEON_SHELL_DOCK_NUM_PROPERTIES
};
static GParamSpec* pantheon_shell_dock_properties[PANTHEON_SHELL_DOCK_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block3Data Block3Data;

struct _PantheonShellDockPrivate {
	GtkLabel* primary_monitor_label;
	GtkSwitch* primary_monitor;
	GtkLabel* monitor_label;
	GtkComboBoxText* monitor;
	PlankDockPreferences* dock_preferences;
};

struct _Block3Data {
	int _ref_count_;
	PantheonShellDock* self;
	GtkComboBoxText* hide_mode;
	PlankHideType* hide_mode_ids;
	gint hide_mode_ids_length1;
	gint _hide_mode_ids_size_;
	GtkSwitch* hide_switch;
};

static gint PantheonShellDock_private_offset;
static gpointer pantheon_shell_dock_parent_class = NULL;

static void pantheon_shell_dock_check_for_screens (PantheonShellDock* self);
static gint pantheon_shell_dock_find_monitor_number (GdkDisplay* display,
                                              const gchar* plug_name);
static gchar** pantheon_shell_dock_get_monitor_plug_names (GdkDisplay* display,
                                                    gint* result_length1);
static GObject * pantheon_shell_dock_constructor (GType type,
                                           guint n_construct_properties,
                                           GObjectConstructParam * construct_properties);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void _pantheon_shell_dock___lambda35_ (Block3Data* _data3_);
static void __pantheon_shell_dock___lambda35__gtk_combo_box_changed (GtkComboBox* _sender,
                                                              gpointer self);
static void _pantheon_shell_dock___lambda36_ (Block3Data* _data3_);
static void __pantheon_shell_dock___lambda36__g_object_notify (GObject* _sender,
                                                        GParamSpec* pspec,
                                                        gpointer self);
static void _pantheon_shell_dock___lambda37_ (PantheonShellDock* self);
static void __pantheon_shell_dock___lambda37__g_object_notify (GObject* _sender,
                                                        GParamSpec* pspec,
                                                        gpointer self);
static void _pantheon_shell_dock___lambda38_ (PantheonShellDock* self);
static void __pantheon_shell_dock___lambda38__g_object_notify (GObject* _sender,
                                                        GParamSpec* pspec,
                                                        gpointer self);
static void _pantheon_shell_dock___lambda39_ (PantheonShellDock* self);
static void __pantheon_shell_dock___lambda39__gdk_screen_monitors_changed (GdkScreen* _sender,
                                                                    gpointer self);
static void _pantheon_shell_dock___lambda40_ (PantheonShellDock* self);
static void __pantheon_shell_dock___lambda40__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                  gpointer self);
static void _pantheon_shell_dock___lambda41_ (PantheonShellDock* self);
static void __pantheon_shell_dock___lambda41__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                  gpointer self);
static void _pantheon_shell_dock___lambda42_ (PantheonShellDock* self);
static void __pantheon_shell_dock___lambda42__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                  gpointer self);
static void pantheon_shell_dock_finalize (GObject * obj);
static GType pantheon_shell_dock_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
pantheon_shell_dock_get_instance_private (PantheonShellDock* self)
{
	return G_STRUCT_MEMBER_P (self, PantheonShellDock_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
pantheon_shell_dock_check_for_screens (PantheonShellDock* self)
{
	gint i = 0;
	gint primary_screen = 0;
	GdkDisplay* default_display = NULL;
	GdkDisplay* _tmp0_;
	GdkDisplay* _tmp1_;
	GdkScreen* default_screen = NULL;
	GdkScreen* _tmp2_;
	GdkScreen* _tmp3_;
	GtkComboBoxText* _tmp4_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	i = 0;
	primary_screen = 0;
	_tmp0_ = gtk_widget_get_display ((GtkWidget*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	default_display = _tmp1_;
	_tmp2_ = gtk_widget_get_screen ((GtkWidget*) self);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	default_screen = _tmp3_;
	_tmp4_ = self->priv->monitor;
	gtk_combo_box_text_remove_all (_tmp4_);
	{
		GnomeRRScreen* screen = NULL;
		GdkScreen* _tmp5_;
		GnomeRRScreen* _tmp6_;
		_tmp5_ = default_screen;
		_tmp6_ = gnome_rr_screen_new (_tmp5_, &_inner_error0_);
		screen = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		{
			gboolean _tmp7_ = FALSE;
			i = 0;
			_tmp7_ = TRUE;
			while (TRUE) {
				GdkDisplay* _tmp9_;
				gchar* monitor_plug_name = NULL;
				GdkDisplay* _tmp10_;
				GdkMonitor* _tmp11_;
				const gchar* _tmp12_;
				const gchar* _tmp13_;
				gchar* _tmp14_;
				const gchar* _tmp15_;
				GtkComboBoxText* _tmp30_;
				gchar* _tmp31_;
				gchar* _tmp32_;
				if (!_tmp7_) {
					gint _tmp8_;
					_tmp8_ = i;
					i = _tmp8_ + 1;
				}
				_tmp7_ = FALSE;
				_tmp9_ = default_display;
				if (!(i < gdk_display_get_n_monitors (_tmp9_))) {
					break;
				}
				_tmp10_ = default_display;
				_tmp11_ = gdk_display_get_monitor (_tmp10_, i);
				_tmp12_ = gdk_monitor_get_model (_tmp11_);
				_tmp13_ = _tmp12_;
				_tmp14_ = g_strdup (_tmp13_);
				monitor_plug_name = _tmp14_;
				_tmp15_ = monitor_plug_name;
				if (_tmp15_ != NULL) {
					GnomeRROutput* output = NULL;
					GnomeRRScreen* _tmp16_;
					const gchar* _tmp17_;
					GnomeRROutput* _tmp18_;
					gboolean _tmp19_ = FALSE;
					gboolean _tmp20_ = FALSE;
					GnomeRROutput* _tmp21_;
					_tmp16_ = screen;
					_tmp17_ = monitor_plug_name;
					_tmp18_ = gnome_rr_screen_get_output_by_name (_tmp16_, _tmp17_);
					output = _tmp18_;
					_tmp21_ = output;
					if (_tmp21_ != NULL) {
						GnomeRROutput* _tmp22_;
						const gchar* _tmp23_;
						_tmp22_ = output;
						_tmp23_ = gnome_rr_output_get_display_name (_tmp22_);
						_tmp20_ = _tmp23_ != NULL;
					} else {
						_tmp20_ = FALSE;
					}
					if (_tmp20_) {
						GnomeRROutput* _tmp24_;
						const gchar* _tmp25_;
						_tmp24_ = output;
						_tmp25_ = gnome_rr_output_get_display_name (_tmp24_);
						_tmp19_ = g_strcmp0 (_tmp25_, "") != 0;
					} else {
						_tmp19_ = FALSE;
					}
					if (_tmp19_) {
						GtkComboBoxText* _tmp26_;
						GnomeRROutput* _tmp27_;
						const gchar* _tmp28_;
						GnomeRROutput* _tmp29_;
						_tmp26_ = self->priv->monitor;
						_tmp27_ = output;
						_tmp28_ = gnome_rr_output_get_display_name (_tmp27_);
						gtk_combo_box_text_append_text (_tmp26_, _tmp28_);
						_tmp29_ = output;
						if (gnome_rr_output_get_is_primary (_tmp29_) == TRUE) {
							primary_screen = i;
						}
						_g_free0 (monitor_plug_name);
						continue;
					}
				}
				_tmp30_ = self->priv->monitor;
				_tmp31_ = g_strdup_printf (_ ("Monitor %d"), i + 1);
				_tmp32_ = _tmp31_;
				gtk_combo_box_text_append_text (_tmp30_, _tmp32_);
				_g_free0 (_tmp32_);
				_g_free0 (monitor_plug_name);
			}
		}
		_g_object_unref0 (screen);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp33_;
		const gchar* _tmp34_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp33_ = e;
		_tmp34_ = _tmp33_->message;
		g_critical ("Dock.vala:252: %s", _tmp34_);
		{
			gboolean _tmp35_ = FALSE;
			i = 0;
			_tmp35_ = TRUE;
			while (TRUE) {
				GdkDisplay* _tmp37_;
				GtkComboBoxText* _tmp38_;
				gchar* _tmp39_;
				gchar* _tmp40_;
				if (!_tmp35_) {
					gint _tmp36_;
					_tmp36_ = i;
					i = _tmp36_ + 1;
				}
				_tmp35_ = FALSE;
				_tmp37_ = default_display;
				if (!(i < gdk_display_get_n_monitors (_tmp37_))) {
					break;
				}
				_tmp38_ = self->priv->monitor;
				_tmp39_ = g_strdup_printf (_ ("Display %d"), i + 1);
				_tmp40_ = _tmp39_;
				gtk_combo_box_text_append_text (_tmp38_, _tmp40_);
				_g_free0 (_tmp40_);
			}
		}
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (default_screen);
		_g_object_unref0 (default_display);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	if (i <= 1) {
		GtkLabel* _tmp41_;
		GtkSwitch* _tmp42_;
		GtkLabel* _tmp43_;
		GtkComboBoxText* _tmp44_;
		GtkComboBoxText* _tmp45_;
		_tmp41_ = self->priv->primary_monitor_label;
		gtk_widget_hide ((GtkWidget*) _tmp41_);
		_tmp42_ = self->priv->primary_monitor;
		gtk_widget_hide ((GtkWidget*) _tmp42_);
		_tmp43_ = self->priv->monitor_label;
		gtk_widget_hide ((GtkWidget*) _tmp43_);
		_tmp44_ = self->priv->monitor;
		gtk_widget_set_no_show_all ((GtkWidget*) _tmp44_, TRUE);
		_tmp45_ = self->priv->monitor;
		gtk_widget_hide ((GtkWidget*) _tmp45_);
	} else {
		PlankDockPreferences* _tmp46_;
		const gchar* _tmp47_;
		const gchar* _tmp48_;
		GtkLabel* _tmp55_;
		GtkSwitch* _tmp56_;
		GtkLabel* _tmp57_;
		GtkComboBoxText* _tmp58_;
		_tmp46_ = self->priv->dock_preferences;
		_tmp47_ = plank_dock_preferences_get_Monitor (_tmp46_);
		_tmp48_ = _tmp47_;
		if (g_strcmp0 (_tmp48_, "") != 0) {
			GtkComboBoxText* _tmp49_;
			GdkDisplay* _tmp50_;
			PlankDockPreferences* _tmp51_;
			const gchar* _tmp52_;
			const gchar* _tmp53_;
			_tmp49_ = self->priv->monitor;
			_tmp50_ = gtk_widget_get_display ((GtkWidget*) self);
			_tmp51_ = self->priv->dock_preferences;
			_tmp52_ = plank_dock_preferences_get_Monitor (_tmp51_);
			_tmp53_ = _tmp52_;
			gtk_combo_box_set_active ((GtkComboBox*) _tmp49_, pantheon_shell_dock_find_monitor_number (_tmp50_, _tmp53_));
		} else {
			GtkComboBoxText* _tmp54_;
			_tmp54_ = self->priv->monitor;
			gtk_combo_box_set_active ((GtkComboBox*) _tmp54_, primary_screen);
		}
		_tmp55_ = self->priv->primary_monitor_label;
		gtk_widget_show ((GtkWidget*) _tmp55_);
		_tmp56_ = self->priv->primary_monitor;
		gtk_widget_show ((GtkWidget*) _tmp56_);
		_tmp57_ = self->priv->monitor_label;
		gtk_widget_show ((GtkWidget*) _tmp57_);
		_tmp58_ = self->priv->monitor;
		gtk_widget_show ((GtkWidget*) _tmp58_);
	}
	_g_object_unref0 (default_screen);
	_g_object_unref0 (default_display);
}

static gchar**
pantheon_shell_dock_get_monitor_plug_names (GdkDisplay* display,
                                            gint* result_length1)
{
	gint n_monitors = 0;
	gchar** _result_ = NULL;
	gchar** _tmp0_;
	gint _result__length1;
	gint __result__size_;
	gchar** _tmp8_;
	gint _tmp8__length1;
	gchar** result;
	g_return_val_if_fail (display != NULL, NULL);
	n_monitors = gdk_display_get_n_monitors (display);
	_tmp0_ = g_new0 (gchar*, n_monitors + 1);
	_result_ = _tmp0_;
	_result__length1 = n_monitors;
	__result__size_ = _result__length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gchar** _tmp3_;
				gint _tmp3__length1;
				GdkMonitor* _tmp4_;
				const gchar* _tmp5_;
				const gchar* _tmp6_;
				gchar* _tmp7_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(i < n_monitors)) {
					break;
				}
				_tmp3_ = _result_;
				_tmp3__length1 = _result__length1;
				_tmp4_ = gdk_display_get_monitor (display, i);
				_tmp5_ = gdk_monitor_get_model (_tmp4_);
				_tmp6_ = _tmp5_;
				_tmp7_ = g_strdup (_tmp6_);
				_g_free0 (_tmp3_[i]);
				_tmp3_[i] = _tmp7_;
			}
		}
	}
	_tmp8_ = _result_;
	_tmp8__length1 = _result__length1;
	if (result_length1) {
		*result_length1 = _tmp8__length1;
	}
	result = _tmp8_;
	return result;
}

static gint
pantheon_shell_dock_find_monitor_number (GdkDisplay* display,
                                         const gchar* plug_name)
{
	gint n_monitors = 0;
	gint result;
	g_return_val_if_fail (display != NULL, 0);
	g_return_val_if_fail (plug_name != NULL, 0);
	n_monitors = gdk_display_get_n_monitors (display);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GdkMonitor* monitor = NULL;
				GdkMonitor* _tmp2_;
				GdkMonitor* _tmp3_;
				gchar* name = NULL;
				GdkMonitor* _tmp4_;
				const gchar* _tmp5_;
				gchar* _tmp6_;
				const gchar* _tmp7_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(i < n_monitors)) {
					break;
				}
				_tmp2_ = gdk_display_get_monitor (display, i);
				_tmp3_ = _g_object_ref0 (_tmp2_);
				monitor = _tmp3_;
				_tmp4_ = monitor;
				_tmp5_ = gdk_monitor_get_model (_tmp4_);
				_tmp6_ = g_strdup (_tmp5_);
				name = _tmp6_;
				_tmp7_ = name;
				if (g_strcmp0 (plug_name, _tmp7_) == 0) {
					result = i;
					_g_free0 (name);
					_g_object_unref0 (monitor);
					return result;
				}
				_g_free0 (name);
				_g_object_unref0 (monitor);
			}
		}
	}
	result = gdk_display_get_n_monitors (display);
	return result;
}

PantheonShellDock*
pantheon_shell_dock_construct (GType object_type)
{
	PantheonShellDock * self = NULL;
	self = (PantheonShellDock*) g_object_new (object_type, NULL);
	return self;
}

PantheonShellDock*
pantheon_shell_dock_new (void)
{
	return pantheon_shell_dock_construct (PANTHEON_SHELL_TYPE_DOCK);
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		PantheonShellDock* self;
		self = _data3_->self;
		_g_object_unref0 (_data3_->hide_switch);
		_data3_->hide_mode_ids = (g_free (_data3_->hide_mode_ids), NULL);
		_g_object_unref0 (_data3_->hide_mode);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}

static void
_pantheon_shell_dock___lambda35_ (Block3Data* _data3_)
{
	PantheonShellDock* self;
	PlankDockPreferences* _tmp0_;
	PlankHideType* _tmp1_;
	gint _tmp1__length1;
	GtkComboBoxText* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	PlankHideType _tmp5_;
	self = _data3_->self;
	_tmp0_ = self->priv->dock_preferences;
	_tmp1_ = _data3_->hide_mode_ids;
	_tmp1__length1 = _data3_->hide_mode_ids_length1;
	_tmp2_ = _data3_->hide_mode;
	_tmp3_ = gtk_combo_box_get_active ((GtkComboBox*) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp1_[_tmp4_];
	plank_dock_preferences_set_HideMode (_tmp0_, _tmp5_);
}

static void
__pantheon_shell_dock___lambda35__gtk_combo_box_changed (GtkComboBox* _sender,
                                                         gpointer self)
{
	_pantheon_shell_dock___lambda35_ (self);
}

static void
_pantheon_shell_dock___lambda36_ (Block3Data* _data3_)
{
	PantheonShellDock* self;
	GtkSwitch* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	self = _data3_->self;
	_tmp0_ = _data3_->hide_switch;
	_tmp1_ = gtk_switch_get_active (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		PlankDockPreferences* _tmp3_;
		PlankHideType* _tmp4_;
		gint _tmp4__length1;
		GtkComboBoxText* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		PlankHideType _tmp8_;
		_tmp3_ = self->priv->dock_preferences;
		_tmp4_ = _data3_->hide_mode_ids;
		_tmp4__length1 = _data3_->hide_mode_ids_length1;
		_tmp5_ = _data3_->hide_mode;
		_tmp6_ = gtk_combo_box_get_active ((GtkComboBox*) _tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = _tmp4_[_tmp7_];
		plank_dock_preferences_set_HideMode (_tmp3_, _tmp8_);
	} else {
		PlankDockPreferences* _tmp9_;
		_tmp9_ = self->priv->dock_preferences;
		plank_dock_preferences_set_HideMode (_tmp9_, PLANK_HIDE_TYPE_NONE);
	}
}

static void
__pantheon_shell_dock___lambda36__g_object_notify (GObject* _sender,
                                                   GParamSpec* pspec,
                                                   gpointer self)
{
	_pantheon_shell_dock___lambda36_ (self);
}

static void
_pantheon_shell_dock___lambda37_ (PantheonShellDock* self)
{
	GtkSwitch* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	_tmp0_ = self->priv->primary_monitor;
	_tmp1_ = gtk_switch_get_active (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == TRUE) {
		PlankDockPreferences* _tmp3_;
		GtkLabel* _tmp4_;
		GtkComboBoxText* _tmp5_;
		_tmp3_ = self->priv->dock_preferences;
		plank_dock_preferences_set_Monitor (_tmp3_, "");
		_tmp4_ = self->priv->monitor_label;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp4_, FALSE);
		_tmp5_ = self->priv->monitor;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp5_, FALSE);
	} else {
		gchar** plug_names = NULL;
		GdkDisplay* _tmp6_;
		gint _tmp7_ = 0;
		gchar** _tmp8_;
		gint plug_names_length1;
		gint _plug_names_size_;
		gchar** _tmp9_;
		gint _tmp9__length1;
		GtkComboBoxText* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		GtkLabel* _tmp19_;
		GtkComboBoxText* _tmp20_;
		_tmp6_ = gtk_widget_get_display ((GtkWidget*) self);
		_tmp8_ = pantheon_shell_dock_get_monitor_plug_names (_tmp6_, &_tmp7_);
		plug_names = _tmp8_;
		plug_names_length1 = _tmp7_;
		_plug_names_size_ = plug_names_length1;
		_tmp9_ = plug_names;
		_tmp9__length1 = plug_names_length1;
		_tmp10_ = self->priv->monitor;
		_tmp11_ = gtk_combo_box_get_active ((GtkComboBox*) _tmp10_);
		_tmp12_ = _tmp11_;
		if (_tmp9__length1 > _tmp12_) {
			PlankDockPreferences* _tmp13_;
			gchar** _tmp14_;
			gint _tmp14__length1;
			GtkComboBoxText* _tmp15_;
			gint _tmp16_;
			gint _tmp17_;
			const gchar* _tmp18_;
			_tmp13_ = self->priv->dock_preferences;
			_tmp14_ = plug_names;
			_tmp14__length1 = plug_names_length1;
			_tmp15_ = self->priv->monitor;
			_tmp16_ = gtk_combo_box_get_active ((GtkComboBox*) _tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = _tmp14_[_tmp17_];
			plank_dock_preferences_set_Monitor (_tmp13_, _tmp18_);
		}
		_tmp19_ = self->priv->monitor_label;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp19_, TRUE);
		_tmp20_ = self->priv->monitor;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp20_, TRUE);
		plug_names = (_vala_array_free (plug_names, plug_names_length1, (GDestroyNotify) g_free), NULL);
	}
}

static void
__pantheon_shell_dock___lambda37__g_object_notify (GObject* _sender,
                                                   GParamSpec* pspec,
                                                   gpointer self)
{
	_pantheon_shell_dock___lambda37_ ((PantheonShellDock*) self);
}

static void
_pantheon_shell_dock___lambda38_ (PantheonShellDock* self)
{
	gboolean _tmp0_ = FALSE;
	GtkComboBoxText* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	_tmp1_ = self->priv->monitor;
	_tmp2_ = gtk_combo_box_get_active ((GtkComboBox*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ >= 0) {
		GtkSwitch* _tmp4_;
		gboolean _tmp5_;
		gboolean _tmp6_;
		_tmp4_ = self->priv->primary_monitor;
		_tmp5_ = gtk_switch_get_active (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = _tmp6_ == FALSE;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gchar** plug_names = NULL;
		GdkDisplay* _tmp7_;
		gint _tmp8_ = 0;
		gchar** _tmp9_;
		gint plug_names_length1;
		gint _plug_names_size_;
		gchar** _tmp10_;
		gint _tmp10__length1;
		GtkComboBoxText* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		_tmp7_ = gtk_widget_get_display ((GtkWidget*) self);
		_tmp9_ = pantheon_shell_dock_get_monitor_plug_names (_tmp7_, &_tmp8_);
		plug_names = _tmp9_;
		plug_names_length1 = _tmp8_;
		_plug_names_size_ = plug_names_length1;
		_tmp10_ = plug_names;
		_tmp10__length1 = plug_names_length1;
		_tmp11_ = self->priv->monitor;
		_tmp12_ = gtk_combo_box_get_active ((GtkComboBox*) _tmp11_);
		_tmp13_ = _tmp12_;
		if (_tmp10__length1 > _tmp13_) {
			PlankDockPreferences* _tmp14_;
			gchar** _tmp15_;
			gint _tmp15__length1;
			GtkComboBoxText* _tmp16_;
			gint _tmp17_;
			gint _tmp18_;
			const gchar* _tmp19_;
			_tmp14_ = self->priv->dock_preferences;
			_tmp15_ = plug_names;
			_tmp15__length1 = plug_names_length1;
			_tmp16_ = self->priv->monitor;
			_tmp17_ = gtk_combo_box_get_active ((GtkComboBox*) _tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = _tmp15_[_tmp18_];
			plank_dock_preferences_set_Monitor (_tmp14_, _tmp19_);
		}
		plug_names = (_vala_array_free (plug_names, plug_names_length1, (GDestroyNotify) g_free), NULL);
	}
}

static void
__pantheon_shell_dock___lambda38__g_object_notify (GObject* _sender,
                                                   GParamSpec* pspec,
                                                   gpointer self)
{
	_pantheon_shell_dock___lambda38_ ((PantheonShellDock*) self);
}

static void
_pantheon_shell_dock___lambda39_ (PantheonShellDock* self)
{
	pantheon_shell_dock_check_for_screens (self);
}

static void
__pantheon_shell_dock___lambda39__gdk_screen_monitors_changed (GdkScreen* _sender,
                                                               gpointer self)
{
	_pantheon_shell_dock___lambda39_ ((PantheonShellDock*) self);
}

static void
_pantheon_shell_dock___lambda40_ (PantheonShellDock* self)
{
	PlankDockPreferences* _tmp0_;
	_tmp0_ = self->priv->dock_preferences;
	plank_dock_preferences_set_IconSize (_tmp0_, 32);
}

static void
__pantheon_shell_dock___lambda40__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                             gpointer self)
{
	_pantheon_shell_dock___lambda40_ ((PantheonShellDock*) self);
}

static void
_pantheon_shell_dock___lambda41_ (PantheonShellDock* self)
{
	PlankDockPreferences* _tmp0_;
	_tmp0_ = self->priv->dock_preferences;
	plank_dock_preferences_set_IconSize (_tmp0_, 48);
}

static void
__pantheon_shell_dock___lambda41__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                             gpointer self)
{
	_pantheon_shell_dock___lambda41_ ((PantheonShellDock*) self);
}

static void
_pantheon_shell_dock___lambda42_ (PantheonShellDock* self)
{
	PlankDockPreferences* _tmp0_;
	_tmp0_ = self->priv->dock_preferences;
	plank_dock_preferences_set_IconSize (_tmp0_, 64);
}

static void
__pantheon_shell_dock___lambda42__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                             gpointer self)
{
	_pantheon_shell_dock___lambda42_ ((PantheonShellDock*) self);
}

static GObject *
pantheon_shell_dock_constructor (GType type,
                                 guint n_construct_properties,
                                 GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PantheonShellDock * self;
	Block3Data* _data3_;
	GraniteHeaderLabel* dock_header = NULL;
	GraniteHeaderLabel* _tmp0_;
	GtkIconTheme* default_theme = NULL;
	GtkIconTheme* _tmp1_;
	GtkIconTheme* _tmp2_;
	GtkRadioButton* icon_size_32 = NULL;
	GtkRadioButton* _tmp3_;
	GtkRadioButton* _tmp4_;
	GtkImage* _tmp5_;
	GtkImage* _tmp6_;
	GtkRadioButton* _tmp7_;
	GtkRadioButton* icon_size_48 = NULL;
	GtkRadioButton* _tmp8_;
	GtkRadioButton* _tmp9_;
	GtkRadioButton* _tmp10_;
	GtkImage* _tmp11_;
	GtkImage* _tmp12_;
	GtkRadioButton* _tmp13_;
	GtkImage* image_64 = NULL;
	GtkImage* _tmp14_;
	GtkImage* _tmp15_;
	GtkImage* _tmp16_;
	GtkRadioButton* icon_size_64 = NULL;
	GtkRadioButton* _tmp17_;
	GtkRadioButton* _tmp18_;
	GtkRadioButton* _tmp19_;
	GtkImage* _tmp20_;
	GtkRadioButton* _tmp21_;
	GtkRadioButton* icon_size_unsupported = NULL;
	GtkRadioButton* _tmp22_;
	GtkRadioButton* _tmp23_;
	GtkBox* icon_size_box = NULL;
	GtkBox* _tmp24_;
	GtkBox* _tmp25_;
	GtkRadioButton* _tmp26_;
	GtkBox* _tmp27_;
	GtkRadioButton* _tmp28_;
	GtkBox* _tmp29_;
	GtkRadioButton* _tmp30_;
	PlankDockPreferences* _tmp31_;
	GtkSwitch* pressure_switch = NULL;
	GtkSwitch* _tmp32_;
	GtkSwitch* _tmp33_;
	GtkSwitch* _tmp34_;
	PlankDockPreferences* _tmp35_;
	GtkSwitch* _tmp36_;
	GtkComboBoxText* _tmp37_ = NULL;
	GtkComboBoxText* _tmp38_;
	GtkComboBoxText* _tmp39_;
	GtkComboBoxText* _tmp40_;
	GtkComboBoxText* _tmp41_;
	PlankHideType* _tmp42_;
	GtkSwitch* _tmp43_;
	GtkSwitch* _tmp44_;
	GtkSwitch* _tmp45_;
	gboolean hide_none = FALSE;
	PlankDockPreferences* _tmp46_;
	PlankHideType _tmp47_;
	PlankHideType _tmp48_;
	GtkSwitch* _tmp49_;
	GtkComboBoxText* _tmp60_;
	GtkSwitch* _tmp61_;
	GtkSwitch* _tmp62_;
	GtkSwitch* _tmp63_;
	GtkComboBoxText* _tmp64_;
	GtkSwitch* _tmp65_;
	GtkComboBoxText* _tmp66_;
	GtkLabel* _tmp67_;
	GtkLabel* _tmp68_;
	GtkLabel* _tmp69_;
	GtkLabel* _tmp70_;
	GtkLabel* _tmp71_;
	GtkLabel* _tmp72_;
	GtkSwitch* _tmp73_;
	GtkSwitch* _tmp74_;
	GtkSwitch* _tmp75_;
	GtkSwitch* _tmp76_;
	PlankDockPreferences* _tmp77_;
	const gchar* _tmp78_;
	const gchar* _tmp79_;
	GtkComboBoxText* _tmp80_;
	GdkScreen* _tmp81_;
	GtkLabel* icon_label = NULL;
	GtkLabel* _tmp82_;
	GtkLabel* _tmp83_;
	GtkLabel* hide_label = NULL;
	GtkLabel* _tmp84_;
	GtkLabel* _tmp85_;
	GtkGrid* primary_monitor_grid = NULL;
	GtkGrid* _tmp86_;
	GtkGrid* _tmp87_;
	GtkSwitch* _tmp88_;
	GtkLabel* pressure_label = NULL;
	GtkLabel* _tmp89_;
	GtkLabel* _tmp90_;
	GraniteHeaderLabel* panel_header = NULL;
	GraniteHeaderLabel* _tmp91_ = NULL;
	GtkLabel* translucency_label = NULL;
	GtkLabel* _tmp92_ = NULL;
	GtkSwitch* translucency_switch = NULL;
	GtkSwitch* _tmp93_ = NULL;
	GtkGrid* grid = NULL;
	GtkGrid* _tmp94_ = NULL;
	GtkGrid* _tmp95_;
	GraniteHeaderLabel* _tmp96_;
	GtkGrid* _tmp97_;
	GtkLabel* _tmp98_;
	GtkGrid* _tmp99_;
	GtkBox* _tmp100_;
	GtkGrid* _tmp101_;
	GtkLabel* _tmp102_;
	GtkGrid* _tmp103_;
	GtkComboBoxText* _tmp104_;
	GtkGrid* _tmp105_;
	GtkSwitch* _tmp106_;
	GtkGrid* _tmp107_;
	GtkLabel* _tmp108_;
	GtkGrid* _tmp109_;
	GtkGrid* _tmp110_;
	GtkGrid* _tmp111_;
	GtkLabel* _tmp112_;
	GtkGrid* _tmp113_;
	GtkComboBoxText* _tmp114_;
	GtkGrid* _tmp115_;
	GtkLabel* _tmp116_;
	GtkGrid* _tmp117_;
	GtkSwitch* _tmp118_;
	GtkGrid* _tmp119_;
	GraniteHeaderLabel* _tmp120_;
	GtkGrid* _tmp121_;
	GtkLabel* _tmp122_;
	GtkGrid* _tmp123_;
	GtkSwitch* _tmp124_;
	HdyClamp* clamp = NULL;
	HdyClamp* _tmp125_;
	HdyClamp* _tmp126_;
	GtkGrid* _tmp127_;
	HdyClamp* _tmp128_;
	PlankDockPreferences* _tmp129_;
	gint _tmp130_;
	gint _tmp131_;
	GtkRadioButton* _tmp136_;
	GtkRadioButton* _tmp137_;
	GtkRadioButton* _tmp138_;
	GSettings* panel_settings = NULL;
	GSettings* _tmp139_;
	GSettings* _tmp140_;
	GtkSwitch* _tmp141_;
	parent_class = G_OBJECT_CLASS (pantheon_shell_dock_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PANTHEON_SHELL_TYPE_DOCK, PantheonShellDock);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_tmp0_ = granite_header_label_new (_ ("Dock"));
	g_object_ref_sink (_tmp0_);
	dock_header = _tmp0_;
	_tmp1_ = gtk_icon_theme_get_default ();
	default_theme = _tmp1_;
	_tmp2_ = default_theme;
	gtk_icon_theme_add_resource_path (_tmp2_, "/io/elementary/switchboard/plug/pantheon-shell");
	_tmp3_ = (GtkRadioButton*) gtk_radio_button_new (NULL);
	g_object_ref_sink (_tmp3_);
	icon_size_32 = _tmp3_;
	_tmp4_ = icon_size_32;
	_tmp5_ = (GtkImage*) gtk_image_new_from_icon_name ("application-default-icon-symbolic", (GtkIconSize) GTK_ICON_SIZE_DND);
	g_object_ref_sink (_tmp5_);
	_tmp6_ = _tmp5_;
	gtk_button_set_image ((GtkButton*) _tmp4_, (GtkWidget*) _tmp6_);
	_g_object_unref0 (_tmp6_);
	_tmp7_ = icon_size_32;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp7_, _ ("Small"));
	_tmp8_ = icon_size_32;
	_tmp9_ = (GtkRadioButton*) gtk_radio_button_new_from_widget (_tmp8_);
	g_object_ref_sink (_tmp9_);
	icon_size_48 = _tmp9_;
	_tmp10_ = icon_size_48;
	_tmp11_ = (GtkImage*) gtk_image_new_from_icon_name ("application-default-icon-symbolic", (GtkIconSize) GTK_ICON_SIZE_DIALOG);
	g_object_ref_sink (_tmp11_);
	_tmp12_ = _tmp11_;
	gtk_button_set_image ((GtkButton*) _tmp10_, (GtkWidget*) _tmp12_);
	_g_object_unref0 (_tmp12_);
	_tmp13_ = icon_size_48;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp13_, _ ("Default"));
	_tmp14_ = (GtkImage*) gtk_image_new ();
	g_object_ref_sink (_tmp14_);
	image_64 = _tmp14_;
	_tmp15_ = image_64;
	g_object_set (_tmp15_, "icon-name", "application-default-icon-symbolic", NULL);
	_tmp16_ = image_64;
	gtk_image_set_pixel_size (_tmp16_, 64);
	_tmp17_ = icon_size_32;
	_tmp18_ = (GtkRadioButton*) gtk_radio_button_new_from_widget (_tmp17_);
	g_object_ref_sink (_tmp18_);
	icon_size_64 = _tmp18_;
	_tmp19_ = icon_size_64;
	_tmp20_ = image_64;
	gtk_button_set_image ((GtkButton*) _tmp19_, (GtkWidget*) _tmp20_);
	_tmp21_ = icon_size_64;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp21_, _ ("Large"));
	_tmp22_ = icon_size_32;
	_tmp23_ = (GtkRadioButton*) gtk_radio_button_new_from_widget (_tmp22_);
	g_object_ref_sink (_tmp23_);
	icon_size_unsupported = _tmp23_;
	_tmp24_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 24);
	g_object_ref_sink (_tmp24_);
	icon_size_box = _tmp24_;
	_tmp25_ = icon_size_box;
	_tmp26_ = icon_size_32;
	gtk_container_add ((GtkContainer*) _tmp25_, (GtkWidget*) _tmp26_);
	_tmp27_ = icon_size_box;
	_tmp28_ = icon_size_48;
	gtk_container_add ((GtkContainer*) _tmp27_, (GtkWidget*) _tmp28_);
	_tmp29_ = icon_size_box;
	_tmp30_ = icon_size_64;
	gtk_container_add ((GtkContainer*) _tmp29_, (GtkWidget*) _tmp30_);
	plank_paths_initialize ("plank", CONSTANTS_PLANKDATADIR);
	_tmp31_ = plank_dock_preferences_new ("dock1");
	_g_object_unref0 (self->priv->dock_preferences);
	self->priv->dock_preferences = _tmp31_;
	_tmp32_ = (GtkSwitch*) gtk_switch_new ();
	g_object_ref_sink (_tmp32_);
	pressure_switch = _tmp32_;
	_tmp33_ = pressure_switch;
	gtk_widget_set_halign ((GtkWidget*) _tmp33_, GTK_ALIGN_START);
	_tmp34_ = pressure_switch;
	gtk_widget_set_valign ((GtkWidget*) _tmp34_, GTK_ALIGN_CENTER);
	_tmp35_ = self->priv->dock_preferences;
	_tmp36_ = pressure_switch;
	g_object_bind_property_with_closures ((GObject*) _tmp35_, "PressureReveal", (GObject*) _tmp36_, "active", G_BINDING_SYNC_CREATE | G_BINDING_BIDIRECTIONAL, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp37_ = (GtkComboBoxText*) gtk_combo_box_text_new ();
	gtk_widget_set_hexpand ((GtkWidget*) _tmp37_, TRUE);
	g_object_ref_sink (_tmp37_);
	_data3_->hide_mode = _tmp37_;
	_tmp38_ = _data3_->hide_mode;
	gtk_combo_box_text_append_text (_tmp38_, _ ("Focused window is maximized"));
	_tmp39_ = _data3_->hide_mode;
	gtk_combo_box_text_append_text (_tmp39_, _ ("Focused window overlaps the dock"));
	_tmp40_ = _data3_->hide_mode;
	gtk_combo_box_text_append_text (_tmp40_, _ ("Any window overlaps the dock"));
	_tmp41_ = _data3_->hide_mode;
	gtk_combo_box_text_append_text (_tmp41_, _ ("Not being used"));
	_tmp42_ = g_new0 (PlankHideType, 4);
	_tmp42_[0] = PLANK_HIDE_TYPE_DODGE_MAXIMIZED;
	_tmp42_[1] = PLANK_HIDE_TYPE_INTELLIGENT;
	_tmp42_[2] = PLANK_HIDE_TYPE_WINDOW_DODGE;
	_tmp42_[3] = PLANK_HIDE_TYPE_AUTO;
	_data3_->hide_mode_ids = _tmp42_;
	_data3_->hide_mode_ids_length1 = 4;
	_data3_->_hide_mode_ids_size_ = _data3_->hide_mode_ids_length1;
	_tmp43_ = (GtkSwitch*) gtk_switch_new ();
	g_object_ref_sink (_tmp43_);
	_data3_->hide_switch = _tmp43_;
	_tmp44_ = _data3_->hide_switch;
	gtk_widget_set_halign ((GtkWidget*) _tmp44_, GTK_ALIGN_START);
	_tmp45_ = _data3_->hide_switch;
	gtk_widget_set_valign ((GtkWidget*) _tmp45_, GTK_ALIGN_CENTER);
	_tmp46_ = self->priv->dock_preferences;
	_tmp47_ = plank_dock_preferences_get_HideMode (_tmp46_);
	_tmp48_ = _tmp47_;
	hide_none = _tmp48_ != PLANK_HIDE_TYPE_NONE;
	_tmp49_ = _data3_->hide_switch;
	gtk_switch_set_active (_tmp49_, hide_none);
	if (hide_none) {
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp50_ = FALSE;
				_tmp50_ = TRUE;
				while (TRUE) {
					PlankHideType* _tmp52_;
					gint _tmp52__length1;
					PlankHideType* _tmp53_;
					gint _tmp53__length1;
					PlankHideType _tmp54_;
					PlankDockPreferences* _tmp55_;
					PlankHideType _tmp56_;
					PlankHideType _tmp57_;
					if (!_tmp50_) {
						gint _tmp51_;
						_tmp51_ = i;
						i = _tmp51_ + 1;
					}
					_tmp50_ = FALSE;
					_tmp52_ = _data3_->hide_mode_ids;
					_tmp52__length1 = _data3_->hide_mode_ids_length1;
					if (!(i < _tmp52__length1)) {
						break;
					}
					_tmp53_ = _data3_->hide_mode_ids;
					_tmp53__length1 = _data3_->hide_mode_ids_length1;
					_tmp54_ = _tmp53_[i];
					_tmp55_ = self->priv->dock_preferences;
					_tmp56_ = plank_dock_preferences_get_HideMode (_tmp55_);
					_tmp57_ = _tmp56_;
					if (_tmp54_ == _tmp57_) {
						GtkComboBoxText* _tmp58_;
						_tmp58_ = _data3_->hide_mode;
						gtk_combo_box_set_active ((GtkComboBox*) _tmp58_, i);
					}
				}
			}
		}
	} else {
		GtkComboBoxText* _tmp59_;
		_tmp59_ = _data3_->hide_mode;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp59_, FALSE);
	}
	_tmp60_ = _data3_->hide_mode;
	g_signal_connect_data ((GtkComboBox*) _tmp60_, "changed", (GCallback) __pantheon_shell_dock___lambda35__gtk_combo_box_changed, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
	_tmp61_ = _data3_->hide_switch;
	_tmp62_ = pressure_switch;
	g_object_bind_property_with_closures ((GObject*) _tmp61_, "active", (GObject*) _tmp62_, "sensitive", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp63_ = _data3_->hide_switch;
	_tmp64_ = _data3_->hide_mode;
	g_object_bind_property_with_closures ((GObject*) _tmp63_, "active", (GObject*) _tmp64_, "sensitive", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp65_ = _data3_->hide_switch;
	g_signal_connect_data ((GObject*) _tmp65_, "notify::active", (GCallback) __pantheon_shell_dock___lambda36__g_object_notify, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
	_tmp66_ = (GtkComboBoxText*) gtk_combo_box_text_new ();
	g_object_ref_sink (_tmp66_);
	_g_object_unref0 (self->priv->monitor);
	self->priv->monitor = _tmp66_;
	_tmp67_ = (GtkLabel*) gtk_label_new (_ ("Primary display:"));
	g_object_ref_sink (_tmp67_);
	_g_object_unref0 (self->priv->primary_monitor_label);
	self->priv->primary_monitor_label = _tmp67_;
	_tmp68_ = self->priv->primary_monitor_label;
	gtk_widget_set_halign ((GtkWidget*) _tmp68_, GTK_ALIGN_END);
	_tmp69_ = self->priv->primary_monitor_label;
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp69_, TRUE);
	_tmp70_ = (GtkLabel*) gtk_label_new (_ ("Display:"));
	g_object_ref_sink (_tmp70_);
	_g_object_unref0 (self->priv->monitor_label);
	self->priv->monitor_label = _tmp70_;
	_tmp71_ = self->priv->monitor_label;
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp71_, TRUE);
	_tmp72_ = self->priv->monitor_label;
	gtk_widget_set_halign ((GtkWidget*) _tmp72_, GTK_ALIGN_END);
	_tmp73_ = (GtkSwitch*) gtk_switch_new ();
	g_object_ref_sink (_tmp73_);
	_g_object_unref0 (self->priv->primary_monitor);
	self->priv->primary_monitor = _tmp73_;
	_tmp74_ = self->priv->primary_monitor;
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp74_, TRUE);
	_tmp75_ = self->priv->primary_monitor;
	g_signal_connect_object ((GObject*) _tmp75_, "notify::active", (GCallback) __pantheon_shell_dock___lambda37__g_object_notify, self, 0);
	_tmp76_ = self->priv->primary_monitor;
	_tmp77_ = self->priv->dock_preferences;
	_tmp78_ = plank_dock_preferences_get_Monitor (_tmp77_);
	_tmp79_ = _tmp78_;
	gtk_switch_set_active (_tmp76_, g_strcmp0 (_tmp79_, "") == 0);
	_tmp80_ = self->priv->monitor;
	g_signal_connect_object ((GObject*) _tmp80_, "notify::active", (GCallback) __pantheon_shell_dock___lambda38__g_object_notify, self, 0);
	_tmp81_ = gtk_widget_get_screen ((GtkWidget*) self);
	g_signal_connect_object (_tmp81_, "monitors-changed", (GCallback) __pantheon_shell_dock___lambda39__gdk_screen_monitors_changed, self, 0);
	_tmp82_ = (GtkLabel*) gtk_label_new (_ ("Icon size:"));
	g_object_ref_sink (_tmp82_);
	icon_label = _tmp82_;
	_tmp83_ = icon_label;
	gtk_widget_set_halign ((GtkWidget*) _tmp83_, GTK_ALIGN_END);
	_tmp84_ = (GtkLabel*) gtk_label_new (_ ("Hide when:"));
	g_object_ref_sink (_tmp84_);
	hide_label = _tmp84_;
	_tmp85_ = hide_label;
	gtk_widget_set_halign ((GtkWidget*) _tmp85_, GTK_ALIGN_END);
	_tmp86_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp86_);
	primary_monitor_grid = _tmp86_;
	_tmp87_ = primary_monitor_grid;
	_tmp88_ = self->priv->primary_monitor;
	gtk_container_add ((GtkContainer*) _tmp87_, (GtkWidget*) _tmp88_);
	_tmp89_ = (GtkLabel*) gtk_label_new (_ ("Pressure reveal:"));
	g_object_ref_sink (_tmp89_);
	pressure_label = _tmp89_;
	_tmp90_ = pressure_label;
	gtk_widget_set_halign ((GtkWidget*) _tmp90_, GTK_ALIGN_END);
	_tmp91_ = granite_header_label_new (_ ("Panel"));
	gtk_widget_set_margin_top ((GtkWidget*) _tmp91_, 12);
	g_object_ref_sink (_tmp91_);
	panel_header = _tmp91_;
	_tmp92_ = (GtkLabel*) gtk_label_new (_ ("Panel translucency:"));
	gtk_widget_set_halign ((GtkWidget*) _tmp92_, GTK_ALIGN_END);
	g_object_ref_sink (_tmp92_);
	translucency_label = _tmp92_;
	_tmp93_ = (GtkSwitch*) gtk_switch_new ();
	gtk_widget_set_halign ((GtkWidget*) _tmp93_, GTK_ALIGN_START);
	g_object_ref_sink (_tmp93_);
	translucency_switch = _tmp93_;
	_tmp94_ = (GtkGrid*) gtk_grid_new ();
	gtk_grid_set_column_spacing (_tmp94_, 12);
	gtk_grid_set_row_spacing (_tmp94_, 12);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp94_, 12);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp94_, 12);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp94_, 24);
	g_object_ref_sink (_tmp94_);
	grid = _tmp94_;
	_tmp95_ = grid;
	_tmp96_ = dock_header;
	gtk_grid_attach (_tmp95_, (GtkWidget*) _tmp96_, 0, 0, 3, 1);
	_tmp97_ = grid;
	_tmp98_ = icon_label;
	gtk_grid_attach (_tmp97_, (GtkWidget*) _tmp98_, 0, 1, 1, 1);
	_tmp99_ = grid;
	_tmp100_ = icon_size_box;
	gtk_grid_attach (_tmp99_, (GtkWidget*) _tmp100_, 1, 1, 2, 1);
	_tmp101_ = grid;
	_tmp102_ = hide_label;
	gtk_grid_attach (_tmp101_, (GtkWidget*) _tmp102_, 0, 2, 1, 1);
	_tmp103_ = grid;
	_tmp104_ = _data3_->hide_mode;
	gtk_grid_attach (_tmp103_, (GtkWidget*) _tmp104_, 1, 2, 1, 1);
	_tmp105_ = grid;
	_tmp106_ = _data3_->hide_switch;
	gtk_grid_attach (_tmp105_, (GtkWidget*) _tmp106_, 2, 2, 1, 1);
	_tmp107_ = grid;
	_tmp108_ = self->priv->primary_monitor_label;
	gtk_grid_attach (_tmp107_, (GtkWidget*) _tmp108_, 0, 3, 1, 1);
	_tmp109_ = grid;
	_tmp110_ = primary_monitor_grid;
	gtk_grid_attach (_tmp109_, (GtkWidget*) _tmp110_, 1, 3, 1, 1);
	_tmp111_ = grid;
	_tmp112_ = self->priv->monitor_label;
	gtk_grid_attach (_tmp111_, (GtkWidget*) _tmp112_, 0, 4, 1, 1);
	_tmp113_ = grid;
	_tmp114_ = self->priv->monitor;
	gtk_grid_attach (_tmp113_, (GtkWidget*) _tmp114_, 1, 4, 1, 1);
	_tmp115_ = grid;
	_tmp116_ = pressure_label;
	gtk_grid_attach (_tmp115_, (GtkWidget*) _tmp116_, 0, 5, 1, 1);
	_tmp117_ = grid;
	_tmp118_ = pressure_switch;
	gtk_grid_attach (_tmp117_, (GtkWidget*) _tmp118_, 1, 5, 1, 1);
	_tmp119_ = grid;
	_tmp120_ = panel_header;
	gtk_grid_attach (_tmp119_, (GtkWidget*) _tmp120_, 0, 6, 3, 1);
	_tmp121_ = grid;
	_tmp122_ = translucency_label;
	gtk_grid_attach (_tmp121_, (GtkWidget*) _tmp122_, 0, 7, 1, 1);
	_tmp123_ = grid;
	_tmp124_ = translucency_switch;
	gtk_grid_attach (_tmp123_, (GtkWidget*) _tmp124_, 1, 7, 1, 1);
	_tmp125_ = (HdyClamp*) hdy_clamp_new ();
	g_object_ref_sink (_tmp125_);
	clamp = _tmp125_;
	_tmp126_ = clamp;
	_tmp127_ = grid;
	gtk_container_add ((GtkContainer*) _tmp126_, (GtkWidget*) _tmp127_);
	_tmp128_ = clamp;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp128_);
	pantheon_shell_dock_check_for_screens (self);
	_tmp129_ = self->priv->dock_preferences;
	_tmp130_ = plank_dock_preferences_get_IconSize (_tmp129_);
	_tmp131_ = _tmp130_;
	switch (_tmp131_) {
		case 32:
		{
			GtkRadioButton* _tmp132_;
			_tmp132_ = icon_size_32;
			gtk_toggle_button_set_active ((GtkToggleButton*) _tmp132_, TRUE);
			break;
		}
		case 48:
		{
			GtkRadioButton* _tmp133_;
			_tmp133_ = icon_size_48;
			gtk_toggle_button_set_active ((GtkToggleButton*) _tmp133_, TRUE);
			break;
		}
		case 64:
		{
			GtkRadioButton* _tmp134_;
			_tmp134_ = icon_size_64;
			gtk_toggle_button_set_active ((GtkToggleButton*) _tmp134_, TRUE);
			break;
		}
		default:
		{
			GtkRadioButton* _tmp135_;
			_tmp135_ = icon_size_unsupported;
			gtk_toggle_button_set_active ((GtkToggleButton*) _tmp135_, TRUE);
			g_debug ("Dock.vala:208: Unsupported dock icon size");
		}
	}
	_tmp136_ = icon_size_32;
	g_signal_connect_object ((GtkToggleButton*) _tmp136_, "toggled", (GCallback) __pantheon_shell_dock___lambda40__gtk_toggle_button_toggled, self, 0);
	_tmp137_ = icon_size_48;
	g_signal_connect_object ((GtkToggleButton*) _tmp137_, "toggled", (GCallback) __pantheon_shell_dock___lambda41__gtk_toggle_button_toggled, self, 0);
	_tmp138_ = icon_size_64;
	g_signal_connect_object ((GtkToggleButton*) _tmp138_, "toggled", (GCallback) __pantheon_shell_dock___lambda42__gtk_toggle_button_toggled, self, 0);
	_tmp139_ = g_settings_new (PANTHEON_SHELL_DOCK_PANEL_SCHEMA);
	panel_settings = _tmp139_;
	_tmp140_ = panel_settings;
	_tmp141_ = translucency_switch;
	g_settings_bind (_tmp140_, PANTHEON_SHELL_DOCK_TRANSLUCENCY_KEY, (GObject*) _tmp141_, "active", G_SETTINGS_BIND_DEFAULT);
	_g_object_unref0 (panel_settings);
	_g_object_unref0 (clamp);
	_g_object_unref0 (grid);
	_g_object_unref0 (translucency_switch);
	_g_object_unref0 (translucency_label);
	_g_object_unref0 (panel_header);
	_g_object_unref0 (pressure_label);
	_g_object_unref0 (primary_monitor_grid);
	_g_object_unref0 (hide_label);
	_g_object_unref0 (icon_label);
	_g_object_unref0 (pressure_switch);
	_g_object_unref0 (icon_size_box);
	_g_object_unref0 (icon_size_unsupported);
	_g_object_unref0 (icon_size_64);
	_g_object_unref0 (image_64);
	_g_object_unref0 (icon_size_48);
	_g_object_unref0 (icon_size_32);
	_g_object_unref0 (dock_header);
	block3_data_unref (_data3_);
	_data3_ = NULL;
	return obj;
}

static void
pantheon_shell_dock_class_init (PantheonShellDockClass * klass,
                                gpointer klass_data)
{
	pantheon_shell_dock_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PantheonShellDock_private_offset);
	G_OBJECT_CLASS (klass)->constructor = pantheon_shell_dock_constructor;
	G_OBJECT_CLASS (klass)->finalize = pantheon_shell_dock_finalize;
}

static void
pantheon_shell_dock_instance_init (PantheonShellDock * self,
                                   gpointer klass)
{
	self->priv = pantheon_shell_dock_get_instance_private (self);
}

static void
pantheon_shell_dock_finalize (GObject * obj)
{
	PantheonShellDock * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PANTHEON_SHELL_TYPE_DOCK, PantheonShellDock);
	_g_object_unref0 (self->priv->primary_monitor_label);
	_g_object_unref0 (self->priv->primary_monitor);
	_g_object_unref0 (self->priv->monitor_label);
	_g_object_unref0 (self->priv->monitor);
	_g_object_unref0 (self->priv->dock_preferences);
	G_OBJECT_CLASS (pantheon_shell_dock_parent_class)->finalize (obj);
}

static GType
pantheon_shell_dock_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PantheonShellDockClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pantheon_shell_dock_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PantheonShellDock), 0, (GInstanceInitFunc) pantheon_shell_dock_instance_init, NULL };
	GType pantheon_shell_dock_type_id;
	pantheon_shell_dock_type_id = g_type_register_static (gtk_box_get_type (), "PantheonShellDock", &g_define_type_info, 0);
	PantheonShellDock_private_offset = g_type_add_instance_private (pantheon_shell_dock_type_id, sizeof (PantheonShellDockPrivate));
	return pantheon_shell_dock_type_id;
}

GType
pantheon_shell_dock_get_type (void)
{
	static volatile gsize pantheon_shell_dock_type_id__once = 0;
	if (g_once_init_enter (&pantheon_shell_dock_type_id__once)) {
		GType pantheon_shell_dock_type_id;
		pantheon_shell_dock_type_id = pantheon_shell_dock_get_type_once ();
		g_once_init_leave (&pantheon_shell_dock_type_id__once, pantheon_shell_dock_type_id);
	}
	return pantheon_shell_dock_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

