"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createClient = void 0;
var url_1 = require("./tools/url");
var index_1 = require("./auth/index");
var copyFile_1 = require("./operations/copyFile");
var createDirectory_1 = require("./operations/createDirectory");
var createStream_1 = require("./operations/createStream");
var customRequest_1 = require("./operations/customRequest");
var deleteFile_1 = require("./operations/deleteFile");
var exists_1 = require("./operations/exists");
var directoryContents_1 = require("./operations/directoryContents");
var getFileContents_1 = require("./operations/getFileContents");
var lock_1 = require("./operations/lock");
var getQuota_1 = require("./operations/getQuota");
var stat_1 = require("./operations/stat");
var moveFile_1 = require("./operations/moveFile");
var putFileContents_1 = require("./operations/putFileContents");
var types_1 = require("./types");
var DEFAULT_CONTACT_HREF = "https://github.com/perry-mitchell/webdav-client/blob/master/LOCK_CONTACT.md";
function createClient(remoteURL, options) {
    if (options === void 0) { options = {}; }
    var _a = options.authType, authTypeRaw = _a === void 0 ? null : _a, _b = options.contactHref, contactHref = _b === void 0 ? DEFAULT_CONTACT_HREF : _b, _c = options.headers, headers = _c === void 0 ? {} : _c, httpAgent = options.httpAgent, httpsAgent = options.httpsAgent, maxBodyLength = options.maxBodyLength, maxContentLength = options.maxContentLength, password = options.password, token = options.token, username = options.username, withCredentials = options.withCredentials;
    var authType = authTypeRaw;
    if (!authType) {
        authType = username || password ? types_1.AuthType.Password : types_1.AuthType.None;
    }
    var context = {
        authType: authType,
        contactHref: contactHref,
        headers: Object.assign({}, headers),
        httpAgent: httpAgent,
        httpsAgent: httpsAgent,
        maxBodyLength: maxBodyLength,
        maxContentLength: maxContentLength,
        remotePath: (0, url_1.extractURLPath)(remoteURL),
        remoteURL: remoteURL,
        password: password,
        token: token,
        username: username,
        withCredentials: withCredentials
    };
    (0, index_1.setupAuth)(context, username, password, token);
    return {
        copyFile: function (filename, destination, options) {
            return (0, copyFile_1.copyFile)(context, filename, destination, options);
        },
        createDirectory: function (path, options) {
            return (0, createDirectory_1.createDirectory)(context, path, options);
        },
        createReadStream: function (filename, options) {
            return (0, createStream_1.createReadStream)(context, filename, options);
        },
        createWriteStream: function (filename, options, callback) { return (0, createStream_1.createWriteStream)(context, filename, options, callback); },
        customRequest: function (path, requestOptions) {
            return (0, customRequest_1.customRequest)(context, path, requestOptions);
        },
        deleteFile: function (filename, options) {
            return (0, deleteFile_1.deleteFile)(context, filename, options);
        },
        exists: function (path, options) { return (0, exists_1.exists)(context, path, options); },
        getDirectoryContents: function (path, options) {
            return (0, directoryContents_1.getDirectoryContents)(context, path, options);
        },
        getFileContents: function (filename, options) {
            return (0, getFileContents_1.getFileContents)(context, filename, options);
        },
        getFileDownloadLink: function (filename) { return (0, getFileContents_1.getFileDownloadLink)(context, filename); },
        getFileUploadLink: function (filename) { return (0, putFileContents_1.getFileUploadLink)(context, filename); },
        getHeaders: function () { return Object.assign({}, context.headers); },
        getQuota: function (options) { return (0, getQuota_1.getQuota)(context, options); },
        lock: function (path, options) { return (0, lock_1.lock)(context, path, options); },
        moveFile: function (filename, destinationFilename, options) {
            return (0, moveFile_1.moveFile)(context, filename, destinationFilename, options);
        },
        putFileContents: function (filename, data, options) { return (0, putFileContents_1.putFileContents)(context, filename, data, options); },
        setHeaders: function (headers) {
            context.headers = Object.assign({}, headers);
        },
        stat: function (path, options) { return (0, stat_1.getStat)(context, path, options); },
        unlock: function (path, token, options) {
            return (0, lock_1.unlock)(context, path, token, options);
        }
    };
}
exports.createClient = createClient;
