/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.packages.ssh;

import cc.arduino.packages.BoardPort;
import cc.arduino.packages.ssh.SSHClientSetupChainRing;
import com.jcraft.jsch.ConfigRepository;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.OpenSSHConfig;
import com.jcraft.jsch.Session;
import java.io.File;
import java.io.IOException;

public class SSHConfigFileSetup
implements SSHClientSetupChainRing {
    private final SSHClientSetupChainRing nextChainRing;

    public SSHConfigFileSetup(SSHClientSetupChainRing nextChainRing) {
        this.nextChainRing = nextChainRing;
    }

    @Override
    public Session setup(BoardPort port, JSch jSch) throws JSchException, IOException {
        String ipAddress = port.getAddress();
        File sshFolder = new File(System.getProperty("user.home"), ".ssh");
        File sshConfig = new File(sshFolder, "config");
        if (!sshFolder.exists() || !sshConfig.exists()) {
            if (this.nextChainRing != null) {
                return this.nextChainRing.setup(port, jSch);
            }
            throw new JSchException("Unable to find a way to connect");
        }
        OpenSSHConfig configRepository = OpenSSHConfig.parseFile((String)sshConfig.getAbsolutePath());
        jSch.setConfigRepository((ConfigRepository)new OpenSSHConfigWrapper(configRepository, ipAddress));
        return jSch.getSession(ipAddress);
    }

    public static class ConfigWrapper
    implements ConfigRepository.Config {
        private final ConfigRepository.Config config;
        private final String ipAddress;

        public ConfigWrapper(ConfigRepository.Config config, String ipAddress) {
            this.config = config;
            this.ipAddress = ipAddress;
        }

        public String getHostname() {
            return this.ipAddress;
        }

        public String getUser() {
            String user = this.config.getUser();
            if (user != null) {
                return user;
            }
            return "root";
        }

        public int getPort() {
            return this.config.getPort();
        }

        public String getValue(String key) {
            return this.config.getValue(key);
        }

        public String[] getValues(String key) {
            return this.config.getValues(key);
        }
    }

    public static class OpenSSHConfigWrapper
    implements ConfigRepository {
        private final OpenSSHConfig config;
        private final String ipAddress;

        public OpenSSHConfigWrapper(OpenSSHConfig config, String ipAddress) {
            this.config = config;
            this.ipAddress = ipAddress;
        }

        public ConfigRepository.Config getConfig(String host) {
            return new ConfigWrapper(this.config.getConfig(host), this.ipAddress);
        }
    }
}

