/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject;

import io.micronaut.core.naming.Described;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.Executable;
import io.micronaut.inject.MethodReference;
import java.util.Arrays;
import java.util.stream.Collectors;

public interface ExecutableMethod<T, R>
extends Executable<T, R>,
MethodReference<T, R>,
Described {
    default public boolean isAbstract() {
        return false;
    }

    default public boolean isSuspend() {
        return false;
    }

    default public String getDescription(boolean simple) {
        Argument argument = this.getReturnType().asArgument();
        String typeString = argument.getTypeString(simple);
        String args = Arrays.stream(this.getArguments()).map(arg -> arg.getTypeString(simple) + " " + arg.getName()).collect(Collectors.joining(","));
        return typeString + " " + this.getName() + "(" + args + ")";
    }

    default public String getDescription() {
        return this.getDescription(true);
    }
}

