/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.IOException;
import org.bouncycastle.tls.AbstractTlsClient;
import org.bouncycastle.tls.BasicTlsPSKIdentity;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.TlsAuthentication;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsPSKIdentity;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCrypto;

public class PSKTlsClient
extends AbstractTlsClient {
    private static final int[] DEFAULT_CIPHER_SUITES = new int[]{52396, 49207, 49205, 52397, 170, 178, 144};
    protected TlsPSKIdentity pskIdentity;

    public PSKTlsClient(TlsCrypto tlsCrypto, byte[] byArray, byte[] byArray2) {
        this(tlsCrypto, new BasicTlsPSKIdentity(byArray, byArray2));
    }

    public PSKTlsClient(TlsCrypto tlsCrypto, TlsPSKIdentity tlsPSKIdentity) {
        super(tlsCrypto);
        this.pskIdentity = tlsPSKIdentity;
    }

    @Override
    protected ProtocolVersion[] getSupportedVersions() {
        return ProtocolVersion.TLSv12.downTo(ProtocolVersion.TLSv10);
    }

    @Override
    protected int[] getSupportedCipherSuites() {
        return TlsUtils.getSupportedCipherSuites(this.getCrypto(), DEFAULT_CIPHER_SUITES);
    }

    @Override
    public TlsPSKIdentity getPSKIdentity() {
        return this.pskIdentity;
    }

    @Override
    public TlsAuthentication getAuthentication() throws IOException {
        throw new TlsFatalAlert(80);
    }
}

