/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.util.logging.Level;
import org.python.core.PrePy;
import org.python.core.PySystemState;

public class Options {
    public static boolean showJavaExceptions = false;
    public static boolean includeJavaStackInExceptions = true;
    public static boolean showPythonProxyExceptions = false;
    public static boolean respectJavaAccessibility = true;
    public static boolean importSite = true;
    public static boolean no_site = false;
    @Deprecated
    public static int verbose = PrePy.verbosityFromLevel(PrePy.getLoggingLevel());
    public static boolean interactive = false;
    public static boolean inspect = false;
    public static String proxyDebugDirectory;
    public static boolean caseok;
    public static boolean Qnew;
    public static boolean unbuffered;
    public static boolean py3k_warning;
    public static boolean dont_write_bytecode;
    public static boolean ignore_environment;
    public static boolean no_user_site;
    public static int bytes_warning;
    public static int optimize;
    public static int division_warning;
    public static final String sreCacheSpecDefault = "weakKeys,concurrencyLevel=4,maximumWeight=2621440,expireAfterAccess=30s";
    public static String sreCacheSpec;

    private Options() {
    }

    private static boolean getBooleanOption(String name, boolean defaultValue) {
        String prop = PySystemState.registry.getProperty(name);
        if (prop == null) {
            return defaultValue;
        }
        return prop.equalsIgnoreCase("true") || prop.equalsIgnoreCase("yes");
    }

    private static String getStringOption(String name, String defaultValue) {
        String prop = PySystemState.registry.getProperty(name);
        if (prop == null) {
            return defaultValue;
        }
        return prop;
    }

    public static void setFromRegistry() {
        showJavaExceptions = Options.getBooleanOption("python.options.showJavaExceptions", showJavaExceptions);
        includeJavaStackInExceptions = Options.getBooleanOption("python.options.includeJavaStackInExceptions", includeJavaStackInExceptions);
        showPythonProxyExceptions = Options.getBooleanOption("python.options.showPythonProxyExceptions", showPythonProxyExceptions);
        respectJavaAccessibility = Options.getBooleanOption("python.security.respectJavaAccessibility", respectJavaAccessibility);
        proxyDebugDirectory = Options.getStringOption("python.options.proxyDebugDirectory", proxyDebugDirectory);
        Options.setLoggingFromRegistry();
        caseok = Options.getBooleanOption("python.options.caseok", caseok);
        Qnew = Options.getBooleanOption("python.options.Qnew", Qnew);
        Options.setDivisionWarningFromRegistry();
        sreCacheSpec = Options.getStringOption("python.sre.cachespec", sreCacheSpec);
        inspect |= Options.getStringOption("python.inspect", "").length() > 0;
        importSite = Options.getBooleanOption("python.import.site", importSite);
        no_site = !importSite;
    }

    private static void setLoggingFromRegistry() {
        String prop = Options.getStringOption("python.verbose", "");
        switch (prop.toLowerCase()) {
            case "": {
                break;
            }
            case "off": {
                PrePy.setLoggingLevel(Level.OFF);
                break;
            }
            case "error": 
            case "severe": {
                PrePy.setLoggingLevel(Level.SEVERE);
                break;
            }
            case "warning": 
            case "warn": {
                PrePy.setLoggingLevel(Level.WARNING);
                break;
            }
            case "message": 
            case "info": {
                PrePy.setLoggingLevel(Level.INFO);
                break;
            }
            case "comment": 
            case "config": {
                PrePy.setLoggingLevel(Level.CONFIG);
                break;
            }
            case "debug": 
            case "fine": {
                PrePy.setLoggingLevel(Level.FINE);
                break;
            }
            case "finer": {
                PrePy.setLoggingLevel(Level.FINER);
                break;
            }
            case "finest": {
                PrePy.setLoggingLevel(Level.FINEST);
                break;
            }
            case "all": {
                PrePy.setLoggingLevel(Level.ALL);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid verbose option: '" + prop + "'");
            }
        }
    }

    private static void setDivisionWarningFromRegistry() {
        String prop = Options.getStringOption("python.division.warning", "");
        switch (prop.toLowerCase()) {
            case "": {
                break;
            }
            case "old": {
                division_warning = 0;
                break;
            }
            case "warn": {
                division_warning = 1;
                break;
            }
            case "warnall": {
                division_warning = 2;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid division_warning option: '" + prop + "'");
            }
        }
    }

    static {
        caseok = false;
        Qnew = false;
        unbuffered = false;
        py3k_warning = false;
        dont_write_bytecode = false;
        ignore_environment = false;
        no_user_site = false;
        bytes_warning = 0;
        optimize = 0;
        division_warning = 0;
        sreCacheSpec = sreCacheSpecDefault;
    }
}

