/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.internal.xml;

import com.ibm.db2.cmx.runtime.exception.DataRuntimeException;
import com.ibm.db2.cmx.runtime.exception.ExceptionFactory;
import com.ibm.db2.cmx.runtime.internal.db.XmlFileHelper;
import com.ibm.db2.cmx.runtime.internal.metadata.StatementDescriptorImpl;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXml;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlAnnotation;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlConnection;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlDataTypeInfo;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlDatabase;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlDriver;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlHint;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlJavaMethod;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlNamedNativeQuery;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlNamedQuery;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlOrigin;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlOriginEnvironment;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlPackage;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlParameter;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlParameterMetaData;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlRSColumn;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlResultSetMetaData;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlStatement;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlStatementAttributes;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlStatementDescriptor;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlStatementMetadata;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlStatementSet;
import com.ibm.db2.cmx.runtime.internal.xml.XmlExporter;
import com.ibm.db2.cmx.runtime.internal.xml.XmlTags;
import com.ibm.db2.cmx.runtime.statement.SqlStatementType;
import com.ibm.db2.cmx.tools.internal.PDQDB2Types;
import com.ibm.db2.cmx.tools.internal.ToolsLogger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class PDQXmlHandler
extends DefaultHandler {
    PDQXml pdqXml_;
    StringBuilder currentText_ = new StringBuilder();
    PDQXmlPackage currentPackage_;
    PDQXmlStatementSet currentStatementSet_;
    PDQXmlStatement currentStatement_;
    int sectionNumber_;
    PDQXmlStatementDescriptor currentStatementDesc_;
    PDQXmlStatementMetadata currentStatementMetadata_;
    PDQXmlOrigin currentOrigin_;
    PDQXmlHint currentHint_;
    PDQXmlAnnotation currentAnnotation_;
    PDQXmlJavaMethod currentJavaMethod_;
    PDQXmlNamedNativeQuery currentNativeQuery_;
    PDQXmlNamedQuery currentNamedQuery_;
    ArrayList<String> autoGenColNames_ = null;
    ArrayList<Integer> autoGenColIndexes_ = null;
    Locator locator_;

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this.pdqXml_ == null) {
            return;
        }
        if (this.currentStatementSet_ != null && string3.equals("statementSet")) {
            this.pdqXml_.getStatementSets().add(this.currentStatementSet_);
            this.currentStatementSet_ = null;
        } else if (this.currentPackage_ != null && this.currentStatement_ == null) {
            if (string3.equals("package")) {
                this.currentStatementSet_.setPackage(this.currentPackage_);
                this.currentPackage_ = null;
            }
        } else if (this.currentStatement_ != null) {
            if (string3.equals("statement")) {
                this.checkStatement(this.currentStatement_);
                if (this.currentStatement_.getPDQXmlStatementDescriptor().getMethodName() == null) {
                    this.currentStatement_.getPDQXmlStatementDescriptor().setMethodName(this.currentStatement_.getId());
                }
                this.currentStatementSet_.getStatements().add(this.currentStatement_);
                this.currentStatement_ = null;
            } else if (this.currentStatement_ != null) {
                this.endElementInsideStatement(string3);
            }
        } else if (this.currentOrigin_ != null) {
            if (string3.equals("origin")) {
                this.pdqXml_.setOrigin(this.currentOrigin_);
                this.currentOrigin_ = null;
            } else {
                this.endElementInsideOrigin(string3);
            }
        }
        this.currentText_.setLength(0);
    }

    private void checkStatement(PDQXmlStatement pDQXmlStatement) throws SAXException {
        if (pDQXmlStatement.getPDQXmlStatementDescriptor() == null) {
            throw new SAXException(Messages.getText("ERR_STMT_DESC_TAG", new Object[0]));
        }
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.currentText_.setLength(0);
        if (string3.equals("programSet")) {
            this.pdqXml_ = new PDQXml();
            this.pdqXml_.setVersion(this.getAttrib(attributes, "version"));
        } else if (this.pdqXml_ != null) {
            this.startElementInsideProgramSet(string3, attributes);
        }
    }

    private void startElementInsideProgramSet(String string, Attributes attributes) throws SAXException {
        if (string.equals("statementSet")) {
            this.currentStatementSet_ = new PDQXmlStatementSet();
        } else if (string.equals("statement")) {
            this.startStatementTag(attributes);
        } else if (string.equals("package")) {
            this.startPackageTag(attributes);
        } else if (this.currentPackage_ == null) {
            if (string.equals("statementDescriptor")) {
                this.startStatementDescriptorTag();
            } else if (this.currentStatementDesc_ != null) {
                this.startElementInsideStatementDescriptor(string, attributes);
            } else if (string.equals("statementMetadata")) {
                this.currentStatementMetadata_ = new PDQXmlStatementMetadata();
            } else if (this.currentStatementMetadata_ != null) {
                this.startElementInsideStatementMetadata(string, attributes);
            } else if (string.equals("origin")) {
                this.currentOrigin_ = new PDQXmlOrigin();
            } else if (this.currentOrigin_ != null) {
                this.startElementInsideOrigin(string);
            }
        }
    }

    private void startStatementDescriptorTag() {
        this.currentStatementDesc_ = new PDQXmlStatementDescriptor();
        this.currentStatementDesc_.setPackageInfo(this.currentStatementSet_.getPackage());
        this.currentStatementDesc_.setSectionNumber(this.sectionNumber_);
        this.currentStatementDesc_.setLineNumber(this.locator_.getLineNumber());
        this.currentStatementDesc_.setColumnNumber(this.locator_.getColumnNumber());
    }

    private void startStatementTag(Attributes attributes) throws SAXException {
        this.currentStatement_ = new PDQXmlStatement();
        this.currentStatement_.setId(this.getAttrib(attributes, "id"));
        if (this.getAttrib(attributes, "sectionNumber") != null) {
            this.sectionNumber_ = this.getIntAttrib(attributes, "sectionNumber");
        }
    }

    private void startPackageTag(Attributes attributes) throws SAXException {
        String string;
        Integer n2;
        String string2;
        this.currentPackage_ = new PDQXmlPackage();
        this.currentPackage_.setPackageName(this.getAttrib(attributes, "name"));
        this.currentPackage_.setPackageVersion(this.getAttrib(attributes, "version"));
        this.currentPackage_.setBindOptions(this.getAttrib(attributes, "bindOptions"));
        this.currentPackage_.setCollectionName(this.getAttrib(attributes, "collection"));
        String string3 = this.getAttrib(attributes, "isBindable");
        if (string3 != null) {
            this.currentPackage_.setBindable(Boolean.valueOf(string3));
        }
        if ((string2 = this.getAttrib(attributes, "consistencyToken")) != null) {
            long l10 = this.getConsistencyToken(string2);
            this.currentPackage_.setConsistencyToken(l10);
        }
        if (null != (n2 = this.getIntAttrib(attributes, "greatestSectionNumberUsed"))) {
            this.currentPackage_.setGreatestSectionNumberUsed(n2);
        }
        if ((string = this.getAttrib(attributes, "forceSingleBindIsolation")) != null) {
            this.currentPackage_.setForceSingleBindIsolation(Boolean.valueOf(string));
        }
    }

    private long getConsistencyToken(String string) throws SAXException {
        try {
            if (!XmlFileHelper.isAttributeSet(string)) {
                return 0L;
            }
            if (string.startsWith("0x")) {
                String string2 = string.substring(2);
                if (string2.length() != 16) {
                    return Long.parseLong(string2, 16);
                }
                byte[] byArray = StatementDescriptorImpl.stringToBytes(string2);
                return StatementDescriptorImpl.bytesToTimestamp(byArray);
            }
            if (string.length() != 16) {
                return Long.parseLong(string, 16);
            }
            byte[] byArray = StatementDescriptorImpl.stringToBytes(string);
            return StatementDescriptorImpl.bytesToTimestamp(byArray);
        }
        catch (NumberFormatException numberFormatException) {
            DataRuntimeException dataRuntimeException = ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(null, Messages.getText("ERR_INVALID_CONSISTENCY_TOKEN", string), numberFormatException, 11024);
            throw new SAXException(Messages.getText("ERR_INVALID_CONSISTENCY_TOKEN", string), dataRuntimeException);
        }
    }

    private void startElementInsideOrigin(String string) {
        if (string.equals("originEnvironment")) {
            this.currentOrigin_.setPDQXmlOriginEnvironment(new PDQXmlOriginEnvironment());
        } else if (this.currentOrigin_.getPDQXmlOriginEnvironment() != null) {
            if (string.equals("driver")) {
                this.currentOrigin_.getPDQXmlOriginEnvironment().setPDQXmlDriver(new PDQXmlDriver());
            } else if (string.equals("database")) {
                this.currentOrigin_.getPDQXmlOriginEnvironment().setPDQXmlDatabase(new PDQXmlDatabase());
            } else if (string.equals("connection")) {
                this.currentOrigin_.getPDQXmlOriginEnvironment().setPDQXmlConnection(new PDQXmlConnection());
            }
        }
    }

    private void endElementInsideOrigin(String string) throws SAXException {
        if (string.equals("originType")) {
            this.currentOrigin_.setOriginType(this.currentText_.toString());
        } else if (this.currentOrigin_.getPDQXmlOriginEnvironment() != null) {
            XmlExporter xmlExporter;
            if (this.currentOrigin_.getPDQXmlOriginEnvironment().getPDQXmlDriver() != null) {
                xmlExporter = this.currentOrigin_.getPDQXmlOriginEnvironment().getPDQXmlDriver();
                if (string.equals("driverName")) {
                    ((PDQXmlDriver)xmlExporter).setDriverName(this.currentText_.toString());
                } else if (string.equals("driverVersion")) {
                    ((PDQXmlDriver)xmlExporter).setDriverVersion(this.currentText_.toString());
                } else if (string.equals("driverMajorVersion")) {
                    ((PDQXmlDriver)xmlExporter).setDriverMajorVersion(this.getInt(this.currentText_.toString()));
                } else if (string.equals("driverMinorVersion")) {
                    ((PDQXmlDriver)xmlExporter).setDriverMinorVersion(this.getInt(this.currentText_.toString()));
                }
            }
            if (this.currentOrigin_.getPDQXmlOriginEnvironment().getPDQXmlDatabase() != null) {
                xmlExporter = this.currentOrigin_.getPDQXmlOriginEnvironment().getPDQXmlDatabase();
                if (string.equals("dbProductName")) {
                    ((PDQXmlDatabase)xmlExporter).setDbProductName(this.currentText_.toString());
                } else if (string.equals("dbProductVersion")) {
                    ((PDQXmlDatabase)xmlExporter).setDbProductVersion(this.currentText_.toString());
                } else if (string.equals("dbProductMajorVersion")) {
                    ((PDQXmlDatabase)xmlExporter).setDbProductMajorVersion(this.getInt(this.currentText_.toString()));
                } else if (string.equals("dbProductMinorVersion")) {
                    ((PDQXmlDatabase)xmlExporter).setDbProductMinorVersion(this.getInt(this.currentText_.toString()));
                }
            }
            if (this.currentOrigin_.getPDQXmlOriginEnvironment().getPDQXmlConnection() != null) {
                xmlExporter = this.currentOrigin_.getPDQXmlOriginEnvironment().getPDQXmlConnection();
                if (string.equals("url")) {
                    ((PDQXmlConnection)xmlExporter).setConnectionURL(this.currentText_.toString());
                } else if (string.equals("connectionUserName")) {
                    ((PDQXmlConnection)xmlExporter).setConnectionUserName(this.currentText_.toString());
                }
            }
        }
    }

    private void endElementInsideStatement(String string) throws SAXException, SAXParseException {
        if (string.equals("statementDescriptor")) {
            this.currentStatement_.setPDQXmlStatementDescriptor(this.currentStatementDesc_);
            this.currentStatementDesc_ = null;
        } else if (string.equals("statementMetadata")) {
            this.currentStatement_.setPDQXmlStatementMetadata(this.currentStatementMetadata_);
            this.currentStatementMetadata_ = null;
        } else if (this.currentStatementDesc_ != null) {
            this.endElementInsideStatementDescriptor(string);
        } else if (this.currentStatementMetadata_ != null) {
            this.endElementInsideStatementMetadata(string);
        }
    }

    private void startElementInsideStatementMetadata(String string, Attributes attributes) throws SAXException {
        if (string.equals("javaMethod")) {
            this.currentJavaMethod_ = new PDQXmlJavaMethod();
        } else if (this.currentJavaMethod_ != null) {
            if (string.equals("annotation")) {
                this.currentAnnotation_ = new PDQXmlAnnotation();
                this.currentAnnotation_.setType(this.getAttrib(attributes, "type"));
            }
        } else if (string.equals("namedNativeQuery")) {
            this.currentNativeQuery_ = new PDQXmlNamedNativeQuery();
        } else if (this.currentNativeQuery_ != null && string.equals("hint")) {
            this.currentHint_ = new PDQXmlHint();
        }
    }

    private void endElementInsideStatementMetadata(String string) {
        if (this.currentJavaMethod_ != null) {
            if (string.equals("javaMethod")) {
                this.currentStatementMetadata_.setJavaMethod(this.currentJavaMethod_);
                this.currentJavaMethod_ = null;
            } else {
                this.endElementInsideJavaMethod(string);
            }
        } else if (this.currentNativeQuery_ != null) {
            if (string.equals("namedNativeQuery")) {
                this.currentStatementMetadata_.addNamedNativeQuery(this.currentNativeQuery_);
                this.currentNativeQuery_ = null;
            } else {
                this.endElementInsideNativeQuery(string);
            }
        } else if (this.currentNamedQuery_ != null) {
            if (string.equals("namedQuery")) {
                this.currentStatementMetadata_.addNamedQuery(this.currentNamedQuery_);
                this.currentNamedQuery_ = null;
            } else {
                this.endElementInsideNamedQuery(string);
            }
        }
    }

    private void endElementInsideNativeQuery(String string) {
        if (this.currentHint_ != null) {
            if (string.equals("hint")) {
                this.currentNativeQuery_.getHints().add(this.currentHint_);
                this.currentHint_ = null;
            } else {
                this.endElementInsideHint(string);
            }
        } else if (string.equals("name")) {
            this.currentNativeQuery_.setName(this.currentText_.toString());
        } else if (string.equals("sql")) {
            this.currentNativeQuery_.setSql(this.currentText_.toString());
        }
    }

    private void endElementInsideNamedQuery(String string) {
        if (this.currentHint_ != null) {
            if (string.equals("hint")) {
                this.currentNativeQuery_.getHints().add(this.currentHint_);
                this.currentHint_ = null;
            } else {
                this.endElementInsideHint(string);
            }
        } else if (string.equals("name")) {
            this.currentNamedQuery_.setName(this.currentText_.toString());
        }
    }

    private void endElementInsideHint(String string) {
        if (string.equals("name")) {
            this.currentHint_.setName(this.currentText_.toString());
        } else if (string.equals("value")) {
            this.currentHint_.setName(this.currentText_.toString());
        }
    }

    private void endElementInsideJavaMethod(String string) {
        if (string.equals("methodName")) {
            this.currentJavaMethod_.setMethodName(this.currentText_.toString());
        } else if (string.equals("sourceCodeLineNumber")) {
            this.currentJavaMethod_.setSourceCodeLineNumber(Integer.valueOf(this.currentText_.toString()));
        } else if (string.equals("annotation")) {
            this.currentJavaMethod_.setAnnotation(this.currentAnnotation_);
            this.currentAnnotation_ = null;
        } else if (this.currentAnnotation_ != null) {
            if (string.equals("pattern")) {
                this.currentAnnotation_.setPattern(this.currentText_.toString());
            } else if (string.equals("sql")) {
                this.currentAnnotation_.setSql(this.currentText_.toString());
            }
        }
    }

    private void startElementInsideStatementDescriptor(String string, Attributes attributes) throws SAXException {
        XmlExporter xmlExporter;
        if (string.equals("parameterMetadata")) {
            this.currentStatementDesc_.setParameterMetadata(new PDQXmlParameterMetaData());
        } else if (this.currentStatementDesc_.getParameterMetadata() != null && string.equals("parameter")) {
            xmlExporter = new PDQXmlParameter();
            this.fillMetaDataAttributes(attributes, (PDQXmlDataTypeInfo)xmlExporter);
            ((PDQXmlParameter)xmlExporter).setParameterMode(XmlTags.getParameterDirectionNumber(this.getAttrib(attributes, "parameterMode")));
            this.currentStatementDesc_.getParameterMetadata().add((PDQXmlParameter)xmlExporter);
        }
        if (string.equals("resultSetMetadata")) {
            this.currentStatementDesc_.setResultSetMetaData(new PDQXmlResultSetMetaData());
        } else if (this.currentStatementDesc_.getResultSetMetaData() != null && string.equals("column")) {
            xmlExporter = new PDQXmlRSColumn();
            this.fillMetaDataAttributes(attributes, (PDQXmlDataTypeInfo)xmlExporter);
            this.currentStatementDesc_.getResultSetMetaData().add((PDQXmlRSColumn)xmlExporter);
        }
        if (string.equals("statementAttributes")) {
            xmlExporter = PDQXmlStatementAttributes.getPDQXmlStatementAttributesForPdqAPI();
            this.currentStatementDesc_.setStatementAttributes((PDQXmlStatementAttributes)xmlExporter);
            String string2 = this.getAttrib(attributes, "resultSetConcurrency");
            if (string2 != null) {
                ((PDQXmlStatementAttributes)xmlExporter).setConcurrency(XmlTags.getConcurrencyNumber(string2));
            }
            if ((string2 = this.getAttrib(attributes, "resultSetHoldability")) != null) {
                ((PDQXmlStatementAttributes)xmlExporter).setHoldability(XmlTags.getHoldabilityNumber(string2, 2));
            }
            if ((string2 = this.getAttrib(attributes, "resultSetType")) != null) {
                ((PDQXmlStatementAttributes)xmlExporter).setType(XmlTags.getCursorTypeNumber(string2));
            }
            if ((string2 = this.getAttrib(attributes, "parameterType")) != null) {
                ((PDQXmlStatementAttributes)xmlExporter).setParameterType(XmlTags.getStatementAttributesParameterTypeNumber(string2));
            }
            if ((string2 = this.getAttrib(attributes, "rowType")) != null) {
                ((PDQXmlStatementAttributes)xmlExporter).setRowType(XmlTags.getStatementAttributesRowTypeNumber(string2));
            }
            if ((string2 = this.getAttrib(attributes, "isBindable")) != null) {
                ((PDQXmlStatementAttributes)xmlExporter).setBindable(Boolean.valueOf(string2));
            }
            if (null != (string2 = this.getAttrib(attributes, "allowStaticRowsetCursors"))) {
                ((PDQXmlStatementAttributes)xmlExporter).setAllowStaticRowsetCursors(Boolean.valueOf(string2));
            }
        } else if (this.currentStatementDesc_.getStatementAttributes() != null) {
            // empty if block
        }
        if (string.equals("autoGeneratedColumnNames")) {
            this.autoGenColNames_ = new ArrayList();
        } else if (this.autoGenColNames_ != null) {
            // empty if block
        }
        if (string.equals("autoGeneratedColumnIndexes")) {
            this.autoGenColIndexes_ = new ArrayList();
        } else if (this.autoGenColIndexes_ != null) {
            // empty if block
        }
    }

    private void fillMetaDataAttributes(Attributes attributes, PDQXmlDataTypeInfo pDQXmlDataTypeInfo) throws SAXException {
        int n2;
        Integer n3;
        Integer n4;
        Integer n5;
        Integer n6;
        Integer n7;
        pDQXmlDataTypeInfo.setColumnName(this.getAttrib(attributes, "columnName"));
        String string = this.getAttrib(attributes, "jdbcType");
        if (string != null) {
            pDQXmlDataTypeInfo.setJdbcType(XmlTags.getDB2TypeNumber(string));
        }
        if ((n7 = this.getIntAttrib(attributes, "db2type")) != null) {
            pDQXmlDataTypeInfo.setDb2Type(n7);
        }
        if ((n6 = this.getIntAttrib(attributes, "precision")) != null) {
            pDQXmlDataTypeInfo.setPrecision(n6);
        }
        if ((n5 = this.getIntAttrib(attributes, "scale")) != null) {
            pDQXmlDataTypeInfo.setScale(n5);
        }
        if ((n4 = this.getIntAttrib(attributes, "ccsid")) != null) {
            pDQXmlDataTypeInfo.setCcsid(n4);
        }
        if ((n3 = this.getIntAttrib(attributes, "length")) != null) {
            pDQXmlDataTypeInfo.setLength(n3.intValue());
        }
        if (n7 != null && (n2 = PDQDB2Types.mapDB2DataTypeToJDBCType(true, pDQXmlDataTypeInfo.getDb2Type(), pDQXmlDataTypeInfo.getLength(), pDQXmlDataTypeInfo.getCcsid())) != 0) {
            pDQXmlDataTypeInfo.setJdbcType(n2);
        }
    }

    private void endElementInsideStatementDescriptor(String string) throws SAXParseException, SAXException {
        if (string.equals("processedSql")) {
            this.currentStatementDesc_.setProcessedSql(this.currentText_.toString());
        } else if (string.equals("methodName")) {
            this.currentStatementDesc_.setMethodName(this.currentText_.toString());
        } else if (string.equals("prepareSql")) {
            this.currentStatementDesc_.setSql(this.currentText_.toString());
        } else if (string.equals("autoGeneratedColumnNames")) {
            this.currentStatementDesc_.setAutogenColumnNames(this.autoGenColNames_.toArray(new String[this.autoGenColNames_.size()]));
            this.autoGenColNames_ = null;
        } else if (string.equals("autoGeneratedColumnIndexes")) {
            int[] nArray = new int[this.autoGenColIndexes_.size()];
            for (int i10 = 0; i10 < nArray.length; ++i10) {
                nArray[i10] = this.autoGenColIndexes_.get(i10);
            }
            this.currentStatementDesc_.setAutogenColumnIndexes(nArray);
            this.autoGenColIndexes_ = null;
        } else if (string.equals("autoGeneratedcolumnIndicator")) {
            this.currentStatementDesc_.setAutogenColumnIndicator(this.getInt(this.currentText_.toString()));
        } else if (string.equals("statementType")) {
            this.currentStatementDesc_.setStatementType(this.currentText_.toString());
        } else if (string.equals("parameterHandlerName")) {
            this.currentStatementDesc_.setParameterHandlerName(this.currentText_.toString());
        } else if (string.equals("resultHandlerName")) {
            this.currentStatementDesc_.setResultHandlerName(this.currentText_.toString());
        } else if (string.equals("rowHandlerName")) {
            this.currentStatementDesc_.setRowHandlerName(this.currentText_.toString());
        } else if (string.equals("callHandlerName")) {
            this.currentStatementDesc_.setCallHandlerName(this.currentText_.toString());
        } else if (this.autoGenColNames_ != null) {
            if (string.equals("columnName")) {
                this.autoGenColNames_.add(this.currentText_.toString());
            }
        } else if (this.autoGenColIndexes_ != null && string.equals("columnIndex")) {
            this.autoGenColIndexes_.add(this.getInt(this.currentText_.toString()));
        }
    }

    private SqlStatementType getSqlStatementType(String string) throws SAXException {
        SqlStatementType[] sqlStatementTypeArray;
        if (string == null) {
            return null;
        }
        for (SqlStatementType sqlStatementType : sqlStatementTypeArray = SqlStatementType.values()) {
            if (!sqlStatementType.name().equals(string)) continue;
            return sqlStatementType;
        }
        throw new SAXException(Messages.getText("ERR_INV_SQL_TYPE", string));
    }

    @Override
    public void characters(char[] cArray, int n2, int n3) throws SAXException {
        this.currentText_.append(cArray, n2, n3);
    }

    @Override
    public void endDocument() throws SAXException {
        this.currentText_ = null;
    }

    @Override
    public void endPrefixMapping(String string) throws SAXException {
        super.endPrefixMapping(string);
    }

    @Override
    public void error(SAXParseException sAXParseException) throws SAXException {
        ToolsLogger.getLogger().log(Level.SEVERE, "Parser error.", sAXParseException);
        throw sAXParseException;
    }

    @Override
    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        ToolsLogger.getLogger().log(Level.SEVERE, "Parser fatal error.", sAXParseException);
        throw sAXParseException;
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n2, int n3) throws SAXException {
        super.ignorableWhitespace(cArray, n2, n3);
    }

    @Override
    public void notationDecl(String string, String string2, String string3) throws SAXException {
        super.notationDecl(string, string2, string3);
    }

    @Override
    public void processingInstruction(String string, String string2) throws SAXException {
        super.processingInstruction(string, string2);
    }

    @Override
    public InputSource resolveEntity(String string, String string2) throws IOException, SAXException {
        return super.resolveEntity(string, string2);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator_ = locator;
    }

    @Override
    public void skippedEntity(String string) throws SAXException {
        super.skippedEntity(string);
    }

    @Override
    public void startDocument() throws SAXException {
        super.startDocument();
    }

    @Override
    public void startPrefixMapping(String string, String string2) throws SAXException {
        super.startPrefixMapping(string, string2);
    }

    @Override
    public void unparsedEntityDecl(String string, String string2, String string3, String string4) throws SAXException {
        super.unparsedEntityDecl(string, string2, string3, string4);
    }

    @Override
    public void warning(SAXParseException sAXParseException) throws SAXException {
        super.warning(sAXParseException);
    }

    private String getAttrib(Attributes attributes, String string) throws SAXException {
        String string2 = attributes.getValue(string);
        return string2;
    }

    private Integer getIntAttrib(Attributes attributes, String string) throws SAXException {
        String string2 = attributes.getValue(string);
        if (string2 == null) {
            return null;
        }
        try {
            return Integer.valueOf(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new SAXException(numberFormatException);
        }
    }

    private int getInt(String string) throws SAXException {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new SAXException(Messages.getText("ERR_INV_NUM", string), numberFormatException);
        }
    }

    private long getLong(String string) throws SAXException {
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new SAXException(Messages.getText("ERR_INV_NUM", string), numberFormatException);
        }
    }

    public PDQXml getPdqXml() {
        return this.pdqXml_;
    }

    public void setPdqXml(PDQXml pDQXml) {
        this.pdqXml_ = pDQXml;
    }
}

