/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.tools.internal.generatePdqXml;

import com.ibm.db2.cmx.runtime.exception.ExceptionFactory;
import com.ibm.db2.cmx.runtime.exception.WarningFactory;
import com.ibm.db2.cmx.runtime.internal.StaticProfileConstants;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlCaptureStatistics;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlStatementDescriptor;
import com.ibm.db2.cmx.tools.internal.generatePdqXml.PDQXmlStatementForGeneratePureQueryXml;
import com.ibm.db2.cmx.tools.internal.generatePdqXml.SQLFile;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class QueryTunerXMLHandler
extends DefaultHandler {
    private static final String ROOT_ELEMENT_WORKLOAD = "workload";
    private static final String ATTRIBUTE_DBTYPE_IN_WORKLOAD = "dbtype";
    private static final String ATTRIBUTE_DBTYPE_VALUE_DB2LUW = "DB2LUW";
    private static final String ELEMENT_STATEMENT = "statement";
    private static final String ELEMENT_STATEMENT_TEXT = "statement_text";
    private static final String ELEMENT_STATEMENT_RUNTIME = "statement_runtime";
    private static final String ATTRIBUTE_INSTID_IN_STATEMENT = "instid";
    private static final String[] ATTRIBUTE_SCHEMA = new String[]{"default_schema", "qualifier"};
    private static final String ATTRIBUTE_SQLID_IN_STATEMENT = "cursqlid";
    private static final String ATTRIBUTE_FUNCPATH_IN_STATEMENT = "func_path";
    private static final String ATTRIBUTE_SECTION_TYPE_IN_STATEMENT = "section_type";
    private static final String ATTRIBUTE_CURSOR_WITH_HOLD_IN_STATEMENT = "bind_chold";
    private static final String ATTRIBUTE_NOT_SET_NULL = "null";
    private static final String COLLID = "collid";
    private static final String STAT_EXEC = "stat_exec";
    private static final String STAT_EXECB = "stat_execb";
    private static final String CACHED_TS = "cached_ts";
    private static final String STAT_ELAP = "stat_elap";
    private static final String NUM_EXECUTIONS = "num_executions";
    private static final String NUM_COORD_EXEC_WITH_METRICS = "num_coord_exec_with_metrics";
    private static final String INSERT_TIMESTAMP = "insert_timestamp";
    private static final String TOTAL_CPU_TIME = "total_cpu_time";
    private static final String[] ATTRIBUTE_EXECUTION_STATISTICS = new String[]{"collid", "stat_exec", "stat_execb", "cached_ts", "stat_elap", "num_executions", "num_coord_exec_with_metrics", "insert_timestamp", "total_cpu_time"};
    private Map<String, AttributeLocationAndValue> executionStatisticsCurrentStatement_ = null;
    private Map<String, String> specialRegistersCurrentStatement_ = null;
    private Locator locator_ = null;
    private final Stack<String> currentElement_ = new Stack();
    private final List<PDQXmlStatementForGeneratePureQueryXml> statements_ = new ArrayList<PDQXmlStatementForGeneratePureQueryXml>();
    private PDQXmlStatementForGeneratePureQueryXml currentStatement_ = null;
    private final StringBuilder currentStatementSQL_ = new StringBuilder();
    private String workloadDBType_ = null;
    private String rootElement_ = null;
    private boolean isXmlParsingComplete_ = false;
    final SQLFile sqlFile_;

    QueryTunerXMLHandler(SQLFile sQLFile) {
        this.sqlFile_ = sQLFile;
    }

    public List<PDQXmlStatementForGeneratePureQueryXml> getStatements() {
        this.throwExceptionIfParseMethodHasNotCompleted("getStatements");
        return this.statements_;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator_ = locator;
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) {
        if (null == this.rootElement_) {
            this.rootElement_ = string3;
        }
        if (this.currentElement_.contains(string3)) {
            throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_XML_PARSE_ERROR_DOUBLE_NESTED", this.sqlFile_.inputSQLFilePath_, this.locator_.getColumnNumber(), this.locator_.getLineNumber(), string3), null, 11164);
        }
        this.currentElement_.push(string3);
        if (ROOT_ELEMENT_WORKLOAD.equals(string3)) {
            this.workloadDBType_ = attributes.getValue(ATTRIBUTE_DBTYPE_IN_WORKLOAD);
        } else if (ELEMENT_STATEMENT.equals(string3)) {
            String string4;
            String string5;
            if (null != this.currentStatement_) {
                throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_INVALID_SWITCH_CASE", this.currentStatement_), null, 11165);
            }
            this.currentStatement_ = new PDQXmlStatementForGeneratePureQueryXml();
            this.statements_.add(this.currentStatement_);
            PDQXmlStatementDescriptor pDQXmlStatementDescriptor = this.sqlFile_.getStatementDescriptor(this.currentStatement_);
            pDQXmlStatementDescriptor.setLineNumber(this.locator_.getLineNumber());
            pDQXmlStatementDescriptor.setColumnNumber(this.locator_.getColumnNumber());
            if (0 < this.currentStatementSQL_.length()) {
                throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_INVALID_SWITCH_CASE", this.currentStatementSQL_), null, 11166);
            }
            String string6 = attributes.getValue(ATTRIBUTE_INSTID_IN_STATEMENT);
            if (this.isAttributeSetAndNotNull(string6)) {
                this.currentStatement_.setID(ATTRIBUTE_INSTID_IN_STATEMENT, '\'', string6);
            }
            String string7 = attributes.getValue(ATTRIBUTE_CURSOR_WITH_HOLD_IN_STATEMENT);
            Integer n2 = null;
            if ("Y".equalsIgnoreCase(string7)) {
                n2 = 1;
            } else if ("N".equalsIgnoreCase(string7)) {
                n2 = 2;
            }
            if (null != n2) {
                this.sqlFile_.getStatementAttributes(this.currentStatement_).setHoldability(n2);
            }
            for (String string8 : ATTRIBUTE_SCHEMA) {
                String string9 = attributes.getValue(string8);
                if (!this.isAttributeSetAndNotNull(string9)) continue;
                this.setSchema(new AttributeLocationAndValue(string3, string8, string9, this.locator_.getLineNumber(), this.locator_.getColumnNumber()));
            }
            String string11 = attributes.getValue(ATTRIBUTE_SQLID_IN_STATEMENT);
            if (this.isAttributeSetAndNotNull(string11)) {
                this.setSpecialRegister("SQLID", string11);
            }
            if (this.isAttributeSetAndNotNull(string5 = attributes.getValue(ATTRIBUTE_FUNCPATH_IN_STATEMENT))) {
                this.setSpecialRegister("PATH", string5);
            }
            if ("S".equalsIgnoreCase(string4 = attributes.getValue(ATTRIBUTE_SECTION_TYPE_IN_STATEMENT))) {
                this.currentStatement_.setWasExecutionStatic(true);
            }
            this.checkForExecutionStatistics(ELEMENT_STATEMENT, attributes);
        } else if (ELEMENT_STATEMENT_TEXT.equals(string3)) {
            for (String string10 : ATTRIBUTE_SCHEMA) {
                String string11 = attributes.getValue(string10);
                if (!this.isAttributeSetAndNotNull(string11)) continue;
                this.setSchema(new AttributeLocationAndValue(string3, string10, string11, this.locator_.getLineNumber(), this.locator_.getColumnNumber()));
            }
        } else if (ELEMENT_STATEMENT_RUNTIME.equals(string3)) {
            this.checkForExecutionStatistics(ELEMENT_STATEMENT_RUNTIME, attributes);
        }
    }

    private void checkForExecutionStatistics(String string, Attributes attributes) {
        for (String string2 : ATTRIBUTE_EXECUTION_STATISTICS) {
            String string3 = attributes.getValue(string2);
            if (!this.isAttributeSetAndNotNull(string3)) continue;
            if (null == this.executionStatisticsCurrentStatement_) {
                this.executionStatisticsCurrentStatement_ = new HashMap<String, AttributeLocationAndValue>();
            }
            this.executionStatisticsCurrentStatement_.put(string2, new AttributeLocationAndValue(string, string2, string3, this.locator_.getLineNumber(), this.locator_.getColumnNumber()));
        }
    }

    private void setSpecialRegister(String string, String string2) {
        if (null == this.specialRegistersCurrentStatement_) {
            this.specialRegistersCurrentStatement_ = new HashMap<String, String>();
        }
        this.specialRegistersCurrentStatement_.put(string, string2);
    }

    private void setSchema(AttributeLocationAndValue attributeLocationAndValue) {
        if (null != attributeLocationAndValue && this.isAttributeSetAndNotNull(attributeLocationAndValue.attributeValue_)) {
            if (null == this.specialRegistersCurrentStatement_) {
                this.specialRegistersCurrentStatement_ = new HashMap<String, String>();
            } else {
                String string = this.specialRegistersCurrentStatement_.get("SCHEMA");
                if (null != string && !string.equals(attributeLocationAndValue.attributeValue_)) {
                    String string2 = Messages.getText("ERR_XML_FILE_NOT_VALID", this.sqlFile_.inputSQLFilePath_, "InfoSphere Optim Query Workload Tuner");
                    string2 = string2 + "  " + Messages.getText("ERR_XML_PARSE_ERROR_CONFLICTING_SPECIAL_REGISTER2", attributeLocationAndValue.elementName_, attributeLocationAndValue.lineNumber_, attributeLocationAndValue.columnNumber_, attributeLocationAndValue.attributeName_, attributeLocationAndValue.attributeValue_, "CURRENT SCHEMA", string);
                    throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(string2, null, 11170);
                }
            }
            boolean bl2 = ATTRIBUTE_DBTYPE_VALUE_DB2LUW.equalsIgnoreCase(this.workloadDBType_);
            String string = attributeLocationAndValue.attributeValue_;
            if (bl2) {
                while (8 > string.length()) {
                    string = string + ' ';
                }
            }
            this.setSpecialRegister("SCHEMA", string);
            if (bl2) {
                this.setSpecialRegister("SQLID", string);
            }
        }
    }

    @Override
    public void characters(char[] cArray, int n2, int n3) throws SAXException {
        if (this.currentElement_.isEmpty()) {
            throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_INVALID_SWITCH_CASE", this.currentElement_), null, 11171);
        }
        String string = this.currentElement_.peek();
        if (ELEMENT_STATEMENT_TEXT.equals(string)) {
            this.currentStatementSQL_.append(cArray, n2, n3);
        } else {
            String string2 = String.copyValueOf(cArray, n2, n3).trim();
            if (0 < string2.length()) {
                WarningFactory.createPureQueryWarningForToolsLogOnly(Messages.getText("WARN_ELEMENT_TEXT_CONTENT_IGNORED", string, this.locator_.getLineNumber(), this.locator_.getColumnNumber(), String.copyValueOf(cArray, n2, n3)), 11172, this.getClass(), "characters");
            }
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) {
        String string4;
        String string5 = string4 = this.currentElement_.isEmpty() ? null : this.currentElement_.peek();
        if (!string3.equals(string4)) {
            throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_XML_PARSE_ERROR_MISMATCHED_TAGS", this.sqlFile_.inputSQLFilePath_, this.locator_.getColumnNumber(), this.locator_.getLineNumber(), string3, string4), null, 11173);
        }
        this.currentElement_.pop();
        if (!ROOT_ELEMENT_WORKLOAD.equals(string3)) {
            if (ELEMENT_STATEMENT.equals(string3)) {
                this.sqlFile_.getStatementDescriptor(this.currentStatement_).addSpecialRegisterValuesSet(this.sqlFile_.specialRegisterValuesSetsOriginElement_, this.specialRegistersCurrentStatement_);
                this.specialRegistersCurrentStatement_ = null;
                this.setExecutionStatistics();
                this.executionStatisticsCurrentStatement_ = null;
                this.currentStatement_ = null;
            } else if (ELEMENT_STATEMENT_TEXT.equals(string3)) {
                PDQXmlStatementDescriptor pDQXmlStatementDescriptor = this.sqlFile_.getStatementDescriptor(this.currentStatement_);
                pDQXmlStatementDescriptor.setSql(this.currentStatementSQL_.toString());
                this.currentStatementSQL_.delete(0, this.currentStatementSQL_.length());
            } else if (ELEMENT_STATEMENT_RUNTIME.equals(string3)) {
                // empty if block
            }
        }
    }

    private void setExecutionStatistics() {
        if (null == this.currentStatement_) {
            throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_INVALID_SWITCH_CASE", this.currentStatement_), null, 11197);
        }
        if (null != this.executionStatisticsCurrentStatement_) {
            Long l10;
            AttributeLocationAndValue attributeLocationAndValue;
            GregorianCalendar gregorianCalendar;
            AttributeLocationAndValue attributeLocationAndValue2;
            Object object;
            COLLID_VALUES cOLLID_VALUES;
            PDQXmlCaptureStatistics pDQXmlCaptureStatistics = SQLFile.getCaptureStatistics(this.currentStatement_);
            AttributeLocationAndValue attributeLocationAndValue3 = this.executionStatisticsCurrentStatement_.get(COLLID);
            if (null == attributeLocationAndValue3 || !this.isAttributeSetAndNotNull(attributeLocationAndValue3.attributeValue_)) {
                cOLLID_VALUES = null;
            } else {
                try {
                    cOLLID_VALUES = COLLID_VALUES.valueOf(attributeLocationAndValue3.attributeValue_);
                }
                catch (Throwable throwable) {
                    cOLLID_VALUES = null;
                    object = attributeLocationAndValue3.getMessageIndicatingUnexpectedAttributeValue(false, Messages.getText("MSG_EXPECTED_VALUES", Arrays.toString((Object[])COLLID_VALUES.values())) + "  " + Messages.getText("ERR_COLLID_VALUE_NOT_RECOGNIZED", attributeLocationAndValue3.attributeName_, "IBM InfoSphere Optim Query Workload Tuner", "pureQuery Runtime"));
                    WarningFactory.createPureQueryWarningForToolsLogOnly((String)object, 11256, this.getClass(), "setExecutionStatistics", null);
                }
            }
            AttributeLocationAndValue attributeLocationAndValue4 = this.executionStatisticsCurrentStatement_.get(NUM_EXECUTIONS);
            if (null == attributeLocationAndValue4) {
                attributeLocationAndValue4 = this.executionStatisticsCurrentStatement_.get(NUM_COORD_EXEC_WITH_METRICS);
            }
            if (null == attributeLocationAndValue4 && (COLLID_VALUES.DSNDYNAMICSQLCACHE == cOLLID_VALUES || COLLID_VALUES.DSNEXPLAINMODEYES == cOLLID_VALUES) && null == (attributeLocationAndValue4 = this.executionStatisticsCurrentStatement_.get(STAT_EXECB))) {
                attributeLocationAndValue4 = this.executionStatisticsCurrentStatement_.get(STAT_EXEC);
            }
            if (null != (object = (Integer)this.getAttributeValueNumber(attributeLocationAndValue4, Integer.class, false))) {
                pDQXmlCaptureStatistics.setExecutionCount((Integer)object);
            }
            if (null == (attributeLocationAndValue2 = this.executionStatisticsCurrentStatement_.get(INSERT_TIMESTAMP)) && COLLID_VALUES.DSNDYNAMICSQLCACHE == cOLLID_VALUES) {
                attributeLocationAndValue2 = this.executionStatisticsCurrentStatement_.get(CACHED_TS);
            }
            if (null != (gregorianCalendar = this.getAttributeValueTimestamp(attributeLocationAndValue2))) {
                pDQXmlCaptureStatistics.setFirstExecutionTime(gregorianCalendar);
                pDQXmlCaptureStatistics.setLastExecutionTime(gregorianCalendar);
            }
            if (null != (attributeLocationAndValue = this.executionStatisticsCurrentStatement_.get(TOTAL_CPU_TIME))) {
                l10 = (Long)this.getAttributeValueNumber(attributeLocationAndValue, Long.class, false);
            } else if (COLLID_VALUES.DSNEXPLAINMODEYES == cOLLID_VALUES || null != object && 1 >= (Integer)object && COLLID_VALUES.DSNDYNAMICSQLCACHE == cOLLID_VALUES) {
                attributeLocationAndValue = this.executionStatisticsCurrentStatement_.get(STAT_ELAP);
                BigDecimal bigDecimal = (BigDecimal)this.getAttributeValueNumber(attributeLocationAndValue, BigDecimal.class, false);
                l10 = StaticProfileConstants.toLong(bigDecimal.movePointRight(6).toBigInteger());
            } else {
                l10 = null;
            }
            if (null != l10) {
                pDQXmlCaptureStatistics.setStmtMaxExecutionTimeInMicroseconds(l10);
            }
        }
    }

    private <T extends Number> T getAttributeValueNumber(AttributeLocationAndValue attributeLocationAndValue, Class<? extends Number> clazz, boolean bl2) {
        if (null == attributeLocationAndValue || null == attributeLocationAndValue.attributeValue_) {
            return null;
        }
        try {
            return StaticProfileConstants.readStringAsNumber(attributeLocationAndValue.attributeValue_.trim(), clazz, bl2);
        }
        catch (Exception exception) {
            throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(attributeLocationAndValue.getMessageIndicatingUnexpectedAttributeValue(true, Messages.getText("ERR_VALUE_NOT_VALID_NUMBER", new Object[0])), exception, 11168);
        }
    }

    private GregorianCalendar getAttributeValueTimestamp(AttributeLocationAndValue attributeLocationAndValue) {
        if (null == attributeLocationAndValue || null == attributeLocationAndValue.attributeValue_) {
            return null;
        }
        try {
            Timestamp timestamp = Timestamp.valueOf(attributeLocationAndValue.attributeValue_);
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTime(timestamp);
            return gregorianCalendar;
        }
        catch (Exception exception) {
            throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(attributeLocationAndValue.getMessageIndicatingUnexpectedAttributeValue(true, Messages.getText("ERR_VALUE_NOT_VALID_TIMESTAMP", new Object[0])), exception, 11198);
        }
    }

    @Override
    public void endDocument() {
        if (!this.currentElement_.isEmpty()) {
            throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_XML_PARSE_ERROR_ELEMENTS_NOT_CLOSED", this.sqlFile_.inputSQLFilePath_, this.currentElement_), null, 11174);
        }
        this.isXmlParsingComplete_ = true;
    }

    protected void throwExceptionIfParseMethodHasNotCompleted(String string) {
        if (!this.isXmlParsingComplete_) {
            throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_METHOD_CALLED_OUT_OF_ORDER", string, this.getClass().getCanonicalName()) + "  " + Messages.getText("ERR_METHOD_CALLED_OUT_OF_ORDER_XML_PARSING_INCOMPLETE", new Object[0]), null, 11162);
        }
    }

    private boolean isAttributeSetAndNotNull(String string) {
        return StaticProfileConstants.isValueSet(string) && !ATTRIBUTE_NOT_SET_NULL.equals(string);
    }

    private class AttributeLocationAndValue {
        protected final String elementName_;
        final String attributeName_;
        final String attributeValue_;
        protected final int lineNumber_;
        protected final int columnNumber_;

        AttributeLocationAndValue(String string, String string2, String string3, int n2, int n3) {
            this.elementName_ = string;
            this.attributeName_ = string2;
            this.attributeValue_ = string3;
            this.lineNumber_ = n2;
            this.columnNumber_ = n3;
        }

        public String getMessageIndicatingUnexpectedAttributeValue(boolean bl2, String string) {
            StringBuilder stringBuilder = new StringBuilder();
            if (bl2) {
                stringBuilder.append(Messages.getText("ERR_XML_FILE_NOT_VALID", QueryTunerXMLHandler.this.sqlFile_.inputSQLFilePath_, "IBM InfoSphere Optim Query Workload Tuner"));
                stringBuilder.append("  ");
            }
            stringBuilder.append(Messages.getText("ERR_XML_ATTRIBUTE_VALUE_UNEXPECTED", this.elementName_, this.lineNumber_, this.columnNumber_, this.attributeName_, this.attributeValue_));
            if (StaticProfileConstants.isValueSet(string)) {
                stringBuilder.append("  ").append(string);
            }
            return stringBuilder.toString();
        }
    }

    private static enum COLLID_VALUES {
        DSNDYNAMICSQLCACHE,
        DSNEXPLAINMODEYES,
        DSNEXPLAINMODEEXPLAIN;

    }
}

