/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.logger;

import com.amazon.redshift.logger.LogHandler;
import com.amazon.redshift.util.GT;
import com.amazon.redshift.util.RedshiftException;
import com.amazon.redshift.util.RedshiftState;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LogFileHandler
implements LogHandler {
    private static final int FILE_SIZE = 0xA00000;
    private static final int FILE_COUNT = 10;
    private static final String FILE_EXTENSION = ".log";
    private static final String FILE_EXTENSION_SEPERATOR = ".";
    private static final Pattern FILE_SIZE_PATTERN = Pattern.compile("\\s*(\\d+)\\s*(k|g|m|)b?\\s*", 2);
    private static final int BUFFER_SIZE = 8192;
    private File currentFile;
    private String fileName;
    private boolean isRotation = false;
    private String directory;
    private int maxFileSize;
    private int maxFileCount;
    private ArrayList<String> rotationFileNames;
    private PrintWriter writer = null;
    private boolean flushAfterWrite;

    public LogFileHandler(String filename, boolean flushAfterWrite, String maxLogFileSize, String maxLogFileCount) throws Exception {
        int separator = filename.lastIndexOf(File.separator);
        this.directory = filename.substring(0, separator);
        this.fileName = filename.substring(separator + 1);
        this.flushAfterWrite = flushAfterWrite;
        if (-1 != separator) {
            this.createDirectory();
        }
        this.createWriter(maxLogFileSize, maxLogFileCount);
    }

    @Override
    public synchronized void write(String message) throws Exception {
        this.writer.println(message);
        if (this.flushAfterWrite) {
            this.writer.flush();
        }
        if (this.isRotation) {
            this.writer.flush();
            if (0 != this.maxFileSize && this.currentFile.length() >= (long)this.maxFileSize) {
                this.closeFile();
                this.rotateFiles();
                this.openFile();
            }
        }
    }

    @Override
    public synchronized void close() throws Exception {
        if (this.writer != null) {
            this.writer.close();
        }
    }

    @Override
    public synchronized void flush() {
        if (this.writer != null) {
            this.writer.flush();
        }
    }

    private void createDirectory() throws RedshiftException {
        File directory = new File(this.directory);
        if (!directory.exists() && !directory.mkdir()) {
            throw new RedshiftException(GT.tr("Couldn't create log directory {0}", directory), RedshiftState.UNEXPECTED_ERROR);
        }
    }

    private void createWriter(String maxLogFileSize, String maxLogFileCount) throws Exception {
        String fullFilename = this.directory + File.separator + this.fileName;
        if (null != fullFilename && 0 != fullFilename.length()) {
            BufferedOutputStream outStream = new BufferedOutputStream(new FileOutputStream(fullFilename, true), 8192);
            this.writer = new PrintWriter(outStream);
            this.updateLoggingFileSettings(maxLogFileSize, maxLogFileCount);
            return;
        }
        throw new Exception("Failed to create log writer");
    }

    private void updateLoggingFileSettings(String maxLogFileSize, String maxLogFileCount) {
        this.currentFile = new File(this.directory + File.separator + this.fileName);
        this.maxFileCount = this.getMaxFileCount(maxLogFileCount);
        this.maxFileSize = this.getMaxFileSize(maxLogFileSize);
        if (this.maxFileCount > 1) {
            this.isRotation = true;
            String fileExt = FILE_EXTENSION;
            this.rotationFileNames = new ArrayList();
            if (this.fileName.contains(FILE_EXTENSION_SEPERATOR)) {
                fileExt = this.fileName.substring(this.fileName.lastIndexOf(FILE_EXTENSION_SEPERATOR), this.fileName.length());
                this.fileName = this.fileName.substring(0, this.fileName.lastIndexOf(FILE_EXTENSION_SEPERATOR));
            }
            this.rotationFileNames.add(this.directory + File.separator + this.fileName + fileExt);
            for (int i = 1; i < this.maxFileCount; ++i) {
                this.rotationFileNames.add(this.directory + File.separator + this.fileName + FILE_EXTENSION_SEPERATOR + i + fileExt);
            }
        }
    }

    private int getMaxFileSize(String maxLogFileSize) {
        int maxBytes = 0xA00000;
        if (null == maxLogFileSize || maxLogFileSize.isEmpty()) {
            return maxBytes;
        }
        Matcher fileSizematcher = FILE_SIZE_PATTERN.matcher(maxLogFileSize);
        if (fileSizematcher.find()) {
            try {
                maxBytes = Integer.valueOf(fileSizematcher.group(1)) * this.toMultiplier(fileSizematcher.group(2).toLowerCase());
            }
            catch (NumberFormatException e) {
                this.writer.println(e.getMessage());
                this.writer.flush();
            }
        }
        return maxBytes;
    }

    private int getMaxFileCount(String maxLogFileCount) {
        int fileCount;
        int maxfileCount = 10;
        if (null != maxLogFileCount && !maxLogFileCount.isEmpty() && (fileCount = Integer.valueOf(maxLogFileCount).intValue()) > 0) {
            maxfileCount = fileCount;
        }
        return maxfileCount;
    }

    private Integer toMultiplier(String sizeChar) {
        if (sizeChar.equals("g")) {
            return 0x40000000;
        }
        if (sizeChar.equals("m")) {
            return 0x100000;
        }
        if (sizeChar.equals("k")) {
            return 1024;
        }
        throw new NumberFormatException("Invalid file size unit.");
    }

    private boolean isOpen() {
        return this.writer != null;
    }

    private void openFile() throws FileNotFoundException {
        this.currentFile = new File(this.rotationFileNames.get(0));
        BufferedOutputStream outStream = new BufferedOutputStream(new FileOutputStream(this.rotationFileNames.get(0), true), 8192);
        this.writer = new PrintWriter(outStream);
    }

    private void closeFile() {
        if (this.isOpen()) {
            this.currentFile = null;
            if (null != this.writer) {
                this.writer.close();
            }
        }
    }

    private void rotateFiles() throws Exception {
        if (!this.rotationFileNames.isEmpty()) {
            this.deleteOldestFile();
        }
    }

    private void deleteOldestFile() throws IOException {
        String last = this.rotationFileNames.get(this.rotationFileNames.size() - 1);
        File file = new File(last);
        if (file.exists()) {
            file.delete();
        }
        for (int i = this.rotationFileNames.size() - 2; i >= 0; --i) {
            File dest;
            File current = new File(this.rotationFileNames.get(i));
            if (current.exists() && !current.renameTo(dest = new File(last))) {
                throw new IOException("can not rename file: " + current.getName() + " to: " + last);
            }
            last = this.rotationFileNames.get(i);
        }
    }
}

