/*
 * Decompiled with CFR 0.152.
 */
package org.apache.subversion.javahl.remote;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Map;
import java.util.SimpleTimeZone;
import org.apache.subversion.javahl.ISVNEditor;
import org.apache.subversion.javahl.callback.RemoteStatus;
import org.apache.subversion.javahl.types.Checksum;
import org.apache.subversion.javahl.types.NodeKind;

class StatusEditor
implements ISVNEditor {
    protected RemoteStatus receiver = null;
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static final SimpleTimeZone UTC = new SimpleTimeZone(2, "UTC");
    private static final String entryprop_uuid = "svn:entry:uuid";
    private static final String entryprop_author = "svn:entry:last-author";
    private static final String entryprop_revision = "svn:entry:committed-rev";
    private static final String entryprop_timestamp = "svn:entry:committed-date";
    private final GregorianCalendar entry_calendar = new GregorianCalendar(UTC, Locale.ROOT);
    private static final String wcprop_prefix = "svn:wc:";
    private static final String entryprop_prefix = "svn:entry:";

    StatusEditor(RemoteStatus remoteStatus) {
        this.receiver = remoteStatus;
    }

    protected void checkState() {
        if (this.receiver == null) {
            throw new IllegalStateException("Status editor is not active");
        }
    }

    @Override
    public void dispose() {
        if (this.receiver != null) {
            this.abort();
        }
    }

    @Override
    public void addDirectory(String string, Iterable<String> iterable, Map<String, byte[]> map, long l) {
        this.checkState();
        this.receiver.addedDirectory(string);
    }

    @Override
    public void addFile(String string, Checksum checksum, InputStream inputStream, Map<String, byte[]> map, long l) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        this.checkState();
        this.receiver.addedFile(string);
    }

    @Override
    public void addSymlink(String string, String string2, Map<String, byte[]> map, long l) {
        this.checkState();
        this.receiver.addedSymlink(string);
    }

    @Override
    public void addAbsent(String string, NodeKind nodeKind, long l) {
        this.checkState();
    }

    @Override
    public void alterDirectory(String string, long l, Iterable<String> iterable, Map<String, byte[]> map) {
        this.checkState();
        this.receiver.modifiedDirectory(string, iterable != null, StatusEditor.props_changed(map), this.make_entry(map));
    }

    @Override
    public void alterFile(String string, long l, Checksum checksum, InputStream inputStream, Map<String, byte[]> map) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        this.checkState();
        this.receiver.modifiedFile(string, checksum != null && inputStream != null, StatusEditor.props_changed(map), this.make_entry(map));
    }

    @Override
    public void alterSymlink(String string, long l, String string2, Map<String, byte[]> map) {
        this.checkState();
        this.receiver.modifiedSymlink(string, string2 != null, StatusEditor.props_changed(map), this.make_entry(map));
    }

    @Override
    public void delete(String string, long l) {
        this.checkState();
        this.receiver.deleted(string);
    }

    @Override
    public void copy(String string, long l, String string2, long l2) {
        this.checkState();
        throw new RuntimeException("Not implemented: StatusEditor.copy");
    }

    @Override
    public void move(String string, long l, String string2, long l2) {
        this.checkState();
        throw new RuntimeException("Not implemented: StatusEditor.move");
    }

    @Override
    public void complete() {
        this.abort();
    }

    @Override
    public void abort() {
        this.checkState();
        this.receiver = null;
    }

    private final RemoteStatus.Entry make_entry(Map<String, byte[]> map) {
        byte[] byArray = map.get(entryprop_uuid);
        byte[] byArray2 = map.get(entryprop_author);
        byte[] byArray3 = map.get(entryprop_revision);
        byte[] byArray4 = map.get(entryprop_timestamp);
        long l = -1L;
        if (byArray4 != null) {
            String string = new String(byArray4, UTF8);
            int n = Integer.valueOf(string.substring(0, 4), 10);
            int n2 = Integer.valueOf(string.substring(5, 7), 10);
            int n3 = Integer.valueOf(string.substring(8, 10), 10);
            int n4 = Integer.valueOf(string.substring(11, 13), 10);
            int n5 = Integer.valueOf(string.substring(14, 16), 10);
            int n6 = Integer.valueOf(string.substring(17, 19), 10);
            int n7 = Integer.valueOf(string.substring(20, 26), 10);
            this.entry_calendar.set(n, n2, n3, n4, n5, n6);
            l = (1000L * this.entry_calendar.getTimeInMillis() + (long)n7 + 500L) / 1000L;
        }
        return new RemoteStatus.Entry(byArray == null ? null : new String(byArray, UTF8), byArray2 == null ? null : new String(byArray2, UTF8), byArray3 == null ? -1L : Long.valueOf(new String(byArray3, UTF8), 10), l);
    }

    private static final boolean props_changed(Map<String, byte[]> map) {
        if (map != null) {
            for (String string : map.keySet()) {
                if (string.startsWith(wcprop_prefix) || string.startsWith(entryprop_prefix)) continue;
                return true;
            }
        }
        return false;
    }
}

