/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractMultiset;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.common.collect.Serialization;
import com.google.common.primitives.Ints;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
public final class EnumMultiset<E extends Enum<E>>
extends AbstractMultiset<E>
implements Serializable {
    private transient Class<E> type;
    private transient E[] enumConstants;
    private transient int[] counts;
    private transient int distinctElements;
    private transient long size;
    @GwtIncompatible
    private static final long serialVersionUID = 0L;

    public static <E extends Enum<E>> EnumMultiset<E> create(Class<E> type2) {
        return new EnumMultiset<E>(type2);
    }

    public static <E extends Enum<E>> EnumMultiset<E> create(Iterable<E> elements) {
        Iterator<E> iterator = elements.iterator();
        Preconditions.checkArgument(iterator.hasNext(), "EnumMultiset constructor passed empty Iterable");
        EnumMultiset multiset = new EnumMultiset(((Enum)iterator.next()).getDeclaringClass());
        Iterables.addAll(multiset, elements);
        return multiset;
    }

    public static <E extends Enum<E>> EnumMultiset<E> create(Iterable<E> elements, Class<E> type2) {
        EnumMultiset<E> result = EnumMultiset.create(type2);
        Iterables.addAll(result, elements);
        return result;
    }

    private EnumMultiset(Class<E> type2) {
        this.type = type2;
        Preconditions.checkArgument(type2.isEnum());
        this.enumConstants = (Enum[])type2.getEnumConstants();
        this.counts = new int[this.enumConstants.length];
    }

    private boolean isActuallyE(@CheckForNull Object o) {
        if (o instanceof Enum) {
            Enum e2 = (Enum)o;
            int index2 = e2.ordinal();
            return index2 < this.enumConstants.length && this.enumConstants[index2] == e2;
        }
        return false;
    }

    private void checkIsE(Object element2) {
        Preconditions.checkNotNull(element2);
        if (!this.isActuallyE(element2)) {
            String string2 = String.valueOf(this.type);
            String string3 = String.valueOf(element2);
            throw new ClassCastException(new StringBuilder(21 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Expected an ").append(string2).append(" but got ").append(string3).toString());
        }
    }

    @Override
    int distinctElements() {
        return this.distinctElements;
    }

    @Override
    public int size() {
        return Ints.saturatedCast(this.size);
    }

    @Override
    public int count(@CheckForNull Object element2) {
        if (element2 == null || !this.isActuallyE(element2)) {
            return 0;
        }
        Enum e2 = (Enum)element2;
        return this.counts[e2.ordinal()];
    }

    @Override
    @CanIgnoreReturnValue
    public int add(E element2, int occurrences) {
        this.checkIsE(element2);
        CollectPreconditions.checkNonnegative(occurrences, "occurrences");
        if (occurrences == 0) {
            return this.count(element2);
        }
        int index2 = ((Enum)element2).ordinal();
        int oldCount = this.counts[index2];
        long newCount = (long)oldCount + (long)occurrences;
        Preconditions.checkArgument(newCount <= Integer.MAX_VALUE, "too many occurrences: %s", newCount);
        this.counts[index2] = (int)newCount;
        if (oldCount == 0) {
            ++this.distinctElements;
        }
        this.size += (long)occurrences;
        return oldCount;
    }

    @Override
    @CanIgnoreReturnValue
    public int remove(@CheckForNull Object element2, int occurrences) {
        if (element2 == null || !this.isActuallyE(element2)) {
            return 0;
        }
        Enum e2 = (Enum)element2;
        CollectPreconditions.checkNonnegative(occurrences, "occurrences");
        if (occurrences == 0) {
            return this.count(element2);
        }
        int index2 = e2.ordinal();
        int oldCount = this.counts[index2];
        if (oldCount == 0) {
            return 0;
        }
        if (oldCount <= occurrences) {
            this.counts[index2] = 0;
            --this.distinctElements;
            this.size -= (long)oldCount;
        } else {
            this.counts[index2] = oldCount - occurrences;
            this.size -= (long)occurrences;
        }
        return oldCount;
    }

    @Override
    @CanIgnoreReturnValue
    public int setCount(E element2, int count2) {
        this.checkIsE(element2);
        CollectPreconditions.checkNonnegative(count2, "count");
        int index2 = ((Enum)element2).ordinal();
        int oldCount = this.counts[index2];
        this.counts[index2] = count2;
        this.size += (long)(count2 - oldCount);
        if (oldCount == 0 && count2 > 0) {
            ++this.distinctElements;
        } else if (oldCount > 0 && count2 == 0) {
            --this.distinctElements;
        }
        return oldCount;
    }

    @Override
    public void clear() {
        Arrays.fill(this.counts, 0);
        this.size = 0L;
        this.distinctElements = 0;
    }

    @Override
    Iterator<E> elementIterator() {
        return new Itr<E>(){

            @Override
            E output(int index2) {
                return EnumMultiset.this.enumConstants[index2];
            }
        };
    }

    @Override
    Iterator<Multiset.Entry<E>> entryIterator() {
        return new Itr<Multiset.Entry<E>>(){

            @Override
            Multiset.Entry<E> output(final int index2) {
                return new Multisets.AbstractEntry<E>(){

                    @Override
                    public E getElement() {
                        return EnumMultiset.this.enumConstants[index2];
                    }

                    @Override
                    public int getCount() {
                        return EnumMultiset.this.counts[index2];
                    }
                };
            }
        };
    }

    @Override
    public Iterator<E> iterator() {
        return Multisets.iteratorImpl(this);
    }

    @GwtIncompatible
    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeObject(this.type);
        Serialization.writeMultiset(this, stream);
    }

    @GwtIncompatible
    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        Class localType;
        stream.defaultReadObject();
        this.type = localType = (Class)stream.readObject();
        this.enumConstants = (Enum[])this.type.getEnumConstants();
        this.counts = new int[this.enumConstants.length];
        Serialization.populateMultiset(this, stream);
    }

    abstract class Itr<T>
    implements Iterator<T> {
        int index = 0;
        int toRemove = -1;

        Itr() {
        }

        abstract T output(int var1);

        @Override
        public boolean hasNext() {
            while (this.index < EnumMultiset.this.enumConstants.length) {
                if (EnumMultiset.this.counts[this.index] > 0) {
                    return true;
                }
                ++this.index;
            }
            return false;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            T result = this.output(this.index);
            this.toRemove = this.index++;
            return result;
        }

        @Override
        public void remove() {
            CollectPreconditions.checkRemove(this.toRemove >= 0);
            if (EnumMultiset.this.counts[this.toRemove] > 0) {
                EnumMultiset.this.distinctElements--;
                EnumMultiset.this.size -= EnumMultiset.this.counts[this.toRemove];
                ((EnumMultiset)EnumMultiset.this).counts[this.toRemove] = 0;
            }
            this.toRemove = -1;
        }
    }
}

