/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.impl;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.gephi.graph.api.AttributeUtils;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Element;
import org.gephi.graph.api.Estimator;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphLock;
import org.gephi.graph.api.Node;
import org.gephi.graph.impl.ColumnImpl;
import org.gephi.graph.impl.ColumnIndexImpl;
import org.gephi.graph.impl.ElementImpl;

public class ColumnNoIndexImpl<K, T extends Element>
implements ColumnIndexImpl<K, T> {
    protected final ColumnImpl column;
    protected final Class<T> elementClass;
    protected final Graph graph;
    protected final GraphLock graphLock;
    protected final AtomicInteger version = new AtomicInteger(Integer.MIN_VALUE);

    protected ColumnNoIndexImpl(ColumnImpl column, Graph graph, Class<T> elementClass) {
        this.column = column;
        this.elementClass = elementClass;
        this.graph = graph;
        this.graphLock = graph.getLock();
    }

    private Iterator<T> getElementIterator() {
        if (this.elementClass.equals(Node.class)) {
            return this.graph.getNodes().iterator();
        }
        if (this.elementClass.equals(Edge.class)) {
            return this.graph.getEdges().iterator();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int count(K value) {
        this.lock();
        try {
            Iterator<T> elementIterator = this.getElementIterator();
            int count = 0;
            if (elementIterator != null) {
                while (elementIterator.hasNext()) {
                    ElementImpl element = (ElementImpl)elementIterator.next();
                    Object obj = element.getAttribute((Column)this.column, this.graph.getView());
                    if (value == null && obj == null) {
                        ++count;
                        continue;
                    }
                    if (value == null || !value.equals(obj)) continue;
                    ++count;
                }
            }
            int n = count;
            return n;
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public Iterable<T> get(K value) {
        return new ElementWithValueIterable(this.getElementIterator(), value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<K> values() {
        this.lock();
        try {
            Iterator<T> elementIterator = this.getElementIterator();
            ObjectOpenHashSet set = new ObjectOpenHashSet();
            if (elementIterator != null) {
                while (elementIterator.hasNext()) {
                    ElementImpl element = (ElementImpl)elementIterator.next();
                    Object obj = element.getAttribute((Column)this.column, this.graph.getView());
                    set.add(obj);
                }
            }
            ObjectOpenHashSet objectOpenHashSet = set;
            return objectOpenHashSet;
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public int countValues() {
        return this.values().size();
    }

    @Override
    public int countElements() {
        if (this.elementClass.equals(Node.class)) {
            return this.graph.getNodeCount();
        }
        if (this.elementClass.equals(Edge.class)) {
            return this.graph.getEdgeCount();
        }
        return 0;
    }

    @Override
    public boolean isSortable() {
        return AttributeUtils.isNumberType(this.column.getTypeClass()) && !AttributeUtils.isArrayType(this.column.getTypeClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Number getMinValue() {
        if (!this.isSortable()) {
            throw new UnsupportedOperationException("Only supported for sortable columns");
        }
        this.lock();
        try {
            Number min = null;
            Iterator<T> elementIterator = this.getElementIterator();
            if (elementIterator != null) {
                double minN = Double.POSITIVE_INFINITY;
                while (elementIterator.hasNext()) {
                    ElementImpl element = (ElementImpl)elementIterator.next();
                    Number num = (Number)element.getAttribute(this.column, this.graph.getView(), Estimator.MIN);
                    if (min != null && (num == null || !(num.doubleValue() < minN))) continue;
                    if (num != null) {
                        minN = num.doubleValue();
                    }
                    min = num;
                }
            }
            Number number = min;
            return number;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Number getMaxValue() {
        if (!this.isSortable()) {
            throw new UnsupportedOperationException("Only supported for sortable columns");
        }
        this.lock();
        try {
            Number max = null;
            Iterator<T> elementIterator = this.getElementIterator();
            if (elementIterator != null) {
                double maxN = Double.NEGATIVE_INFINITY;
                while (elementIterator.hasNext()) {
                    ElementImpl element = (ElementImpl)elementIterator.next();
                    Number num = (Number)element.getAttribute(this.column, this.graph.getView(), Estimator.MAX);
                    if (max != null && (num == null || !(num.doubleValue() > maxN))) continue;
                    if (num != null) {
                        maxN = num.doubleValue();
                    }
                    max = num;
                }
            }
            Number number = max;
            return number;
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public Column getColumn() {
        return this.column;
    }

    @Override
    public int getVersion() {
        return this.version.get();
    }

    @Override
    public Iterator<Map.Entry<K, ? extends Set<T>>> iterator() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public void clear() {
        this.version.incrementAndGet();
    }

    @Override
    public void destroy() {
        this.version.incrementAndGet();
    }

    @Override
    public K putValue(T element, K value) {
        this.version.incrementAndGet();
        return value;
    }

    @Override
    public K replaceValue(T element, K oldValue, K newValue) {
        this.version.incrementAndGet();
        return newValue;
    }

    @Override
    public void removeValue(T element, K value) {
        this.version.incrementAndGet();
    }

    private void lock() {
        if (this.graphLock != null) {
            this.graphLock.readLock();
        }
    }

    private void unlock() {
        if (this.graphLock != null) {
            this.graphLock.readUnlock();
        }
    }

    private class ElementWithValueIterator
    implements Iterator<T> {
        private final Iterator<T> itr;
        private final K value;
        private T pointer;

        public ElementWithValueIterator(Iterator<T> itr, K value) {
            this.itr = itr;
            this.value = value;
            ColumnNoIndexImpl.this.lock();
        }

        @Override
        public boolean hasNext() {
            while (this.pointer == null && this.itr.hasNext()) {
                Element element = (Element)this.itr.next();
                Object val = element.getAttribute((Column)ColumnNoIndexImpl.this.column, ColumnNoIndexImpl.this.graph.getView());
                if ((this.value != null || val != null) && (val == null || !val.equals(this.value))) continue;
                this.pointer = element;
            }
            if (this.pointer != null) {
                return true;
            }
            ColumnNoIndexImpl.this.unlock();
            return false;
        }

        @Override
        public T next() {
            Object res = this.pointer;
            this.pointer = null;
            return res;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported.");
        }
    }

    private class ElementWithValueIterable
    implements Iterable<T> {
        private final Iterator<T> ite;
        private final K value;

        public ElementWithValueIterable(Iterator<T> ite, K value) {
            this.ite = ite;
            this.value = value;
        }

        @Override
        public Iterator<T> iterator() {
            return new ElementWithValueIterator(this.ite, this.value);
        }
    }
}

