/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.io.exporter.plugin;

import java.io.Writer;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.gephi.graph.api.AttributeUtils;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.EdgeIterable;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.NodeIterable;
import org.gephi.io.exporter.api.FileType;
import org.gephi.io.exporter.plugin.NormalizationHelper;
import org.gephi.io.exporter.spi.CharacterExporter;
import org.gephi.io.exporter.spi.GraphExporter;
import org.gephi.project.api.Workspace;
import org.gephi.utils.longtask.spi.LongTask;
import org.gephi.utils.progress.Progress;
import org.gephi.utils.progress.ProgressTicket;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class ExporterGDF
implements GraphExporter,
CharacterExporter,
LongTask {
    private Workspace workspace;
    private boolean exportVisible;
    private boolean cancel = false;
    private ProgressTicket progressTicket;
    private boolean normalize = false;
    private boolean simpleQuotes = false;
    private boolean useQuotes = true;
    private boolean exportColors = true;
    private boolean exportPosition = true;
    private boolean exportAttributes = true;
    private final boolean exportDynamicWeight = true;
    private boolean exportVisibility = false;
    private NormalizationHelper normalization;
    private boolean edgeLabels;
    private boolean edgeColors;
    private NodeColumnsGDF[] defaultNodeColumnsGDFs;
    private EdgeColumnsGDF[] defaultEdgeColumnsGDFs;
    private Writer writer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute() {
        GraphController graphController = (GraphController)Lookup.getDefault().lookup(GraphController.class);
        GraphModel graphModel = graphController.getGraphModel(this.workspace);
        Graph graph = this.exportVisible ? graphModel.getGraphVisible() : graphModel.getGraph();
        graph.readLock();
        try {
            this.exportData(graph, graphModel);
        }
        catch (Exception e) {
            Logger.getLogger(ExporterGDF.class.getName()).log(Level.SEVERE, null, e);
        }
        finally {
            graph.readUnlock();
            Progress.finish((ProgressTicket)this.progressTicket);
        }
        return !this.cancel;
    }

    private void exportData(Graph graph, GraphModel graphModel) throws Exception {
        Progress.start((ProgressTicket)this.progressTicket);
        this.defaultNodeColumns(graph);
        this.defaultEdgeColumns(graph);
        Column[] nodeColumns = this.attributesNodeColumns(graphModel);
        Column[] edgeColumns = this.attributesEdgeColumns(graphModel);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("nodedef> name VARCHAR,");
        for (NodeColumnsGDF nodeColumnsGDF : this.defaultNodeColumnsGDFs) {
            if (!nodeColumnsGDF.isEnable()) continue;
            stringBuilder.append(nodeColumnsGDF.getTitle());
            stringBuilder.append(" ");
            stringBuilder.append(nodeColumnsGDF.getType().toString().toUpperCase());
            if (nodeColumnsGDF.getDefaultValue() != null) {
                stringBuilder.append(" default ");
                stringBuilder.append(nodeColumnsGDF.getDefaultValue().toString());
            }
            stringBuilder.append(",");
        }
        for (NodeColumnsGDF nodeColumnsGDF : nodeColumns) {
            if (nodeColumnsGDF.isProperty()) continue;
            stringBuilder.append(nodeColumnsGDF.getTitle());
            stringBuilder.append(" ");
            NodeColumnsGDF[] dataTypeGDF = this.getDataTypeGDF(nodeColumnsGDF.getTypeClass());
            stringBuilder.append(dataTypeGDF.toString().toUpperCase());
            if (nodeColumnsGDF.getDefaultValue() != null) {
                stringBuilder.append(" default ");
                stringBuilder.append(nodeColumnsGDF.getDefaultValue().toString());
            }
            stringBuilder.append(",");
        }
        stringBuilder.setLength(stringBuilder.length() - 1);
        stringBuilder.append("\n");
        this.normalization = NormalizationHelper.build(this.normalize, graph);
        int max = graph.getNodeCount() + graph.getEdgeCount();
        Progress.switchToDeterminate((ProgressTicket)this.progressTicket, (int)max);
        NodeIterable itr = graph.getNodes();
        for (Node node : itr) {
            if (this.cancel) {
                itr.doBreak();
                return;
            }
            stringBuilder.append(node.getId());
            stringBuilder.append(",");
            for (NodeColumnsGDF nodeColumnsGDF : this.defaultNodeColumnsGDFs) {
                if (!nodeColumnsGDF.isEnable()) continue;
                nodeColumnsGDF.writeData(stringBuilder, node);
                stringBuilder.append(",");
            }
            for (NodeColumnsGDF nodeColumnsGDF : nodeColumns) {
                if (nodeColumnsGDF.isProperty()) continue;
                Object object = node.getAttribute((Column)nodeColumnsGDF, graph.getView());
                if (object != null) {
                    if (nodeColumnsGDF.getTypeClass().equals(String.class) || nodeColumnsGDF.getTypeClass().equals(String[].class)) {
                        String quote = !this.useQuotes ? "" : (this.simpleQuotes ? "'" : "\"");
                        stringBuilder.append(quote);
                        stringBuilder.append(object);
                        stringBuilder.append(quote);
                    } else {
                        stringBuilder.append(object);
                    }
                }
                stringBuilder.append(",");
            }
            stringBuilder.setLength(stringBuilder.length() - 1);
            stringBuilder.append("\n");
            Progress.progress((ProgressTicket)this.progressTicket);
        }
        stringBuilder.append("edgedef> node1,node2,");
        for (Edge edge : graph.getEdges()) {
            this.edgeColors = this.edgeColors || edge.alpha() != 0.0f;
            this.edgeLabels = this.edgeLabels || edge.getLabel() != null && !edge.getLabel().isEmpty();
        }
        for (EdgeColumnsGDF edgeColumnsGDF : this.defaultEdgeColumnsGDFs) {
            if (!edgeColumnsGDF.isEnable()) continue;
            stringBuilder.append(edgeColumnsGDF.getTitle());
            stringBuilder.append(" ");
            stringBuilder.append(edgeColumnsGDF.getType().toString().toUpperCase());
            if (edgeColumnsGDF.getDefaultValue() != null) {
                stringBuilder.append(" default ");
                stringBuilder.append(edgeColumnsGDF.getDefaultValue().toString());
            }
            stringBuilder.append(",");
        }
        for (EdgeColumnsGDF edgeColumnsGDF : edgeColumns) {
            if (edgeColumnsGDF.isProperty()) continue;
            stringBuilder.append(edgeColumnsGDF.getTitle());
            stringBuilder.append(" ");
            DataTypeGDF dataTypeGDF = this.getDataTypeGDF(edgeColumnsGDF.getTypeClass());
            stringBuilder.append(dataTypeGDF.toString().toUpperCase());
            if (edgeColumnsGDF.getDefaultValue() != null) {
                stringBuilder.append(" default ");
                stringBuilder.append(edgeColumnsGDF.getDefaultValue().toString());
            }
            stringBuilder.append(",");
        }
        stringBuilder.setLength(stringBuilder.length() - 1);
        stringBuilder.append("\n");
        EdgeIterable itrEdges = graph.getEdges();
        for (Edge edge : itrEdges) {
            if (this.cancel) {
                itrEdges.doBreak();
                return;
            }
            stringBuilder.append(edge.getSource().getId());
            stringBuilder.append(",");
            stringBuilder.append(edge.getTarget().getId());
            stringBuilder.append(",");
            for (EdgeColumnsGDF edgeColumnsGDF : this.defaultEdgeColumnsGDFs) {
                if (!edgeColumnsGDF.isEnable()) continue;
                edgeColumnsGDF.writeData(stringBuilder, edge);
                stringBuilder.append(",");
            }
            for (Column column : edgeColumns) {
                if (column.isProperty()) continue;
                Object val = edge.getAttribute(column, graph.getView());
                if (val != null) {
                    if (column.getTypeClass().equals(String.class) || column.getTypeClass().equals(String[].class)) {
                        String quote = !this.useQuotes ? "" : (this.simpleQuotes ? "'" : "\"");
                        stringBuilder.append(quote);
                        stringBuilder.append(val);
                        stringBuilder.append(quote);
                    } else {
                        stringBuilder.append(val);
                    }
                }
                stringBuilder.append(",");
            }
            stringBuilder.setLength(stringBuilder.length() - 1);
            stringBuilder.append("\n");
            Progress.progress((ProgressTicket)this.progressTicket);
        }
        if (!this.cancel) {
            this.writer.append(stringBuilder);
        }
        Progress.finish((ProgressTicket)this.progressTicket);
    }

    private Column[] attributesNodeColumns(GraphModel graphModel) {
        ArrayList<Column> cols = new ArrayList<Column>();
        if (this.exportAttributes && graphModel != null) {
            for (Column column : graphModel.getNodeTable()) {
                if (column.isProperty() || this.isNodeDefaultColumn(column.getId())) continue;
                cols.add(column);
            }
        }
        return cols.toArray(new Column[0]);
    }

    private Column[] attributesEdgeColumns(GraphModel graphModel) {
        ArrayList<Column> cols = new ArrayList<Column>();
        if (this.exportAttributes && graphModel != null) {
            for (Column column : graphModel.getEdgeTable()) {
                if (column.isProperty() || this.isEdgeDefaultColumn(column.getId())) continue;
                cols.add(column);
            }
        }
        return cols.toArray(new Column[0]);
    }

    private boolean isNodeDefaultColumn(String id) {
        for (NodeColumnsGDF c : this.defaultNodeColumnsGDFs) {
            if (!c.title.equalsIgnoreCase(id)) continue;
            return true;
        }
        return false;
    }

    private boolean isEdgeDefaultColumn(String id) {
        for (EdgeColumnsGDF c : this.defaultEdgeColumnsGDFs) {
            if (!c.title.equalsIgnoreCase(id)) continue;
            return true;
        }
        return false;
    }

    private void defaultNodeColumns(Graph graph) {
        NodeColumnsGDF labelColumn = new NodeColumnsGDF("label"){

            @Override
            public boolean isEnable() {
                return true;
            }

            @Override
            public void writeData(StringBuilder builder, Node node) {
                String label = node.getLabel();
                if (label != null) {
                    String quote = !ExporterGDF.this.useQuotes ? "" : (ExporterGDF.this.simpleQuotes ? "'" : "\"");
                    builder.append(quote);
                    builder.append(label);
                    builder.append(quote);
                }
            }
        };
        NodeColumnsGDF visibleColumn = new NodeColumnsGDF("visible", DataTypeGDF.BOOLEAN){

            @Override
            public boolean isEnable() {
                return ExporterGDF.this.exportVisibility;
            }

            @Override
            public void writeData(StringBuilder builder, Node node) {
                builder.append(true);
            }
        };
        NodeColumnsGDF labelVisibleColumn = new NodeColumnsGDF("labelvisible", DataTypeGDF.BOOLEAN){

            @Override
            public boolean isEnable() {
                return ExporterGDF.this.exportVisibility;
            }

            @Override
            public void writeData(StringBuilder builder, Node node) {
                builder.append(node.getTextProperties().isVisible());
            }
        };
        NodeColumnsGDF widthColumn = new NodeColumnsGDF("width", DataTypeGDF.DOUBLE){

            @Override
            public boolean isEnable() {
                return ExporterGDF.this.exportPosition;
            }

            @Override
            public void writeData(StringBuilder builder, Node node) {
                float size = ExporterGDF.this.normalization.normalizeSize(node.size());
                builder.append(size);
            }
        };
        NodeColumnsGDF heightColumn = new NodeColumnsGDF("height", DataTypeGDF.DOUBLE){

            @Override
            public boolean isEnable() {
                return ExporterGDF.this.exportPosition;
            }

            @Override
            public void writeData(StringBuilder builder, Node node) {
                float size = ExporterGDF.this.normalization.normalizeSize(node.size());
                builder.append(size);
            }
        };
        NodeColumnsGDF xColumn = new NodeColumnsGDF("x", DataTypeGDF.DOUBLE){

            @Override
            public boolean isEnable() {
                return ExporterGDF.this.exportPosition;
            }

            @Override
            public void writeData(StringBuilder builder, Node node) {
                float x = ExporterGDF.this.normalization.normalizeX(node.x());
                builder.append(x);
            }
        };
        NodeColumnsGDF yColumn = new NodeColumnsGDF("y", DataTypeGDF.DOUBLE){

            @Override
            public boolean isEnable() {
                return ExporterGDF.this.exportPosition;
            }

            @Override
            public void writeData(StringBuilder builder, Node node) {
                float y = ExporterGDF.this.normalization.normalizeY(node.y());
                builder.append(y);
            }
        };
        NodeColumnsGDF colorColumn = new NodeColumnsGDF("color"){

            @Override
            public boolean isEnable() {
                return ExporterGDF.this.exportColors;
            }

            @Override
            public void writeData(StringBuilder builder, Node node) {
                String quote = "'";
                builder.append(quote);
                builder.append((int)(node.r() * 255.0f));
                builder.append(",");
                builder.append((int)(node.g() * 255.0f));
                builder.append(",");
                builder.append((int)(node.b() * 255.0f));
                builder.append(quote);
            }
        };
        NodeColumnsGDF fixedColumn = new NodeColumnsGDF("fixed", DataTypeGDF.BOOLEAN){

            @Override
            public boolean isEnable() {
                return ExporterGDF.this.exportVisibility;
            }

            @Override
            public void writeData(StringBuilder builder, Node node) {
                builder.append(node.isFixed());
            }
        };
        NodeColumnsGDF styleColumn = new NodeColumnsGDF("style", DataTypeGDF.INT){

            @Override
            public boolean isEnable() {
                return false;
            }

            @Override
            public void writeData(StringBuilder builder, Node node) {
            }
        };
        this.defaultNodeColumnsGDFs = new NodeColumnsGDF[10];
        this.defaultNodeColumnsGDFs[0] = labelColumn;
        this.defaultNodeColumnsGDFs[1] = visibleColumn;
        this.defaultNodeColumnsGDFs[2] = labelVisibleColumn;
        this.defaultNodeColumnsGDFs[3] = widthColumn;
        this.defaultNodeColumnsGDFs[4] = heightColumn;
        this.defaultNodeColumnsGDFs[5] = xColumn;
        this.defaultNodeColumnsGDFs[6] = yColumn;
        this.defaultNodeColumnsGDFs[7] = colorColumn;
        this.defaultNodeColumnsGDFs[8] = fixedColumn;
        this.defaultNodeColumnsGDFs[9] = styleColumn;
    }

    private void defaultEdgeColumns(final Graph graph) {
        EdgeColumnsGDF labelColumn = new EdgeColumnsGDF("label"){

            @Override
            public boolean isEnable() {
                return ExporterGDF.this.edgeLabels;
            }

            @Override
            public void writeData(StringBuilder builder, Edge edge) {
                String label = edge.getLabel();
                if (label != null) {
                    String quote = !ExporterGDF.this.useQuotes ? "" : (ExporterGDF.this.simpleQuotes ? "'" : "\"");
                    builder.append(quote);
                    builder.append(label);
                    builder.append(quote);
                }
            }
        };
        EdgeColumnsGDF weightColumn = new EdgeColumnsGDF("weight", DataTypeGDF.DOUBLE){

            @Override
            public boolean isEnable() {
                return true;
            }

            @Override
            public void writeData(StringBuilder builder, Edge edge) {
                double weight = edge.getWeight(graph.getView());
                builder.append(weight);
            }
        };
        EdgeColumnsGDF directedColumn = new EdgeColumnsGDF("directed", DataTypeGDF.BOOLEAN){

            @Override
            public boolean isEnable() {
                return true;
            }

            @Override
            public void writeData(StringBuilder builder, Edge edge) {
                builder.append(graph.isDirected(edge));
            }
        };
        EdgeColumnsGDF colorColumn = new EdgeColumnsGDF("color"){

            @Override
            public boolean isEnable() {
                return ExporterGDF.this.exportColors && ExporterGDF.this.edgeColors;
            }

            @Override
            public void writeData(StringBuilder builder, Edge edge) {
                if (edge.alpha() != 0.0f) {
                    String quote = "'";
                    builder.append(quote);
                    builder.append((int)(edge.r() * 255.0f));
                    builder.append(",");
                    builder.append((int)(edge.g() * 255.0f));
                    builder.append(",");
                    builder.append((int)(edge.b() * 255.0f));
                    builder.append(quote);
                }
            }
        };
        EdgeColumnsGDF visibleColumn = new EdgeColumnsGDF("visible", DataTypeGDF.BOOLEAN){

            @Override
            public boolean isEnable() {
                return ExporterGDF.this.exportVisibility;
            }

            @Override
            public void writeData(StringBuilder builder, Edge edge) {
                builder.append(true);
            }
        };
        EdgeColumnsGDF labelVisibleColumn = new EdgeColumnsGDF("labelvisible", DataTypeGDF.BOOLEAN){

            @Override
            public boolean isEnable() {
                return ExporterGDF.this.exportVisibility;
            }

            @Override
            public void writeData(StringBuilder builder, Edge edge) {
                builder.append(edge.getTextProperties().isVisible());
            }
        };
        EdgeColumnsGDF edgeIdColumn = new EdgeColumnsGDF("id", DataTypeGDF.VARCHAR){

            @Override
            public boolean isEnable() {
                return false;
            }

            @Override
            public void writeData(StringBuilder builder, Edge edge) {
            }
        };
        this.defaultEdgeColumnsGDFs = new EdgeColumnsGDF[7];
        this.defaultEdgeColumnsGDFs[0] = edgeIdColumn;
        this.defaultEdgeColumnsGDFs[1] = labelColumn;
        this.defaultEdgeColumnsGDFs[2] = weightColumn;
        this.defaultEdgeColumnsGDFs[3] = directedColumn;
        this.defaultEdgeColumnsGDFs[4] = colorColumn;
        this.defaultEdgeColumnsGDFs[5] = visibleColumn;
        this.defaultEdgeColumnsGDFs[6] = labelVisibleColumn;
    }

    public boolean cancel() {
        this.cancel = true;
        return true;
    }

    public void setProgressTicket(ProgressTicket progressTicket) {
        this.progressTicket = progressTicket;
    }

    public String getName() {
        return NbBundle.getMessage(this.getClass(), (String)"ExporterGDF_name");
    }

    public FileType[] getFileTypes() {
        FileType ft = new FileType(".gdf", NbBundle.getMessage(this.getClass(), (String)"fileType_GDF_Name"));
        return new FileType[]{ft};
    }

    public boolean isExportAttributes() {
        return this.exportAttributes;
    }

    public void setExportAttributes(boolean exportAttributes) {
        this.exportAttributes = exportAttributes;
    }

    public boolean isExportColors() {
        return this.exportColors;
    }

    public void setExportColors(boolean exportColors) {
        this.exportColors = exportColors;
    }

    public boolean isExportPosition() {
        return this.exportPosition;
    }

    public void setExportPosition(boolean exportPosition) {
        this.exportPosition = exportPosition;
    }

    public boolean isNormalize() {
        return this.normalize;
    }

    public void setNormalize(boolean normalize) {
        this.normalize = normalize;
    }

    public boolean isSimpleQuotes() {
        return this.simpleQuotes;
    }

    public void setSimpleQuotes(boolean simpleQuotes) {
        this.simpleQuotes = simpleQuotes;
    }

    public boolean isUseQuotes() {
        return this.useQuotes;
    }

    public void setUseQuotes(boolean useQuotes) {
        this.useQuotes = useQuotes;
    }

    public boolean isExportVisibility() {
        return this.exportVisibility;
    }

    public void setExportVisibility(boolean exportVisibility) {
        this.exportVisibility = exportVisibility;
    }

    private DataTypeGDF getDataTypeGDF(Class type) {
        if (AttributeUtils.isDynamicType((Class)type)) {
            type = AttributeUtils.getStaticType((Class)type);
        }
        if (type.equals(Boolean.class)) {
            return DataTypeGDF.BOOLEAN;
        }
        if (type.equals(Double.class)) {
            return DataTypeGDF.DOUBLE;
        }
        if (type.equals(Float.class)) {
            return DataTypeGDF.FLOAT;
        }
        if (type.equals(Integer.class)) {
            return DataTypeGDF.INTEGER;
        }
        if (type.equals(Long.class)) {
            return DataTypeGDF.INTEGER;
        }
        if (type.equals(Short.class)) {
            return DataTypeGDF.INTEGER;
        }
        if (type.equals(Byte.class)) {
            return DataTypeGDF.TINYINT;
        }
        if (type.equals(String.class)) {
            return DataTypeGDF.VARCHAR;
        }
        return DataTypeGDF.VARCHAR;
    }

    public boolean isExportVisible() {
        return this.exportVisible;
    }

    public void setExportVisible(boolean exportVisible) {
        this.exportVisible = exportVisible;
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    private abstract class EdgeColumnsGDF {
        protected final String title;
        protected final DataTypeGDF type;
        protected final Object defaultValue;

        public EdgeColumnsGDF(String title) {
            this(title, DataTypeGDF.VARCHAR);
        }

        public EdgeColumnsGDF(String title, DataTypeGDF type) {
            this(title, type, null);
        }

        public EdgeColumnsGDF(String title, DataTypeGDF type, Object defaultValue) {
            this.title = title;
            this.type = type;
            this.defaultValue = defaultValue;
        }

        public abstract boolean isEnable();

        public abstract void writeData(StringBuilder var1, Edge var2);

        public String getTitle() {
            return this.title;
        }

        public DataTypeGDF getType() {
            return this.type;
        }

        public Object getDefaultValue() {
            return this.defaultValue;
        }
    }

    private abstract class NodeColumnsGDF {
        protected final String title;
        protected final DataTypeGDF type;
        protected final Object defaultValue;

        public NodeColumnsGDF(String title) {
            this(title, DataTypeGDF.VARCHAR);
        }

        public NodeColumnsGDF(String title, DataTypeGDF type) {
            this(title, type, null);
        }

        public NodeColumnsGDF(String title, DataTypeGDF type, Object defaultValue) {
            this.title = title;
            this.type = type;
            this.defaultValue = defaultValue;
        }

        public abstract boolean isEnable();

        public abstract void writeData(StringBuilder var1, Node var2);

        public String getTitle() {
            return this.title;
        }

        public DataTypeGDF getType() {
            return this.type;
        }

        public Object getDefaultValue() {
            return this.defaultValue;
        }
    }

    private static enum DataTypeGDF {
        VARCHAR,
        BOOL,
        BOOLEAN,
        INTEGER,
        TINYINT,
        INT,
        DOUBLE,
        FLOAT;

    }
}

