/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.project;

import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.gephi.project.api.Project;
import org.gephi.project.api.ProjectController;
import org.gephi.project.api.ProjectInformation;
import org.gephi.project.api.ProjectMetaData;
import org.netbeans.validation.api.Validator;
import org.netbeans.validation.api.builtin.stringvalidation.StringValidators;
import org.netbeans.validation.api.ui.ValidationGroup;
import org.netbeans.validation.api.ui.swing.ValidationPanel;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class ProjectPropertiesEditor
extends JPanel {
    private JTextField authorTextField;
    private JPanel descriptionPanel;
    private JScrollPane descriptionScrollPane;
    private JTextArea descriptionTextArea;
    private JLabel fileLabel;
    private JTextField keywordsTextField;
    private JLabel labelAuthor;
    private JLabel labelDescription;
    private JLabel labelFile;
    private JLabel labelKeywords;
    private JLabel labelName;
    private JLabel labelTitle;
    private JTextField nameTextField;
    private JTextField titleTextField;

    public ProjectPropertiesEditor() {
        this.initComponents();
    }

    public static ValidationPanel createValidationPanel(ProjectPropertiesEditor innerPanel) {
        ValidationPanel validationPanel = new ValidationPanel();
        validationPanel.setInnerComponent((Component)innerPanel);
        ValidationGroup group = validationPanel.getValidationGroup();
        innerPanel.nameTextField.setName(innerPanel.labelName.getText().replace(":", ""));
        group.add((Object)innerPanel.nameTextField, (Validator)StringValidators.REQUIRE_NON_EMPTY_STRING);
        return validationPanel;
    }

    public void load(Project project) {
        ProjectMetaData metaData;
        ProjectInformation info = (ProjectInformation)project.getLookup().lookup(ProjectInformation.class);
        if (info != null) {
            this.nameTextField.setText(info.getName());
            if (info.getFile() != null) {
                this.fileLabel.setText(info.getFile().getName());
            }
        }
        if ((metaData = (ProjectMetaData)project.getLookup().lookup(ProjectMetaData.class)) != null) {
            this.titleTextField.setText(metaData.getTitle());
            this.authorTextField.setText(metaData.getAuthor());
            this.keywordsTextField.setText(metaData.getKeywords());
            this.descriptionTextArea.setText(metaData.getDescription());
        }
    }

    public void save(Project project) {
        ProjectMetaData metaData;
        ProjectInformation info = (ProjectInformation)project.getLookup().lookup(ProjectInformation.class);
        if (info != null && !this.nameTextField.getText().isEmpty() && !this.nameTextField.getText().equals(info.getName())) {
            ProjectController pc = (ProjectController)Lookup.getDefault().lookup(ProjectController.class);
            pc.renameProject(project, this.nameTextField.getText());
        }
        if ((metaData = (ProjectMetaData)project.getLookup().lookup(ProjectMetaData.class)) != null) {
            metaData.setTitle(this.titleTextField.getText());
            metaData.setAuthor(this.authorTextField.getText());
            metaData.setKeywords(this.keywordsTextField.getText());
            metaData.setDescription(this.descriptionTextArea.getText());
        }
    }

    private void initComponents() {
        this.descriptionPanel = new JPanel();
        this.descriptionScrollPane = new JScrollPane();
        this.descriptionTextArea = new JTextArea();
        this.labelDescription = new JLabel();
        this.labelKeywords = new JLabel();
        this.keywordsTextField = new JTextField();
        this.authorTextField = new JTextField();
        this.labelAuthor = new JLabel();
        this.labelName = new JLabel();
        this.nameTextField = new JTextField();
        this.fileLabel = new JLabel();
        this.labelFile = new JLabel();
        this.labelTitle = new JLabel();
        this.titleTextField = new JTextField();
        this.descriptionPanel.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(ProjectPropertiesEditor.class, (String)"ProjectPropertiesEditor.descriptionPanel.border.title")));
        this.descriptionTextArea.setColumns(20);
        this.descriptionTextArea.setRows(3);
        this.descriptionScrollPane.setViewportView(this.descriptionTextArea);
        this.labelDescription.setText(NbBundle.getMessage(ProjectPropertiesEditor.class, (String)"ProjectPropertiesEditor.labelDescription.text"));
        this.labelKeywords.setText(NbBundle.getMessage(ProjectPropertiesEditor.class, (String)"ProjectPropertiesEditor.labelKeywords.text"));
        this.keywordsTextField.setText(NbBundle.getMessage(ProjectPropertiesEditor.class, (String)"ProjectPropertiesEditor.keywordsTextField.text"));
        this.authorTextField.setText(NbBundle.getMessage(ProjectPropertiesEditor.class, (String)"ProjectPropertiesEditor.authorTextField.text"));
        this.labelAuthor.setText(NbBundle.getMessage(ProjectPropertiesEditor.class, (String)"ProjectPropertiesEditor.labelAuthor.text"));
        this.labelName.setText(NbBundle.getMessage(ProjectPropertiesEditor.class, (String)"ProjectPropertiesEditor.labelName.text"));
        this.nameTextField.setText(NbBundle.getMessage(ProjectPropertiesEditor.class, (String)"ProjectPropertiesEditor.nameTextField.text"));
        this.fileLabel.setText(NbBundle.getMessage(ProjectPropertiesEditor.class, (String)"ProjectPropertiesEditor.fileLabel.text"));
        this.labelFile.setText(NbBundle.getMessage(ProjectPropertiesEditor.class, (String)"ProjectPropertiesEditor.labelFile.text"));
        this.labelTitle.setText(NbBundle.getMessage(ProjectPropertiesEditor.class, (String)"ProjectPropertiesEditor.labelTitle.text"));
        this.titleTextField.setText(NbBundle.getMessage(ProjectPropertiesEditor.class, (String)"ProjectPropertiesEditor.titleTextField.text"));
        GroupLayout descriptionPanelLayout = new GroupLayout(this.descriptionPanel);
        this.descriptionPanel.setLayout(descriptionPanelLayout);
        descriptionPanelLayout.setHorizontalGroup(descriptionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(descriptionPanelLayout.createSequentialGroup().addContainerGap().addGroup(descriptionPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.labelTitle).addComponent(this.labelAuthor).addComponent(this.labelFile).addComponent(this.labelName).addComponent(this.labelKeywords).addComponent(this.labelDescription)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(descriptionPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.descriptionScrollPane, GroupLayout.Alignment.LEADING, -1, 377, Short.MAX_VALUE).addComponent(this.fileLabel, GroupLayout.Alignment.LEADING, -1, 377, Short.MAX_VALUE).addComponent(this.nameTextField, GroupLayout.Alignment.LEADING, -1, 377, Short.MAX_VALUE).addComponent(this.keywordsTextField, GroupLayout.Alignment.LEADING, -1, 377, Short.MAX_VALUE).addComponent(this.authorTextField, GroupLayout.Alignment.LEADING, -1, 377, Short.MAX_VALUE).addComponent(this.titleTextField, -1, 377, Short.MAX_VALUE)).addContainerGap()));
        descriptionPanelLayout.setVerticalGroup(descriptionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(descriptionPanelLayout.createSequentialGroup().addContainerGap().addGroup(descriptionPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fileLabel).addComponent(this.labelFile)).addGap(12, 12, 12).addGroup(descriptionPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nameTextField, -2, -1, -2).addComponent(this.labelName)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(descriptionPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelTitle).addComponent(this.titleTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(descriptionPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelAuthor).addComponent(this.authorTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(descriptionPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.keywordsTextField, -2, -1, -2).addComponent(this.labelKeywords)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(descriptionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelDescription).addComponent(this.descriptionScrollPane, -2, -1, -2)).addContainerGap(24, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.descriptionPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.descriptionPanel, -2, -1, -2).addContainerGap(148, Short.MAX_VALUE)));
    }
}

