/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.data;

import tim.prune.data.DataPoint;
import tim.prune.data.Track;

public abstract class Checker {
    public static DoubleStatus isDoubledTrack(Track track) {
        if (track == null || track.getNumPoints() < 2) {
            return DoubleStatus.NOTHING;
        }
        int n = track.getNumPoints();
        if (n % 2 != 0) {
            return DoubleStatus.NOTHING;
        }
        int n2 = n / 2;
        boolean bl = true;
        int n3 = 0;
        while (n3 < n2) {
            DataPoint dataPoint = track.getPoint(n3);
            DataPoint dataPoint2 = track.getPoint(n3 + n2);
            if (!dataPoint.getLatitude().equals(dataPoint2.getLatitude()) || !dataPoint.getLongitude().equals(dataPoint2.getLongitude())) {
                return DoubleStatus.NOTHING;
            }
            if (dataPoint.isWaypoint() == dataPoint2.isWaypoint()) {
                bl = false;
            }
            ++n3;
        }
        return bl ? DoubleStatus.DOUBLED_WAYPOINTS_TRACKPOINTS : DoubleStatus.DOUBLED;
    }

    public static int getNextSegmentStart(Track track, int n) {
        int n2 = n + 1;
        DataPoint dataPoint = null;
        while ((dataPoint = track.getPoint(n2)) != null && (dataPoint.isWaypoint() || !dataPoint.getSegmentStart())) {
            ++n2;
        }
        return Math.min(n2, track.getNumPoints() - 1);
    }

    public static int getPreviousSegmentStart(Track track, int n) {
        int n2 = n - 1;
        DataPoint dataPoint = null;
        while ((dataPoint = track.getPoint(n2)) != null && (dataPoint.isWaypoint() || !dataPoint.getSegmentStart())) {
            --n2;
        }
        n2 = Math.max(n2, 0);
        while ((dataPoint = track.getPoint(n2)) != null && dataPoint.isWaypoint()) {
            ++n2;
        }
        return n2;
    }

    public static int getNextSegmentEnd(Track track, int n) {
        int n2 = Checker.getNextSegmentStart(track, n);
        DataPoint dataPoint = track.getPoint(n2);
        if (dataPoint == null || dataPoint.getSegmentStart()) {
            --n2;
        }
        while ((dataPoint = track.getPoint(n2)) != null && dataPoint.isWaypoint()) {
            --n2;
        }
        return Math.min(n2, track.getNumPoints() - 1);
    }

    public static boolean haveWaypointsGotTimestamps(Track track) {
        if (track != null) {
            int n = 0;
            while (n < track.getNumPoints()) {
                DataPoint dataPoint = track.getPoint(n);
                if (dataPoint != null && dataPoint.isWaypoint() && dataPoint.hasTimestamp()) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    public static enum DoubleStatus {
        NOTHING,
        DOUBLED,
        DOUBLED_WAYPOINTS_TRACKPOINTS;

    }
}

