/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.data.DataPoint;
import tim.prune.gui.WaypointNameMatcher;

public class FindWaypoint
extends GenericFunction {
    private WaypointNameMatcher _nameMatcher = null;
    private JDialog _dialog = null;
    private JTextField _searchField = null;
    private JList<String> _pointList = null;
    private JButton _okButton = null;

    public FindWaypoint(App app) {
        super(app);
    }

    @Override
    public String getNameKey() {
        return "function.findwaypoint";
    }

    @Override
    public void begin() {
        if (this._dialog == null) {
            this._dialog = new JDialog(this._parentFrame, I18nManager.getText(this.getNameKey()), true);
            this._dialog.setLocationRelativeTo(this._parentFrame);
            this._dialog.setDefaultCloseOperation(2);
            this._dialog.getContentPane().add(this.makeDialogComponents());
            this._dialog.pack();
        }
        this._nameMatcher.init(this._app.getTrackInfo().getTrack());
        this._searchField.setText("");
        this._dialog.setVisible(true);
    }

    private Component makeDialogComponents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.add(new JLabel(I18nManager.getText("dialog.findwaypoint.intro")));
        JPanel jPanel3 = new JPanel();
        jPanel3.add(new JLabel(I18nManager.getText("dialog.findwaypoint.search")));
        this._searchField = new JTextField(12);
        this._searchField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                FindWaypoint.this._nameMatcher.findMatches(FindWaypoint.this._searchField.getText());
                if (FindWaypoint.this._nameMatcher.getSize() == 0 || FindWaypoint.this._nameMatcher.getSize() < FindWaypoint.this._pointList.getSelectedIndex()) {
                    FindWaypoint.this._okButton.setEnabled(false);
                } else if (FindWaypoint.this._pointList.getSelectedIndex() >= 0) {
                    FindWaypoint.this._okButton.setEnabled(true);
                }
                if (keyEvent.getKeyCode() == 27) {
                    FindWaypoint.this._dialog.dispose();
                }
            }
        });
        jPanel3.add(this._searchField);
        jPanel2.add(jPanel3);
        jPanel.add((Component)jPanel2, "North");
        this._nameMatcher = new WaypointNameMatcher();
        this._pointList = new JList<String>(this._nameMatcher);
        this._pointList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    FindWaypoint.this._okButton.setEnabled(true);
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this._pointList);
        jPanel.add((Component)jScrollPane, "Center");
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout(2));
        this._okButton = new JButton(I18nManager.getText("button.ok"));
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FindWaypoint.this.finish();
            }
        };
        this._okButton.addActionListener(actionListener);
        this._okButton.setEnabled(false);
        jPanel4.add(this._okButton);
        JButton jButton = new JButton(I18nManager.getText("button.cancel"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FindWaypoint.this._dialog.dispose();
            }
        });
        jPanel4.add(jButton);
        jPanel.add((Component)jPanel4, "South");
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 15));
        return jPanel;
    }

    private void finish() {
        DataPoint dataPoint = this._nameMatcher.getWaypoint(this._pointList.getSelectedIndex());
        this._app.getTrackInfo().selectPoint(dataPoint);
        this._dialog.dispose();
    }
}

