/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.symmetry;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.M4;
import javajs.util.Measure;
import javajs.util.P3;
import javajs.util.P4;
import javajs.util.PT;
import javajs.util.Quat;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.api.SymmetryInterface;
import org.jmol.modelset.Atom;
import org.jmol.modelset.ModelSet;
import org.jmol.script.T;
import org.jmol.symmetry.SpaceGroup;
import org.jmol.symmetry.Symmetry;
import org.jmol.symmetry.SymmetryOperation;
import org.jmol.symmetry.UnitCell;
import org.jmol.util.Escape;
import org.jmol.util.Logger;

public class SymmetryDesc {
    private ModelSet modelSet;
    private static final String THIN_LINE = "0.05";
    private static final String THICK_LINE = "0.1";
    private static final int RET_XYZ = 0;
    private static final int RET_XYZORIGINAL = 1;
    private static final int RET_LABEL = 2;
    private static final int RET_DRAW = 3;
    private static final int RET_FTRANS = 4;
    private static final int RET_CTRANS = 5;
    private static final int RET_INVCTR = 6;
    private static final int RET_POINT = 7;
    private static final int RET_AXISVECTOR = 8;
    private static final int RET_ROTANGLE = 9;
    private static final int RET_MATRIX = 10;
    private static final int RET_UNITTRANS = 11;
    private static final int RET_CTRVECTOR = 12;
    private static final int RET_TIMEREV = 13;
    private static final int RET_PLANE = 14;
    private static final int RET_TYPE = 15;
    private static final int RET_ID = 16;
    private static final int RET_CIF2 = 17;
    private static final int RET_XYZCANON = 18;
    private static final int RET_XYZNORMALIZED = 19;
    private static final int RET_COUNT = 20;
    static final int RET_LIST = 21;
    static final int RET_INVARIANT = 22;
    private static final String[] keys = new String[]{"xyz", "xyzOriginal", "label", null, "fractionalTranslation", "cartesianTranslation", "inversionCenter", null, "axisVector", "rotationAngle", "matrix", "unitTranslation", "centeringVector", "timeReversal", "plane", "_type", "id", "cif2", "xyzCanonical", "xyzNormalized"};
    private static V3 vtemp = new V3();
    private static P3 ptemp = new P3();
    private static P3 ptemp2 = new P3();
    private static P3 pta01 = new P3();
    private static P3 pta02 = new P3();
    private static V3 vtrans = new V3();

    public SymmetryDesc set(ModelSet modelSet) {
        this.modelSet = modelSet;
        return this;
    }

    private static int getType(String id) {
        if (id == null) {
            return 1073742001;
        }
        if (id.equalsIgnoreCase("matrix")) {
            return 12;
        }
        if (id.equalsIgnoreCase("description")) {
            return 1825200146;
        }
        if (id.equalsIgnoreCase("axispoint")) {
            return 134217751;
        }
        if (id.equalsIgnoreCase("time")) {
            return 0x100000B1;
        }
        if (id.equalsIgnoreCase("info")) {
            return 1275068418;
        }
        if (id.equalsIgnoreCase("element")) {
            return 1086326789;
        }
        if (id.equalsIgnoreCase("invariant")) {
            return 36868;
        }
        int type = T.getTokFromName(id);
        if (type != 0) {
            return type;
        }
        type = SymmetryDesc.getKeyType(id);
        return type < 0 ? type : 1073742327;
    }

    private static int getKeyType(String id) {
        if ("type".equals(id)) {
            id = "_type";
        }
        for (int type = 0; type < keys.length; ++type) {
            if (!id.equalsIgnoreCase(keys[type])) continue;
            return -1 - type;
        }
        return 0;
    }

    private static Object nullReturn(int type) {
        switch (type) {
            case 135176: {
                return "draw ID sym_* delete";
            }
            case 11: 
            case 1073741961: 
            case 1073741974: 
            case 1073742078: 
            case 1145047050: 
            case 1145047053: 
            case 1825200146: {
                return "";
            }
            case 0x44000001: {
                return new BS();
            }
        }
        return null;
    }

    private static Object getInfo(Object[] io, int type) {
        Object object;
        if (io.length == 0) {
            return "";
        }
        if (type < 0 && -type <= keys.length && -type <= io.length) {
            return io[-1 - type];
        }
        switch (type) {
            case 1073741982: 
            case 1073742327: {
                return io;
            }
            case 1275068418: {
                Hashtable<String, Object> lst = new Hashtable<String, Object>();
                int n = io.length;
                for (int j = 0; j < n; ++j) {
                    String key;
                    String string = j == 3 ? "draw" : (key = j == 7 ? "axispoint" : keys[j]);
                    if (io[j] == null) continue;
                    lst.put(key, io[j]);
                }
                return lst;
            }
            case 1073741961: {
                return io[0] + "  \t" + io[2];
            }
            case 1145047050: {
                return io[0];
            }
            case 1145047053: {
                return io[19];
            }
            case 1073742078: {
                return io[1];
            }
            default: {
                return io[2];
            }
            case 135176: {
                return io[3] + "\nprint " + PT.esc(io[0] + " " + io[2]);
            }
            case 1145047051: {
                return io[4];
            }
            case 1073742178: {
                return io[5];
            }
            case 12289: {
                return io[6];
            }
            case 134217751: {
                return io[7];
            }
            case 1073741854: {
                return io[8];
            }
            case 0x8000001: {
                return io[9];
            }
            case 12: {
                return io[10];
            }
            case 1814695966: {
                return io[11];
            }
            case 4160: {
                return io[12];
            }
            case 0x100000B1: {
                return io[13];
            }
            case 134217750: {
                return io[14];
            }
            case 0x44000008: {
                return io[15];
            }
            case 1073741974: {
                return io[16];
            }
            case 1086326789: {
                return new Object[]{io[6], io[7], io[8], io[14], io[5]};
            }
            case 36868: 
        }
        if (io[5] != null) {
            object = "none";
        } else if (io[6] != null) {
            object = io[6];
        } else if (io[8] != null) {
            Object[] objectArray = new Object[2];
            objectArray[0] = io[7];
            object = objectArray;
            objectArray[1] = io[8];
        } else {
            object = io[14] != null ? io[14] : "identity";
        }
        return object;
    }

    private static BS getInfoBS(int type) {
        BS bsInfo = new BS();
        if (type < 0 && -type <= keys.length) {
            bsInfo.set(-1 - type);
            return bsInfo;
        }
        switch (type) {
            case 0: 
            case 1073741982: 
            case 1073742001: 
            case 1073742327: 
            case 0x44000001: 
            case 1275068418: {
                bsInfo.setBits(0, keys.length);
                break;
            }
            case 1073741961: {
                bsInfo.set(0);
                bsInfo.set(2);
                break;
            }
            case 1145047050: {
                bsInfo.set(0);
                break;
            }
            case 1145047053: {
                bsInfo.set(19);
                break;
            }
            case 1073742078: {
                bsInfo.set(1);
                break;
            }
            default: {
                bsInfo.set(2);
                break;
            }
            case 135176: {
                bsInfo.set(0);
                bsInfo.set(2);
                bsInfo.set(3);
                break;
            }
            case 1145047051: {
                bsInfo.set(4);
                break;
            }
            case 1073742178: {
                bsInfo.set(5);
                break;
            }
            case 12289: {
                bsInfo.set(6);
                break;
            }
            case 134217751: {
                bsInfo.set(7);
                break;
            }
            case 1073741854: {
                bsInfo.set(8);
                break;
            }
            case 0x8000001: {
                bsInfo.set(9);
                break;
            }
            case 12: {
                bsInfo.set(10);
                break;
            }
            case 1814695966: {
                bsInfo.set(11);
                break;
            }
            case 4160: {
                bsInfo.set(12);
                break;
            }
            case 0x100000B1: {
                bsInfo.set(13);
                break;
            }
            case 134217750: {
                bsInfo.set(14);
                break;
            }
            case 0x44000008: {
                bsInfo.set(15);
                break;
            }
            case 1073741974: {
                bsInfo.set(16);
                break;
            }
            case 36868: 
            case 1086326789: {
                bsInfo.set(5);
                bsInfo.set(6);
                bsInfo.set(7);
                bsInfo.set(8);
                bsInfo.set(14);
                bsInfo.set(22);
            }
        }
        return bsInfo;
    }

    private Object[] createInfoArray(SymmetryOperation op, SymmetryInterface uc, P3 ptFrom, P3 ptTarget, String id, float scaleFactor, int options, boolean haveTranslation, BS bsInfo) {
        boolean isScrew;
        boolean isTranslationOnly;
        V3 trans;
        boolean haveInversion;
        boolean isMagnetic;
        P3 pta00;
        boolean isTimeReversed;
        if (!op.isFinalized) {
            op.doFinalize();
        }
        boolean matrixOnly = bsInfo.cardinality() == 1 && bsInfo.get(10);
        boolean bl = isTimeReversed = op.timeReversal == -1;
        if (scaleFactor == 0.0f) {
            scaleFactor = 1.0f;
        }
        ptemp.set(0.0f, 0.0f, 0.0f);
        vtrans.set(0.0f, 0.0f, 0.0f);
        P4 plane = null;
        P3 p3 = pta00 = ptFrom == null || Float.isNaN(ptFrom.x) ? new P3() : ptFrom;
        if (ptTarget != null) {
            pta01.setT(pta00);
            pta02.setT(ptTarget);
            uc.toFractional(pta01, true);
            uc.toFractional(pta02, true);
            op.rotTrans(pta01);
            ptemp.setT(pta01);
            uc.unitize(pta01);
            vtrans.setT(pta02);
            uc.unitize(pta02);
            if (pta01.distanceSquared(pta02) >= 1.96E-6f) {
                return null;
            }
            vtrans.sub(ptemp);
        }
        M4 m2 = M4.newM4(op);
        m2.add(vtrans);
        boolean bl2 = isMagnetic = op.timeReversal != 0;
        if (matrixOnly && !isMagnetic) {
            int im = SymmetryDesc.getKeyType("matrix");
            Object[] o = new Object[-im];
            o[-1 - im] = m2;
            return o;
        }
        V3 ftrans = new V3();
        pta01.set(1.0f, 0.0f, 0.0f);
        pta02.set(0.0f, 1.0f, 0.0f);
        P3 pta03 = P3.new3(0.0f, 0.0f, 1.0f);
        pta01.add(pta00);
        pta02.add(pta00);
        pta03.add(pta00);
        P3 pt0 = SymmetryDesc.rotTransCart(op, uc, pta00, vtrans);
        P3 pt1 = SymmetryDesc.rotTransCart(op, uc, pta01, vtrans);
        P3 pt2 = SymmetryDesc.rotTransCart(op, uc, pta02, vtrans);
        P3 pt3 = SymmetryDesc.rotTransCart(op, uc, pta03, vtrans);
        V3 vt1 = V3.newVsub(pt1, pt0);
        V3 vt2 = V3.newVsub(pt2, pt0);
        V3 vt3 = V3.newVsub(pt3, pt0);
        SymmetryDesc.approx(vtrans);
        vtemp.cross(vt1, vt2);
        boolean bl3 = haveInversion = vtemp.dot(vt3) < 0.0f;
        if (haveInversion) {
            pt1.sub2(pt0, vt1);
            pt2.sub2(pt0, vt2);
            pt3.sub2(pt0, vt3);
        }
        T3[] info = Measure.computeHelicalAxis(pta00, pt0, Quat.getQuaternionFrame(pt0, pt1, pt2).div(Quat.getQuaternionFrame(pta00, pta01, pta02)));
        P3 pa1 = (P3)info[0];
        V3 ax1 = (V3)info[1];
        int ang1 = (int)Math.abs(PT.approx(((P3)info[3]).x, 1.0f));
        float pitch1 = SymmetryOperation.approxF(((P3)info[3]).y);
        if (haveInversion) {
            pt1.add2(pt0, vt1);
            pt2.add2(pt0, vt2);
            pt3.add2(pt0, vt3);
        }
        if ((trans = V3.newVsub(pt0, pta00)).length() < 0.1f) {
            trans = null;
        }
        P3 ptinv = null;
        P3 ipt = null;
        P3 ptref = null;
        float w = 0.0f;
        float margin = 0.0f;
        boolean isTranslation = ang1 == 0;
        boolean isRotation = !isTranslation;
        boolean isInversionOnly = false;
        boolean isMirrorPlane = false;
        boolean bl4 = isTranslationOnly = !isRotation && !haveInversion;
        if (isRotation || haveInversion) {
            trans = null;
        }
        if (haveInversion && isTranslation) {
            ipt = P3.newP(pta00);
            ipt.add(pt0);
            ipt.scale(0.5f);
            ptinv = pt0;
            isInversionOnly = true;
        } else if (haveInversion) {
            V3 d = pitch1 == 0.0f ? new V3() : ax1;
            float f = 0.0f;
            switch (ang1) {
                case 60: {
                    f = 0.6666667f;
                    break;
                }
                case 120: {
                    f = 2.0f;
                    break;
                }
                case 90: {
                    f = 1.0f;
                    break;
                }
                case 180: {
                    ptref = P3.newP(pta00);
                    ptref.add(d);
                    pa1.scaleAdd2(0.5f, d, pta00);
                    if (ptref.distance(pt0) > 0.1f) {
                        trans = V3.newVsub(pt0, ptref);
                        SymmetryDesc.setFractional(uc, trans, ptemp, null);
                        ftrans.setT(ptemp);
                    } else {
                        trans = null;
                    }
                    vtemp.setT(ax1);
                    vtemp.normalize();
                    w = -SymmetryDesc.vtemp.x * pa1.x - SymmetryDesc.vtemp.y * pa1.y - SymmetryDesc.vtemp.z * pa1.z;
                    plane = P4.new4(SymmetryDesc.vtemp.x, SymmetryDesc.vtemp.y, SymmetryDesc.vtemp.z, w);
                    margin = Math.abs(w) < 0.01f && (double)(SymmetryDesc.vtemp.x * SymmetryDesc.vtemp.y) > 0.4 ? 1.3f : 1.05f;
                    isRotation = false;
                    haveInversion = false;
                    isMirrorPlane = true;
                    break;
                }
                default: {
                    haveInversion = false;
                }
            }
            if (f != 0.0f) {
                vtemp.sub2(pta00, pa1);
                vtemp.add(pt0);
                vtemp.sub(pa1);
                vtemp.sub(d);
                vtemp.scale(f);
                pa1.add(vtemp);
                ipt = new P3();
                ipt.scaleAdd2(0.5f, d, pa1);
                ptinv = new P3();
                ptinv.scaleAdd2(-2.0f, ipt, pt0);
                ptinv.scale(-1.0f);
            }
        } else if (trans != null) {
            ptemp.setT(trans);
            uc.toFractional(ptemp, false);
            ftrans.setT(ptemp);
            uc.toCartesian(ptemp, false);
            trans.setT(ptemp);
        }
        int ang = ang1;
        SymmetryDesc.approx0(ax1);
        if (isRotation) {
            P3 p0;
            P3 ptr = new P3();
            vtemp.setT(ax1);
            int ang2 = ang1;
            if (haveInversion) {
                ptr.setT(ptinv);
                p0 = ptinv;
            } else if (pitch1 == 0.0f) {
                p0 = pt0;
                ptr.setT(pa1);
            } else {
                p0 = pt0;
                ptr.scaleAdd2(0.5f, vtemp, pa1);
            }
            ptemp.add2(pa1, vtemp);
            ang2 = Math.round(Measure.computeTorsion(pta00, pa1, ptemp, p0, true));
            if (SymmetryOperation.approxF(ang2) != 0.0f) {
                ang1 = ang2;
            }
            if (ang1 < 0) {
                ang1 = 360 + ang1;
            }
        }
        String info1 = null;
        String type = null;
        if (bsInfo.get(2) || bsInfo.get(15)) {
            type = "identity";
            info1 = "identity";
            if (isInversionOnly) {
                ptemp.setT(ipt);
                uc.toFractional(ptemp, false);
                info1 = "Ci: " + SymmetryDesc.strCoord(op, ptemp, op.isBio);
                type = "inversion center";
            } else if (isRotation) {
                if (haveInversion) {
                    type = info1 = 360 / ang + "-bar axis";
                } else if (pitch1 != 0.0f) {
                    type = info1 = 360 / ang + "-fold screw axis";
                    ptemp.setT(ax1);
                    uc.toFractional(ptemp, false);
                    info1 = info1 + "|translation: " + SymmetryDesc.strCoord(op, ptemp, op.isBio);
                } else {
                    type = info1 = "C" + 360 / ang + " axis";
                }
            } else if (trans != null) {
                String s = " " + SymmetryDesc.strCoord(op, ftrans, op.isBio);
                if (isTranslation) {
                    info1 = "translation";
                    type = "translation";
                    info1 = info1 + ":" + s;
                } else if (isMirrorPlane) {
                    float fx = Math.abs(SymmetryOperation.approxF(ftrans.x));
                    float fy = Math.abs(SymmetryOperation.approxF(ftrans.y));
                    float fz = Math.abs(SymmetryOperation.approxF(ftrans.z));
                    s = " " + SymmetryDesc.strCoord(op, ftrans, op.isBio);
                    info1 = fx != 0.0f && fy != 0.0f && fz != 0.0f ? (fx == 0.25f && fy == 0.25f && fz == 0.25f ? "d-" : (fx == 0.5f && fy == 0.5f && fz == 0.5f ? "n-" : "g-")) : (fx != 0.0f && fy != 0.0f || fy != 0.0f && fz != 0.0f || fz != 0.0f && fx != 0.0f ? (fx == 0.25f && fy == 0.25f || fx == 0.25f && fz == 0.25f || fy == 0.25f && fz == 0.25f ? "d-" : (fx == 0.5f && fy == 0.5f || fx == 0.5f && fz == 0.5f || fy == 0.5f && fz == 0.5f ? (fx == 0.0f && ax1.x == 0.0f || fy == 0.0f && ax1.y == 0.0f || fz == 0.0f && ax1.z == 0.0f ? "g-" : "n-") : "g-")) : (fx != 0.0f ? "a-" : (fy != 0.0f ? "b-" : "c-")));
                    type = info1 = info1 + "glide plane";
                    info1 = info1 + "|translation:" + s;
                }
            } else if (isMirrorPlane) {
                info1 = "mirror plane";
                type = "mirror plane";
            }
            if (haveInversion && !isInversionOnly) {
                ptemp.setT(ipt);
                uc.toFractional(ptemp, false);
                info1 = info1 + "|inversion center at " + SymmetryDesc.strCoord(op, ptemp, op.isBio);
            }
            if (isTimeReversed) {
                info1 = info1 + "|time-reversed";
                type = type + " (time-reversed)";
            }
        }
        String cmds = null;
        boolean isOK = true;
        boolean bl5 = isScrew = isRotation && !haveInversion && pitch1 != 0.0f;
        if (!isScrew && !(isOK = SymmetryDesc.checkHandedness(uc, ax1))) {
            if ((ang1 = -ang1) < 0) {
                ang1 = 360 + ang1;
            }
            ax1.scale(-1.0f);
        }
        if (id != null && bsInfo.get(3)) {
            String color;
            boolean isSpecial;
            String opType = null;
            String drawid = "\ndraw ID " + id + "_";
            SB draw1 = new SB();
            draw1.append(drawid).append("* delete");
            SymmetryDesc.drawLine(draw1, drawid + "frame1X", 0.15f, pta00, pta01, "red");
            SymmetryDesc.drawLine(draw1, drawid + "frame1Y", 0.15f, pta00, pta02, "green");
            SymmetryDesc.drawLine(draw1, drawid + "frame1Z", 0.15f, pta00, pta03, "blue");
            boolean bl6 = isSpecial = pta00.distance(pt0) < 0.2f;
            if (isRotation) {
                P3 ptr = new P3();
                color = "red";
                ang = ang1;
                float scale = 1.0f;
                vtemp.setT(ax1);
                if (pitch1 != 0.0f && !haveInversion) {
                    opType = drawid + "screw";
                    color = "orange";
                    SymmetryDesc.drawLine(draw1, drawid + "rotLine1", 0.1f, pta00, pa1, "red");
                    ptemp.add2(pa1, vtemp);
                    SymmetryDesc.drawLine(draw1, drawid + "rotLine2", 0.1f, pt0, ptemp, "red");
                    ptr.scaleAdd2(0.5f, vtemp, pa1);
                } else {
                    ptr.setT(pa1);
                    if (!isOK && !isSpecial) {
                        pa1.sub2(pa1, vtemp);
                    }
                    if (haveInversion) {
                        opType = drawid + "rotinv";
                        if (pitch1 == 0.0f) {
                            ptr.setT(ipt);
                            vtemp.scale(3.0f * scaleFactor);
                            if (isSpecial) {
                                ptemp.scaleAdd2(0.25f, vtemp, pa1);
                                pa1.scaleAdd2(-0.24f, vtemp, pa1);
                                ptr.scaleAdd2(0.31f, vtemp, ptr);
                                color = "cyan";
                            } else {
                                ptemp.scaleAdd2(-1.0f, vtemp, pa1);
                                SymmetryDesc.drawLine(draw1, drawid + "rotLine1", 0.1f, pta00, ipt, "red");
                                SymmetryDesc.drawLine(draw1, drawid + "rotLine2", 0.1f, ptinv, ipt, "red");
                            }
                        } else if (!isSpecial) {
                            scale = pta00.distance(ptr);
                            SymmetryDesc.drawLine(draw1, drawid + "rotLine1", 0.1f, pta00, ptr, "red");
                            SymmetryDesc.drawLine(draw1, drawid + "rotLine2", 0.1f, ptinv, ptr, "red");
                        }
                    } else {
                        opType = drawid + "rot";
                        vtemp.scale(3.0f * scaleFactor);
                        if (!isSpecial) {
                            SymmetryDesc.drawLine(draw1, drawid + "rotLine1", 0.1f, pta00, ptr, "red");
                            SymmetryDesc.drawLine(draw1, drawid + "rotLine2", 0.1f, pt0, ptr, "red");
                        }
                        ptr.setT(pa1);
                        if (pitch1 == 0.0f && isSpecial) {
                            ptr.scaleAdd2(0.25f, vtemp, ptr);
                        }
                    }
                }
                ptemp.add2(ptr, vtemp);
                draw1.append(drawid).append("rotRotArrow arrow width 0.1 scale " + PT.escF(scale) + " arc ").append(Escape.eP(ptr)).append(Escape.eP(ptemp));
                ptemp.setT(pta00);
                if (ptemp.distance(pt0) < 0.1f) {
                    ptemp.set((float)Math.random(), (float)Math.random(), (float)Math.random());
                }
                draw1.append(Escape.eP(ptemp));
                ptemp.set(0.0f, (float)ang - 5.0f * Math.signum(ang), 0.0f);
                draw1.append(Escape.eP(ptemp)).append(" color red");
                if (pitch1 == 0.0f && !haveInversion) {
                    ptemp.scaleAdd2(0.5f, vtemp, pa1);
                    pa1.scaleAdd2(-0.45f, vtemp, pa1);
                }
                SymmetryDesc.drawVector(draw1, drawid, "rotVector1", "vector", THICK_LINE, pa1, vtemp, isTimeReversed ? "gray" : color);
            } else if (isMirrorPlane) {
                ptemp.sub2(ptref, pta00);
                if (pta00.distance(ptref) > 0.2f) {
                    SymmetryDesc.drawVector(draw1, drawid, "planeVector", "vector", THIN_LINE, pta00, ptemp, isTimeReversed ? "gray" : "cyan");
                }
                opType = drawid + "plane";
                if (trans != null) {
                    opType = drawid + "glide";
                    SymmetryDesc.drawFrameLine("X", ptref, vt1, 0.15f, ptemp, draw1, opType, "red");
                    SymmetryDesc.drawFrameLine("Y", ptref, vt2, 0.15f, ptemp, draw1, opType, "green");
                    SymmetryDesc.drawFrameLine("Z", ptref, vt3, 0.15f, ptemp, draw1, opType, "blue");
                }
                color = trans == null ? "green" : "blue";
                Lst<Object> v = this.modelSet.vwr.getTriangulator().intersectPlane(plane, uc.getCanonicalCopy(margin, true), 3);
                if (v != null) {
                    int i = v.size();
                    while (--i >= 0) {
                        P3[] pts = (P3[])v.get(i);
                        draw1.append(drawid).append("planep").appendI(i).append(" ").append(Escape.eP(pts[0])).append(Escape.eP(pts[1]));
                        if (pts.length == 3) {
                            draw1.append(Escape.eP(pts[2]));
                        }
                        draw1.append(" color translucent ").append(color);
                    }
                }
                if (v == null || v.size() == 0) {
                    ptemp.add2(pa1, ax1);
                    draw1.append(drawid).append("planeCircle scale 2.0 circle ").append(Escape.eP(pa1)).append(Escape.eP(ptemp)).append(" color translucent ").append(color).append(" mesh fill");
                }
            }
            if (haveInversion) {
                opType = drawid + "inv";
                draw1.append(drawid).append("invPoint diameter 0.4 ").append(Escape.eP(ipt));
                if (isInversionOnly) {
                    ptemp.sub2(ptinv, pta00);
                    SymmetryDesc.drawVector(draw1, drawid, "invArrow", "vector", THIN_LINE, pta00, ptemp, isTimeReversed ? "gray" : "cyan");
                } else {
                    draw1.append(" color cyan");
                    if (!isSpecial) {
                        ptemp.sub2(pt0, ptinv);
                        SymmetryDesc.drawVector(draw1, drawid, "invArrow", "vector", THIN_LINE, ptinv, ptemp, isTimeReversed ? "gray" : "cyan");
                    }
                    if (options != 1073742066) {
                        vtemp.setT(vt1);
                        vtemp.scale(-1.0f);
                        SymmetryDesc.drawFrameLine("X", ptinv, vtemp, 0.15f, ptemp, draw1, opType, "red");
                        vtemp.setT(vt2);
                        vtemp.scale(-1.0f);
                        SymmetryDesc.drawFrameLine("Y", ptinv, vtemp, 0.15f, ptemp, draw1, opType, "green");
                        vtemp.setT(vt3);
                        vtemp.scale(-1.0f);
                        SymmetryDesc.drawFrameLine("Z", ptinv, vtemp, 0.15f, ptemp, draw1, opType, "blue");
                    }
                }
            }
            if (trans != null) {
                if (ptref == null) {
                    ptref = P3.newP(pta00);
                }
                SymmetryDesc.drawVector(draw1, drawid, "transVector", "vector", isTranslationOnly ? THICK_LINE : THIN_LINE, ptref, trans, isTimeReversed && !haveInversion && !isMirrorPlane && !isRotation ? "darkGray" : "gold");
            }
            ptemp2.setT(pt0);
            ptemp.sub2(pt1, pt0);
            ptemp.scaleAdd2(0.9f, ptemp, ptemp2);
            SymmetryDesc.drawLine(draw1, drawid + "frame2X", 0.2f, ptemp2, ptemp, "red");
            ptemp.sub2(pt2, pt0);
            ptemp.scaleAdd2(0.9f, ptemp, ptemp2);
            SymmetryDesc.drawLine(draw1, drawid + "frame2Y", 0.2f, ptemp2, ptemp, "green");
            ptemp.sub2(pt3, pt0);
            ptemp.scaleAdd2(0.9f, ptemp, ptemp2);
            SymmetryDesc.drawLine(draw1, drawid + "frame2Z", 0.2f, ptemp2, ptemp, "purple");
            draw1.append("\nsym_point = " + Escape.eP(pta00));
            draw1.append("\nvar p0 = " + Escape.eP(ptemp2));
            if (pta00 instanceof Atom) {
                draw1.append("\nvar set2 = within(0.2,p0);if(!set2){set2 = within(0.2,p0.uxyz.xyz)}");
                draw1.append("\n set2 &= {_" + ((Atom)pta00).getElementSymbol() + "}");
            } else {
                draw1.append("\nvar set2 = p0.uxyz");
            }
            draw1.append("\nsym_target = set2;if (set2) {");
            if (!isSpecial && options != 1073742066 && ptTarget == null && !haveTranslation) {
                draw1.append(drawid).append("offsetFrameX diameter 0.20 @{set2.xyz} @{set2.xyz + ").append(Escape.eP(vt1)).append("*0.9} color red");
                draw1.append(drawid).append("offsetFrameY diameter 0.20 @{set2.xyz} @{set2.xyz + ").append(Escape.eP(vt2)).append("*0.9} color green");
                draw1.append(drawid).append("offsetFrameZ diameter 0.20 @{set2.xyz} @{set2.xyz + ").append(Escape.eP(vt3)).append("*0.9} color purple");
            }
            draw1.append("\n}\n");
            cmds = draw1.toString();
            if (Logger.debugging) {
                Logger.info(cmds);
            }
            draw1 = null;
            drawid = null;
        }
        if (trans == null) {
            ftrans = null;
        }
        if (isRotation && !haveInversion && pitch1 != 0.0f) {
            trans = V3.newV(ax1);
            ptemp.setT(trans);
            uc.toFractional(ptemp, false);
            ftrans = V3.newV(ptemp);
        }
        if (isMirrorPlane) {
            ang1 = 0;
        }
        if (haveInversion) {
            if (isInversionOnly) {
                pa1 = null;
                ax1 = null;
                trans = null;
                ftrans = null;
            }
        } else if (isTranslation) {
            pa1 = null;
            ax1 = null;
        }
        if (ax1 != null) {
            ax1.normalize();
        }
        String xyzNew = null;
        if (bsInfo.get(0) || bsInfo.get(17)) {
            String string = op.isBio ? m2.toString() : (xyzNew = op.modDim > 0 ? op.xyzOriginal : SymmetryOperation.getXYZFromMatrix(m2, false, false, false));
            if (isMagnetic) {
                xyzNew = op.fixMagneticXYZ(m2, xyzNew, true);
            }
        }
        Object[] ret = new Object[20];
        int i = bsInfo.nextSetBit(0);
        while (i >= 0) {
            switch (i) {
                case 0: {
                    ret[i] = xyzNew;
                    break;
                }
                case 19: {
                    if (ptFrom == null || ptTarget != null || op.isBio || op.modDim != 0) break;
                    pta02.setT(ptFrom);
                    uc.toFractional(pta02, true);
                    m2.rotTrans(pta02);
                    ptemp.setT(pta02);
                    uc.unitize(pta02);
                    vtrans.sub2(pta02, ptemp);
                    m2 = M4.newM4(op);
                    m2.add(vtrans);
                    String xyzN = SymmetryOperation.getXYZFromMatrix(m2, false, false, false);
                    if (isMagnetic) {
                        xyzN = op.fixMagneticXYZ(m2, xyzN, true);
                    }
                    ret[i] = xyzN;
                    break;
                }
                case 1: {
                    ret[i] = op.xyzOriginal;
                    break;
                }
                case 2: {
                    ret[i] = info1;
                    break;
                }
                case 3: {
                    ret[i] = cmds;
                    break;
                }
                case 4: {
                    ret[i] = SymmetryDesc.approx0(ftrans);
                    break;
                }
                case 5: {
                    ret[i] = SymmetryDesc.approx0(trans);
                    break;
                }
                case 6: {
                    ret[i] = SymmetryDesc.approx0(ipt);
                    break;
                }
                case 7: {
                    ret[i] = SymmetryDesc.approx0(pa1 != null && bsInfo.get(22) ? pta00 : pa1);
                    break;
                }
                case 8: {
                    ret[i] = plane == null ? SymmetryDesc.approx0(ax1) : null;
                    break;
                }
                case 9: {
                    ret[i] = ang1 != 0 ? Integer.valueOf(ang1) : null;
                    break;
                }
                case 10: {
                    ret[i] = m2;
                    break;
                }
                case 11: {
                    ret[i] = vtrans.lengthSquared() > 0.0f ? vtrans : null;
                    break;
                }
                case 12: {
                    ret[i] = op.getCentering();
                    break;
                }
                case 13: {
                    ret[i] = op.timeReversal;
                    break;
                }
                case 14: {
                    if (plane != null && bsInfo.get(22)) {
                        float d = Measure.distanceToPlane(plane, pta00);
                        plane.w -= d;
                    }
                    ret[i] = plane;
                    break;
                }
                case 15: {
                    ret[i] = type;
                    break;
                }
                case 16: {
                    ret[i] = op.number;
                    break;
                }
                case 17: {
                    P3 cift = null;
                    if (!op.isBio && !xyzNew.equals(op.xyzOriginal) && op.number > 0) {
                        M4 orig = SymmetryOperation.getMatrixFromXYZ(op.xyzOriginal);
                        orig.sub(m2);
                        cift = new P3();
                        orig.getTranslation(cift);
                    }
                    int cifi = op.number < 0 ? 0 : op.number;
                    ret[i] = cifi + (cift == null ? " [0 0 0]" : " [" + (int)(-cift.x) + " " + (int)(-cift.y) + " " + (int)(-cift.z) + "]");
                    break;
                }
                case 18: {
                    ret[i] = op.xyzCanonical;
                }
            }
            i = bsInfo.nextSetBit(i + 1);
        }
        return ret;
    }

    private static boolean checkHandedness(SymmetryInterface uc, V3 ax1) {
        ptemp.set(1.0f, 0.0f, 0.0f);
        uc.toCartesian(ptemp, false);
        float a = SymmetryDesc.approx0f(ptemp.dot(ax1));
        ptemp.set(0.0f, 1.0f, 0.0f);
        uc.toCartesian(ptemp, false);
        float b = SymmetryDesc.approx0f(ptemp.dot(ax1));
        ptemp.set(0.0f, 0.0f, 1.0f);
        uc.toCartesian(ptemp, false);
        float c = SymmetryDesc.approx0f(ptemp.dot(ax1));
        return a == 0.0f ? (b == 0.0f ? c > 0.0f : b > 0.0f) : (c == 0.0f ? a > 0.0f : (b == 0.0f ? c > 0.0f : a * b * c > 0.0f));
    }

    private static void drawLine(SB s, String id, float diameter, P3 pt0, P3 pt1, String color) {
        s.append(id).append(" diameter ").appendF(diameter).append(Escape.eP(pt0)).append(Escape.eP(pt1)).append(" color ").append(color);
    }

    private static void drawFrameLine(String xyz, P3 pt, V3 v, float width, P3 ptemp, SB draw1, String key, String color) {
        ptemp.setT(pt);
        ptemp.add(v);
        SymmetryDesc.drawLine(draw1, key + "Pt" + xyz, width, pt, ptemp, "translucent " + color);
    }

    private static void drawVector(SB draw1, String drawid, String label, String type, String d, T3 pt1, T3 v, String color) {
        if (type.equals("vline")) {
            ptemp2.add2(pt1, v);
            type = "";
            v = ptemp2;
        }
        d = d + " ";
        draw1.append(drawid).append(label).append(" diameter ").append(d).append(type).append(Escape.eP(pt1)).append(Escape.eP(v)).append(" color ").append(color);
    }

    private static void setFractional(SymmetryInterface uc, T3 pt00, P3 pt01, P3 offset) {
        pt01.setT(pt00);
        if (offset != null) {
            uc.toUnitCell(pt01, offset);
        }
        uc.toFractional(pt01, false);
    }

    private static P3 rotTransCart(SymmetryOperation op, SymmetryInterface uc, P3 pt00, V3 vtrans) {
        P3 p0 = P3.newP(pt00);
        uc.toFractional(p0, false);
        op.rotTrans(p0);
        p0.add(vtrans);
        uc.toCartesian(p0, false);
        return p0;
    }

    private static String strCoord(SymmetryOperation op, T3 p, boolean isBio) {
        SymmetryDesc.approx0(p);
        return isBio ? p.x + " " + p.y + " " + p.z : op.fcoord2(p);
    }

    private static T3 approx0(T3 pt) {
        if (pt != null) {
            pt.x = SymmetryDesc.approx0f(pt.x);
            pt.y = SymmetryDesc.approx0f(pt.y);
            pt.z = SymmetryDesc.approx0f(pt.z);
        }
        return pt;
    }

    private static float approx0f(float x) {
        return Math.abs(x) < 1.0E-4f ? 0.0f : x;
    }

    private static T3 approx(T3 pt) {
        if (pt != null) {
            pt.x = SymmetryOperation.approxF(pt.x);
            pt.y = SymmetryOperation.approxF(pt.y);
            pt.z = SymmetryOperation.approxF(pt.z);
        }
        return pt;
    }

    private Object getSymmetryInfo(SymmetryInterface sym, int iModel, int iatom, SymmetryInterface uc, String xyz, int op, P3 translation, P3 pt, P3 pt2, String id, int type, float scaleFactor, int nth, int options) {
        boolean isList;
        int i;
        P3 offset;
        int returnType = 0;
        Object nullRet = SymmetryDesc.nullReturn(type);
        block0 : switch (type) {
            case 0x400000AA: {
                return "" + uc.getLatticeType();
            }
            case 1073742001: {
                returnType = 1825200146;
                break;
            }
            case 135176: {
                returnType = 135176;
                break;
            }
            case 1275068418: {
                returnType = SymmetryDesc.getType(id);
                switch (returnType) {
                    case 36868: 
                    case 134217751: 
                    case 1073741961: 
                    case 1073742001: 
                    case 1086326789: 
                    case 0x44000001: {
                        type = returnType;
                        break block0;
                    }
                }
                returnType = SymmetryDesc.getKeyType(id);
            }
        }
        BS bsInfo = SymmetryDesc.getInfoBS(returnType);
        int iop = op;
        P3 p3 = offset = options == 1073742066 && (type == 0x44000001 || type == 134217751) ? pt2 : null;
        if (offset != null) {
            pt2 = null;
        }
        Object[] info = null;
        String xyzOriginal = null;
        if (pt2 == null) {
            if (xyz == null) {
                SymmetryOperation[] ops = (SymmetryOperation[])uc.getSymmetryOperations();
                if (ops == null || op == 0 || Math.abs(op) > ops.length) {
                    return nullRet;
                }
                iop = Math.abs(op) - 1;
                xyz = translation == null ? ops[iop].xyz : ops[iop].getxyzTrans(translation);
                xyzOriginal = ops[iop].xyzOriginal;
            } else {
                op = 0;
                iop = 0;
            }
            Symmetry symTemp = new Symmetry();
            symTemp.setSpaceGroup(false);
            boolean isBio = uc.isBio();
            int n = isBio ? symTemp.addBioMoleculeOperation(((SpaceGroup)uc.getSpaceGroup()).finalOperations[iop], op < 0) : (i = symTemp.addSpaceGroupOperation((op < 0 ? "!" : "=") + xyz, Math.abs(op)));
            if (i < 0) {
                return nullRet;
            }
            SymmetryOperation opTemp = (SymmetryOperation)symTemp.getSpaceGroupOperation(i);
            if (xyzOriginal != null) {
                opTemp.xyzOriginal = xyzOriginal;
            }
            opTemp.number = op;
            if (!isBio) {
                opTemp.getCentering();
            }
            if (pt == null && iatom >= 0) {
                pt = this.modelSet.at[iatom];
            }
            if (type == 134217751 || type == 0x44000001) {
                if (isBio) {
                    return nullRet;
                }
                symTemp.setUnitCell(uc);
                pt = P3.newP(pt);
                uc.toFractional(pt, false);
                if (Float.isNaN(pt.x)) {
                    return nullRet;
                }
                P3 sympt = new P3();
                symTemp.newSpaceGroupPoint(pt, i, null, 0, 0, 0, sympt);
                if (options == 1073742066) {
                    uc.unitize(sympt);
                    sympt.add(offset);
                }
                symTemp.toCartesian(sympt, false);
                return type == 0x44000001 ? this.getAtom(uc, iModel, iatom, sympt) : sympt;
            }
            info = this.createInfoArray(opTemp, uc, pt, null, id == null ? "sym" : id, scaleFactor, options, translation != null, bsInfo);
            if (type == 1275068418 && id != null) {
                returnType = SymmetryDesc.getKeyType(id);
            }
        } else {
            String stype = "info";
            boolean asString = false;
            switch (type) {
                case 1275068418: {
                    returnType = SymmetryDesc.getKeyType(id);
                    stype = null;
                    id = null;
                    if (nth != 0) break;
                    nth = -1;
                    break;
                }
                case 1073742001: {
                    stype = null;
                    id = null;
                    if (nth == 0) {
                        nth = -1;
                    }
                    asString = true;
                    bsInfo.set(21);
                    bsInfo.set(0);
                    bsInfo.set(19);
                    break;
                }
                case 135176: {
                    if (id == null) {
                        id = "sym";
                    }
                    stype = "all";
                    asString = true;
                    break;
                }
                case 0x44000001: {
                    stype = null;
                    id = null;
                }
                default: {
                    if (nth != 0) break;
                    nth = 1;
                }
            }
            Object ret1 = this.getSymopInfoForPoints(sym, iModel, op, translation, pt, pt2, id, stype, scaleFactor, nth, options, bsInfo);
            if (asString) {
                return ret1;
            }
            if (ret1 instanceof String) {
                return nullRet;
            }
            info = (Object[])ret1;
            if (type == 0x44000001) {
                if (!(pt instanceof Atom) && !(pt2 instanceof Atom)) {
                    iatom = -1;
                }
                return info == null ? nullRet : this.getAtom(uc, iModel, iatom, (T3)info[7]);
            }
        }
        if (info == null) {
            return nullRet;
        }
        boolean bl = isList = info.length > 0 && info[0] instanceof Object[];
        if (nth < 0 && op <= 0 && (type == 1275068418 || isList)) {
            if (type == 1275068418 && info.length > 0 && !(info[0] instanceof Object[])) {
                info = new Object[]{info};
            }
            Lst<Object> lst = new Lst<Object>();
            for (i = 0; i < info.length; ++i) {
                lst.addLast(SymmetryDesc.getInfo((Object[])info[i], returnType < 0 ? returnType : type));
            }
            return lst;
        }
        if (returnType < 0 && (nth >= 0 || op > 0)) {
            type = returnType;
        }
        if (nth > 0 && isList) {
            info = (Object[])info[0];
        }
        return SymmetryDesc.getInfo(info, type);
    }

    private BS getAtom(SymmetryInterface uc, int iModel, int iAtom, T3 sympt) {
        BS bsElement = null;
        if (iAtom >= 0) {
            bsElement = new BS();
            this.modelSet.getAtomBitsMDa(1094715402, this.modelSet.at[iAtom].getElementNumber(), bsElement);
        }
        BS bsResult = new BS();
        this.modelSet.getAtomsWithin(0.02f, sympt, bsResult, iModel);
        if (bsElement != null) {
            bsResult.and(bsElement);
        }
        if (bsResult.isEmpty()) {
            sympt = P3.newP(sympt);
            uc.toUnitCell(sympt, null);
            uc.toCartesian(sympt, false);
            this.modelSet.getAtomsWithin(0.02f, sympt, bsResult, iModel);
            if (bsElement != null) {
                bsResult.and(bsElement);
            }
        }
        return bsResult;
    }

    Object getSymopInfoForPoints(SymmetryInterface sym, int modelIndex, int symOp, P3 translation, P3 pt1, P3 pt2, String drawID, String stype, float scaleFactor, int nth, int options, BS bsInfo) {
        boolean asString = bsInfo.get(21) || bsInfo.get(3) && bsInfo.cardinality() == 3;
        bsInfo.clear(21);
        String ret = asString ? "" : null;
        Map<String, Object> sginfo = this.getSpaceGroupInfo(sym, modelIndex, null, symOp, pt1, pt2, drawID, scaleFactor, nth, false, true, options, null, bsInfo);
        if (sginfo == null) {
            return ret;
        }
        Object[][] infolist = (Object[][])sginfo.get("operations");
        if (infolist == null) {
            return ret;
        }
        SB sb = asString ? new SB() : null;
        boolean isAll = !asString && --symOp < 0;
        String strOperations = (String)sginfo.get("symmetryInfo");
        boolean labelOnly = "label".equals(stype);
        int n = 0;
        for (int i = 0; i < infolist.length; ++i) {
            if (infolist[i] == null || symOp >= 0 && symOp != i) continue;
            if (!asString) {
                if (!isAll) {
                    return infolist[i];
                }
                infolist[n++] = infolist[i];
                continue;
            }
            if (drawID != null) {
                return (String)infolist[i][3] + "\nprint " + PT.esc(strOperations);
            }
            if (sb.length() > 0) {
                sb.appendC('\n');
            }
            if (!labelOnly) {
                if (symOp < 0) {
                    sb.appendI(i + 1).appendC('\t');
                }
                sb.append((String)infolist[i][0]).appendC('\t');
            }
            sb.append((String)infolist[i][2]);
        }
        if (!asString) {
            Object[] a = new Object[n];
            for (int i = 0; i < n; ++i) {
                a[i] = infolist[i];
            }
            return a;
        }
        if (sb.length() == 0) {
            return drawID != null ? "draw " + drawID + "* delete" : ret;
        }
        return sb.toString();
    }

    Object getSymopInfo(int iAtom, String xyz, int op, P3 translation, P3 pt, P3 pt2, String id, int type, float scaleFactor, int nth, int options) {
        Object ret;
        if (type == 0) {
            type = SymmetryDesc.getType(id);
        }
        Object object = ret = type == 0x44000001 ? new BS() : "";
        if (iAtom < 0) {
            return ret;
        }
        short iModel = this.modelSet.at[iAtom].mi;
        SymmetryInterface uc = this.modelSet.am[iModel].biosymmetry;
        if (uc == null && (uc = this.modelSet.getUnitCell(iModel)) == null) {
            return ret;
        }
        if (type != 135176 || op != Integer.MAX_VALUE) {
            return this.getSymmetryInfo(uc, iModel, iAtom, uc, xyz, op, translation, pt, pt2, id, type, scaleFactor, nth, options);
        }
        String s = "";
        M4[] ops = uc.getSymmetryOperations();
        if (ops != null) {
            if (id == null) {
                id = "sg";
            }
            int n = ops.length;
            for (op = 1; op <= n; ++op) {
                s = s + (String)this.getSymmetryInfo(uc, iModel, iAtom, uc, xyz, op, translation, pt, pt2, id + op, 135176, scaleFactor, nth, options);
            }
        }
        return s;
    }

    Map<String, Object> getSpaceGroupInfo(SymmetryInterface sym, int modelIndex, String sgName, int symOp, P3 pt1, P3 pt2, String drawID, float scaleFactor, int nth, boolean isFull, boolean isForModel, int options, SymmetryInterface cellInfo, BS bsInfo) {
        Object data;
        boolean haveRawName;
        if (bsInfo == null) {
            bsInfo = new BS();
            bsInfo.setBits(0, keys.length);
            bsInfo.clear(19);
        }
        boolean matrixOnly = bsInfo.cardinality() == 1 && bsInfo.get(10);
        Map<String, Object> info = null;
        boolean isStandard = !matrixOnly && pt1 == null && drawID == null && nth <= 0 && bsInfo.cardinality() >= keys.length;
        boolean isBio = false;
        String sgNote = null;
        boolean haveName = sgName != null && sgName.length() > 0;
        boolean bl = haveRawName = haveName && sgName.indexOf("[--]") >= 0;
        if (isForModel || !haveName) {
            boolean saveModelInfo;
            boolean bl2 = saveModelInfo = isStandard && symOp == 0;
            if (matrixOnly) {
                cellInfo = sym;
            } else {
                if (modelIndex < 0) {
                    modelIndex = pt1 instanceof Atom ? ((Atom)pt1).mi : this.modelSet.vwr.am.cmi;
                }
                if (modelIndex < 0) {
                    sgNote = "no single current model";
                } else if (cellInfo == null && !(isBio = (cellInfo = this.modelSet.am[modelIndex].biosymmetry) != null) && (cellInfo = this.modelSet.getUnitCell(modelIndex)) == null) {
                    sgNote = "not applicable";
                }
                if (sgNote != null) {
                    info = new Hashtable();
                    info.put("spaceGroupInfo", "");
                    info.put("spaceGroupNote", sgNote);
                    info.put("symmetryInfo", "");
                } else if (isStandard) {
                    info = (Map)this.modelSet.getInfo(modelIndex, "spaceGroupInfo");
                }
                if (info != null) {
                    return info;
                }
                sgName = cellInfo.getSpaceGroupName();
            }
            info = new Hashtable();
            SymmetryOperation[] ops = (SymmetryOperation[])cellInfo.getSymmetryOperations();
            SpaceGroup sg = isBio ? ((Symmetry)cellInfo).spaceGroup : null;
            String slist = haveRawName ? "" : null;
            int opCount = 0;
            if (ops != null) {
                if (!matrixOnly) {
                    if (isBio) {
                        sym.setSpaceGroupTo(SpaceGroup.getNull(false, false, false));
                    } else {
                        sym.setSpaceGroup(false);
                    }
                }
                if (ops[0].timeReversal != 0) {
                    ((SymmetryOperation)sym.getSpaceGroupOperation((int)0)).timeReversal = 1;
                }
                Object[][] infolist = new Object[ops.length][];
                String sops = "";
                int nop = 0;
                for (int i = 0; i < ops.length && nop != nth; ++i) {
                    Object[] ret;
                    int iop;
                    SymmetryOperation op = ops[i];
                    String xyzOriginal = op.xyzOriginal;
                    if (matrixOnly) {
                        iop = i;
                    } else {
                        boolean isNewIncomm;
                        boolean bl3 = isNewIncomm = i == 0 && op.xyz.indexOf("x4") >= 0;
                        int n = !isNewIncomm && sym.getSpaceGroupOperation(i) != null ? i : (iop = isBio ? sym.addBioMoleculeOperation(sg.finalOperations[i], false) : sym.addSpaceGroupOperation("=" + op.xyz, i + 1));
                        if (iop < 0 || (op = (SymmetryOperation)sym.getSpaceGroupOperation(i)) == null) continue;
                        op.xyzOriginal = xyzOriginal;
                    }
                    if (op.timeReversal != 0 || op.modDim > 0) {
                        isStandard = false;
                    }
                    if (slist != null) {
                        slist = slist + ";" + op.xyz;
                    }
                    Object[] objectArray = ret = symOp > 0 && symOp - 1 != iop ? null : this.createInfoArray(op, cellInfo, pt1, pt2, drawID, scaleFactor, options, false, bsInfo);
                    if (ret == null || nth > 0 && ++nop != nth) continue;
                    infolist[i] = ret;
                    if (!matrixOnly) {
                        sops = sops + "\n" + (i + 1) + "\t" + ret[bsInfo.get(19) ? 19 : 0] + "\t" + ret[2];
                    }
                    ++opCount;
                }
                info.put("operations", infolist);
                if (!matrixOnly) {
                    info.put("symmetryInfo", sops.length() == 0 ? "" : sops.substring(1));
                }
            }
            if (matrixOnly) {
                return info;
            }
            String string = opCount == 0 ? "\n no symmetry operations" : (nth <= 0 && symOp <= 0 ? "\n" + opCount + " symmetry operation" + (opCount == 1 ? ":\n" : "s:\n") : (sgNote = ""));
            if (slist != null) {
                sgName = slist.substring(slist.indexOf(";") + 1);
            }
            if (saveModelInfo) {
                this.modelSet.setInfo(modelIndex, "spaceGroupInfo", info);
            }
        } else {
            info = new Hashtable<String, Object>();
        }
        info.put("spaceGroupName", sgName);
        info.put("spaceGroupNote", sgNote == null ? "" : sgNote);
        if (isBio) {
            data = sgName;
        } else {
            if (haveName && !haveRawName) {
                sym.setSpaceGroupName(sgName);
            }
            if ((data = sym.getSpaceGroupInfoObj(sgName, cellInfo == null ? null : cellInfo.getUnitCellParams(), isFull, !isForModel)) == null || data.equals("?")) {
                data = "?";
                info.put("spaceGroupNote", "could not identify space group from name: " + sgName + "\nformat: show spacegroup \"2\" or \"P 2c\" or \"C m m m\" or \"x, y, z;-x ,-y, -z\"");
            }
        }
        info.put("spaceGroupInfo", data);
        return info;
    }

    public M4 getTransform(UnitCell uc, SymmetryOperation[] ops, P3 fracA, P3 fracB, boolean best) {
        if (pta01 == null) {
            pta01 = new P3();
            pta02 = new P3();
            ptemp = new P3();
            vtrans = new V3();
        }
        pta02.setT(fracB);
        vtrans.setT(pta02);
        uc.unitize(pta02);
        float dmin = Float.MAX_VALUE;
        int imin = -1;
        int n = ops.length;
        for (int i = 0; i < n; ++i) {
            SymmetryOperation op = ops[i];
            pta01.setT(fracA);
            op.rotTrans(pta01);
            ptemp.setT(pta01);
            uc.unitize(pta01);
            float d = pta01.distanceSquared(pta02);
            if (d < 1.96E-6f) {
                vtrans.sub(ptemp);
                uc.normalize(vtrans);
                M4 m2 = M4.newM4(op);
                m2.add(vtrans);
                pta01.setT(fracA);
                m2.rotTrans(pta01);
                uc.unitize(pta01);
                d = pta01.distanceSquared(pta02);
                if (d >= 1.96E-6f) continue;
                return m2;
            }
            if (!(d < dmin)) continue;
            dmin = d;
            imin = i;
        }
        if (best) {
            SymmetryOperation op = ops[imin];
            pta01.setT(fracA);
            op.rotTrans(pta01);
            uc.unitize(pta01);
            System.err.println("" + imin + " " + pta01.distance(pta02) + " " + pta01 + " " + pta02 + " " + V3.newVsub(pta02, pta01));
        }
        return null;
    }
}

