/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.compiler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.types.ArrayUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.visitors.FirVisitorVoid;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\u0004\u0018\u00010\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a8\u0006\u0005"}, d2={"findMainClass", "Lorg/jetbrains/kotlin/name/FqName;", "fir", "", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "cli"})
public final class FirKotlinToJvmBytecodeCompilerKt {
    @Nullable
    public static final FqName findMainClass(@NotNull List<? extends FirFile> fir) {
        Intrinsics.checkNotNullParameter(fir, "fir");
        List compatibleClasses = new ArrayList();
        FirVisitorVoid visitor2 = new FirVisitorVoid(compatibleClasses){
            public FirFile file;
            final /* synthetic */ List $compatibleClasses;

            @NotNull
            public final FirFile getFile() {
                FirFile firFile = this.file;
                if (firFile == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("file");
                }
                return firFile;
            }

            public final void setFile(@NotNull FirFile firFile) {
                Intrinsics.checkNotNullParameter(firFile, "<set-?>");
                this.file = firFile;
            }

            public void visitElement(@NotNull FirElement element) {
                Intrinsics.checkNotNullParameter(element, "element");
            }

            public void visitFile(@NotNull FirFile file2) {
                Intrinsics.checkNotNullParameter(file2, "file");
                this.file = file2;
                file2.acceptChildren(this);
            }

            /*
             * WARNING - void declaration
             */
            public void visitSimpleFunction(@NotNull FirSimpleFunction simpleFunction) {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter(simpleFunction, "simpleFunction");
                if (Intrinsics.areEqual(simpleFunction.getName().asString(), "main") ^ true) {
                    return;
                }
                Collection collection = simpleFunction.getTypeParameters();
                if (!collection.isEmpty()) {
                    return;
                }
                switch (simpleFunction.getValueParameters().size()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        ConeKotlinType parameterType = FirTypeUtilsKt.getConeType(CollectionsKt.single(simpleFunction.getValueParameters()).getReturnTypeRef());
                        if (ConeBuiltinTypeUtilsKt.isArrayType(parameterType)) {
                            ConeKotlinType coneKotlinType = ArrayUtilsKt.arrayElementType(parameterType);
                            if (coneKotlinType != null && ConeBuiltinTypeUtilsKt.isString(coneKotlinType)) break;
                        }
                        return;
                    }
                    default: {
                        return;
                    }
                }
                collection = this.$compatibleClasses;
                FirFile firFile = this.file;
                if (firFile == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("file");
                }
                List<Name> list2 = UtilsKt.getPackageFqName(firFile).pathSegments();
                Intrinsics.checkNotNullExpressionValue(list2, "file.packageFqName.pathSegments()");
                Iterable $this$map$iv = list2;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Name name = (Name)item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    boolean bl = false;
                    String string2 = it.asString();
                    collection2.add(string2);
                }
                Collection collection3 = (List)destination$iv$iv;
                StringBuilder stringBuilder2 = new StringBuilder();
                FirFile firFile2 = this.file;
                if (firFile2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("file");
                }
                FqName fqName2 = FqName.fromSegments(CollectionsKt.plus(collection3, stringBuilder2.append(StringsKt.capitalize(StringsKt.removeSuffix(firFile2.getName(), (CharSequence)".kt"))).append("Kt").toString()));
                collection.add(fqName2);
            }
            {
                this.$compatibleClasses = $captured_local_variable$0;
            }
        };
        Iterable $this$forEach$iv = fir;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirFile it = (FirFile)element$iv;
            boolean bl = false;
            it.accept(visitor2);
        }
        return (FqName)CollectionsKt.singleOrNull(compatibleClasses);
    }
}

