#define _CFFI_

/* We try to define Py_LIMITED_API before including Python.h.

   Mess: we can only define it if Py_DEBUG, Py_TRACE_REFS and
   Py_REF_DEBUG are not defined.  This is a best-effort approximation:
   we can learn about Py_DEBUG from pyconfig.h, but it is unclear if
   the same works for the other two macros.  Py_DEBUG implies them,
   but not the other way around.

   The implementation is messy (issue #350): on Windows, with _MSC_VER,
   we have to define Py_LIMITED_API even before including pyconfig.h.
   In that case, we guess what pyconfig.h will do to the macros above,
   and check our guess after the #include.

   Note that on Windows, with CPython 3.x, you need >= 3.5 and virtualenv
   version >= 16.0.0.  With older versions of either, you don't get a
   copy of PYTHON3.DLL in the virtualenv.  We can't check the version of
   CPython *before* we even include pyconfig.h.  ffi.set_source() puts
   a ``#define _CFFI_NO_LIMITED_API'' at the start of this file if it is
   running on Windows < 3.5, as an attempt at fixing it, but that's
   arguably wrong because it may not be the target version of Python.
   Still better than nothing I guess.  As another workaround, you can
   remove the definition of Py_LIMITED_API here.

   See also 'py_limited_api' in cffi/setuptools_ext.py.
*/
#if !defined(_CFFI_USE_EMBEDDING) && !defined(Py_LIMITED_API)
#  ifdef _MSC_VER
#    if !defined(_DEBUG) && !defined(Py_DEBUG) && !defined(Py_TRACE_REFS) && !defined(Py_REF_DEBUG) && !defined(_CFFI_NO_LIMITED_API)
#      define Py_LIMITED_API
#    endif
#    include <pyconfig.h>
     /* sanity-check: Py_LIMITED_API will cause crashes if any of these
        are also defined.  Normally, the Python file PC/pyconfig.h does not
        cause any of these to be defined, with the exception that _DEBUG
        causes Py_DEBUG.  Double-check that. */
#    ifdef Py_LIMITED_API
#      if defined(Py_DEBUG)
#        error "pyconfig.h unexpectedly defines Py_DEBUG, but Py_LIMITED_API is set"
#      endif
#      if defined(Py_TRACE_REFS)
#        error "pyconfig.h unexpectedly defines Py_TRACE_REFS, but Py_LIMITED_API is set"
#      endif
#      if defined(Py_REF_DEBUG)
#        error "pyconfig.h unexpectedly defines Py_REF_DEBUG, but Py_LIMITED_API is set"
#      endif
#    endif
#  else
#    include <pyconfig.h>
#    if !defined(Py_DEBUG) && !defined(Py_TRACE_REFS) && !defined(Py_REF_DEBUG) && !defined(_CFFI_NO_LIMITED_API)
#      define Py_LIMITED_API
#    endif
#  endif
#endif

#include <Python.h>
#ifdef __cplusplus
extern "C" {
#endif
#include <stddef.h>

/* This part is from file 'cffi/parse_c_type.h'.  It is copied at the
   beginning of C sources generated by CFFI's ffi.set_source(). */

typedef void *_cffi_opcode_t;

#define _CFFI_OP(opcode, arg)   (_cffi_opcode_t)(opcode | (((uintptr_t)(arg)) << 8))
#define _CFFI_GETOP(cffi_opcode)    ((unsigned char)(uintptr_t)cffi_opcode)
#define _CFFI_GETARG(cffi_opcode)   (((intptr_t)cffi_opcode) >> 8)

#define _CFFI_OP_PRIMITIVE       1
#define _CFFI_OP_POINTER         3
#define _CFFI_OP_ARRAY           5
#define _CFFI_OP_OPEN_ARRAY      7
#define _CFFI_OP_STRUCT_UNION    9
#define _CFFI_OP_ENUM           11
#define _CFFI_OP_FUNCTION       13
#define _CFFI_OP_FUNCTION_END   15
#define _CFFI_OP_NOOP           17
#define _CFFI_OP_BITFIELD       19
#define _CFFI_OP_TYPENAME       21
#define _CFFI_OP_CPYTHON_BLTN_V 23   // varargs
#define _CFFI_OP_CPYTHON_BLTN_N 25   // noargs
#define _CFFI_OP_CPYTHON_BLTN_O 27   // O  (i.e. a single arg)
#define _CFFI_OP_CONSTANT       29
#define _CFFI_OP_CONSTANT_INT   31
#define _CFFI_OP_GLOBAL_VAR     33
#define _CFFI_OP_DLOPEN_FUNC    35
#define _CFFI_OP_DLOPEN_CONST   37
#define _CFFI_OP_GLOBAL_VAR_F   39
#define _CFFI_OP_EXTERN_PYTHON  41

#define _CFFI_PRIM_VOID          0
#define _CFFI_PRIM_BOOL          1
#define _CFFI_PRIM_CHAR          2
#define _CFFI_PRIM_SCHAR         3
#define _CFFI_PRIM_UCHAR         4
#define _CFFI_PRIM_SHORT         5
#define _CFFI_PRIM_USHORT        6
#define _CFFI_PRIM_INT           7
#define _CFFI_PRIM_UINT          8
#define _CFFI_PRIM_LONG          9
#define _CFFI_PRIM_ULONG        10
#define _CFFI_PRIM_LONGLONG     11
#define _CFFI_PRIM_ULONGLONG    12
#define _CFFI_PRIM_FLOAT        13
#define _CFFI_PRIM_DOUBLE       14
#define _CFFI_PRIM_LONGDOUBLE   15

#define _CFFI_PRIM_WCHAR        16
#define _CFFI_PRIM_INT8         17
#define _CFFI_PRIM_UINT8        18
#define _CFFI_PRIM_INT16        19
#define _CFFI_PRIM_UINT16       20
#define _CFFI_PRIM_INT32        21
#define _CFFI_PRIM_UINT32       22
#define _CFFI_PRIM_INT64        23
#define _CFFI_PRIM_UINT64       24
#define _CFFI_PRIM_INTPTR       25
#define _CFFI_PRIM_UINTPTR      26
#define _CFFI_PRIM_PTRDIFF      27
#define _CFFI_PRIM_SIZE         28
#define _CFFI_PRIM_SSIZE        29
#define _CFFI_PRIM_INT_LEAST8   30
#define _CFFI_PRIM_UINT_LEAST8  31
#define _CFFI_PRIM_INT_LEAST16  32
#define _CFFI_PRIM_UINT_LEAST16 33
#define _CFFI_PRIM_INT_LEAST32  34
#define _CFFI_PRIM_UINT_LEAST32 35
#define _CFFI_PRIM_INT_LEAST64  36
#define _CFFI_PRIM_UINT_LEAST64 37
#define _CFFI_PRIM_INT_FAST8    38
#define _CFFI_PRIM_UINT_FAST8   39
#define _CFFI_PRIM_INT_FAST16   40
#define _CFFI_PRIM_UINT_FAST16  41
#define _CFFI_PRIM_INT_FAST32   42
#define _CFFI_PRIM_UINT_FAST32  43
#define _CFFI_PRIM_INT_FAST64   44
#define _CFFI_PRIM_UINT_FAST64  45
#define _CFFI_PRIM_INTMAX       46
#define _CFFI_PRIM_UINTMAX      47
#define _CFFI_PRIM_FLOATCOMPLEX 48
#define _CFFI_PRIM_DOUBLECOMPLEX 49
#define _CFFI_PRIM_CHAR16       50
#define _CFFI_PRIM_CHAR32       51

#define _CFFI__NUM_PRIM         52
#define _CFFI__UNKNOWN_PRIM           (-1)
#define _CFFI__UNKNOWN_FLOAT_PRIM     (-2)
#define _CFFI__UNKNOWN_LONG_DOUBLE    (-3)

#define _CFFI__IO_FILE_STRUCT         (-1)


struct _cffi_global_s {
    const char *name;
    void *address;
    _cffi_opcode_t type_op;
    void *size_or_direct_fn;  // OP_GLOBAL_VAR: size, or 0 if unknown
                              // OP_CPYTHON_BLTN_*: addr of direct function
};

struct _cffi_getconst_s {
    unsigned long long value;
    const struct _cffi_type_context_s *ctx;
    int gindex;
};

struct _cffi_struct_union_s {
    const char *name;
    int type_index;          // -> _cffi_types, on a OP_STRUCT_UNION
    int flags;               // _CFFI_F_* flags below
    size_t size;
    int alignment;
    int first_field_index;   // -> _cffi_fields array
    int num_fields;
};
#define _CFFI_F_UNION         0x01   // is a union, not a struct
#define _CFFI_F_CHECK_FIELDS  0x02   // complain if fields are not in the
                                     // "standard layout" or if some are missing
#define _CFFI_F_PACKED        0x04   // for CHECK_FIELDS, assume a packed struct
#define _CFFI_F_EXTERNAL      0x08   // in some other ffi.include()
#define _CFFI_F_OPAQUE        0x10   // opaque

struct _cffi_field_s {
    const char *name;
    size_t field_offset;
    size_t field_size;
    _cffi_opcode_t field_type_op;
};

struct _cffi_enum_s {
    const char *name;
    int type_index;          // -> _cffi_types, on a OP_ENUM
    int type_prim;           // _CFFI_PRIM_xxx
    const char *enumerators; // comma-delimited string
};

struct _cffi_typename_s {
    const char *name;
    int type_index;   /* if opaque, points to a possibly artificial
                         OP_STRUCT which is itself opaque */
};

struct _cffi_type_context_s {
    _cffi_opcode_t *types;
    const struct _cffi_global_s *globals;
    const struct _cffi_field_s *fields;
    const struct _cffi_struct_union_s *struct_unions;
    const struct _cffi_enum_s *enums;
    const struct _cffi_typename_s *typenames;
    int num_globals;
    int num_struct_unions;
    int num_enums;
    int num_typenames;
    const char *const *includes;
    int num_types;
    int flags;      /* future extension */
};

struct _cffi_parse_info_s {
    const struct _cffi_type_context_s *ctx;
    _cffi_opcode_t *output;
    unsigned int output_size;
    size_t error_location;
    const char *error_message;
};

struct _cffi_externpy_s {
    const char *name;
    size_t size_of_result;
    void *reserved1, *reserved2;
};

#ifdef _CFFI_INTERNAL
static int parse_c_type(struct _cffi_parse_info_s *info, const char *input);
static int search_in_globals(const struct _cffi_type_context_s *ctx,
                             const char *search, size_t search_len);
static int search_in_struct_unions(const struct _cffi_type_context_s *ctx,
                                   const char *search, size_t search_len);
#endif

/* this block of #ifs should be kept exactly identical between
   c/_cffi_backend.c, cffi/vengine_cpy.py, cffi/vengine_gen.py
   and cffi/_cffi_include.h */
#if defined(_MSC_VER)
# include <malloc.h>   /* for alloca() */
# if _MSC_VER < 1600   /* MSVC < 2010 */
   typedef __int8 int8_t;
   typedef __int16 int16_t;
   typedef __int32 int32_t;
   typedef __int64 int64_t;
   typedef unsigned __int8 uint8_t;
   typedef unsigned __int16 uint16_t;
   typedef unsigned __int32 uint32_t;
   typedef unsigned __int64 uint64_t;
   typedef __int8 int_least8_t;
   typedef __int16 int_least16_t;
   typedef __int32 int_least32_t;
   typedef __int64 int_least64_t;
   typedef unsigned __int8 uint_least8_t;
   typedef unsigned __int16 uint_least16_t;
   typedef unsigned __int32 uint_least32_t;
   typedef unsigned __int64 uint_least64_t;
   typedef __int8 int_fast8_t;
   typedef __int16 int_fast16_t;
   typedef __int32 int_fast32_t;
   typedef __int64 int_fast64_t;
   typedef unsigned __int8 uint_fast8_t;
   typedef unsigned __int16 uint_fast16_t;
   typedef unsigned __int32 uint_fast32_t;
   typedef unsigned __int64 uint_fast64_t;
   typedef __int64 intmax_t;
   typedef unsigned __int64 uintmax_t;
# else
#  include <stdint.h>
# endif
# if _MSC_VER < 1800   /* MSVC < 2013 */
#  ifndef __cplusplus
    typedef unsigned char _Bool;
#  endif
# endif
#else
# include <stdint.h>
# if (defined (__SVR4) && defined (__sun)) || defined(_AIX) || defined(__hpux)
#  include <alloca.h>
# endif
#endif

#ifdef __GNUC__
# define _CFFI_UNUSED_FN  __attribute__((unused))
#else
# define _CFFI_UNUSED_FN  /* nothing */
#endif

#ifdef __cplusplus
# ifndef _Bool
   typedef bool _Bool;   /* semi-hackish: C++ has no _Bool; bool is builtin */
# endif
#endif

/**********  CPython-specific section  **********/
#ifndef PYPY_VERSION


#if PY_MAJOR_VERSION >= 3
# define PyInt_FromLong PyLong_FromLong
#endif

#define _cffi_from_c_double PyFloat_FromDouble
#define _cffi_from_c_float PyFloat_FromDouble
#define _cffi_from_c_long PyInt_FromLong
#define _cffi_from_c_ulong PyLong_FromUnsignedLong
#define _cffi_from_c_longlong PyLong_FromLongLong
#define _cffi_from_c_ulonglong PyLong_FromUnsignedLongLong
#define _cffi_from_c__Bool PyBool_FromLong

#define _cffi_to_c_double PyFloat_AsDouble
#define _cffi_to_c_float PyFloat_AsDouble

#define _cffi_from_c_int(x, type)                                        \
    (((type)-1) > 0 ? /* unsigned */                                     \
        (sizeof(type) < sizeof(long) ?                                   \
            PyInt_FromLong((long)x) :                                    \
         sizeof(type) == sizeof(long) ?                                  \
            PyLong_FromUnsignedLong((unsigned long)x) :                  \
            PyLong_FromUnsignedLongLong((unsigned long long)x)) :        \
        (sizeof(type) <= sizeof(long) ?                                  \
            PyInt_FromLong((long)x) :                                    \
            PyLong_FromLongLong((long long)x)))

#define _cffi_to_c_int(o, type)                                          \
    ((type)(                                                             \
     sizeof(type) == 1 ? (((type)-1) > 0 ? (type)_cffi_to_c_u8(o)        \
                                         : (type)_cffi_to_c_i8(o)) :     \
     sizeof(type) == 2 ? (((type)-1) > 0 ? (type)_cffi_to_c_u16(o)       \
                                         : (type)_cffi_to_c_i16(o)) :    \
     sizeof(type) == 4 ? (((type)-1) > 0 ? (type)_cffi_to_c_u32(o)       \
                                         : (type)_cffi_to_c_i32(o)) :    \
     sizeof(type) == 8 ? (((type)-1) > 0 ? (type)_cffi_to_c_u64(o)       \
                                         : (type)_cffi_to_c_i64(o)) :    \
     (Py_FatalError("unsupported size for type " #type), (type)0)))

#define _cffi_to_c_i8                                                    \
                 ((int(*)(PyObject *))_cffi_exports[1])
#define _cffi_to_c_u8                                                    \
                 ((int(*)(PyObject *))_cffi_exports[2])
#define _cffi_to_c_i16                                                   \
                 ((int(*)(PyObject *))_cffi_exports[3])
#define _cffi_to_c_u16                                                   \
                 ((int(*)(PyObject *))_cffi_exports[4])
#define _cffi_to_c_i32                                                   \
                 ((int(*)(PyObject *))_cffi_exports[5])
#define _cffi_to_c_u32                                                   \
                 ((unsigned int(*)(PyObject *))_cffi_exports[6])
#define _cffi_to_c_i64                                                   \
                 ((long long(*)(PyObject *))_cffi_exports[7])
#define _cffi_to_c_u64                                                   \
                 ((unsigned long long(*)(PyObject *))_cffi_exports[8])
#define _cffi_to_c_char                                                  \
                 ((int(*)(PyObject *))_cffi_exports[9])
#define _cffi_from_c_pointer                                             \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[10])
#define _cffi_to_c_pointer                                               \
    ((char *(*)(PyObject *, struct _cffi_ctypedescr *))_cffi_exports[11])
#define _cffi_get_struct_layout                                          \
    not used any more
#define _cffi_restore_errno                                              \
    ((void(*)(void))_cffi_exports[13])
#define _cffi_save_errno                                                 \
    ((void(*)(void))_cffi_exports[14])
#define _cffi_from_c_char                                                \
    ((PyObject *(*)(char))_cffi_exports[15])
#define _cffi_from_c_deref                                               \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[16])
#define _cffi_to_c                                                       \
    ((int(*)(char *, struct _cffi_ctypedescr *, PyObject *))_cffi_exports[17])
#define _cffi_from_c_struct                                              \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[18])
#define _cffi_to_c_wchar_t                                               \
    ((_cffi_wchar_t(*)(PyObject *))_cffi_exports[19])
#define _cffi_from_c_wchar_t                                             \
    ((PyObject *(*)(_cffi_wchar_t))_cffi_exports[20])
#define _cffi_to_c_long_double                                           \
    ((long double(*)(PyObject *))_cffi_exports[21])
#define _cffi_to_c__Bool                                                 \
    ((_Bool(*)(PyObject *))_cffi_exports[22])
#define _cffi_prepare_pointer_call_argument                              \
    ((Py_ssize_t(*)(struct _cffi_ctypedescr *,                           \
                    PyObject *, char **))_cffi_exports[23])
#define _cffi_convert_array_from_object                                  \
    ((int(*)(char *, struct _cffi_ctypedescr *, PyObject *))_cffi_exports[24])
#define _CFFI_CPIDX  25
#define _cffi_call_python                                                \
    ((void(*)(struct _cffi_externpy_s *, char *))_cffi_exports[_CFFI_CPIDX])
#define _cffi_to_c_wchar3216_t                                           \
    ((int(*)(PyObject *))_cffi_exports[26])
#define _cffi_from_c_wchar3216_t                                         \
    ((PyObject *(*)(int))_cffi_exports[27])
#define _CFFI_NUM_EXPORTS 28

struct _cffi_ctypedescr;

static void *_cffi_exports[_CFFI_NUM_EXPORTS];

#define _cffi_type(index)   (                           \
    assert((((uintptr_t)_cffi_types[index]) & 1) == 0), \
    (struct _cffi_ctypedescr *)_cffi_types[index])

static PyObject *_cffi_init(const char *module_name, Py_ssize_t version,
                            const struct _cffi_type_context_s *ctx)
{
    PyObject *module, *o_arg, *new_module;
    void *raw[] = {
        (void *)module_name,
        (void *)version,
        (void *)_cffi_exports,
        (void *)ctx,
    };

    module = PyImport_ImportModule("_cffi_backend");
    if (module == NULL)
        goto failure;

    o_arg = PyLong_FromVoidPtr((void *)raw);
    if (o_arg == NULL)
        goto failure;

    new_module = PyObject_CallMethod(
        module, (char *)"_init_cffi_1_0_external_module", (char *)"O", o_arg);

    Py_DECREF(o_arg);
    Py_DECREF(module);
    return new_module;

  failure:
    Py_XDECREF(module);
    return NULL;
}


#ifdef HAVE_WCHAR_H
typedef wchar_t _cffi_wchar_t;
#else
typedef uint16_t _cffi_wchar_t;   /* same random pick as _cffi_backend.c */
#endif

_CFFI_UNUSED_FN static uint16_t _cffi_to_c_char16_t(PyObject *o)
{
    if (sizeof(_cffi_wchar_t) == 2)
        return (uint16_t)_cffi_to_c_wchar_t(o);
    else
        return (uint16_t)_cffi_to_c_wchar3216_t(o);
}

_CFFI_UNUSED_FN static PyObject *_cffi_from_c_char16_t(uint16_t x)
{
    if (sizeof(_cffi_wchar_t) == 2)
        return _cffi_from_c_wchar_t((_cffi_wchar_t)x);
    else
        return _cffi_from_c_wchar3216_t((int)x);
}

_CFFI_UNUSED_FN static int _cffi_to_c_char32_t(PyObject *o)
{
    if (sizeof(_cffi_wchar_t) == 4)
        return (int)_cffi_to_c_wchar_t(o);
    else
        return (int)_cffi_to_c_wchar3216_t(o);
}

_CFFI_UNUSED_FN static PyObject *_cffi_from_c_char32_t(unsigned int x)
{
    if (sizeof(_cffi_wchar_t) == 4)
        return _cffi_from_c_wchar_t((_cffi_wchar_t)x);
    else
        return _cffi_from_c_wchar3216_t((int)x);
}

union _cffi_union_alignment_u {
    unsigned char m_char;
    unsigned short m_short;
    unsigned int m_int;
    unsigned long m_long;
    unsigned long long m_longlong;
    float m_float;
    double m_double;
    long double m_longdouble;
};

struct _cffi_freeme_s {
    struct _cffi_freeme_s *next;
    union _cffi_union_alignment_u alignment;
};

_CFFI_UNUSED_FN static int
_cffi_convert_array_argument(struct _cffi_ctypedescr *ctptr, PyObject *arg,
                             char **output_data, Py_ssize_t datasize,
                             struct _cffi_freeme_s **freeme)
{
    char *p;
    if (datasize < 0)
        return -1;

    p = *output_data;
    if (p == NULL) {
        struct _cffi_freeme_s *fp = (struct _cffi_freeme_s *)PyObject_Malloc(
            offsetof(struct _cffi_freeme_s, alignment) + (size_t)datasize);
        if (fp == NULL)
            return -1;
        fp->next = *freeme;
        *freeme = fp;
        p = *output_data = (char *)&fp->alignment;
    }
    memset((void *)p, 0, (size_t)datasize);
    return _cffi_convert_array_from_object(p, ctptr, arg);
}

_CFFI_UNUSED_FN static void
_cffi_free_array_arguments(struct _cffi_freeme_s *freeme)
{
    do {
        void *p = (void *)freeme;
        freeme = freeme->next;
        PyObject_Free(p);
    } while (freeme != NULL);
}

/**********  end CPython-specific section  **********/
#else
_CFFI_UNUSED_FN
static void (*_cffi_call_python_org)(struct _cffi_externpy_s *, char *);
# define _cffi_call_python  _cffi_call_python_org
#endif


#define _cffi_array_len(array)   (sizeof(array) / sizeof((array)[0]))

#define _cffi_prim_int(size, sign)                                      \
    ((size) == 1 ? ((sign) ? _CFFI_PRIM_INT8  : _CFFI_PRIM_UINT8)  :    \
     (size) == 2 ? ((sign) ? _CFFI_PRIM_INT16 : _CFFI_PRIM_UINT16) :    \
     (size) == 4 ? ((sign) ? _CFFI_PRIM_INT32 : _CFFI_PRIM_UINT32) :    \
     (size) == 8 ? ((sign) ? _CFFI_PRIM_INT64 : _CFFI_PRIM_UINT64) :    \
     _CFFI__UNKNOWN_PRIM)

#define _cffi_prim_float(size)                                          \
    ((size) == sizeof(float) ? _CFFI_PRIM_FLOAT :                       \
     (size) == sizeof(double) ? _CFFI_PRIM_DOUBLE :                     \
     (size) == sizeof(long double) ? _CFFI__UNKNOWN_LONG_DOUBLE :       \
     _CFFI__UNKNOWN_FLOAT_PRIM)

#define _cffi_check_int(got, got_nonpos, expected)      \
    ((got_nonpos) == (expected <= 0) &&                 \
     (got) == (unsigned long long)expected)

#ifdef MS_WIN32
# define _cffi_stdcall  __stdcall
#else
# define _cffi_stdcall  /* nothing */
#endif

#ifdef __cplusplus
}
#endif

/************************************************************/


        #include <olm/olm.h>
        #include <olm/inbound_group_session.h>
        #include <olm/outbound_group_session.h>
        #include <olm/pk.h>
        #include <olm/sas.h>
    

/************************************************************/

static void *_cffi_types[] = {
/*  0 */ _CFFI_OP(_CFFI_OP_FUNCTION, 94), // OlmAccount *()(void *)
/*  1 */ _CFFI_OP(_CFFI_OP_POINTER, 441), // void *
/*  2 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/*  3 */ _CFFI_OP(_CFFI_OP_FUNCTION, 126), // OlmInboundGroupSession *()(void *)
/*  4 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/*  5 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/*  6 */ _CFFI_OP(_CFFI_OP_FUNCTION, 163), // OlmOutboundGroupSession *()(void *)
/*  7 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/*  8 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/*  9 */ _CFFI_OP(_CFFI_OP_FUNCTION, 192), // OlmPkDecryption *()(void *)
/* 10 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 11 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 12 */ _CFFI_OP(_CFFI_OP_FUNCTION, 241), // OlmPkEncryption *()(void *)
/* 13 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 14 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 15 */ _CFFI_OP(_CFFI_OP_FUNCTION, 269), // OlmPkSigning *()(void *)
/* 16 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 17 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 18 */ _CFFI_OP(_CFFI_OP_FUNCTION, 286), // OlmSAS *()(void *)
/* 19 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 20 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 21 */ _CFFI_OP(_CFFI_OP_FUNCTION, 98), // OlmSession *()(void *)
/* 22 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 23 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 24 */ _CFFI_OP(_CFFI_OP_FUNCTION, 382), // OlmUtility *()(void *)
/* 25 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 26 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 27 */ _CFFI_OP(_CFFI_OP_FUNCTION, 438), // char const *()(OlmAccount const *)
/* 28 */ _CFFI_OP(_CFFI_OP_POINTER, 429), // OlmAccount const *
/* 29 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 30 */ _CFFI_OP(_CFFI_OP_FUNCTION, 438), // char const *()(OlmInboundGroupSession const *)
/* 31 */ _CFFI_OP(_CFFI_OP_POINTER, 430), // OlmInboundGroupSession const *
/* 32 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 33 */ _CFFI_OP(_CFFI_OP_FUNCTION, 438), // char const *()(OlmOutboundGroupSession const *)
/* 34 */ _CFFI_OP(_CFFI_OP_POINTER, 431), // OlmOutboundGroupSession const *
/* 35 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 36 */ _CFFI_OP(_CFFI_OP_FUNCTION, 438), // char const *()(OlmPkDecryption const *)
/* 37 */ _CFFI_OP(_CFFI_OP_POINTER, 432), // OlmPkDecryption const *
/* 38 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 39 */ _CFFI_OP(_CFFI_OP_FUNCTION, 438), // char const *()(OlmPkEncryption const *)
/* 40 */ _CFFI_OP(_CFFI_OP_POINTER, 433), // OlmPkEncryption const *
/* 41 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 42 */ _CFFI_OP(_CFFI_OP_FUNCTION, 438), // char const *()(OlmPkSigning const *)
/* 43 */ _CFFI_OP(_CFFI_OP_POINTER, 434), // OlmPkSigning const *
/* 44 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 45 */ _CFFI_OP(_CFFI_OP_FUNCTION, 438), // char const *()(OlmSAS const *)
/* 46 */ _CFFI_OP(_CFFI_OP_POINTER, 435), // OlmSAS const *
/* 47 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 48 */ _CFFI_OP(_CFFI_OP_FUNCTION, 438), // char const *()(OlmSession const *)
/* 49 */ _CFFI_OP(_CFFI_OP_POINTER, 436), // OlmSession const *
/* 50 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 51 */ _CFFI_OP(_CFFI_OP_FUNCTION, 438), // char const *()(OlmUtility const *)
/* 52 */ _CFFI_OP(_CFFI_OP_POINTER, 437), // OlmUtility const *
/* 53 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 54 */ _CFFI_OP(_CFFI_OP_FUNCTION, 438), // char const *()(enum OlmErrorCode)
/* 55 */ _CFFI_OP(_CFFI_OP_ENUM, 0), // enum OlmErrorCode
/* 56 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 57 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // enum OlmErrorCode()(OlmAccount const *)
/* 58 */ _CFFI_OP(_CFFI_OP_NOOP, 28),
/* 59 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 60 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // enum OlmErrorCode()(OlmInboundGroupSession const *)
/* 61 */ _CFFI_OP(_CFFI_OP_NOOP, 31),
/* 62 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 63 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // enum OlmErrorCode()(OlmOutboundGroupSession const *)
/* 64 */ _CFFI_OP(_CFFI_OP_NOOP, 34),
/* 65 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 66 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // enum OlmErrorCode()(OlmPkDecryption const *)
/* 67 */ _CFFI_OP(_CFFI_OP_NOOP, 37),
/* 68 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 69 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // enum OlmErrorCode()(OlmPkEncryption const *)
/* 70 */ _CFFI_OP(_CFFI_OP_NOOP, 40),
/* 71 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 72 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // enum OlmErrorCode()(OlmPkSigning const *)
/* 73 */ _CFFI_OP(_CFFI_OP_NOOP, 43),
/* 74 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 75 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // enum OlmErrorCode()(OlmSAS const *)
/* 76 */ _CFFI_OP(_CFFI_OP_NOOP, 46),
/* 77 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 78 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // enum OlmErrorCode()(OlmSession const *)
/* 79 */ _CFFI_OP(_CFFI_OP_NOOP, 49),
/* 80 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 81 */ _CFFI_OP(_CFFI_OP_FUNCTION, 55), // enum OlmErrorCode()(OlmUtility const *)
/* 82 */ _CFFI_OP(_CFFI_OP_NOOP, 52),
/* 83 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 84 */ _CFFI_OP(_CFFI_OP_FUNCTION, 413), // int()(OlmInboundGroupSession const *)
/* 85 */ _CFFI_OP(_CFFI_OP_NOOP, 31),
/* 86 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 87 */ _CFFI_OP(_CFFI_OP_FUNCTION, 413), // int()(OlmSAS const *)
/* 88 */ _CFFI_OP(_CFFI_OP_NOOP, 46),
/* 89 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 90 */ _CFFI_OP(_CFFI_OP_FUNCTION, 413), // int()(OlmSession const *)
/* 91 */ _CFFI_OP(_CFFI_OP_NOOP, 49),
/* 92 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 93 */ _CFFI_OP(_CFFI_OP_FUNCTION, 102), // size_t()(OlmAccount *)
/* 94 */ _CFFI_OP(_CFFI_OP_POINTER, 429), // OlmAccount *
/* 95 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 96 */ _CFFI_OP(_CFFI_OP_FUNCTION, 102), // size_t()(OlmAccount *, OlmSession *)
/* 97 */ _CFFI_OP(_CFFI_OP_NOOP, 94),
/* 98 */ _CFFI_OP(_CFFI_OP_POINTER, 436), // OlmSession *
/* 99 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 100 */ _CFFI_OP(_CFFI_OP_FUNCTION, 102), // size_t()(OlmAccount *, size_t, void *, size_t)
/* 101 */ _CFFI_OP(_CFFI_OP_NOOP, 94),
/* 102 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28), // size_t
/* 103 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 104 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 105 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 106 */ _CFFI_OP(_CFFI_OP_FUNCTION, 102), // size_t()(OlmAccount *, void *, size_t)
/* 107 */ _CFFI_OP(_CFFI_OP_NOOP, 94),
/* 108 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 109 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 110 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 111 */ _CFFI_OP(_CFFI_OP_FUNCTION, 102), // size_t()(OlmAccount *, void const *, size_t, void *, size_t)
/* 112 */ _CFFI_OP(_CFFI_OP_NOOP, 94),
/* 113 */ _CFFI_OP(_CFFI_OP_POINTER, 441), // void const *
/* 114 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 115 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 116 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 117 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 118 */ _CFFI_OP(_CFFI_OP_FUNCTION, 102), // size_t()(OlmAccount const *)
/* 119 */ _CFFI_OP(_CFFI_OP_NOOP, 28),
/* 120 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 121 */ _CFFI_OP(_CFFI_OP_FUNCTION, 102), // size_t()(OlmAccount const *, size_t)
/* 122 */ _CFFI_OP(_CFFI_OP_NOOP, 28),
/* 123 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 124 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 125 */ _CFFI_OP(_CFFI_OP_FUNCTION, 102), // size_t()(OlmInboundGroupSession *)
/* 126 */ _CFFI_OP(_CFFI_OP_POINTER, 430), // OlmInboundGroupSession *
/* 127 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 128 */ _CFFI_OP(_CFFI_OP_FUNCTION, 102), // size_t()(OlmInboundGroupSession *, uint8_t *, size_t)
/* 129 */ _CFFI_OP(_CFFI_OP_NOOP, 126),
/* 130 */ _CFFI_OP(_CFFI_OP_POINTER, 440), // uint8_t *
/* 131 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 132 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 133 */ _CFFI_OP(_CFFI_OP_FUNCTION, 102), // size_t()(OlmInboundGroupSession *, uint8_t *, size_t, uint32_t)
/* 134 */ _CFFI_OP(_CFFI_OP_NOOP, 126),
/* 135 */ _CFFI_OP(_CFFI_OP_NOOP, 130),
/* 136 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 137 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22), // uint32_t
/* 138 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 139 */ _CFFI_OP(_CFFI_OP_FUNCTION, 102), // size_t()(OlmInboundGroupSession *, uint8_t *, size_t, uint8_t *, size_t, uint32_t *)
/* 140 */ _CFFI_OP(_CFFI_OP_NOOP, 126),
/* 141 */ _CFFI_OP(_CFFI_OP_NOOP, 130),
/* 142 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 143 */ _CFFI_OP(_CFFI_OP_NOOP, 130),
/* 144 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 145 */ _CFFI_OP(_CFFI_OP_POINTER, 137), // uint32_t *
/* 146 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 147 */ _CFFI_OP(_CFFI_OP_FUNCTION, 102), // size_t()(OlmInboundGroupSession *, uint8_t const *, size_t)
/* 148 */ _CFFI_OP(_CFFI_OP_NOOP, 126),
/* 149 */ _CFFI_OP(_CFFI_OP_POINTER, 440), // uint8_t const *
/* 150 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 151 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 152 */ _CFFI_OP(_CFFI_OP_FUNCTION, 102), // size_t()(OlmInboundGroupSession *, void const *, size_t, void *, size_t)
/* 153 */ _CFFI_OP(_CFFI_OP_NOOP, 126),
/* 154 */ _CFFI_OP(_CFFI_OP_NOOP, 113),
/* 155 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 156 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 157 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 158 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 159 */ _CFFI_OP(_CFFI_OP_FUNCTION, 102), // size_t()(OlmInboundGroupSession const *)
/* 160 */ _CFFI_OP(_CFFI_OP_NOOP, 31),
/* 161 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 162 */ _CFFI_OP(_CFFI_OP_FUNCTION, 102), // size_t()(OlmOutboundGroupSession *)
/* 163 */ _CFFI_OP(_CFFI_OP_POINTER, 431), // OlmOutboundGroupSession *
/* 164 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 165 */ _CFFI_OP(_CFFI_OP_FUNCTION, 102), // size_t()(OlmOutboundGroupSession *, size_t)
/* 166 */ _CFFI_OP(_CFFI_OP_NOOP, 163),
/* 167 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 168 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 169 */ _CFFI_OP(_CFFI_OP_FUNCTION, 102), // size_t()(OlmOutboundGroupSession *, uint8_t *, size_t)
/* 170 */ _CFFI_OP(_CFFI_OP_NOOP, 163),
/* 171 */ _CFFI_OP(_CFFI_OP_NOOP, 130),
/* 172 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 173 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 174 */ _CFFI_OP(_CFFI_OP_FUNCTION, 102), // size_t()(OlmOutboundGroupSession *, uint8_t const *, size_t, uint8_t *, size_t)
/* 175 */ _CFFI_OP(_CFFI_OP_NOOP, 163),
/* 176 */ _CFFI_OP(_CFFI_OP_NOOP, 149),
/* 177 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 178 */ _CFFI_OP(_CFFI_OP_NOOP, 130),
/* 179 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 180 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 181 */ _CFFI_OP(_CFFI_OP_FUNCTION, 102), // size_t()(OlmOutboundGroupSession *, void const *, size_t, void *, size_t)
/* 182 */ _CFFI_OP(_CFFI_OP_NOOP, 163),
/* 183 */ _CFFI_OP(_CFFI_OP_NOOP, 113),
/* 184 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 185 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 186 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 187 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 188 */ _CFFI_OP(_CFFI_OP_FUNCTION, 102), // size_t()(OlmOutboundGroupSession const *)
/* 189 */ _CFFI_OP(_CFFI_OP_NOOP, 34),
/* 190 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 191 */ _CFFI_OP(_CFFI_OP_FUNCTION, 102), // size_t()(OlmPkDecryption *)
/* 192 */ _CFFI_OP(_CFFI_OP_POINTER, 432), // OlmPkDecryption *
/* 193 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 194 */ _CFFI_OP(_CFFI_OP_FUNCTION, 102), // size_t()(OlmPkDecryption *, void *, size_t)
/* 195 */ _CFFI_OP(_CFFI_OP_NOOP, 192),
/* 196 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 197 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 198 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 199 */ _CFFI_OP(_CFFI_OP_FUNCTION, 102), // size_t()(OlmPkDecryption *, void *, size_t, void const *, size_t)
/* 200 */ _CFFI_OP(_CFFI_OP_NOOP, 192),
/* 201 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 202 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 203 */ _CFFI_OP(_CFFI_OP_NOOP, 113),
/* 204 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 205 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 206 */ _CFFI_OP(_CFFI_OP_FUNCTION, 102), // size_t()(OlmPkDecryption *, void const *, size_t, void *, size_t)
/* 207 */ _CFFI_OP(_CFFI_OP_NOOP, 192),
/* 208 */ _CFFI_OP(_CFFI_OP_NOOP, 113),
/* 209 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 210 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 211 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 212 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 213 */ _CFFI_OP(_CFFI_OP_FUNCTION, 102), // size_t()(OlmPkDecryption *, void const *, size_t, void *, size_t, void *, size_t)
/* 214 */ _CFFI_OP(_CFFI_OP_NOOP, 192),
/* 215 */ _CFFI_OP(_CFFI_OP_NOOP, 113),
/* 216 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 217 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 218 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 219 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 220 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 221 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 222 */ _CFFI_OP(_CFFI_OP_FUNCTION, 102), // size_t()(OlmPkDecryption *, void const *, size_t, void const *, size_t, void *, size_t, void *, size_t)
/* 223 */ _CFFI_OP(_CFFI_OP_NOOP, 192),
/* 224 */ _CFFI_OP(_CFFI_OP_NOOP, 113),
/* 225 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 226 */ _CFFI_OP(_CFFI_OP_NOOP, 113),
/* 227 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 228 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 229 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 230 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 231 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 232 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 233 */ _CFFI_OP(_CFFI_OP_FUNCTION, 102), // size_t()(OlmPkDecryption const *)
/* 234 */ _CFFI_OP(_CFFI_OP_NOOP, 37),
/* 235 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 236 */ _CFFI_OP(_CFFI_OP_FUNCTION, 102), // size_t()(OlmPkDecryption const *, size_t)
/* 237 */ _CFFI_OP(_CFFI_OP_NOOP, 37),
/* 238 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 239 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 240 */ _CFFI_OP(_CFFI_OP_FUNCTION, 102), // size_t()(OlmPkEncryption *)
/* 241 */ _CFFI_OP(_CFFI_OP_POINTER, 433), // OlmPkEncryption *
/* 242 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 243 */ _CFFI_OP(_CFFI_OP_FUNCTION, 102), // size_t()(OlmPkEncryption *, void const *, size_t)
/* 244 */ _CFFI_OP(_CFFI_OP_NOOP, 241),
/* 245 */ _CFFI_OP(_CFFI_OP_NOOP, 113),
/* 246 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 247 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 248 */ _CFFI_OP(_CFFI_OP_FUNCTION, 102), // size_t()(OlmPkEncryption *, void const *, size_t, void *, size_t, void *, size_t, void *, size_t, void const *, size_t)
/* 249 */ _CFFI_OP(_CFFI_OP_NOOP, 241),
/* 250 */ _CFFI_OP(_CFFI_OP_NOOP, 113),
/* 251 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 252 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 253 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 254 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 255 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 256 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 257 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 258 */ _CFFI_OP(_CFFI_OP_NOOP, 113),
/* 259 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 260 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 261 */ _CFFI_OP(_CFFI_OP_FUNCTION, 102), // size_t()(OlmPkEncryption const *)
/* 262 */ _CFFI_OP(_CFFI_OP_NOOP, 40),
/* 263 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 264 */ _CFFI_OP(_CFFI_OP_FUNCTION, 102), // size_t()(OlmPkEncryption const *, size_t)
/* 265 */ _CFFI_OP(_CFFI_OP_NOOP, 40),
/* 266 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 267 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 268 */ _CFFI_OP(_CFFI_OP_FUNCTION, 102), // size_t()(OlmPkSigning *)
/* 269 */ _CFFI_OP(_CFFI_OP_POINTER, 434), // OlmPkSigning *
/* 270 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 271 */ _CFFI_OP(_CFFI_OP_FUNCTION, 102), // size_t()(OlmPkSigning *, uint8_t const *, size_t, uint8_t *, size_t)
/* 272 */ _CFFI_OP(_CFFI_OP_NOOP, 269),
/* 273 */ _CFFI_OP(_CFFI_OP_NOOP, 149),
/* 274 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 275 */ _CFFI_OP(_CFFI_OP_NOOP, 130),
/* 276 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 277 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 278 */ _CFFI_OP(_CFFI_OP_FUNCTION, 102), // size_t()(OlmPkSigning *, void *, size_t, void const *, size_t)
/* 279 */ _CFFI_OP(_CFFI_OP_NOOP, 269),
/* 280 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 281 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 282 */ _CFFI_OP(_CFFI_OP_NOOP, 113),
/* 283 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 284 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 285 */ _CFFI_OP(_CFFI_OP_FUNCTION, 102), // size_t()(OlmSAS *)
/* 286 */ _CFFI_OP(_CFFI_OP_POINTER, 435), // OlmSAS *
/* 287 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 288 */ _CFFI_OP(_CFFI_OP_FUNCTION, 102), // size_t()(OlmSAS *, void *, size_t)
/* 289 */ _CFFI_OP(_CFFI_OP_NOOP, 286),
/* 290 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 291 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 292 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 293 */ _CFFI_OP(_CFFI_OP_FUNCTION, 102), // size_t()(OlmSAS *, void const *, size_t, void *, size_t)
/* 294 */ _CFFI_OP(_CFFI_OP_NOOP, 286),
/* 295 */ _CFFI_OP(_CFFI_OP_NOOP, 113),
/* 296 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 297 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 298 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 299 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 300 */ _CFFI_OP(_CFFI_OP_FUNCTION, 102), // size_t()(OlmSAS *, void const *, size_t, void const *, size_t, void *, size_t)
/* 301 */ _CFFI_OP(_CFFI_OP_NOOP, 286),
/* 302 */ _CFFI_OP(_CFFI_OP_NOOP, 113),
/* 303 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 304 */ _CFFI_OP(_CFFI_OP_NOOP, 113),
/* 305 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 306 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 307 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 308 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 309 */ _CFFI_OP(_CFFI_OP_FUNCTION, 102), // size_t()(OlmSAS const *)
/* 310 */ _CFFI_OP(_CFFI_OP_NOOP, 46),
/* 311 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 312 */ _CFFI_OP(_CFFI_OP_FUNCTION, 102), // size_t()(OlmSession *)
/* 313 */ _CFFI_OP(_CFFI_OP_NOOP, 98),
/* 314 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 315 */ _CFFI_OP(_CFFI_OP_FUNCTION, 102), // size_t()(OlmSession *, OlmAccount *, void *, size_t)
/* 316 */ _CFFI_OP(_CFFI_OP_NOOP, 98),
/* 317 */ _CFFI_OP(_CFFI_OP_NOOP, 94),
/* 318 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 319 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 320 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 321 */ _CFFI_OP(_CFFI_OP_FUNCTION, 102), // size_t()(OlmSession *, OlmAccount *, void const *, size_t, void *, size_t)
/* 322 */ _CFFI_OP(_CFFI_OP_NOOP, 98),
/* 323 */ _CFFI_OP(_CFFI_OP_NOOP, 94),
/* 324 */ _CFFI_OP(_CFFI_OP_NOOP, 113),
/* 325 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 326 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 327 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 328 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 329 */ _CFFI_OP(_CFFI_OP_FUNCTION, 102), // size_t()(OlmSession *, OlmAccount const *, void const *, size_t, void const *, size_t, void *, size_t)
/* 330 */ _CFFI_OP(_CFFI_OP_NOOP, 98),
/* 331 */ _CFFI_OP(_CFFI_OP_NOOP, 28),
/* 332 */ _CFFI_OP(_CFFI_OP_NOOP, 113),
/* 333 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 334 */ _CFFI_OP(_CFFI_OP_NOOP, 113),
/* 335 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 336 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 337 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 338 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 339 */ _CFFI_OP(_CFFI_OP_FUNCTION, 102), // size_t()(OlmSession *, size_t, void *, size_t)
/* 340 */ _CFFI_OP(_CFFI_OP_NOOP, 98),
/* 341 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 342 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 343 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 344 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 345 */ _CFFI_OP(_CFFI_OP_FUNCTION, 102), // size_t()(OlmSession *, size_t, void *, size_t, void *, size_t)
/* 346 */ _CFFI_OP(_CFFI_OP_NOOP, 98),
/* 347 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 348 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 349 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 350 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 351 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 352 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 353 */ _CFFI_OP(_CFFI_OP_FUNCTION, 102), // size_t()(OlmSession *, void *, size_t)
/* 354 */ _CFFI_OP(_CFFI_OP_NOOP, 98),
/* 355 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 356 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 357 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 358 */ _CFFI_OP(_CFFI_OP_FUNCTION, 102), // size_t()(OlmSession *, void const *, size_t, void *, size_t)
/* 359 */ _CFFI_OP(_CFFI_OP_NOOP, 98),
/* 360 */ _CFFI_OP(_CFFI_OP_NOOP, 113),
/* 361 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 362 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 363 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 364 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 365 */ _CFFI_OP(_CFFI_OP_FUNCTION, 102), // size_t()(OlmSession *, void const *, size_t, void *, size_t, void *, size_t)
/* 366 */ _CFFI_OP(_CFFI_OP_NOOP, 98),
/* 367 */ _CFFI_OP(_CFFI_OP_NOOP, 113),
/* 368 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 369 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 370 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 371 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 372 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 373 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 374 */ _CFFI_OP(_CFFI_OP_FUNCTION, 102), // size_t()(OlmSession const *)
/* 375 */ _CFFI_OP(_CFFI_OP_NOOP, 49),
/* 376 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 377 */ _CFFI_OP(_CFFI_OP_FUNCTION, 102), // size_t()(OlmSession const *, size_t)
/* 378 */ _CFFI_OP(_CFFI_OP_NOOP, 49),
/* 379 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 380 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 381 */ _CFFI_OP(_CFFI_OP_FUNCTION, 102), // size_t()(OlmUtility *)
/* 382 */ _CFFI_OP(_CFFI_OP_POINTER, 437), // OlmUtility *
/* 383 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 384 */ _CFFI_OP(_CFFI_OP_FUNCTION, 102), // size_t()(OlmUtility *, void const *, size_t, void *, size_t)
/* 385 */ _CFFI_OP(_CFFI_OP_NOOP, 382),
/* 386 */ _CFFI_OP(_CFFI_OP_NOOP, 113),
/* 387 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 388 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 389 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 390 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 391 */ _CFFI_OP(_CFFI_OP_FUNCTION, 102), // size_t()(OlmUtility *, void const *, size_t, void const *, size_t, void *, size_t)
/* 392 */ _CFFI_OP(_CFFI_OP_NOOP, 382),
/* 393 */ _CFFI_OP(_CFFI_OP_NOOP, 113),
/* 394 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 395 */ _CFFI_OP(_CFFI_OP_NOOP, 113),
/* 396 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 397 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 398 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 399 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 400 */ _CFFI_OP(_CFFI_OP_FUNCTION, 102), // size_t()(OlmUtility const *)
/* 401 */ _CFFI_OP(_CFFI_OP_NOOP, 52),
/* 402 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 403 */ _CFFI_OP(_CFFI_OP_FUNCTION, 102), // size_t()(void)
/* 404 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 405 */ _CFFI_OP(_CFFI_OP_FUNCTION, 137), // uint32_t()(OlmInboundGroupSession const *)
/* 406 */ _CFFI_OP(_CFFI_OP_NOOP, 31),
/* 407 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 408 */ _CFFI_OP(_CFFI_OP_FUNCTION, 137), // uint32_t()(OlmOutboundGroupSession *)
/* 409 */ _CFFI_OP(_CFFI_OP_NOOP, 163),
/* 410 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 411 */ _CFFI_OP(_CFFI_OP_FUNCTION, 1), // void *()(void *, int, size_t)
/* 412 */ _CFFI_OP(_CFFI_OP_NOOP, 1),
/* 413 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7), // int
/* 414 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 415 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 416 */ _CFFI_OP(_CFFI_OP_FUNCTION, 441), // void()(OlmAccount *)
/* 417 */ _CFFI_OP(_CFFI_OP_NOOP, 94),
/* 418 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 419 */ _CFFI_OP(_CFFI_OP_FUNCTION, 441), // void()(OlmSession *, char *, size_t)
/* 420 */ _CFFI_OP(_CFFI_OP_NOOP, 98),
/* 421 */ _CFFI_OP(_CFFI_OP_POINTER, 439), // char *
/* 422 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 423 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 424 */ _CFFI_OP(_CFFI_OP_FUNCTION, 441), // void()(uint8_t *, uint8_t *, uint8_t *)
/* 425 */ _CFFI_OP(_CFFI_OP_NOOP, 130),
/* 426 */ _CFFI_OP(_CFFI_OP_NOOP, 130),
/* 427 */ _CFFI_OP(_CFFI_OP_NOOP, 130),
/* 428 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 429 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 0), // OlmAccount
/* 430 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 1), // OlmInboundGroupSession
/* 431 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 2), // OlmOutboundGroupSession
/* 432 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 3), // OlmPkDecryption
/* 433 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 4), // OlmPkEncryption
/* 434 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 5), // OlmPkSigning
/* 435 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 6), // OlmSAS
/* 436 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 7), // OlmSession
/* 437 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 8), // OlmUtility
/* 438 */ _CFFI_OP(_CFFI_OP_POINTER, 439), // char const *
/* 439 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 2), // char
/* 440 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 18), // uint8_t
/* 441 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 0), // void
};

static int _cffi_const_OLM_SUCCESS(unsigned long long *o)
{
  int n = (OLM_SUCCESS) <= 0;
  *o = (unsigned long long)((OLM_SUCCESS) | 0);  /* check that OLM_SUCCESS is an integer */
  return n;
}

static int _cffi_const_OLM_NOT_ENOUGH_RANDOM(unsigned long long *o)
{
  int n = (OLM_NOT_ENOUGH_RANDOM) <= 0;
  *o = (unsigned long long)((OLM_NOT_ENOUGH_RANDOM) | 0);  /* check that OLM_NOT_ENOUGH_RANDOM is an integer */
  return n;
}

static int _cffi_const_OLM_OUTPUT_BUFFER_TOO_SMALL(unsigned long long *o)
{
  int n = (OLM_OUTPUT_BUFFER_TOO_SMALL) <= 0;
  *o = (unsigned long long)((OLM_OUTPUT_BUFFER_TOO_SMALL) | 0);  /* check that OLM_OUTPUT_BUFFER_TOO_SMALL is an integer */
  return n;
}

static int _cffi_const_OLM_BAD_MESSAGE_VERSION(unsigned long long *o)
{
  int n = (OLM_BAD_MESSAGE_VERSION) <= 0;
  *o = (unsigned long long)((OLM_BAD_MESSAGE_VERSION) | 0);  /* check that OLM_BAD_MESSAGE_VERSION is an integer */
  return n;
}

static int _cffi_const_OLM_BAD_MESSAGE_FORMAT(unsigned long long *o)
{
  int n = (OLM_BAD_MESSAGE_FORMAT) <= 0;
  *o = (unsigned long long)((OLM_BAD_MESSAGE_FORMAT) | 0);  /* check that OLM_BAD_MESSAGE_FORMAT is an integer */
  return n;
}

static int _cffi_const_OLM_BAD_MESSAGE_MAC(unsigned long long *o)
{
  int n = (OLM_BAD_MESSAGE_MAC) <= 0;
  *o = (unsigned long long)((OLM_BAD_MESSAGE_MAC) | 0);  /* check that OLM_BAD_MESSAGE_MAC is an integer */
  return n;
}

static int _cffi_const_OLM_BAD_MESSAGE_KEY_ID(unsigned long long *o)
{
  int n = (OLM_BAD_MESSAGE_KEY_ID) <= 0;
  *o = (unsigned long long)((OLM_BAD_MESSAGE_KEY_ID) | 0);  /* check that OLM_BAD_MESSAGE_KEY_ID is an integer */
  return n;
}

static int _cffi_const_OLM_INVALID_BASE64(unsigned long long *o)
{
  int n = (OLM_INVALID_BASE64) <= 0;
  *o = (unsigned long long)((OLM_INVALID_BASE64) | 0);  /* check that OLM_INVALID_BASE64 is an integer */
  return n;
}

static int _cffi_const_OLM_BAD_ACCOUNT_KEY(unsigned long long *o)
{
  int n = (OLM_BAD_ACCOUNT_KEY) <= 0;
  *o = (unsigned long long)((OLM_BAD_ACCOUNT_KEY) | 0);  /* check that OLM_BAD_ACCOUNT_KEY is an integer */
  return n;
}

static int _cffi_const_OLM_UNKNOWN_PICKLE_VERSION(unsigned long long *o)
{
  int n = (OLM_UNKNOWN_PICKLE_VERSION) <= 0;
  *o = (unsigned long long)((OLM_UNKNOWN_PICKLE_VERSION) | 0);  /* check that OLM_UNKNOWN_PICKLE_VERSION is an integer */
  return n;
}

static int _cffi_const_OLM_CORRUPTED_PICKLE(unsigned long long *o)
{
  int n = (OLM_CORRUPTED_PICKLE) <= 0;
  *o = (unsigned long long)((OLM_CORRUPTED_PICKLE) | 0);  /* check that OLM_CORRUPTED_PICKLE is an integer */
  return n;
}

static int _cffi_const_OLM_BAD_SESSION_KEY(unsigned long long *o)
{
  int n = (OLM_BAD_SESSION_KEY) <= 0;
  *o = (unsigned long long)((OLM_BAD_SESSION_KEY) | 0);  /* check that OLM_BAD_SESSION_KEY is an integer */
  return n;
}

static int _cffi_const_OLM_UNKNOWN_MESSAGE_INDEX(unsigned long long *o)
{
  int n = (OLM_UNKNOWN_MESSAGE_INDEX) <= 0;
  *o = (unsigned long long)((OLM_UNKNOWN_MESSAGE_INDEX) | 0);  /* check that OLM_UNKNOWN_MESSAGE_INDEX is an integer */
  return n;
}

static int _cffi_const_OLM_BAD_LEGACY_ACCOUNT_PICKLE(unsigned long long *o)
{
  int n = (OLM_BAD_LEGACY_ACCOUNT_PICKLE) <= 0;
  *o = (unsigned long long)((OLM_BAD_LEGACY_ACCOUNT_PICKLE) | 0);  /* check that OLM_BAD_LEGACY_ACCOUNT_PICKLE is an integer */
  return n;
}

static int _cffi_const_OLM_BAD_SIGNATURE(unsigned long long *o)
{
  int n = (OLM_BAD_SIGNATURE) <= 0;
  *o = (unsigned long long)((OLM_BAD_SIGNATURE) | 0);  /* check that OLM_BAD_SIGNATURE is an integer */
  return n;
}

static int _cffi_const_OLM_INPUT_BUFFER_TOO_SMALL(unsigned long long *o)
{
  int n = (OLM_INPUT_BUFFER_TOO_SMALL) <= 0;
  *o = (unsigned long long)((OLM_INPUT_BUFFER_TOO_SMALL) | 0);  /* check that OLM_INPUT_BUFFER_TOO_SMALL is an integer */
  return n;
}

static int _cffi_const_OLM_SAS_THEIR_KEY_NOT_SET(unsigned long long *o)
{
  int n = (OLM_SAS_THEIR_KEY_NOT_SET) <= 0;
  *o = (unsigned long long)((OLM_SAS_THEIR_KEY_NOT_SET) | 0);  /* check that OLM_SAS_THEIR_KEY_NOT_SET is an integer */
  return n;
}

static int _cffi_const_OLM_PICKLE_EXTRA_DATA(unsigned long long *o)
{
  int n = (OLM_PICKLE_EXTRA_DATA) <= 0;
  *o = (unsigned long long)((OLM_PICKLE_EXTRA_DATA) | 0);  /* check that OLM_PICKLE_EXTRA_DATA is an integer */
  return n;
}

static char const * _cffi_d__olm_error_to_string(enum OlmErrorCode x0)
{
  return _olm_error_to_string(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f__olm_error_to_string(PyObject *self, PyObject *arg0)
{
  enum OlmErrorCode x0;
  char const * result;
  PyObject *pyresult;

  if (_cffi_to_c((char *)&x0, _cffi_type(55), arg0) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = _olm_error_to_string(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(438));
  return pyresult;
}
#else
#  define _cffi_f__olm_error_to_string _cffi_d__olm_error_to_string
#endif

static void * _cffi_d_memset(void * x0, int x1, size_t x2)
{
  return memset(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_memset(PyObject *self, PyObject *args)
{
  void * x0;
  int x1;
  size_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  void * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "memset", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = memset(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(1));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_memset _cffi_d_memset
#endif

static OlmAccount * _cffi_d_olm_account(void * x0)
{
  return olm_account(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_account(PyObject *self, PyObject *arg0)
{
  void * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  OlmAccount * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_account(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(94));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_account _cffi_d_olm_account
#endif

static size_t _cffi_d_olm_account_fallback_key(OlmAccount * x0, void * x1, size_t x2)
{
  return olm_account_fallback_key(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_account_fallback_key(PyObject *self, PyObject *args)
{
  OlmAccount * x0;
  void * x1;
  size_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "olm_account_fallback_key", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(94), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmAccount *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(94), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_account_fallback_key(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_account_fallback_key _cffi_d_olm_account_fallback_key
#endif

static size_t _cffi_d_olm_account_fallback_key_length(OlmAccount const * x0)
{
  return olm_account_fallback_key_length(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_account_fallback_key_length(PyObject *self, PyObject *arg0)
{
  OlmAccount const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(28), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmAccount const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(28), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_account_fallback_key_length(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_account_fallback_key_length _cffi_d_olm_account_fallback_key_length
#endif

static void _cffi_d_olm_account_forget_old_fallback_key(OlmAccount * x0)
{
  olm_account_forget_old_fallback_key(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_account_forget_old_fallback_key(PyObject *self, PyObject *arg0)
{
  OlmAccount * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(94), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmAccount *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(94), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { olm_account_forget_old_fallback_key(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_olm_account_forget_old_fallback_key _cffi_d_olm_account_forget_old_fallback_key
#endif

static size_t _cffi_d_olm_account_generate_fallback_key(OlmAccount * x0, void * x1, size_t x2)
{
  return olm_account_generate_fallback_key(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_account_generate_fallback_key(PyObject *self, PyObject *args)
{
  OlmAccount * x0;
  void * x1;
  size_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "olm_account_generate_fallback_key", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(94), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmAccount *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(94), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_account_generate_fallback_key(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_account_generate_fallback_key _cffi_d_olm_account_generate_fallback_key
#endif

static size_t _cffi_d_olm_account_generate_fallback_key_random_length(OlmAccount const * x0)
{
  return olm_account_generate_fallback_key_random_length(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_account_generate_fallback_key_random_length(PyObject *self, PyObject *arg0)
{
  OlmAccount const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(28), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmAccount const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(28), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_account_generate_fallback_key_random_length(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_account_generate_fallback_key_random_length _cffi_d_olm_account_generate_fallback_key_random_length
#endif

static size_t _cffi_d_olm_account_generate_one_time_keys(OlmAccount * x0, size_t x1, void * x2, size_t x3)
{
  return olm_account_generate_one_time_keys(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_account_generate_one_time_keys(PyObject *self, PyObject *args)
{
  OlmAccount * x0;
  size_t x1;
  void * x2;
  size_t x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "olm_account_generate_one_time_keys", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(94), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmAccount *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(94), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x3 = _cffi_to_c_int(arg3, size_t);
  if (x3 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_account_generate_one_time_keys(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_account_generate_one_time_keys _cffi_d_olm_account_generate_one_time_keys
#endif

static size_t _cffi_d_olm_account_generate_one_time_keys_random_length(OlmAccount const * x0, size_t x1)
{
  return olm_account_generate_one_time_keys_random_length(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_account_generate_one_time_keys_random_length(PyObject *self, PyObject *args)
{
  OlmAccount const * x0;
  size_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "olm_account_generate_one_time_keys_random_length", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(28), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmAccount const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(28), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_account_generate_one_time_keys_random_length(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_account_generate_one_time_keys_random_length _cffi_d_olm_account_generate_one_time_keys_random_length
#endif

static size_t _cffi_d_olm_account_identity_keys(OlmAccount * x0, void * x1, size_t x2)
{
  return olm_account_identity_keys(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_account_identity_keys(PyObject *self, PyObject *args)
{
  OlmAccount * x0;
  void * x1;
  size_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "olm_account_identity_keys", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(94), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmAccount *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(94), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_account_identity_keys(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_account_identity_keys _cffi_d_olm_account_identity_keys
#endif

static size_t _cffi_d_olm_account_identity_keys_length(OlmAccount const * x0)
{
  return olm_account_identity_keys_length(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_account_identity_keys_length(PyObject *self, PyObject *arg0)
{
  OlmAccount const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(28), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmAccount const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(28), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_account_identity_keys_length(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_account_identity_keys_length _cffi_d_olm_account_identity_keys_length
#endif

static char const * _cffi_d_olm_account_last_error(OlmAccount const * x0)
{
  return olm_account_last_error(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_account_last_error(PyObject *self, PyObject *arg0)
{
  OlmAccount const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char const * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(28), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmAccount const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(28), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_account_last_error(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(438));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_account_last_error _cffi_d_olm_account_last_error
#endif

static enum OlmErrorCode _cffi_d_olm_account_last_error_code(OlmAccount const * x0)
{
  return olm_account_last_error_code(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_account_last_error_code(PyObject *self, PyObject *arg0)
{
  OlmAccount const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  enum OlmErrorCode result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(28), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmAccount const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(28), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_account_last_error_code(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(55));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_account_last_error_code _cffi_d_olm_account_last_error_code
#endif

static size_t _cffi_d_olm_account_mark_keys_as_published(OlmAccount * x0)
{
  return olm_account_mark_keys_as_published(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_account_mark_keys_as_published(PyObject *self, PyObject *arg0)
{
  OlmAccount * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(94), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmAccount *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(94), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_account_mark_keys_as_published(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_account_mark_keys_as_published _cffi_d_olm_account_mark_keys_as_published
#endif

static size_t _cffi_d_olm_account_max_number_of_one_time_keys(OlmAccount const * x0)
{
  return olm_account_max_number_of_one_time_keys(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_account_max_number_of_one_time_keys(PyObject *self, PyObject *arg0)
{
  OlmAccount const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(28), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmAccount const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(28), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_account_max_number_of_one_time_keys(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_account_max_number_of_one_time_keys _cffi_d_olm_account_max_number_of_one_time_keys
#endif

static size_t _cffi_d_olm_account_one_time_keys(OlmAccount * x0, void * x1, size_t x2)
{
  return olm_account_one_time_keys(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_account_one_time_keys(PyObject *self, PyObject *args)
{
  OlmAccount * x0;
  void * x1;
  size_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "olm_account_one_time_keys", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(94), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmAccount *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(94), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_account_one_time_keys(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_account_one_time_keys _cffi_d_olm_account_one_time_keys
#endif

static size_t _cffi_d_olm_account_one_time_keys_length(OlmAccount const * x0)
{
  return olm_account_one_time_keys_length(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_account_one_time_keys_length(PyObject *self, PyObject *arg0)
{
  OlmAccount const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(28), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmAccount const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(28), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_account_one_time_keys_length(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_account_one_time_keys_length _cffi_d_olm_account_one_time_keys_length
#endif

static size_t _cffi_d_olm_account_sign(OlmAccount * x0, void const * x1, size_t x2, void * x3, size_t x4)
{
  return olm_account_sign(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_account_sign(PyObject *self, PyObject *args)
{
  OlmAccount * x0;
  void const * x1;
  size_t x2;
  void * x3;
  size_t x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "olm_account_sign", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(94), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmAccount *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(94), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(113), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(113), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, size_t);
  if (x4 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_account_sign(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_account_sign _cffi_d_olm_account_sign
#endif

static size_t _cffi_d_olm_account_signature_length(OlmAccount const * x0)
{
  return olm_account_signature_length(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_account_signature_length(PyObject *self, PyObject *arg0)
{
  OlmAccount const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(28), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmAccount const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(28), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_account_signature_length(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_account_signature_length _cffi_d_olm_account_signature_length
#endif

static size_t _cffi_d_olm_account_size(void)
{
  return olm_account_size();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_account_size(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_account_size(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_olm_account_size _cffi_d_olm_account_size
#endif

static size_t _cffi_d_olm_account_unpublished_fallback_key(OlmAccount * x0, void * x1, size_t x2)
{
  return olm_account_unpublished_fallback_key(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_account_unpublished_fallback_key(PyObject *self, PyObject *args)
{
  OlmAccount * x0;
  void * x1;
  size_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "olm_account_unpublished_fallback_key", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(94), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmAccount *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(94), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_account_unpublished_fallback_key(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_account_unpublished_fallback_key _cffi_d_olm_account_unpublished_fallback_key
#endif

static size_t _cffi_d_olm_account_unpublished_fallback_key_length(OlmAccount const * x0)
{
  return olm_account_unpublished_fallback_key_length(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_account_unpublished_fallback_key_length(PyObject *self, PyObject *arg0)
{
  OlmAccount const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(28), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmAccount const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(28), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_account_unpublished_fallback_key_length(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_account_unpublished_fallback_key_length _cffi_d_olm_account_unpublished_fallback_key_length
#endif

static size_t _cffi_d_olm_clear_account(OlmAccount * x0)
{
  return olm_clear_account(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_clear_account(PyObject *self, PyObject *arg0)
{
  OlmAccount * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(94), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmAccount *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(94), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_clear_account(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_clear_account _cffi_d_olm_clear_account
#endif

static size_t _cffi_d_olm_clear_inbound_group_session(OlmInboundGroupSession * x0)
{
  return olm_clear_inbound_group_session(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_clear_inbound_group_session(PyObject *self, PyObject *arg0)
{
  OlmInboundGroupSession * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(126), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmInboundGroupSession *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(126), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_clear_inbound_group_session(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_clear_inbound_group_session _cffi_d_olm_clear_inbound_group_session
#endif

static size_t _cffi_d_olm_clear_outbound_group_session(OlmOutboundGroupSession * x0)
{
  return olm_clear_outbound_group_session(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_clear_outbound_group_session(PyObject *self, PyObject *arg0)
{
  OlmOutboundGroupSession * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(163), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmOutboundGroupSession *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(163), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_clear_outbound_group_session(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_clear_outbound_group_session _cffi_d_olm_clear_outbound_group_session
#endif

static size_t _cffi_d_olm_clear_pk_decryption(OlmPkDecryption * x0)
{
  return olm_clear_pk_decryption(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_clear_pk_decryption(PyObject *self, PyObject *arg0)
{
  OlmPkDecryption * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(192), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmPkDecryption *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(192), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_clear_pk_decryption(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_clear_pk_decryption _cffi_d_olm_clear_pk_decryption
#endif

static size_t _cffi_d_olm_clear_pk_encryption(OlmPkEncryption * x0)
{
  return olm_clear_pk_encryption(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_clear_pk_encryption(PyObject *self, PyObject *arg0)
{
  OlmPkEncryption * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(241), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmPkEncryption *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(241), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_clear_pk_encryption(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_clear_pk_encryption _cffi_d_olm_clear_pk_encryption
#endif

static size_t _cffi_d_olm_clear_pk_signing(OlmPkSigning * x0)
{
  return olm_clear_pk_signing(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_clear_pk_signing(PyObject *self, PyObject *arg0)
{
  OlmPkSigning * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(269), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmPkSigning *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(269), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_clear_pk_signing(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_clear_pk_signing _cffi_d_olm_clear_pk_signing
#endif

static size_t _cffi_d_olm_clear_sas(OlmSAS * x0)
{
  return olm_clear_sas(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_clear_sas(PyObject *self, PyObject *arg0)
{
  OlmSAS * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(286), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmSAS *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(286), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_clear_sas(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_clear_sas _cffi_d_olm_clear_sas
#endif

static size_t _cffi_d_olm_clear_session(OlmSession * x0)
{
  return olm_clear_session(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_clear_session(PyObject *self, PyObject *arg0)
{
  OlmSession * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(98), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmSession *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(98), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_clear_session(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_clear_session _cffi_d_olm_clear_session
#endif

static size_t _cffi_d_olm_clear_utility(OlmUtility * x0)
{
  return olm_clear_utility(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_clear_utility(PyObject *self, PyObject *arg0)
{
  OlmUtility * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(382), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmUtility *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(382), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_clear_utility(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_clear_utility _cffi_d_olm_clear_utility
#endif

static size_t _cffi_d_olm_create_account(OlmAccount * x0, void * x1, size_t x2)
{
  return olm_create_account(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_create_account(PyObject *self, PyObject *args)
{
  OlmAccount * x0;
  void * x1;
  size_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "olm_create_account", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(94), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmAccount *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(94), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_create_account(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_create_account _cffi_d_olm_create_account
#endif

static size_t _cffi_d_olm_create_account_random_length(OlmAccount const * x0)
{
  return olm_create_account_random_length(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_create_account_random_length(PyObject *self, PyObject *arg0)
{
  OlmAccount const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(28), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmAccount const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(28), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_create_account_random_length(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_create_account_random_length _cffi_d_olm_create_account_random_length
#endif

static size_t _cffi_d_olm_create_inbound_session(OlmSession * x0, OlmAccount * x1, void * x2, size_t x3)
{
  return olm_create_inbound_session(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_create_inbound_session(PyObject *self, PyObject *args)
{
  OlmSession * x0;
  OlmAccount * x1;
  void * x2;
  size_t x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "olm_create_inbound_session", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(98), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmSession *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(98), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(94), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (OlmAccount *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(94), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x3 = _cffi_to_c_int(arg3, size_t);
  if (x3 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_create_inbound_session(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_create_inbound_session _cffi_d_olm_create_inbound_session
#endif

static size_t _cffi_d_olm_create_inbound_session_from(OlmSession * x0, OlmAccount * x1, void const * x2, size_t x3, void * x4, size_t x5)
{
  return olm_create_inbound_session_from(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_create_inbound_session_from(PyObject *self, PyObject *args)
{
  OlmSession * x0;
  OlmAccount * x1;
  void const * x2;
  size_t x3;
  void * x4;
  size_t x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "olm_create_inbound_session_from", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(98), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmSession *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(98), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(94), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (OlmAccount *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(94), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(113), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(113), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x3 = _cffi_to_c_int(arg3, size_t);
  if (x3 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x5 = _cffi_to_c_int(arg5, size_t);
  if (x5 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_create_inbound_session_from(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_create_inbound_session_from _cffi_d_olm_create_inbound_session_from
#endif

static size_t _cffi_d_olm_create_outbound_session(OlmSession * x0, OlmAccount const * x1, void const * x2, size_t x3, void const * x4, size_t x5, void * x6, size_t x7)
{
  return olm_create_outbound_session(x0, x1, x2, x3, x4, x5, x6, x7);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_create_outbound_session(PyObject *self, PyObject *args)
{
  OlmSession * x0;
  OlmAccount const * x1;
  void const * x2;
  size_t x3;
  void const * x4;
  size_t x5;
  void * x6;
  size_t x7;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;

  if (!PyArg_UnpackTuple(args, "olm_create_outbound_session", 8, 8, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(98), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmSession *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(98), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(28), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (OlmAccount const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(28), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(113), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(113), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x3 = _cffi_to_c_int(arg3, size_t);
  if (x3 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(113), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(113), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x5 = _cffi_to_c_int(arg5, size_t);
  if (x5 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x7 = _cffi_to_c_int(arg7, size_t);
  if (x7 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_create_outbound_session(x0, x1, x2, x3, x4, x5, x6, x7); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_create_outbound_session _cffi_d_olm_create_outbound_session
#endif

static size_t _cffi_d_olm_create_outbound_session_random_length(OlmSession const * x0)
{
  return olm_create_outbound_session_random_length(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_create_outbound_session_random_length(PyObject *self, PyObject *arg0)
{
  OlmSession const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(49), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmSession const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(49), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_create_outbound_session_random_length(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_create_outbound_session_random_length _cffi_d_olm_create_outbound_session_random_length
#endif

static size_t _cffi_d_olm_create_sas(OlmSAS * x0, void * x1, size_t x2)
{
  return olm_create_sas(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_create_sas(PyObject *self, PyObject *args)
{
  OlmSAS * x0;
  void * x1;
  size_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "olm_create_sas", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(286), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmSAS *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(286), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_create_sas(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_create_sas _cffi_d_olm_create_sas
#endif

static size_t _cffi_d_olm_create_sas_random_length(OlmSAS const * x0)
{
  return olm_create_sas_random_length(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_create_sas_random_length(PyObject *self, PyObject *arg0)
{
  OlmSAS const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(46), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmSAS const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(46), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_create_sas_random_length(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_create_sas_random_length _cffi_d_olm_create_sas_random_length
#endif

static size_t _cffi_d_olm_decrypt(OlmSession * x0, size_t x1, void * x2, size_t x3, void * x4, size_t x5)
{
  return olm_decrypt(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_decrypt(PyObject *self, PyObject *args)
{
  OlmSession * x0;
  size_t x1;
  void * x2;
  size_t x3;
  void * x4;
  size_t x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "olm_decrypt", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(98), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmSession *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(98), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x3 = _cffi_to_c_int(arg3, size_t);
  if (x3 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x5 = _cffi_to_c_int(arg5, size_t);
  if (x5 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_decrypt(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_decrypt _cffi_d_olm_decrypt
#endif

static size_t _cffi_d_olm_decrypt_max_plaintext_length(OlmSession * x0, size_t x1, void * x2, size_t x3)
{
  return olm_decrypt_max_plaintext_length(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_decrypt_max_plaintext_length(PyObject *self, PyObject *args)
{
  OlmSession * x0;
  size_t x1;
  void * x2;
  size_t x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "olm_decrypt_max_plaintext_length", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(98), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmSession *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(98), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x3 = _cffi_to_c_int(arg3, size_t);
  if (x3 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_decrypt_max_plaintext_length(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_decrypt_max_plaintext_length _cffi_d_olm_decrypt_max_plaintext_length
#endif

static size_t _cffi_d_olm_ed25519_verify(OlmUtility * x0, void const * x1, size_t x2, void const * x3, size_t x4, void * x5, size_t x6)
{
  return olm_ed25519_verify(x0, x1, x2, x3, x4, x5, x6);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_ed25519_verify(PyObject *self, PyObject *args)
{
  OlmUtility * x0;
  void const * x1;
  size_t x2;
  void const * x3;
  size_t x4;
  void * x5;
  size_t x6;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;

  if (!PyArg_UnpackTuple(args, "olm_ed25519_verify", 7, 7, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(382), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmUtility *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(382), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(113), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(113), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(113), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(113), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, size_t);
  if (x4 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x6 = _cffi_to_c_int(arg6, size_t);
  if (x6 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_ed25519_verify(x0, x1, x2, x3, x4, x5, x6); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_ed25519_verify _cffi_d_olm_ed25519_verify
#endif

static size_t _cffi_d_olm_encrypt(OlmSession * x0, void const * x1, size_t x2, void * x3, size_t x4, void * x5, size_t x6)
{
  return olm_encrypt(x0, x1, x2, x3, x4, x5, x6);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_encrypt(PyObject *self, PyObject *args)
{
  OlmSession * x0;
  void const * x1;
  size_t x2;
  void * x3;
  size_t x4;
  void * x5;
  size_t x6;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;

  if (!PyArg_UnpackTuple(args, "olm_encrypt", 7, 7, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(98), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmSession *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(98), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(113), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(113), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, size_t);
  if (x4 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x6 = _cffi_to_c_int(arg6, size_t);
  if (x6 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_encrypt(x0, x1, x2, x3, x4, x5, x6); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_encrypt _cffi_d_olm_encrypt
#endif

static size_t _cffi_d_olm_encrypt_message_length(OlmSession const * x0, size_t x1)
{
  return olm_encrypt_message_length(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_encrypt_message_length(PyObject *self, PyObject *args)
{
  OlmSession const * x0;
  size_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "olm_encrypt_message_length", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(49), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmSession const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(49), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_encrypt_message_length(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_encrypt_message_length _cffi_d_olm_encrypt_message_length
#endif

static size_t _cffi_d_olm_encrypt_message_type(OlmSession const * x0)
{
  return olm_encrypt_message_type(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_encrypt_message_type(PyObject *self, PyObject *arg0)
{
  OlmSession const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(49), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmSession const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(49), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_encrypt_message_type(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_encrypt_message_type _cffi_d_olm_encrypt_message_type
#endif

static size_t _cffi_d_olm_encrypt_random_length(OlmSession const * x0)
{
  return olm_encrypt_random_length(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_encrypt_random_length(PyObject *self, PyObject *arg0)
{
  OlmSession const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(49), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmSession const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(49), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_encrypt_random_length(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_encrypt_random_length _cffi_d_olm_encrypt_random_length
#endif

static size_t _cffi_d_olm_error(void)
{
  return olm_error();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_error(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_error(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_olm_error _cffi_d_olm_error
#endif

static size_t _cffi_d_olm_export_inbound_group_session(OlmInboundGroupSession * x0, uint8_t * x1, size_t x2, uint32_t x3)
{
  return olm_export_inbound_group_session(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_export_inbound_group_session(PyObject *self, PyObject *args)
{
  OlmInboundGroupSession * x0;
  uint8_t * x1;
  size_t x2;
  uint32_t x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "olm_export_inbound_group_session", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(126), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmInboundGroupSession *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(126), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(130), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (uint8_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(130), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, uint32_t);
  if (x3 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_export_inbound_group_session(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_export_inbound_group_session _cffi_d_olm_export_inbound_group_session
#endif

static size_t _cffi_d_olm_export_inbound_group_session_length(OlmInboundGroupSession const * x0)
{
  return olm_export_inbound_group_session_length(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_export_inbound_group_session_length(PyObject *self, PyObject *arg0)
{
  OlmInboundGroupSession const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(31), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmInboundGroupSession const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(31), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_export_inbound_group_session_length(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_export_inbound_group_session_length _cffi_d_olm_export_inbound_group_session_length
#endif

static void _cffi_d_olm_get_library_version(uint8_t * x0, uint8_t * x1, uint8_t * x2)
{
  olm_get_library_version(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_get_library_version(PyObject *self, PyObject *args)
{
  uint8_t * x0;
  uint8_t * x1;
  uint8_t * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "olm_get_library_version", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(130), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (uint8_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(130), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(130), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (uint8_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(130), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(130), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (uint8_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(130), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { olm_get_library_version(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_olm_get_library_version _cffi_d_olm_get_library_version
#endif

static size_t _cffi_d_olm_group_decrypt(OlmInboundGroupSession * x0, uint8_t * x1, size_t x2, uint8_t * x3, size_t x4, uint32_t * x5)
{
  return olm_group_decrypt(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_group_decrypt(PyObject *self, PyObject *args)
{
  OlmInboundGroupSession * x0;
  uint8_t * x1;
  size_t x2;
  uint8_t * x3;
  size_t x4;
  uint32_t * x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "olm_group_decrypt", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(126), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmInboundGroupSession *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(126), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(130), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (uint8_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(130), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(130), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (uint8_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(130), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, size_t);
  if (x4 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(145), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (uint32_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(145), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_group_decrypt(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_group_decrypt _cffi_d_olm_group_decrypt
#endif

static size_t _cffi_d_olm_group_decrypt_max_plaintext_length(OlmInboundGroupSession * x0, uint8_t * x1, size_t x2)
{
  return olm_group_decrypt_max_plaintext_length(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_group_decrypt_max_plaintext_length(PyObject *self, PyObject *args)
{
  OlmInboundGroupSession * x0;
  uint8_t * x1;
  size_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "olm_group_decrypt_max_plaintext_length", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(126), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmInboundGroupSession *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(126), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(130), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (uint8_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(130), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_group_decrypt_max_plaintext_length(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_group_decrypt_max_plaintext_length _cffi_d_olm_group_decrypt_max_plaintext_length
#endif

static size_t _cffi_d_olm_group_encrypt(OlmOutboundGroupSession * x0, uint8_t const * x1, size_t x2, uint8_t * x3, size_t x4)
{
  return olm_group_encrypt(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_group_encrypt(PyObject *self, PyObject *args)
{
  OlmOutboundGroupSession * x0;
  uint8_t const * x1;
  size_t x2;
  uint8_t * x3;
  size_t x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "olm_group_encrypt", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(163), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmOutboundGroupSession *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(163), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(149), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (uint8_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(149), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(130), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (uint8_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(130), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, size_t);
  if (x4 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_group_encrypt(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_group_encrypt _cffi_d_olm_group_encrypt
#endif

static size_t _cffi_d_olm_group_encrypt_message_length(OlmOutboundGroupSession * x0, size_t x1)
{
  return olm_group_encrypt_message_length(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_group_encrypt_message_length(PyObject *self, PyObject *args)
{
  OlmOutboundGroupSession * x0;
  size_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "olm_group_encrypt_message_length", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(163), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmOutboundGroupSession *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(163), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_group_encrypt_message_length(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_group_encrypt_message_length _cffi_d_olm_group_encrypt_message_length
#endif

static size_t _cffi_d_olm_import_inbound_group_session(OlmInboundGroupSession * x0, uint8_t const * x1, size_t x2)
{
  return olm_import_inbound_group_session(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_import_inbound_group_session(PyObject *self, PyObject *args)
{
  OlmInboundGroupSession * x0;
  uint8_t const * x1;
  size_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "olm_import_inbound_group_session", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(126), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmInboundGroupSession *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(126), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(149), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (uint8_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(149), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_import_inbound_group_session(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_import_inbound_group_session _cffi_d_olm_import_inbound_group_session
#endif

static OlmInboundGroupSession * _cffi_d_olm_inbound_group_session(void * x0)
{
  return olm_inbound_group_session(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_inbound_group_session(PyObject *self, PyObject *arg0)
{
  void * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  OlmInboundGroupSession * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_inbound_group_session(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(126));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_inbound_group_session _cffi_d_olm_inbound_group_session
#endif

static uint32_t _cffi_d_olm_inbound_group_session_first_known_index(OlmInboundGroupSession const * x0)
{
  return olm_inbound_group_session_first_known_index(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_inbound_group_session_first_known_index(PyObject *self, PyObject *arg0)
{
  OlmInboundGroupSession const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(31), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmInboundGroupSession const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(31), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_inbound_group_session_first_known_index(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_inbound_group_session_first_known_index _cffi_d_olm_inbound_group_session_first_known_index
#endif

static size_t _cffi_d_olm_inbound_group_session_id(OlmInboundGroupSession * x0, uint8_t * x1, size_t x2)
{
  return olm_inbound_group_session_id(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_inbound_group_session_id(PyObject *self, PyObject *args)
{
  OlmInboundGroupSession * x0;
  uint8_t * x1;
  size_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "olm_inbound_group_session_id", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(126), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmInboundGroupSession *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(126), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(130), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (uint8_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(130), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_inbound_group_session_id(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_inbound_group_session_id _cffi_d_olm_inbound_group_session_id
#endif

static size_t _cffi_d_olm_inbound_group_session_id_length(OlmInboundGroupSession const * x0)
{
  return olm_inbound_group_session_id_length(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_inbound_group_session_id_length(PyObject *self, PyObject *arg0)
{
  OlmInboundGroupSession const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(31), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmInboundGroupSession const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(31), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_inbound_group_session_id_length(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_inbound_group_session_id_length _cffi_d_olm_inbound_group_session_id_length
#endif

static int _cffi_d_olm_inbound_group_session_is_verified(OlmInboundGroupSession const * x0)
{
  return olm_inbound_group_session_is_verified(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_inbound_group_session_is_verified(PyObject *self, PyObject *arg0)
{
  OlmInboundGroupSession const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(31), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmInboundGroupSession const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(31), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_inbound_group_session_is_verified(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_inbound_group_session_is_verified _cffi_d_olm_inbound_group_session_is_verified
#endif

static char const * _cffi_d_olm_inbound_group_session_last_error(OlmInboundGroupSession const * x0)
{
  return olm_inbound_group_session_last_error(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_inbound_group_session_last_error(PyObject *self, PyObject *arg0)
{
  OlmInboundGroupSession const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char const * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(31), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmInboundGroupSession const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(31), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_inbound_group_session_last_error(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(438));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_inbound_group_session_last_error _cffi_d_olm_inbound_group_session_last_error
#endif

static enum OlmErrorCode _cffi_d_olm_inbound_group_session_last_error_code(OlmInboundGroupSession const * x0)
{
  return olm_inbound_group_session_last_error_code(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_inbound_group_session_last_error_code(PyObject *self, PyObject *arg0)
{
  OlmInboundGroupSession const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  enum OlmErrorCode result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(31), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmInboundGroupSession const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(31), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_inbound_group_session_last_error_code(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(55));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_inbound_group_session_last_error_code _cffi_d_olm_inbound_group_session_last_error_code
#endif

static size_t _cffi_d_olm_inbound_group_session_size(void)
{
  return olm_inbound_group_session_size();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_inbound_group_session_size(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_inbound_group_session_size(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_olm_inbound_group_session_size _cffi_d_olm_inbound_group_session_size
#endif

static size_t _cffi_d_olm_init_inbound_group_session(OlmInboundGroupSession * x0, uint8_t const * x1, size_t x2)
{
  return olm_init_inbound_group_session(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_init_inbound_group_session(PyObject *self, PyObject *args)
{
  OlmInboundGroupSession * x0;
  uint8_t const * x1;
  size_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "olm_init_inbound_group_session", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(126), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmInboundGroupSession *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(126), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(149), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (uint8_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(149), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_init_inbound_group_session(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_init_inbound_group_session _cffi_d_olm_init_inbound_group_session
#endif

static size_t _cffi_d_olm_init_outbound_group_session(OlmOutboundGroupSession * x0, uint8_t * x1, size_t x2)
{
  return olm_init_outbound_group_session(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_init_outbound_group_session(PyObject *self, PyObject *args)
{
  OlmOutboundGroupSession * x0;
  uint8_t * x1;
  size_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "olm_init_outbound_group_session", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(163), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmOutboundGroupSession *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(163), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(130), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (uint8_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(130), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_init_outbound_group_session(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_init_outbound_group_session _cffi_d_olm_init_outbound_group_session
#endif

static size_t _cffi_d_olm_init_outbound_group_session_random_length(OlmOutboundGroupSession const * x0)
{
  return olm_init_outbound_group_session_random_length(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_init_outbound_group_session_random_length(PyObject *self, PyObject *arg0)
{
  OlmOutboundGroupSession const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(34), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmOutboundGroupSession const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(34), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_init_outbound_group_session_random_length(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_init_outbound_group_session_random_length _cffi_d_olm_init_outbound_group_session_random_length
#endif

static size_t _cffi_d_olm_matches_inbound_session(OlmSession * x0, void * x1, size_t x2)
{
  return olm_matches_inbound_session(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_matches_inbound_session(PyObject *self, PyObject *args)
{
  OlmSession * x0;
  void * x1;
  size_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "olm_matches_inbound_session", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(98), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmSession *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(98), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_matches_inbound_session(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_matches_inbound_session _cffi_d_olm_matches_inbound_session
#endif

static size_t _cffi_d_olm_matches_inbound_session_from(OlmSession * x0, void const * x1, size_t x2, void * x3, size_t x4)
{
  return olm_matches_inbound_session_from(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_matches_inbound_session_from(PyObject *self, PyObject *args)
{
  OlmSession * x0;
  void const * x1;
  size_t x2;
  void * x3;
  size_t x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "olm_matches_inbound_session_from", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(98), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmSession *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(98), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(113), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(113), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, size_t);
  if (x4 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_matches_inbound_session_from(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_matches_inbound_session_from _cffi_d_olm_matches_inbound_session_from
#endif

static OlmOutboundGroupSession * _cffi_d_olm_outbound_group_session(void * x0)
{
  return olm_outbound_group_session(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_outbound_group_session(PyObject *self, PyObject *arg0)
{
  void * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  OlmOutboundGroupSession * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_outbound_group_session(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(163));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_outbound_group_session _cffi_d_olm_outbound_group_session
#endif

static size_t _cffi_d_olm_outbound_group_session_id(OlmOutboundGroupSession * x0, uint8_t * x1, size_t x2)
{
  return olm_outbound_group_session_id(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_outbound_group_session_id(PyObject *self, PyObject *args)
{
  OlmOutboundGroupSession * x0;
  uint8_t * x1;
  size_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "olm_outbound_group_session_id", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(163), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmOutboundGroupSession *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(163), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(130), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (uint8_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(130), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_outbound_group_session_id(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_outbound_group_session_id _cffi_d_olm_outbound_group_session_id
#endif

static size_t _cffi_d_olm_outbound_group_session_id_length(OlmOutboundGroupSession const * x0)
{
  return olm_outbound_group_session_id_length(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_outbound_group_session_id_length(PyObject *self, PyObject *arg0)
{
  OlmOutboundGroupSession const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(34), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmOutboundGroupSession const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(34), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_outbound_group_session_id_length(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_outbound_group_session_id_length _cffi_d_olm_outbound_group_session_id_length
#endif

static size_t _cffi_d_olm_outbound_group_session_key(OlmOutboundGroupSession * x0, uint8_t * x1, size_t x2)
{
  return olm_outbound_group_session_key(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_outbound_group_session_key(PyObject *self, PyObject *args)
{
  OlmOutboundGroupSession * x0;
  uint8_t * x1;
  size_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "olm_outbound_group_session_key", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(163), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmOutboundGroupSession *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(163), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(130), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (uint8_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(130), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_outbound_group_session_key(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_outbound_group_session_key _cffi_d_olm_outbound_group_session_key
#endif

static size_t _cffi_d_olm_outbound_group_session_key_length(OlmOutboundGroupSession const * x0)
{
  return olm_outbound_group_session_key_length(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_outbound_group_session_key_length(PyObject *self, PyObject *arg0)
{
  OlmOutboundGroupSession const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(34), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmOutboundGroupSession const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(34), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_outbound_group_session_key_length(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_outbound_group_session_key_length _cffi_d_olm_outbound_group_session_key_length
#endif

static char const * _cffi_d_olm_outbound_group_session_last_error(OlmOutboundGroupSession const * x0)
{
  return olm_outbound_group_session_last_error(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_outbound_group_session_last_error(PyObject *self, PyObject *arg0)
{
  OlmOutboundGroupSession const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char const * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(34), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmOutboundGroupSession const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(34), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_outbound_group_session_last_error(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(438));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_outbound_group_session_last_error _cffi_d_olm_outbound_group_session_last_error
#endif

static enum OlmErrorCode _cffi_d_olm_outbound_group_session_last_error_code(OlmOutboundGroupSession const * x0)
{
  return olm_outbound_group_session_last_error_code(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_outbound_group_session_last_error_code(PyObject *self, PyObject *arg0)
{
  OlmOutboundGroupSession const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  enum OlmErrorCode result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(34), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmOutboundGroupSession const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(34), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_outbound_group_session_last_error_code(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(55));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_outbound_group_session_last_error_code _cffi_d_olm_outbound_group_session_last_error_code
#endif

static uint32_t _cffi_d_olm_outbound_group_session_message_index(OlmOutboundGroupSession * x0)
{
  return olm_outbound_group_session_message_index(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_outbound_group_session_message_index(PyObject *self, PyObject *arg0)
{
  OlmOutboundGroupSession * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  uint32_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(163), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmOutboundGroupSession *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(163), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_outbound_group_session_message_index(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, uint32_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_outbound_group_session_message_index _cffi_d_olm_outbound_group_session_message_index
#endif

static size_t _cffi_d_olm_outbound_group_session_size(void)
{
  return olm_outbound_group_session_size();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_outbound_group_session_size(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_outbound_group_session_size(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_olm_outbound_group_session_size _cffi_d_olm_outbound_group_session_size
#endif

static size_t _cffi_d_olm_pickle_account(OlmAccount * x0, void const * x1, size_t x2, void * x3, size_t x4)
{
  return olm_pickle_account(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_pickle_account(PyObject *self, PyObject *args)
{
  OlmAccount * x0;
  void const * x1;
  size_t x2;
  void * x3;
  size_t x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "olm_pickle_account", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(94), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmAccount *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(94), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(113), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(113), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, size_t);
  if (x4 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_pickle_account(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_pickle_account _cffi_d_olm_pickle_account
#endif

static size_t _cffi_d_olm_pickle_account_length(OlmAccount const * x0)
{
  return olm_pickle_account_length(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_pickle_account_length(PyObject *self, PyObject *arg0)
{
  OlmAccount const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(28), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmAccount const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(28), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_pickle_account_length(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_pickle_account_length _cffi_d_olm_pickle_account_length
#endif

static size_t _cffi_d_olm_pickle_inbound_group_session(OlmInboundGroupSession * x0, void const * x1, size_t x2, void * x3, size_t x4)
{
  return olm_pickle_inbound_group_session(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_pickle_inbound_group_session(PyObject *self, PyObject *args)
{
  OlmInboundGroupSession * x0;
  void const * x1;
  size_t x2;
  void * x3;
  size_t x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "olm_pickle_inbound_group_session", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(126), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmInboundGroupSession *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(126), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(113), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(113), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, size_t);
  if (x4 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_pickle_inbound_group_session(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_pickle_inbound_group_session _cffi_d_olm_pickle_inbound_group_session
#endif

static size_t _cffi_d_olm_pickle_inbound_group_session_length(OlmInboundGroupSession const * x0)
{
  return olm_pickle_inbound_group_session_length(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_pickle_inbound_group_session_length(PyObject *self, PyObject *arg0)
{
  OlmInboundGroupSession const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(31), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmInboundGroupSession const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(31), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_pickle_inbound_group_session_length(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_pickle_inbound_group_session_length _cffi_d_olm_pickle_inbound_group_session_length
#endif

static size_t _cffi_d_olm_pickle_outbound_group_session(OlmOutboundGroupSession * x0, void const * x1, size_t x2, void * x3, size_t x4)
{
  return olm_pickle_outbound_group_session(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_pickle_outbound_group_session(PyObject *self, PyObject *args)
{
  OlmOutboundGroupSession * x0;
  void const * x1;
  size_t x2;
  void * x3;
  size_t x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "olm_pickle_outbound_group_session", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(163), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmOutboundGroupSession *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(163), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(113), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(113), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, size_t);
  if (x4 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_pickle_outbound_group_session(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_pickle_outbound_group_session _cffi_d_olm_pickle_outbound_group_session
#endif

static size_t _cffi_d_olm_pickle_outbound_group_session_length(OlmOutboundGroupSession const * x0)
{
  return olm_pickle_outbound_group_session_length(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_pickle_outbound_group_session_length(PyObject *self, PyObject *arg0)
{
  OlmOutboundGroupSession const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(34), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmOutboundGroupSession const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(34), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_pickle_outbound_group_session_length(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_pickle_outbound_group_session_length _cffi_d_olm_pickle_outbound_group_session_length
#endif

static size_t _cffi_d_olm_pickle_pk_decryption(OlmPkDecryption * x0, void const * x1, size_t x2, void * x3, size_t x4)
{
  return olm_pickle_pk_decryption(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_pickle_pk_decryption(PyObject *self, PyObject *args)
{
  OlmPkDecryption * x0;
  void const * x1;
  size_t x2;
  void * x3;
  size_t x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "olm_pickle_pk_decryption", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(192), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmPkDecryption *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(192), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(113), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(113), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, size_t);
  if (x4 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_pickle_pk_decryption(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_pickle_pk_decryption _cffi_d_olm_pickle_pk_decryption
#endif

static size_t _cffi_d_olm_pickle_pk_decryption_length(OlmPkDecryption const * x0)
{
  return olm_pickle_pk_decryption_length(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_pickle_pk_decryption_length(PyObject *self, PyObject *arg0)
{
  OlmPkDecryption const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(37), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmPkDecryption const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(37), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_pickle_pk_decryption_length(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_pickle_pk_decryption_length _cffi_d_olm_pickle_pk_decryption_length
#endif

static size_t _cffi_d_olm_pickle_session(OlmSession * x0, void const * x1, size_t x2, void * x3, size_t x4)
{
  return olm_pickle_session(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_pickle_session(PyObject *self, PyObject *args)
{
  OlmSession * x0;
  void const * x1;
  size_t x2;
  void * x3;
  size_t x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "olm_pickle_session", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(98), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmSession *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(98), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(113), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(113), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, size_t);
  if (x4 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_pickle_session(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_pickle_session _cffi_d_olm_pickle_session
#endif

static size_t _cffi_d_olm_pickle_session_length(OlmSession const * x0)
{
  return olm_pickle_session_length(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_pickle_session_length(PyObject *self, PyObject *arg0)
{
  OlmSession const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(49), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmSession const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(49), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_pickle_session_length(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_pickle_session_length _cffi_d_olm_pickle_session_length
#endif

static size_t _cffi_d_olm_pk_ciphertext_length(OlmPkEncryption const * x0, size_t x1)
{
  return olm_pk_ciphertext_length(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_pk_ciphertext_length(PyObject *self, PyObject *args)
{
  OlmPkEncryption const * x0;
  size_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "olm_pk_ciphertext_length", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(40), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmPkEncryption const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(40), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_pk_ciphertext_length(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_pk_ciphertext_length _cffi_d_olm_pk_ciphertext_length
#endif

static size_t _cffi_d_olm_pk_decrypt(OlmPkDecryption * x0, void const * x1, size_t x2, void const * x3, size_t x4, void * x5, size_t x6, void * x7, size_t x8)
{
  return olm_pk_decrypt(x0, x1, x2, x3, x4, x5, x6, x7, x8);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_pk_decrypt(PyObject *self, PyObject *args)
{
  OlmPkDecryption * x0;
  void const * x1;
  size_t x2;
  void const * x3;
  size_t x4;
  void * x5;
  size_t x6;
  void * x7;
  size_t x8;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;
  PyObject *arg8;

  if (!PyArg_UnpackTuple(args, "olm_pk_decrypt", 9, 9, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7, &arg8))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(192), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmPkDecryption *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(192), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(113), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(113), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(113), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(113), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, size_t);
  if (x4 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x6 = _cffi_to_c_int(arg6, size_t);
  if (x6 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg7, (char **)&x7);
  if (datasize != 0) {
    x7 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg7, (char **)&x7,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x8 = _cffi_to_c_int(arg8, size_t);
  if (x8 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_pk_decrypt(x0, x1, x2, x3, x4, x5, x6, x7, x8); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_pk_decrypt _cffi_d_olm_pk_decrypt
#endif

static OlmPkDecryption * _cffi_d_olm_pk_decryption(void * x0)
{
  return olm_pk_decryption(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_pk_decryption(PyObject *self, PyObject *arg0)
{
  void * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  OlmPkDecryption * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_pk_decryption(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(192));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_pk_decryption _cffi_d_olm_pk_decryption
#endif

static char const * _cffi_d_olm_pk_decryption_last_error(OlmPkDecryption const * x0)
{
  return olm_pk_decryption_last_error(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_pk_decryption_last_error(PyObject *self, PyObject *arg0)
{
  OlmPkDecryption const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char const * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(37), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmPkDecryption const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(37), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_pk_decryption_last_error(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(438));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_pk_decryption_last_error _cffi_d_olm_pk_decryption_last_error
#endif

static enum OlmErrorCode _cffi_d_olm_pk_decryption_last_error_code(OlmPkDecryption const * x0)
{
  return olm_pk_decryption_last_error_code(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_pk_decryption_last_error_code(PyObject *self, PyObject *arg0)
{
  OlmPkDecryption const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  enum OlmErrorCode result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(37), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmPkDecryption const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(37), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_pk_decryption_last_error_code(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(55));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_pk_decryption_last_error_code _cffi_d_olm_pk_decryption_last_error_code
#endif

static size_t _cffi_d_olm_pk_decryption_size(void)
{
  return olm_pk_decryption_size();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_pk_decryption_size(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_pk_decryption_size(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_olm_pk_decryption_size _cffi_d_olm_pk_decryption_size
#endif

static size_t _cffi_d_olm_pk_encrypt(OlmPkEncryption * x0, void const * x1, size_t x2, void * x3, size_t x4, void * x5, size_t x6, void * x7, size_t x8, void const * x9, size_t x10)
{
  return olm_pk_encrypt(x0, x1, x2, x3, x4, x5, x6, x7, x8, x9, x10);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_pk_encrypt(PyObject *self, PyObject *args)
{
  OlmPkEncryption * x0;
  void const * x1;
  size_t x2;
  void * x3;
  size_t x4;
  void * x5;
  size_t x6;
  void * x7;
  size_t x8;
  void const * x9;
  size_t x10;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;
  PyObject *arg8;
  PyObject *arg9;
  PyObject *arg10;

  if (!PyArg_UnpackTuple(args, "olm_pk_encrypt", 11, 11, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7, &arg8, &arg9, &arg10))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(241), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmPkEncryption *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(241), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(113), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(113), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, size_t);
  if (x4 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x6 = _cffi_to_c_int(arg6, size_t);
  if (x6 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg7, (char **)&x7);
  if (datasize != 0) {
    x7 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg7, (char **)&x7,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x8 = _cffi_to_c_int(arg8, size_t);
  if (x8 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(113), arg9, (char **)&x9);
  if (datasize != 0) {
    x9 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(113), arg9, (char **)&x9,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x10 = _cffi_to_c_int(arg10, size_t);
  if (x10 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_pk_encrypt(x0, x1, x2, x3, x4, x5, x6, x7, x8, x9, x10); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_pk_encrypt _cffi_d_olm_pk_encrypt
#endif

static size_t _cffi_d_olm_pk_encrypt_random_length(OlmPkEncryption const * x0)
{
  return olm_pk_encrypt_random_length(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_pk_encrypt_random_length(PyObject *self, PyObject *arg0)
{
  OlmPkEncryption const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(40), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmPkEncryption const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(40), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_pk_encrypt_random_length(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_pk_encrypt_random_length _cffi_d_olm_pk_encrypt_random_length
#endif

static OlmPkEncryption * _cffi_d_olm_pk_encryption(void * x0)
{
  return olm_pk_encryption(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_pk_encryption(PyObject *self, PyObject *arg0)
{
  void * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  OlmPkEncryption * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_pk_encryption(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(241));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_pk_encryption _cffi_d_olm_pk_encryption
#endif

static char const * _cffi_d_olm_pk_encryption_last_error(OlmPkEncryption const * x0)
{
  return olm_pk_encryption_last_error(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_pk_encryption_last_error(PyObject *self, PyObject *arg0)
{
  OlmPkEncryption const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char const * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(40), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmPkEncryption const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(40), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_pk_encryption_last_error(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(438));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_pk_encryption_last_error _cffi_d_olm_pk_encryption_last_error
#endif

static enum OlmErrorCode _cffi_d_olm_pk_encryption_last_error_code(OlmPkEncryption const * x0)
{
  return olm_pk_encryption_last_error_code(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_pk_encryption_last_error_code(PyObject *self, PyObject *arg0)
{
  OlmPkEncryption const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  enum OlmErrorCode result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(40), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmPkEncryption const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(40), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_pk_encryption_last_error_code(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(55));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_pk_encryption_last_error_code _cffi_d_olm_pk_encryption_last_error_code
#endif

static size_t _cffi_d_olm_pk_encryption_set_recipient_key(OlmPkEncryption * x0, void const * x1, size_t x2)
{
  return olm_pk_encryption_set_recipient_key(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_pk_encryption_set_recipient_key(PyObject *self, PyObject *args)
{
  OlmPkEncryption * x0;
  void const * x1;
  size_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "olm_pk_encryption_set_recipient_key", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(241), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmPkEncryption *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(241), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(113), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(113), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_pk_encryption_set_recipient_key(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_pk_encryption_set_recipient_key _cffi_d_olm_pk_encryption_set_recipient_key
#endif

static size_t _cffi_d_olm_pk_encryption_size(void)
{
  return olm_pk_encryption_size();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_pk_encryption_size(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_pk_encryption_size(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_olm_pk_encryption_size _cffi_d_olm_pk_encryption_size
#endif

static size_t _cffi_d_olm_pk_generate_key(OlmPkDecryption * x0, void * x1, size_t x2, void const * x3, size_t x4)
{
  return olm_pk_generate_key(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_pk_generate_key(PyObject *self, PyObject *args)
{
  OlmPkDecryption * x0;
  void * x1;
  size_t x2;
  void const * x3;
  size_t x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "olm_pk_generate_key", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(192), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmPkDecryption *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(192), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(113), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(113), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, size_t);
  if (x4 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_pk_generate_key(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_pk_generate_key _cffi_d_olm_pk_generate_key
#endif

static size_t _cffi_d_olm_pk_generate_key_random_length(void)
{
  return olm_pk_generate_key_random_length();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_pk_generate_key_random_length(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_pk_generate_key_random_length(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_olm_pk_generate_key_random_length _cffi_d_olm_pk_generate_key_random_length
#endif

static size_t _cffi_d_olm_pk_get_private_key(OlmPkDecryption * x0, void * x1, size_t x2)
{
  return olm_pk_get_private_key(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_pk_get_private_key(PyObject *self, PyObject *args)
{
  OlmPkDecryption * x0;
  void * x1;
  size_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "olm_pk_get_private_key", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(192), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmPkDecryption *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(192), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_pk_get_private_key(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_pk_get_private_key _cffi_d_olm_pk_get_private_key
#endif

static size_t _cffi_d_olm_pk_key_from_private(OlmPkDecryption * x0, void * x1, size_t x2, void const * x3, size_t x4)
{
  return olm_pk_key_from_private(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_pk_key_from_private(PyObject *self, PyObject *args)
{
  OlmPkDecryption * x0;
  void * x1;
  size_t x2;
  void const * x3;
  size_t x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "olm_pk_key_from_private", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(192), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmPkDecryption *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(192), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(113), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(113), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, size_t);
  if (x4 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_pk_key_from_private(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_pk_key_from_private _cffi_d_olm_pk_key_from_private
#endif

static size_t _cffi_d_olm_pk_key_length(void)
{
  return olm_pk_key_length();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_pk_key_length(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_pk_key_length(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_olm_pk_key_length _cffi_d_olm_pk_key_length
#endif

static size_t _cffi_d_olm_pk_mac_length(OlmPkEncryption const * x0)
{
  return olm_pk_mac_length(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_pk_mac_length(PyObject *self, PyObject *arg0)
{
  OlmPkEncryption const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(40), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmPkEncryption const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(40), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_pk_mac_length(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_pk_mac_length _cffi_d_olm_pk_mac_length
#endif

static size_t _cffi_d_olm_pk_max_plaintext_length(OlmPkDecryption const * x0, size_t x1)
{
  return olm_pk_max_plaintext_length(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_pk_max_plaintext_length(PyObject *self, PyObject *args)
{
  OlmPkDecryption const * x0;
  size_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "olm_pk_max_plaintext_length", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(37), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmPkDecryption const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(37), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_pk_max_plaintext_length(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_pk_max_plaintext_length _cffi_d_olm_pk_max_plaintext_length
#endif

static size_t _cffi_d_olm_pk_private_key_length(void)
{
  return olm_pk_private_key_length();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_pk_private_key_length(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_pk_private_key_length(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_olm_pk_private_key_length _cffi_d_olm_pk_private_key_length
#endif

static size_t _cffi_d_olm_pk_sign(OlmPkSigning * x0, uint8_t const * x1, size_t x2, uint8_t * x3, size_t x4)
{
  return olm_pk_sign(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_pk_sign(PyObject *self, PyObject *args)
{
  OlmPkSigning * x0;
  uint8_t const * x1;
  size_t x2;
  uint8_t * x3;
  size_t x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "olm_pk_sign", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(269), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmPkSigning *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(269), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(149), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (uint8_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(149), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(130), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (uint8_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(130), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, size_t);
  if (x4 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_pk_sign(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_pk_sign _cffi_d_olm_pk_sign
#endif

static size_t _cffi_d_olm_pk_signature_length(void)
{
  return olm_pk_signature_length();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_pk_signature_length(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_pk_signature_length(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_olm_pk_signature_length _cffi_d_olm_pk_signature_length
#endif

static OlmPkSigning * _cffi_d_olm_pk_signing(void * x0)
{
  return olm_pk_signing(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_pk_signing(PyObject *self, PyObject *arg0)
{
  void * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  OlmPkSigning * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_pk_signing(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(269));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_pk_signing _cffi_d_olm_pk_signing
#endif

static size_t _cffi_d_olm_pk_signing_key_from_seed(OlmPkSigning * x0, void * x1, size_t x2, void const * x3, size_t x4)
{
  return olm_pk_signing_key_from_seed(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_pk_signing_key_from_seed(PyObject *self, PyObject *args)
{
  OlmPkSigning * x0;
  void * x1;
  size_t x2;
  void const * x3;
  size_t x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "olm_pk_signing_key_from_seed", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(269), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmPkSigning *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(269), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(113), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(113), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, size_t);
  if (x4 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_pk_signing_key_from_seed(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_pk_signing_key_from_seed _cffi_d_olm_pk_signing_key_from_seed
#endif

static char const * _cffi_d_olm_pk_signing_last_error(OlmPkSigning const * x0)
{
  return olm_pk_signing_last_error(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_pk_signing_last_error(PyObject *self, PyObject *arg0)
{
  OlmPkSigning const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char const * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(43), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmPkSigning const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(43), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_pk_signing_last_error(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(438));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_pk_signing_last_error _cffi_d_olm_pk_signing_last_error
#endif

static enum OlmErrorCode _cffi_d_olm_pk_signing_last_error_code(OlmPkSigning const * x0)
{
  return olm_pk_signing_last_error_code(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_pk_signing_last_error_code(PyObject *self, PyObject *arg0)
{
  OlmPkSigning const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  enum OlmErrorCode result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(43), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmPkSigning const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(43), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_pk_signing_last_error_code(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(55));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_pk_signing_last_error_code _cffi_d_olm_pk_signing_last_error_code
#endif

static size_t _cffi_d_olm_pk_signing_public_key_length(void)
{
  return olm_pk_signing_public_key_length();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_pk_signing_public_key_length(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_pk_signing_public_key_length(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_olm_pk_signing_public_key_length _cffi_d_olm_pk_signing_public_key_length
#endif

static size_t _cffi_d_olm_pk_signing_seed_length(void)
{
  return olm_pk_signing_seed_length();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_pk_signing_seed_length(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_pk_signing_seed_length(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_olm_pk_signing_seed_length _cffi_d_olm_pk_signing_seed_length
#endif

static size_t _cffi_d_olm_pk_signing_size(void)
{
  return olm_pk_signing_size();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_pk_signing_size(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_pk_signing_size(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_olm_pk_signing_size _cffi_d_olm_pk_signing_size
#endif

static size_t _cffi_d_olm_remove_one_time_keys(OlmAccount * x0, OlmSession * x1)
{
  return olm_remove_one_time_keys(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_remove_one_time_keys(PyObject *self, PyObject *args)
{
  OlmAccount * x0;
  OlmSession * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "olm_remove_one_time_keys", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(94), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmAccount *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(94), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(98), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (OlmSession *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(98), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_remove_one_time_keys(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_remove_one_time_keys _cffi_d_olm_remove_one_time_keys
#endif

static OlmSAS * _cffi_d_olm_sas(void * x0)
{
  return olm_sas(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_sas(PyObject *self, PyObject *arg0)
{
  void * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  OlmSAS * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_sas(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(286));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_sas _cffi_d_olm_sas
#endif

static size_t _cffi_d_olm_sas_calculate_mac(OlmSAS * x0, void const * x1, size_t x2, void const * x3, size_t x4, void * x5, size_t x6)
{
  return olm_sas_calculate_mac(x0, x1, x2, x3, x4, x5, x6);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_sas_calculate_mac(PyObject *self, PyObject *args)
{
  OlmSAS * x0;
  void const * x1;
  size_t x2;
  void const * x3;
  size_t x4;
  void * x5;
  size_t x6;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;

  if (!PyArg_UnpackTuple(args, "olm_sas_calculate_mac", 7, 7, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(286), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmSAS *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(286), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(113), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(113), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(113), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(113), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, size_t);
  if (x4 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x6 = _cffi_to_c_int(arg6, size_t);
  if (x6 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_sas_calculate_mac(x0, x1, x2, x3, x4, x5, x6); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_sas_calculate_mac _cffi_d_olm_sas_calculate_mac
#endif

static size_t _cffi_d_olm_sas_calculate_mac_fixed_base64(OlmSAS * x0, void const * x1, size_t x2, void const * x3, size_t x4, void * x5, size_t x6)
{
  return olm_sas_calculate_mac_fixed_base64(x0, x1, x2, x3, x4, x5, x6);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_sas_calculate_mac_fixed_base64(PyObject *self, PyObject *args)
{
  OlmSAS * x0;
  void const * x1;
  size_t x2;
  void const * x3;
  size_t x4;
  void * x5;
  size_t x6;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;

  if (!PyArg_UnpackTuple(args, "olm_sas_calculate_mac_fixed_base64", 7, 7, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(286), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmSAS *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(286), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(113), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(113), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(113), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(113), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, size_t);
  if (x4 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x6 = _cffi_to_c_int(arg6, size_t);
  if (x6 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_sas_calculate_mac_fixed_base64(x0, x1, x2, x3, x4, x5, x6); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_sas_calculate_mac_fixed_base64 _cffi_d_olm_sas_calculate_mac_fixed_base64
#endif

static size_t _cffi_d_olm_sas_calculate_mac_long_kdf(OlmSAS * x0, void const * x1, size_t x2, void const * x3, size_t x4, void * x5, size_t x6)
{
  return olm_sas_calculate_mac_long_kdf(x0, x1, x2, x3, x4, x5, x6);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_sas_calculate_mac_long_kdf(PyObject *self, PyObject *args)
{
  OlmSAS * x0;
  void const * x1;
  size_t x2;
  void const * x3;
  size_t x4;
  void * x5;
  size_t x6;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;

  if (!PyArg_UnpackTuple(args, "olm_sas_calculate_mac_long_kdf", 7, 7, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(286), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmSAS *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(286), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(113), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(113), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(113), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(113), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, size_t);
  if (x4 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x6 = _cffi_to_c_int(arg6, size_t);
  if (x6 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_sas_calculate_mac_long_kdf(x0, x1, x2, x3, x4, x5, x6); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_sas_calculate_mac_long_kdf _cffi_d_olm_sas_calculate_mac_long_kdf
#endif

static size_t _cffi_d_olm_sas_generate_bytes(OlmSAS * x0, void const * x1, size_t x2, void * x3, size_t x4)
{
  return olm_sas_generate_bytes(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_sas_generate_bytes(PyObject *self, PyObject *args)
{
  OlmSAS * x0;
  void const * x1;
  size_t x2;
  void * x3;
  size_t x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "olm_sas_generate_bytes", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(286), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmSAS *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(286), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(113), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(113), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, size_t);
  if (x4 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_sas_generate_bytes(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_sas_generate_bytes _cffi_d_olm_sas_generate_bytes
#endif

static size_t _cffi_d_olm_sas_get_pubkey(OlmSAS * x0, void * x1, size_t x2)
{
  return olm_sas_get_pubkey(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_sas_get_pubkey(PyObject *self, PyObject *args)
{
  OlmSAS * x0;
  void * x1;
  size_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "olm_sas_get_pubkey", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(286), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmSAS *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(286), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_sas_get_pubkey(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_sas_get_pubkey _cffi_d_olm_sas_get_pubkey
#endif

static int _cffi_d_olm_sas_is_their_key_set(OlmSAS const * x0)
{
  return olm_sas_is_their_key_set(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_sas_is_their_key_set(PyObject *self, PyObject *arg0)
{
  OlmSAS const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(46), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmSAS const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(46), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_sas_is_their_key_set(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_sas_is_their_key_set _cffi_d_olm_sas_is_their_key_set
#endif

static char const * _cffi_d_olm_sas_last_error(OlmSAS const * x0)
{
  return olm_sas_last_error(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_sas_last_error(PyObject *self, PyObject *arg0)
{
  OlmSAS const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char const * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(46), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmSAS const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(46), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_sas_last_error(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(438));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_sas_last_error _cffi_d_olm_sas_last_error
#endif

static enum OlmErrorCode _cffi_d_olm_sas_last_error_code(OlmSAS const * x0)
{
  return olm_sas_last_error_code(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_sas_last_error_code(PyObject *self, PyObject *arg0)
{
  OlmSAS const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  enum OlmErrorCode result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(46), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmSAS const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(46), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_sas_last_error_code(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(55));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_sas_last_error_code _cffi_d_olm_sas_last_error_code
#endif

static size_t _cffi_d_olm_sas_mac_length(OlmSAS const * x0)
{
  return olm_sas_mac_length(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_sas_mac_length(PyObject *self, PyObject *arg0)
{
  OlmSAS const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(46), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmSAS const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(46), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_sas_mac_length(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_sas_mac_length _cffi_d_olm_sas_mac_length
#endif

static size_t _cffi_d_olm_sas_pubkey_length(OlmSAS const * x0)
{
  return olm_sas_pubkey_length(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_sas_pubkey_length(PyObject *self, PyObject *arg0)
{
  OlmSAS const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(46), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmSAS const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(46), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_sas_pubkey_length(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_sas_pubkey_length _cffi_d_olm_sas_pubkey_length
#endif

static size_t _cffi_d_olm_sas_set_their_key(OlmSAS * x0, void * x1, size_t x2)
{
  return olm_sas_set_their_key(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_sas_set_their_key(PyObject *self, PyObject *args)
{
  OlmSAS * x0;
  void * x1;
  size_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "olm_sas_set_their_key", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(286), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmSAS *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(286), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_sas_set_their_key(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_sas_set_their_key _cffi_d_olm_sas_set_their_key
#endif

static size_t _cffi_d_olm_sas_size(void)
{
  return olm_sas_size();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_sas_size(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_sas_size(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_olm_sas_size _cffi_d_olm_sas_size
#endif

static OlmSession * _cffi_d_olm_session(void * x0)
{
  return olm_session(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_session(PyObject *self, PyObject *arg0)
{
  void * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  OlmSession * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_session(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(98));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_session _cffi_d_olm_session
#endif

static void _cffi_d_olm_session_describe(OlmSession * x0, char * x1, size_t x2)
{
  olm_session_describe(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_session_describe(PyObject *self, PyObject *args)
{
  OlmSession * x0;
  char * x1;
  size_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "olm_session_describe", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(98), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmSession *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(98), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(421), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(421), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { olm_session_describe(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_olm_session_describe _cffi_d_olm_session_describe
#endif

static int _cffi_d_olm_session_has_received_message(OlmSession const * x0)
{
  return olm_session_has_received_message(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_session_has_received_message(PyObject *self, PyObject *arg0)
{
  OlmSession const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(49), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmSession const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(49), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_session_has_received_message(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_session_has_received_message _cffi_d_olm_session_has_received_message
#endif

static size_t _cffi_d_olm_session_id(OlmSession * x0, void * x1, size_t x2)
{
  return olm_session_id(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_session_id(PyObject *self, PyObject *args)
{
  OlmSession * x0;
  void * x1;
  size_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "olm_session_id", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(98), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmSession *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(98), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_session_id(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_session_id _cffi_d_olm_session_id
#endif

static size_t _cffi_d_olm_session_id_length(OlmSession const * x0)
{
  return olm_session_id_length(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_session_id_length(PyObject *self, PyObject *arg0)
{
  OlmSession const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(49), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmSession const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(49), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_session_id_length(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_session_id_length _cffi_d_olm_session_id_length
#endif

static char const * _cffi_d_olm_session_last_error(OlmSession const * x0)
{
  return olm_session_last_error(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_session_last_error(PyObject *self, PyObject *arg0)
{
  OlmSession const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char const * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(49), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmSession const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(49), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_session_last_error(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(438));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_session_last_error _cffi_d_olm_session_last_error
#endif

static enum OlmErrorCode _cffi_d_olm_session_last_error_code(OlmSession const * x0)
{
  return olm_session_last_error_code(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_session_last_error_code(PyObject *self, PyObject *arg0)
{
  OlmSession const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  enum OlmErrorCode result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(49), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmSession const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(49), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_session_last_error_code(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(55));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_session_last_error_code _cffi_d_olm_session_last_error_code
#endif

static size_t _cffi_d_olm_session_size(void)
{
  return olm_session_size();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_session_size(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_session_size(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_olm_session_size _cffi_d_olm_session_size
#endif

static size_t _cffi_d_olm_sha256(OlmUtility * x0, void const * x1, size_t x2, void * x3, size_t x4)
{
  return olm_sha256(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_sha256(PyObject *self, PyObject *args)
{
  OlmUtility * x0;
  void const * x1;
  size_t x2;
  void * x3;
  size_t x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "olm_sha256", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(382), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmUtility *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(382), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(113), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(113), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, size_t);
  if (x4 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_sha256(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_sha256 _cffi_d_olm_sha256
#endif

static size_t _cffi_d_olm_sha256_length(OlmUtility const * x0)
{
  return olm_sha256_length(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_sha256_length(PyObject *self, PyObject *arg0)
{
  OlmUtility const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(52), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmUtility const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(52), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_sha256_length(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_sha256_length _cffi_d_olm_sha256_length
#endif

static size_t _cffi_d_olm_unpickle_account(OlmAccount * x0, void const * x1, size_t x2, void * x3, size_t x4)
{
  return olm_unpickle_account(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_unpickle_account(PyObject *self, PyObject *args)
{
  OlmAccount * x0;
  void const * x1;
  size_t x2;
  void * x3;
  size_t x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "olm_unpickle_account", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(94), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmAccount *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(94), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(113), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(113), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, size_t);
  if (x4 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_unpickle_account(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_unpickle_account _cffi_d_olm_unpickle_account
#endif

static size_t _cffi_d_olm_unpickle_inbound_group_session(OlmInboundGroupSession * x0, void const * x1, size_t x2, void * x3, size_t x4)
{
  return olm_unpickle_inbound_group_session(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_unpickle_inbound_group_session(PyObject *self, PyObject *args)
{
  OlmInboundGroupSession * x0;
  void const * x1;
  size_t x2;
  void * x3;
  size_t x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "olm_unpickle_inbound_group_session", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(126), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmInboundGroupSession *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(126), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(113), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(113), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, size_t);
  if (x4 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_unpickle_inbound_group_session(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_unpickle_inbound_group_session _cffi_d_olm_unpickle_inbound_group_session
#endif

static size_t _cffi_d_olm_unpickle_outbound_group_session(OlmOutboundGroupSession * x0, void const * x1, size_t x2, void * x3, size_t x4)
{
  return olm_unpickle_outbound_group_session(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_unpickle_outbound_group_session(PyObject *self, PyObject *args)
{
  OlmOutboundGroupSession * x0;
  void const * x1;
  size_t x2;
  void * x3;
  size_t x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "olm_unpickle_outbound_group_session", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(163), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmOutboundGroupSession *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(163), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(113), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(113), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, size_t);
  if (x4 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_unpickle_outbound_group_session(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_unpickle_outbound_group_session _cffi_d_olm_unpickle_outbound_group_session
#endif

static size_t _cffi_d_olm_unpickle_pk_decryption(OlmPkDecryption * x0, void const * x1, size_t x2, void * x3, size_t x4, void * x5, size_t x6)
{
  return olm_unpickle_pk_decryption(x0, x1, x2, x3, x4, x5, x6);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_unpickle_pk_decryption(PyObject *self, PyObject *args)
{
  OlmPkDecryption * x0;
  void const * x1;
  size_t x2;
  void * x3;
  size_t x4;
  void * x5;
  size_t x6;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;

  if (!PyArg_UnpackTuple(args, "olm_unpickle_pk_decryption", 7, 7, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(192), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmPkDecryption *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(192), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(113), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(113), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, size_t);
  if (x4 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x6 = _cffi_to_c_int(arg6, size_t);
  if (x6 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_unpickle_pk_decryption(x0, x1, x2, x3, x4, x5, x6); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_unpickle_pk_decryption _cffi_d_olm_unpickle_pk_decryption
#endif

static size_t _cffi_d_olm_unpickle_session(OlmSession * x0, void const * x1, size_t x2, void * x3, size_t x4)
{
  return olm_unpickle_session(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_unpickle_session(PyObject *self, PyObject *args)
{
  OlmSession * x0;
  void const * x1;
  size_t x2;
  void * x3;
  size_t x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "olm_unpickle_session", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(98), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmSession *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(98), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(113), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(113), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = _cffi_to_c_int(arg4, size_t);
  if (x4 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_unpickle_session(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_unpickle_session _cffi_d_olm_unpickle_session
#endif

static OlmUtility * _cffi_d_olm_utility(void * x0)
{
  return olm_utility(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_utility(PyObject *self, PyObject *arg0)
{
  void * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  OlmUtility * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(1), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(1), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_utility(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(382));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_utility _cffi_d_olm_utility
#endif

static char const * _cffi_d_olm_utility_last_error(OlmUtility const * x0)
{
  return olm_utility_last_error(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_utility_last_error(PyObject *self, PyObject *arg0)
{
  OlmUtility const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char const * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(52), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmUtility const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(52), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_utility_last_error(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(438));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_utility_last_error _cffi_d_olm_utility_last_error
#endif

static enum OlmErrorCode _cffi_d_olm_utility_last_error_code(OlmUtility const * x0)
{
  return olm_utility_last_error_code(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_utility_last_error_code(PyObject *self, PyObject *arg0)
{
  OlmUtility const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  enum OlmErrorCode result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(52), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (OlmUtility const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(52), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_utility_last_error_code(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(55));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_olm_utility_last_error_code _cffi_d_olm_utility_last_error_code
#endif

static size_t _cffi_d_olm_utility_size(void)
{
  return olm_utility_size();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_olm_utility_size(PyObject *self, PyObject *noarg)
{
  size_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = olm_utility_size(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  return pyresult;
}
#else
#  define _cffi_f_olm_utility_size _cffi_d_olm_utility_size
#endif

static int _cffi_const_OLM_MESSAGE_TYPE_MESSAGE(unsigned long long *o)
{
  int n = (OLM_MESSAGE_TYPE_MESSAGE) <= 0;
  *o = (unsigned long long)((OLM_MESSAGE_TYPE_MESSAGE) | 0);  /* check that OLM_MESSAGE_TYPE_MESSAGE is an integer */
  if (!_cffi_check_int(*o, n, 1U))
    n |= 2;
  return n;
}

static int _cffi_const_OLM_MESSAGE_TYPE_PRE_KEY(unsigned long long *o)
{
  int n = (OLM_MESSAGE_TYPE_PRE_KEY) <= 0;
  *o = (unsigned long long)((OLM_MESSAGE_TYPE_PRE_KEY) | 0);  /* check that OLM_MESSAGE_TYPE_PRE_KEY is an integer */
  if (!_cffi_check_int(*o, n, 0))
    n |= 2;
  return n;
}

static const struct _cffi_global_s _cffi_globals[] = {
  { "OLM_BAD_ACCOUNT_KEY", (void *)_cffi_const_OLM_BAD_ACCOUNT_KEY, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "OLM_BAD_LEGACY_ACCOUNT_PICKLE", (void *)_cffi_const_OLM_BAD_LEGACY_ACCOUNT_PICKLE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "OLM_BAD_MESSAGE_FORMAT", (void *)_cffi_const_OLM_BAD_MESSAGE_FORMAT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "OLM_BAD_MESSAGE_KEY_ID", (void *)_cffi_const_OLM_BAD_MESSAGE_KEY_ID, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "OLM_BAD_MESSAGE_MAC", (void *)_cffi_const_OLM_BAD_MESSAGE_MAC, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "OLM_BAD_MESSAGE_VERSION", (void *)_cffi_const_OLM_BAD_MESSAGE_VERSION, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "OLM_BAD_SESSION_KEY", (void *)_cffi_const_OLM_BAD_SESSION_KEY, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "OLM_BAD_SIGNATURE", (void *)_cffi_const_OLM_BAD_SIGNATURE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "OLM_CORRUPTED_PICKLE", (void *)_cffi_const_OLM_CORRUPTED_PICKLE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "OLM_INPUT_BUFFER_TOO_SMALL", (void *)_cffi_const_OLM_INPUT_BUFFER_TOO_SMALL, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "OLM_INVALID_BASE64", (void *)_cffi_const_OLM_INVALID_BASE64, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "OLM_MESSAGE_TYPE_MESSAGE", (void *)_cffi_const_OLM_MESSAGE_TYPE_MESSAGE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "OLM_MESSAGE_TYPE_PRE_KEY", (void *)_cffi_const_OLM_MESSAGE_TYPE_PRE_KEY, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "OLM_NOT_ENOUGH_RANDOM", (void *)_cffi_const_OLM_NOT_ENOUGH_RANDOM, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "OLM_OUTPUT_BUFFER_TOO_SMALL", (void *)_cffi_const_OLM_OUTPUT_BUFFER_TOO_SMALL, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "OLM_PICKLE_EXTRA_DATA", (void *)_cffi_const_OLM_PICKLE_EXTRA_DATA, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "OLM_SAS_THEIR_KEY_NOT_SET", (void *)_cffi_const_OLM_SAS_THEIR_KEY_NOT_SET, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "OLM_SUCCESS", (void *)_cffi_const_OLM_SUCCESS, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "OLM_UNKNOWN_MESSAGE_INDEX", (void *)_cffi_const_OLM_UNKNOWN_MESSAGE_INDEX, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "OLM_UNKNOWN_PICKLE_VERSION", (void *)_cffi_const_OLM_UNKNOWN_PICKLE_VERSION, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "_olm_error_to_string", (void *)_cffi_f__olm_error_to_string, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 54), (void *)_cffi_d__olm_error_to_string },
  { "memset", (void *)_cffi_f_memset, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 411), (void *)_cffi_d_memset },
  { "olm_account", (void *)_cffi_f_olm_account, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 0), (void *)_cffi_d_olm_account },
  { "olm_account_fallback_key", (void *)_cffi_f_olm_account_fallback_key, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 106), (void *)_cffi_d_olm_account_fallback_key },
  { "olm_account_fallback_key_length", (void *)_cffi_f_olm_account_fallback_key_length, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 118), (void *)_cffi_d_olm_account_fallback_key_length },
  { "olm_account_forget_old_fallback_key", (void *)_cffi_f_olm_account_forget_old_fallback_key, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 416), (void *)_cffi_d_olm_account_forget_old_fallback_key },
  { "olm_account_generate_fallback_key", (void *)_cffi_f_olm_account_generate_fallback_key, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 106), (void *)_cffi_d_olm_account_generate_fallback_key },
  { "olm_account_generate_fallback_key_random_length", (void *)_cffi_f_olm_account_generate_fallback_key_random_length, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 118), (void *)_cffi_d_olm_account_generate_fallback_key_random_length },
  { "olm_account_generate_one_time_keys", (void *)_cffi_f_olm_account_generate_one_time_keys, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 100), (void *)_cffi_d_olm_account_generate_one_time_keys },
  { "olm_account_generate_one_time_keys_random_length", (void *)_cffi_f_olm_account_generate_one_time_keys_random_length, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 121), (void *)_cffi_d_olm_account_generate_one_time_keys_random_length },
  { "olm_account_identity_keys", (void *)_cffi_f_olm_account_identity_keys, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 106), (void *)_cffi_d_olm_account_identity_keys },
  { "olm_account_identity_keys_length", (void *)_cffi_f_olm_account_identity_keys_length, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 118), (void *)_cffi_d_olm_account_identity_keys_length },
  { "olm_account_last_error", (void *)_cffi_f_olm_account_last_error, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 27), (void *)_cffi_d_olm_account_last_error },
  { "olm_account_last_error_code", (void *)_cffi_f_olm_account_last_error_code, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 57), (void *)_cffi_d_olm_account_last_error_code },
  { "olm_account_mark_keys_as_published", (void *)_cffi_f_olm_account_mark_keys_as_published, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 93), (void *)_cffi_d_olm_account_mark_keys_as_published },
  { "olm_account_max_number_of_one_time_keys", (void *)_cffi_f_olm_account_max_number_of_one_time_keys, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 118), (void *)_cffi_d_olm_account_max_number_of_one_time_keys },
  { "olm_account_one_time_keys", (void *)_cffi_f_olm_account_one_time_keys, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 106), (void *)_cffi_d_olm_account_one_time_keys },
  { "olm_account_one_time_keys_length", (void *)_cffi_f_olm_account_one_time_keys_length, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 118), (void *)_cffi_d_olm_account_one_time_keys_length },
  { "olm_account_sign", (void *)_cffi_f_olm_account_sign, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 111), (void *)_cffi_d_olm_account_sign },
  { "olm_account_signature_length", (void *)_cffi_f_olm_account_signature_length, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 118), (void *)_cffi_d_olm_account_signature_length },
  { "olm_account_size", (void *)_cffi_f_olm_account_size, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 403), (void *)_cffi_d_olm_account_size },
  { "olm_account_unpublished_fallback_key", (void *)_cffi_f_olm_account_unpublished_fallback_key, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 106), (void *)_cffi_d_olm_account_unpublished_fallback_key },
  { "olm_account_unpublished_fallback_key_length", (void *)_cffi_f_olm_account_unpublished_fallback_key_length, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 118), (void *)_cffi_d_olm_account_unpublished_fallback_key_length },
  { "olm_clear_account", (void *)_cffi_f_olm_clear_account, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 93), (void *)_cffi_d_olm_clear_account },
  { "olm_clear_inbound_group_session", (void *)_cffi_f_olm_clear_inbound_group_session, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 125), (void *)_cffi_d_olm_clear_inbound_group_session },
  { "olm_clear_outbound_group_session", (void *)_cffi_f_olm_clear_outbound_group_session, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 162), (void *)_cffi_d_olm_clear_outbound_group_session },
  { "olm_clear_pk_decryption", (void *)_cffi_f_olm_clear_pk_decryption, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 191), (void *)_cffi_d_olm_clear_pk_decryption },
  { "olm_clear_pk_encryption", (void *)_cffi_f_olm_clear_pk_encryption, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 240), (void *)_cffi_d_olm_clear_pk_encryption },
  { "olm_clear_pk_signing", (void *)_cffi_f_olm_clear_pk_signing, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 268), (void *)_cffi_d_olm_clear_pk_signing },
  { "olm_clear_sas", (void *)_cffi_f_olm_clear_sas, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 285), (void *)_cffi_d_olm_clear_sas },
  { "olm_clear_session", (void *)_cffi_f_olm_clear_session, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 312), (void *)_cffi_d_olm_clear_session },
  { "olm_clear_utility", (void *)_cffi_f_olm_clear_utility, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 381), (void *)_cffi_d_olm_clear_utility },
  { "olm_create_account", (void *)_cffi_f_olm_create_account, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 106), (void *)_cffi_d_olm_create_account },
  { "olm_create_account_random_length", (void *)_cffi_f_olm_create_account_random_length, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 118), (void *)_cffi_d_olm_create_account_random_length },
  { "olm_create_inbound_session", (void *)_cffi_f_olm_create_inbound_session, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 315), (void *)_cffi_d_olm_create_inbound_session },
  { "olm_create_inbound_session_from", (void *)_cffi_f_olm_create_inbound_session_from, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 321), (void *)_cffi_d_olm_create_inbound_session_from },
  { "olm_create_outbound_session", (void *)_cffi_f_olm_create_outbound_session, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 329), (void *)_cffi_d_olm_create_outbound_session },
  { "olm_create_outbound_session_random_length", (void *)_cffi_f_olm_create_outbound_session_random_length, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 374), (void *)_cffi_d_olm_create_outbound_session_random_length },
  { "olm_create_sas", (void *)_cffi_f_olm_create_sas, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 288), (void *)_cffi_d_olm_create_sas },
  { "olm_create_sas_random_length", (void *)_cffi_f_olm_create_sas_random_length, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 309), (void *)_cffi_d_olm_create_sas_random_length },
  { "olm_decrypt", (void *)_cffi_f_olm_decrypt, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 345), (void *)_cffi_d_olm_decrypt },
  { "olm_decrypt_max_plaintext_length", (void *)_cffi_f_olm_decrypt_max_plaintext_length, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 339), (void *)_cffi_d_olm_decrypt_max_plaintext_length },
  { "olm_ed25519_verify", (void *)_cffi_f_olm_ed25519_verify, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 391), (void *)_cffi_d_olm_ed25519_verify },
  { "olm_encrypt", (void *)_cffi_f_olm_encrypt, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 365), (void *)_cffi_d_olm_encrypt },
  { "olm_encrypt_message_length", (void *)_cffi_f_olm_encrypt_message_length, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 377), (void *)_cffi_d_olm_encrypt_message_length },
  { "olm_encrypt_message_type", (void *)_cffi_f_olm_encrypt_message_type, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 374), (void *)_cffi_d_olm_encrypt_message_type },
  { "olm_encrypt_random_length", (void *)_cffi_f_olm_encrypt_random_length, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 374), (void *)_cffi_d_olm_encrypt_random_length },
  { "olm_error", (void *)_cffi_f_olm_error, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 403), (void *)_cffi_d_olm_error },
  { "olm_export_inbound_group_session", (void *)_cffi_f_olm_export_inbound_group_session, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 133), (void *)_cffi_d_olm_export_inbound_group_session },
  { "olm_export_inbound_group_session_length", (void *)_cffi_f_olm_export_inbound_group_session_length, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 159), (void *)_cffi_d_olm_export_inbound_group_session_length },
  { "olm_get_library_version", (void *)_cffi_f_olm_get_library_version, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 424), (void *)_cffi_d_olm_get_library_version },
  { "olm_group_decrypt", (void *)_cffi_f_olm_group_decrypt, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 139), (void *)_cffi_d_olm_group_decrypt },
  { "olm_group_decrypt_max_plaintext_length", (void *)_cffi_f_olm_group_decrypt_max_plaintext_length, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 128), (void *)_cffi_d_olm_group_decrypt_max_plaintext_length },
  { "olm_group_encrypt", (void *)_cffi_f_olm_group_encrypt, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 174), (void *)_cffi_d_olm_group_encrypt },
  { "olm_group_encrypt_message_length", (void *)_cffi_f_olm_group_encrypt_message_length, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 165), (void *)_cffi_d_olm_group_encrypt_message_length },
  { "olm_import_inbound_group_session", (void *)_cffi_f_olm_import_inbound_group_session, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 147), (void *)_cffi_d_olm_import_inbound_group_session },
  { "olm_inbound_group_session", (void *)_cffi_f_olm_inbound_group_session, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 3), (void *)_cffi_d_olm_inbound_group_session },
  { "olm_inbound_group_session_first_known_index", (void *)_cffi_f_olm_inbound_group_session_first_known_index, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 405), (void *)_cffi_d_olm_inbound_group_session_first_known_index },
  { "olm_inbound_group_session_id", (void *)_cffi_f_olm_inbound_group_session_id, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 128), (void *)_cffi_d_olm_inbound_group_session_id },
  { "olm_inbound_group_session_id_length", (void *)_cffi_f_olm_inbound_group_session_id_length, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 159), (void *)_cffi_d_olm_inbound_group_session_id_length },
  { "olm_inbound_group_session_is_verified", (void *)_cffi_f_olm_inbound_group_session_is_verified, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 84), (void *)_cffi_d_olm_inbound_group_session_is_verified },
  { "olm_inbound_group_session_last_error", (void *)_cffi_f_olm_inbound_group_session_last_error, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 30), (void *)_cffi_d_olm_inbound_group_session_last_error },
  { "olm_inbound_group_session_last_error_code", (void *)_cffi_f_olm_inbound_group_session_last_error_code, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 60), (void *)_cffi_d_olm_inbound_group_session_last_error_code },
  { "olm_inbound_group_session_size", (void *)_cffi_f_olm_inbound_group_session_size, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 403), (void *)_cffi_d_olm_inbound_group_session_size },
  { "olm_init_inbound_group_session", (void *)_cffi_f_olm_init_inbound_group_session, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 147), (void *)_cffi_d_olm_init_inbound_group_session },
  { "olm_init_outbound_group_session", (void *)_cffi_f_olm_init_outbound_group_session, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 169), (void *)_cffi_d_olm_init_outbound_group_session },
  { "olm_init_outbound_group_session_random_length", (void *)_cffi_f_olm_init_outbound_group_session_random_length, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 188), (void *)_cffi_d_olm_init_outbound_group_session_random_length },
  { "olm_matches_inbound_session", (void *)_cffi_f_olm_matches_inbound_session, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 353), (void *)_cffi_d_olm_matches_inbound_session },
  { "olm_matches_inbound_session_from", (void *)_cffi_f_olm_matches_inbound_session_from, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 358), (void *)_cffi_d_olm_matches_inbound_session_from },
  { "olm_outbound_group_session", (void *)_cffi_f_olm_outbound_group_session, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 6), (void *)_cffi_d_olm_outbound_group_session },
  { "olm_outbound_group_session_id", (void *)_cffi_f_olm_outbound_group_session_id, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 169), (void *)_cffi_d_olm_outbound_group_session_id },
  { "olm_outbound_group_session_id_length", (void *)_cffi_f_olm_outbound_group_session_id_length, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 188), (void *)_cffi_d_olm_outbound_group_session_id_length },
  { "olm_outbound_group_session_key", (void *)_cffi_f_olm_outbound_group_session_key, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 169), (void *)_cffi_d_olm_outbound_group_session_key },
  { "olm_outbound_group_session_key_length", (void *)_cffi_f_olm_outbound_group_session_key_length, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 188), (void *)_cffi_d_olm_outbound_group_session_key_length },
  { "olm_outbound_group_session_last_error", (void *)_cffi_f_olm_outbound_group_session_last_error, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 33), (void *)_cffi_d_olm_outbound_group_session_last_error },
  { "olm_outbound_group_session_last_error_code", (void *)_cffi_f_olm_outbound_group_session_last_error_code, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 63), (void *)_cffi_d_olm_outbound_group_session_last_error_code },
  { "olm_outbound_group_session_message_index", (void *)_cffi_f_olm_outbound_group_session_message_index, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 408), (void *)_cffi_d_olm_outbound_group_session_message_index },
  { "olm_outbound_group_session_size", (void *)_cffi_f_olm_outbound_group_session_size, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 403), (void *)_cffi_d_olm_outbound_group_session_size },
  { "olm_pickle_account", (void *)_cffi_f_olm_pickle_account, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 111), (void *)_cffi_d_olm_pickle_account },
  { "olm_pickle_account_length", (void *)_cffi_f_olm_pickle_account_length, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 118), (void *)_cffi_d_olm_pickle_account_length },
  { "olm_pickle_inbound_group_session", (void *)_cffi_f_olm_pickle_inbound_group_session, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 152), (void *)_cffi_d_olm_pickle_inbound_group_session },
  { "olm_pickle_inbound_group_session_length", (void *)_cffi_f_olm_pickle_inbound_group_session_length, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 159), (void *)_cffi_d_olm_pickle_inbound_group_session_length },
  { "olm_pickle_outbound_group_session", (void *)_cffi_f_olm_pickle_outbound_group_session, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 181), (void *)_cffi_d_olm_pickle_outbound_group_session },
  { "olm_pickle_outbound_group_session_length", (void *)_cffi_f_olm_pickle_outbound_group_session_length, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 188), (void *)_cffi_d_olm_pickle_outbound_group_session_length },
  { "olm_pickle_pk_decryption", (void *)_cffi_f_olm_pickle_pk_decryption, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 206), (void *)_cffi_d_olm_pickle_pk_decryption },
  { "olm_pickle_pk_decryption_length", (void *)_cffi_f_olm_pickle_pk_decryption_length, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 233), (void *)_cffi_d_olm_pickle_pk_decryption_length },
  { "olm_pickle_session", (void *)_cffi_f_olm_pickle_session, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 358), (void *)_cffi_d_olm_pickle_session },
  { "olm_pickle_session_length", (void *)_cffi_f_olm_pickle_session_length, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 374), (void *)_cffi_d_olm_pickle_session_length },
  { "olm_pk_ciphertext_length", (void *)_cffi_f_olm_pk_ciphertext_length, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 264), (void *)_cffi_d_olm_pk_ciphertext_length },
  { "olm_pk_decrypt", (void *)_cffi_f_olm_pk_decrypt, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 222), (void *)_cffi_d_olm_pk_decrypt },
  { "olm_pk_decryption", (void *)_cffi_f_olm_pk_decryption, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 9), (void *)_cffi_d_olm_pk_decryption },
  { "olm_pk_decryption_last_error", (void *)_cffi_f_olm_pk_decryption_last_error, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 36), (void *)_cffi_d_olm_pk_decryption_last_error },
  { "olm_pk_decryption_last_error_code", (void *)_cffi_f_olm_pk_decryption_last_error_code, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 66), (void *)_cffi_d_olm_pk_decryption_last_error_code },
  { "olm_pk_decryption_size", (void *)_cffi_f_olm_pk_decryption_size, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 403), (void *)_cffi_d_olm_pk_decryption_size },
  { "olm_pk_encrypt", (void *)_cffi_f_olm_pk_encrypt, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 248), (void *)_cffi_d_olm_pk_encrypt },
  { "olm_pk_encrypt_random_length", (void *)_cffi_f_olm_pk_encrypt_random_length, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 261), (void *)_cffi_d_olm_pk_encrypt_random_length },
  { "olm_pk_encryption", (void *)_cffi_f_olm_pk_encryption, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 12), (void *)_cffi_d_olm_pk_encryption },
  { "olm_pk_encryption_last_error", (void *)_cffi_f_olm_pk_encryption_last_error, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 39), (void *)_cffi_d_olm_pk_encryption_last_error },
  { "olm_pk_encryption_last_error_code", (void *)_cffi_f_olm_pk_encryption_last_error_code, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 69), (void *)_cffi_d_olm_pk_encryption_last_error_code },
  { "olm_pk_encryption_set_recipient_key", (void *)_cffi_f_olm_pk_encryption_set_recipient_key, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 243), (void *)_cffi_d_olm_pk_encryption_set_recipient_key },
  { "olm_pk_encryption_size", (void *)_cffi_f_olm_pk_encryption_size, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 403), (void *)_cffi_d_olm_pk_encryption_size },
  { "olm_pk_generate_key", (void *)_cffi_f_olm_pk_generate_key, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 199), (void *)_cffi_d_olm_pk_generate_key },
  { "olm_pk_generate_key_random_length", (void *)_cffi_f_olm_pk_generate_key_random_length, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 403), (void *)_cffi_d_olm_pk_generate_key_random_length },
  { "olm_pk_get_private_key", (void *)_cffi_f_olm_pk_get_private_key, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 194), (void *)_cffi_d_olm_pk_get_private_key },
  { "olm_pk_key_from_private", (void *)_cffi_f_olm_pk_key_from_private, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 199), (void *)_cffi_d_olm_pk_key_from_private },
  { "olm_pk_key_length", (void *)_cffi_f_olm_pk_key_length, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 403), (void *)_cffi_d_olm_pk_key_length },
  { "olm_pk_mac_length", (void *)_cffi_f_olm_pk_mac_length, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 261), (void *)_cffi_d_olm_pk_mac_length },
  { "olm_pk_max_plaintext_length", (void *)_cffi_f_olm_pk_max_plaintext_length, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 236), (void *)_cffi_d_olm_pk_max_plaintext_length },
  { "olm_pk_private_key_length", (void *)_cffi_f_olm_pk_private_key_length, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 403), (void *)_cffi_d_olm_pk_private_key_length },
  { "olm_pk_sign", (void *)_cffi_f_olm_pk_sign, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 271), (void *)_cffi_d_olm_pk_sign },
  { "olm_pk_signature_length", (void *)_cffi_f_olm_pk_signature_length, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 403), (void *)_cffi_d_olm_pk_signature_length },
  { "olm_pk_signing", (void *)_cffi_f_olm_pk_signing, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 15), (void *)_cffi_d_olm_pk_signing },
  { "olm_pk_signing_key_from_seed", (void *)_cffi_f_olm_pk_signing_key_from_seed, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 278), (void *)_cffi_d_olm_pk_signing_key_from_seed },
  { "olm_pk_signing_last_error", (void *)_cffi_f_olm_pk_signing_last_error, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 42), (void *)_cffi_d_olm_pk_signing_last_error },
  { "olm_pk_signing_last_error_code", (void *)_cffi_f_olm_pk_signing_last_error_code, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 72), (void *)_cffi_d_olm_pk_signing_last_error_code },
  { "olm_pk_signing_public_key_length", (void *)_cffi_f_olm_pk_signing_public_key_length, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 403), (void *)_cffi_d_olm_pk_signing_public_key_length },
  { "olm_pk_signing_seed_length", (void *)_cffi_f_olm_pk_signing_seed_length, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 403), (void *)_cffi_d_olm_pk_signing_seed_length },
  { "olm_pk_signing_size", (void *)_cffi_f_olm_pk_signing_size, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 403), (void *)_cffi_d_olm_pk_signing_size },
  { "olm_remove_one_time_keys", (void *)_cffi_f_olm_remove_one_time_keys, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 96), (void *)_cffi_d_olm_remove_one_time_keys },
  { "olm_sas", (void *)_cffi_f_olm_sas, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 18), (void *)_cffi_d_olm_sas },
  { "olm_sas_calculate_mac", (void *)_cffi_f_olm_sas_calculate_mac, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 300), (void *)_cffi_d_olm_sas_calculate_mac },
  { "olm_sas_calculate_mac_fixed_base64", (void *)_cffi_f_olm_sas_calculate_mac_fixed_base64, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 300), (void *)_cffi_d_olm_sas_calculate_mac_fixed_base64 },
  { "olm_sas_calculate_mac_long_kdf", (void *)_cffi_f_olm_sas_calculate_mac_long_kdf, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 300), (void *)_cffi_d_olm_sas_calculate_mac_long_kdf },
  { "olm_sas_generate_bytes", (void *)_cffi_f_olm_sas_generate_bytes, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 293), (void *)_cffi_d_olm_sas_generate_bytes },
  { "olm_sas_get_pubkey", (void *)_cffi_f_olm_sas_get_pubkey, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 288), (void *)_cffi_d_olm_sas_get_pubkey },
  { "olm_sas_is_their_key_set", (void *)_cffi_f_olm_sas_is_their_key_set, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 87), (void *)_cffi_d_olm_sas_is_their_key_set },
  { "olm_sas_last_error", (void *)_cffi_f_olm_sas_last_error, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 45), (void *)_cffi_d_olm_sas_last_error },
  { "olm_sas_last_error_code", (void *)_cffi_f_olm_sas_last_error_code, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 75), (void *)_cffi_d_olm_sas_last_error_code },
  { "olm_sas_mac_length", (void *)_cffi_f_olm_sas_mac_length, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 309), (void *)_cffi_d_olm_sas_mac_length },
  { "olm_sas_pubkey_length", (void *)_cffi_f_olm_sas_pubkey_length, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 309), (void *)_cffi_d_olm_sas_pubkey_length },
  { "olm_sas_set_their_key", (void *)_cffi_f_olm_sas_set_their_key, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 288), (void *)_cffi_d_olm_sas_set_their_key },
  { "olm_sas_size", (void *)_cffi_f_olm_sas_size, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 403), (void *)_cffi_d_olm_sas_size },
  { "olm_session", (void *)_cffi_f_olm_session, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 21), (void *)_cffi_d_olm_session },
  { "olm_session_describe", (void *)_cffi_f_olm_session_describe, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 419), (void *)_cffi_d_olm_session_describe },
  { "olm_session_has_received_message", (void *)_cffi_f_olm_session_has_received_message, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 90), (void *)_cffi_d_olm_session_has_received_message },
  { "olm_session_id", (void *)_cffi_f_olm_session_id, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 353), (void *)_cffi_d_olm_session_id },
  { "olm_session_id_length", (void *)_cffi_f_olm_session_id_length, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 374), (void *)_cffi_d_olm_session_id_length },
  { "olm_session_last_error", (void *)_cffi_f_olm_session_last_error, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 48), (void *)_cffi_d_olm_session_last_error },
  { "olm_session_last_error_code", (void *)_cffi_f_olm_session_last_error_code, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 78), (void *)_cffi_d_olm_session_last_error_code },
  { "olm_session_size", (void *)_cffi_f_olm_session_size, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 403), (void *)_cffi_d_olm_session_size },
  { "olm_sha256", (void *)_cffi_f_olm_sha256, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 384), (void *)_cffi_d_olm_sha256 },
  { "olm_sha256_length", (void *)_cffi_f_olm_sha256_length, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 400), (void *)_cffi_d_olm_sha256_length },
  { "olm_unpickle_account", (void *)_cffi_f_olm_unpickle_account, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 111), (void *)_cffi_d_olm_unpickle_account },
  { "olm_unpickle_inbound_group_session", (void *)_cffi_f_olm_unpickle_inbound_group_session, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 152), (void *)_cffi_d_olm_unpickle_inbound_group_session },
  { "olm_unpickle_outbound_group_session", (void *)_cffi_f_olm_unpickle_outbound_group_session, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 181), (void *)_cffi_d_olm_unpickle_outbound_group_session },
  { "olm_unpickle_pk_decryption", (void *)_cffi_f_olm_unpickle_pk_decryption, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 213), (void *)_cffi_d_olm_unpickle_pk_decryption },
  { "olm_unpickle_session", (void *)_cffi_f_olm_unpickle_session, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 358), (void *)_cffi_d_olm_unpickle_session },
  { "olm_utility", (void *)_cffi_f_olm_utility, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 24), (void *)_cffi_d_olm_utility },
  { "olm_utility_last_error", (void *)_cffi_f_olm_utility_last_error, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 51), (void *)_cffi_d_olm_utility_last_error },
  { "olm_utility_last_error_code", (void *)_cffi_f_olm_utility_last_error_code, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 81), (void *)_cffi_d_olm_utility_last_error_code },
  { "olm_utility_size", (void *)_cffi_f_olm_utility_size, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 403), (void *)_cffi_d_olm_utility_size },
};

static const struct _cffi_struct_union_s _cffi_struct_unions[] = {
  { "OlmAccount", 429, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "OlmInboundGroupSession", 430, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "OlmOutboundGroupSession", 431, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "OlmPkDecryption", 432, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "OlmPkEncryption", 433, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "OlmPkSigning", 434, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "OlmSAS", 435, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "OlmSession", 436, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "OlmUtility", 437, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
};

static const struct _cffi_enum_s _cffi_enums[] = {
  { "OlmErrorCode", 55, _cffi_prim_int(sizeof(enum OlmErrorCode), ((enum OlmErrorCode)-1) <= 0),
    "OLM_SUCCESS,OLM_NOT_ENOUGH_RANDOM,OLM_OUTPUT_BUFFER_TOO_SMALL,OLM_BAD_MESSAGE_VERSION,OLM_BAD_MESSAGE_FORMAT,OLM_BAD_MESSAGE_MAC,OLM_BAD_MESSAGE_KEY_ID,OLM_INVALID_BASE64,OLM_BAD_ACCOUNT_KEY,OLM_UNKNOWN_PICKLE_VERSION,OLM_CORRUPTED_PICKLE,OLM_BAD_SESSION_KEY,OLM_UNKNOWN_MESSAGE_INDEX,OLM_BAD_LEGACY_ACCOUNT_PICKLE,OLM_BAD_SIGNATURE,OLM_INPUT_BUFFER_TOO_SMALL,OLM_SAS_THEIR_KEY_NOT_SET,OLM_PICKLE_EXTRA_DATA" },
};

static const struct _cffi_typename_s _cffi_typenames[] = {
  { "OlmAccount", 429 },
  { "OlmInboundGroupSession", 430 },
  { "OlmOutboundGroupSession", 431 },
  { "OlmPkDecryption", 432 },
  { "OlmPkEncryption", 433 },
  { "OlmPkSigning", 434 },
  { "OlmSAS", 435 },
  { "OlmSession", 436 },
  { "OlmUtility", 437 },
};

static const struct _cffi_type_context_s _cffi_type_context = {
  _cffi_types,
  _cffi_globals,
  NULL,  /* no fields */
  _cffi_struct_unions,
  _cffi_enums,
  _cffi_typenames,
  171,  /* num_globals */
  9,  /* num_struct_unions */
  1,  /* num_enums */
  9,  /* num_typenames */
  NULL,  /* no includes */
  442,  /* num_types */
  0,  /* flags */
};

#ifdef __GNUC__
#  pragma GCC visibility push(default)  /* for -fvisibility= */
#endif

#ifdef PYPY_VERSION
PyMODINIT_FUNC
_cffi_pypyinit__libolm(const void *p[])
{
    p[0] = (const void *)0x2601;
    p[1] = &_cffi_type_context;
#if PY_MAJOR_VERSION >= 3
    return NULL;
#endif
}
#  ifdef _MSC_VER
     PyMODINIT_FUNC
#  if PY_MAJOR_VERSION >= 3
     PyInit__libolm(void) { return NULL; }
#  else
     init_libolm(void) { }
#  endif
#  endif
#elif PY_MAJOR_VERSION >= 3
PyMODINIT_FUNC
PyInit__libolm(void)
{
  return _cffi_init("_libolm", 0x2601, &_cffi_type_context);
}
#else
PyMODINIT_FUNC
init_libolm(void)
{
  _cffi_init("_libolm", 0x2601, &_cffi_type_context);
}
#endif

#ifdef __GNUC__
#  pragma GCC visibility pop
#endif
