/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatLineBorder;
import com.formdev.flatlaf.ui.FlatTableUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.util.function.Function;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.TableUI;

public class FlatTableCellBorder
extends FlatLineBorder {
    protected boolean showCellFocusIndicator = UIManager.getBoolean("Table.showCellFocusIndicator");
    private Component c;

    protected FlatTableCellBorder() {
        super(UIManager.getInsets("Table.cellMargins"), UIManager.getColor("Table.cellFocusColor"));
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        Insets m3 = FlatTableCellBorder.getStyleFromTableUI(c, ui -> ui.cellMargins);
        if (m3 != null) {
            return FlatTableCellBorder.scaleInsets(c, insets, m3.top, m3.left, m3.bottom, m3.right);
        }
        return super.getBorderInsets(c, insets);
    }

    @Override
    public Color getLineColor() {
        Color color;
        if (this.c != null && (color = FlatTableCellBorder.getStyleFromTableUI(this.c, ui -> ui.cellFocusColor)) != null) {
            return color;
        }
        return super.getLineColor();
    }

    @Override
    public void paintBorder(Component c, Graphics g2, int x, int y, int width, int height) {
        this.c = c;
        super.paintBorder(c, g2, x, y, width, height);
        this.c = null;
    }

    static <T> T getStyleFromTableUI(Component c, Function<FlatTableUI, T> f) {
        TableUI ui;
        JTable table = (JTable)SwingUtilities.getAncestorOfClass(JTable.class, c);
        if (table != null && (ui = table.getUI()) instanceof FlatTableUI) {
            return f.apply((FlatTableUI)ui);
        }
        return null;
    }

    public static class Selected
    extends FlatTableCellBorder {
        @Override
        public void paintBorder(Component c, Graphics g2, int x, int y, int width, int height) {
            JTable table;
            boolean showCellFocusIndicator;
            Boolean b = Selected.getStyleFromTableUI(c, ui -> ui.showCellFocusIndicator);
            boolean bl = showCellFocusIndicator = b != null ? b : this.showCellFocusIndicator;
            if (!showCellFocusIndicator && (table = (JTable)SwingUtilities.getAncestorOfClass(JTable.class, c)) != null && !this.isSelectionEditable(table)) {
                return;
            }
            super.paintBorder(c, g2, x, y, width, height);
        }

        protected boolean isSelectionEditable(JTable table) {
            if (table.getRowSelectionAllowed()) {
                int[] selectedRows;
                int columnCount = table.getColumnCount();
                for (int selectedRow : selectedRows = table.getSelectedRows()) {
                    for (int column = 0; column < columnCount; ++column) {
                        if (!table.isCellEditable(selectedRow, column)) continue;
                        return true;
                    }
                }
            }
            if (table.getColumnSelectionAllowed()) {
                int rowCount = table.getRowCount();
                int[] selectedColumns = table.getSelectedColumns();
                for (int selectedColumn : selectedColumns) {
                    for (int row = 0; row < rowCount; ++row) {
                        if (!table.isCellEditable(row, selectedColumn)) continue;
                        return true;
                    }
                }
            }
            return false;
        }
    }

    public static class Focused
    extends FlatTableCellBorder {
    }

    public static class Default
    extends FlatTableCellBorder {
        @Override
        public void paintBorder(Component c, Graphics g2, int x, int y, int width, int height) {
        }
    }
}

