/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.countries.tools;

import eu.hansolo.fx.countries.Country;
import eu.hansolo.fx.countries.evt.CountryEvt;
import eu.hansolo.fx.countries.tools.CLocationBuilder;
import eu.hansolo.fx.countries.tools.ConnectionPartType;
import eu.hansolo.toolbox.evt.EvtObserver;
import eu.hansolo.toolboxfx.geom.Location;
import eu.hansolo.toolboxfx.geom.Poi;
import eu.hansolo.toolboxfx.geom.PoiSize;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import javafx.scene.paint.Color;

public class CLocation
extends Location {
    private final CountryEvt<CLocation> UPDATE_EVENT = new CountryEvt<CLocation>((Object)this, CountryEvt.LOCATION, this);
    private Optional<Country> country = Optional.empty();
    private ConnectionPartType connectionPartType = ConnectionPartType.NONE;
    private List<EvtObserver<CountryEvt<CLocation>>> observers = new CopyOnWriteArrayList<EvtObserver<CountryEvt<CLocation>>>();

    public CLocation() {
        this(0.0, 0.0, 0.0, Instant.now(), "", "", Color.BLACK, Color.TRANSPARENT);
    }

    public CLocation(double latitude, double longitude) {
        this(latitude, longitude, 0.0, Instant.now(), "", "", Color.BLACK, Color.TRANSPARENT);
    }

    public CLocation(double latitude, double longitude, String name) {
        this(latitude, longitude, 0.0, Instant.now(), name, "", Color.BLACK, Color.TRANSPARENT);
    }

    public CLocation(double latitude, double longitude, String name, Color fill) {
        this(latitude, longitude, 0.0, Instant.now(), name, "", fill, Color.TRANSPARENT);
    }

    public CLocation(double latitude, double longitude, String name, String info) {
        this(latitude, longitude, 0.0, Instant.now(), name, info, Color.BLACK, Color.TRANSPARENT);
    }

    public CLocation(double latitude, double longitude, String name, String info, Color fill) {
        this(latitude, longitude, 0.0, Instant.now(), name, info, fill, Color.TRANSPARENT);
    }

    public CLocation(double latitude, double longitude, double altitude, String name) {
        this(latitude, longitude, altitude, Instant.now(), name, "", Color.BLACK, Color.TRANSPARENT);
    }

    public CLocation(double latitude, double longitude, double altitude, Instant timestamp, String name) {
        this(latitude, longitude, altitude, timestamp, name, "", Color.BLACK, Color.TRANSPARENT);
    }

    public CLocation(double latitude, double longitude, double altitude, Instant timestamp, String name, String info, Color fill, Color stroke) {
        super(timestamp, latitude, longitude, altitude, 1.0, name, info, fill, stroke);
    }

    public Optional<Country> getCountry() {
        return this.country;
    }

    public void setCountry(Country country) {
        this.setCountry(Optional.of(country));
    }

    public void setCountry(Optional<Country> country) {
        this.country = country;
        this.fireEvt(this.UPDATE_EVENT);
    }

    public ConnectionPartType getConnectionPartType() {
        return this.connectionPartType;
    }

    public void setConnectionPartType(ConnectionPartType connectionPartType) {
        this.connectionPartType = connectionPartType;
    }

    public void update(double latitude, double longitude) {
        this.set(latitude, longitude);
    }

    @Override
    public void set(double latitude, double longitude) {
        this.set(latitude, longitude, this.getAltitude(), this.getTimestamp(), this.getInfo());
    }

    @Override
    public void set(double latitude, double longitude, double altitude, Instant timestamp) {
        this.set(latitude, longitude, altitude, timestamp, this.getInfo());
    }

    public void set(double latitude, double longitude, double altitude, Instant timestamp, String info) {
        this.setLatitude(latitude);
        this.setLongitude(longitude);
        this.setAltitude(altitude);
        this.setTimestamp(timestamp);
        this.setInfo(info);
        this.fireEvt(this.UPDATE_EVENT);
    }

    public void set(CLocation location) {
        this.setName(location.getName());
        this.setLatitude(location.getLatitude());
        this.setLongitude(location.getLongitude());
        this.setAltitude(location.getAltitude());
        this.setTimestamp(location.getTimestamp());
        this.setInfo(location.getInfo());
        this.setFill(location.getFill());
        this.setStroke(location.getStroke());
        this.connectionPartType = null == this.connectionPartType ? location.getConnectionPartType() : ConnectionPartType.NONE;
        this.fireEvt(this.UPDATE_EVENT);
    }

    public void setOnEvt(EvtObserver<CountryEvt<CLocation>> observer) {
        this.addEvtObserver(observer);
    }

    public void addEvtObserver(EvtObserver<CountryEvt<CLocation>> observer) {
        if (!this.observers.contains(observer)) {
            this.observers.add(observer);
        }
    }

    public void removeEvtObserver(EvtObserver<CountryEvt<CLocation>> observer) {
        if (this.observers.contains(observer)) {
            this.observers.remove(observer);
        }
    }

    public void fireEvt(CountryEvt<CLocation> evt) {
        this.observers.forEach(observer -> observer.handle(evt));
    }

    public Poi toPoi() {
        return new Poi(this.getLatitude(), this.getLongitude(), this.getName(), "", null, PoiSize.NORMAL, this.getFill(), this.getStroke(), null, null, null);
    }

    public static CLocation fromPoi(Poi poi) {
        return ((CLocationBuilder)((CLocationBuilder)((CLocationBuilder)((CLocationBuilder)((CLocationBuilder)CLocationBuilder.create().name(poi.getName())).fill(poi.getFill())).stroke(poi.getStroke())).latitude(poi.getLat())).longitude(poi.getLon())).build();
    }
}

