/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx.skins;

import eu.hansolo.tilesfx.Tile;
import eu.hansolo.tilesfx.events.TileEvt;
import eu.hansolo.tilesfx.fonts.Fonts;
import eu.hansolo.tilesfx.skins.TileSkin;
import eu.hansolo.tilesfx.tools.Helper;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.Effect;
import javafx.scene.effect.InnerShadow;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.RadialGradient;
import javafx.scene.paint.Stop;
import javafx.scene.shape.Circle;
import javafx.scene.text.Font;
import javafx.scene.text.Text;

public class LedTileSkin
extends TileSkin {
    private InnerShadow innerShadow;
    private Paint borderFill;
    private Paint onFill;
    private Paint offFill;
    private Paint highlightFill;
    private Text titleText;
    private Text text;
    private Label description;
    private Circle ledBorder;
    private Circle led;
    private Circle hightlight;

    public LedTileSkin(Tile TILE) {
        super(TILE);
    }

    @Override
    protected void initGraphics() {
        super.initGraphics();
        this.titleText = new Text();
        this.titleText.setFill((Paint)this.tile.getTitleColor());
        Helper.enableNode((Node)this.titleText, !this.tile.getTitle().isEmpty());
        this.text = new Text(this.tile.getText());
        this.text.setFill((Paint)this.tile.getUnitColor());
        Helper.enableNode((Node)this.text, this.tile.isTextVisible());
        this.description = new Label(this.tile.getDescription());
        this.description.setAlignment(this.tile.getDescriptionAlignment());
        this.description.setWrapText(true);
        this.description.setTextFill((Paint)this.tile.getTextColor());
        Helper.enableNode((Node)this.description, !this.tile.getDescription().isEmpty());
        this.ledBorder = new Circle();
        this.led = new Circle();
        this.hightlight = new Circle();
        this.innerShadow = new InnerShadow(BlurType.TWO_PASS_BOX, Color.rgb((int)0, (int)0, (int)0, (double)0.65), 0.07 * this.size, 0.0, 0.0, 0.0);
        this.led.setEffect((Effect)this.innerShadow);
        this.getPane().getChildren().addAll((Object[])new Node[]{this.titleText, this.text, this.description, this.ledBorder, this.led, this.hightlight});
    }

    @Override
    protected void handleEvents(String EVENT_TYPE) {
        super.handleEvents(EVENT_TYPE);
        if (TileEvt.VISIBILITY.getName().equals(EVENT_TYPE)) {
            Helper.enableNode((Node)this.titleText, !this.tile.getTitle().isEmpty());
            Helper.enableNode((Node)this.text, this.tile.isTextVisible());
            Helper.enableNode((Node)this.description, !this.tile.getDescription().isEmpty());
        } else if (TileEvt.REDRAW.getName().equals(EVENT_TYPE)) {
            this.updateFills();
            this.redraw();
        }
    }

    @Override
    protected void handleCurrentValue(double VALUE) {
        this.led.setFill(this.tile.isActive() ? this.onFill : this.offFill);
    }

    private void updateFills() {
        if (this.tile.isFlatUI()) {
            this.borderFill = Color.rgb((int)200, (int)200, (int)200, (double)0.5);
            this.onFill = this.tile.getActiveColor();
            this.offFill = this.tile.getActiveColor().darker().darker().darker().darker();
            this.highlightFill = Color.TRANSPARENT;
            this.led.setEffect(null);
        } else {
            this.borderFill = new LinearGradient(0.0, 0.0, 1.0, 1.0, true, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)20, (int)20, (int)20, (double)0.65)), new Stop(0.15, Color.rgb((int)20, (int)20, (int)20, (double)0.65)), new Stop(0.26, Color.rgb((int)41, (int)41, (int)41, (double)0.65)), new Stop(0.26, Color.rgb((int)41, (int)41, (int)41, (double)0.64)), new Stop(0.85, Color.rgb((int)200, (int)200, (int)200, (double)0.41)), new Stop(1.0, Color.rgb((int)200, (int)200, (int)200, (double)0.35))});
            Color ledColor = this.tile.getActiveColor();
            this.onFill = new LinearGradient(0.0, 0.0, 1.0, 1.0, true, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, ledColor.deriveColor(0.0, 1.0, 0.77, 1.0)), new Stop(0.49, ledColor.deriveColor(0.0, 1.0, 0.5, 1.0)), new Stop(1.0, ledColor)});
            this.offFill = new LinearGradient(0.0, 0.0, 1.0, 1.0, true, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, ledColor.deriveColor(0.0, 1.0, 0.2, 1.0)), new Stop(0.49, ledColor.deriveColor(0.0, 1.0, 0.13, 1.0)), new Stop(1.0, ledColor.deriveColor(0.0, 1.0, 0.2, 1.0))});
            this.highlightFill = new RadialGradient(0.0, 0.0, this.hightlight.getCenterX() - this.hightlight.getRadius(), this.hightlight.getCenterY() - this.hightlight.getRadius(), this.hightlight.getRadius(), false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.WHITE), new Stop(1.0, Color.TRANSPARENT)});
            this.led.setEffect((Effect)this.innerShadow);
        }
    }

    @Override
    protected void resizeStaticText() {
        double maxWidth = this.width - this.size * 0.1;
        double fontSize = this.size * this.textSize.factor;
        boolean customFontEnabled = this.tile.isCustomFontEnabled();
        Font customFont = this.tile.getCustomFont();
        Font font = customFontEnabled && customFont != null ? Font.font((String)customFont.getFamily(), (double)fontSize) : Fonts.latoRegular(fontSize);
        this.titleText.setFont(font);
        if (this.titleText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.titleText, maxWidth, fontSize);
        }
        switch (this.tile.getTitleAlignment()) {
            default: {
                this.titleText.relocate(this.size * 0.05, this.size * 0.05);
                break;
            }
            case CENTER: {
                this.titleText.relocate((this.width - this.titleText.getLayoutBounds().getWidth()) * 0.5, this.size * 0.05);
                break;
            }
            case RIGHT: {
                this.titleText.relocate(this.width - this.size * 0.05 - this.titleText.getLayoutBounds().getWidth(), this.size * 0.05);
            }
        }
        this.text.setText(this.tile.getText());
        this.text.setFont(font);
        if (this.text.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.text, maxWidth, fontSize);
        }
        switch (this.tile.getTextAlignment()) {
            default: {
                this.text.setX(this.size * 0.05);
                break;
            }
            case CENTER: {
                this.text.setX((this.width - this.text.getLayoutBounds().getWidth()) * 0.5);
                break;
            }
            case RIGHT: {
                this.text.setX(this.width - this.size * 0.05 - this.text.getLayoutBounds().getWidth());
            }
        }
        this.text.setY(this.height - this.size * 0.05);
        fontSize = this.size * 0.1;
        this.description.setFont(Fonts.latoRegular(fontSize));
        this.description.setAlignment(Pos.TOP_CENTER);
        this.description.setWrapText(false);
    }

    @Override
    protected void resize() {
        super.resize();
        this.description.setPrefWidth(this.contentBounds.getWidth());
        this.description.relocate(this.contentBounds.getX(), this.contentBounds.getY());
        this.updateFills();
        this.ledBorder.setRadius(this.size * 0.19);
        this.ledBorder.setCenterX(this.width * 0.5);
        this.ledBorder.setCenterY(this.height * 0.5);
        this.led.setRadius(this.size * 0.15);
        this.led.setCenterX(this.width * 0.5);
        this.led.setCenterY(this.height * 0.5);
        this.hightlight.setRadius(this.size * 0.13);
        this.hightlight.setCenterX(this.width * 0.5);
        this.hightlight.setCenterY(this.height * 0.5);
        this.innerShadow.setRadius(0.075 * this.size);
    }

    @Override
    protected void redraw() {
        super.redraw();
        this.titleText.setText(this.tile.getTitle());
        this.text.setText(this.tile.getText());
        this.description.setText(this.tile.getDescription());
        this.description.setAlignment(this.tile.getDescriptionAlignment());
        this.resizeStaticText();
        this.titleText.setFill((Paint)this.tile.getTitleColor());
        this.text.setFill((Paint)this.tile.getTextColor());
        this.description.setTextFill((Paint)this.tile.getDescriptionColor());
        this.ledBorder.setFill(this.borderFill);
        this.led.setFill(this.tile.isActive() ? this.onFill : this.offFill);
        this.hightlight.setFill(this.highlightFill);
    }
}

