/*
 * Decompiled with CFR 0.152.
 */
package mediathek.javafx.tool;

import javafx.application.Application;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.DialogPane;
import javafx.scene.image.Image;
import javafx.scene.layout.Pane;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class JFXHiddenApplication
extends Application {
    private static Stage primaryStage;
    private static final String ICON_NAME = "MediathekView.png";
    private static final String ICON_PATH = "/mediathek/res/";

    public static void launchApplication() {
        new Thread(() -> JFXHiddenApplication.launch((String[])new String[0])).start();
    }

    public static Image getApplicationImage() {
        return new Image(JFXHiddenApplication.class.getResourceAsStream("/mediathek/res/MediathekView.png"));
    }

    public void start(Stage primaryStage) {
        JFXHiddenApplication.primaryStage = primaryStage;
        primaryStage.initStyle(StageStyle.TRANSPARENT);
        primaryStage.setScene(new Scene((Parent)new Pane(), 1.0, 1.0));
        primaryStage.setTitle("MediathekView Invisible Helper Window");
        primaryStage.getIcons().add((Object)JFXHiddenApplication.getApplicationImage());
        primaryStage.show();
        primaryStage.hide();
    }

    public static Stage getPrimaryStage() {
        return primaryStage;
    }

    public static void showJavaFXDialog(Stage fxDialog, JFrame swingParent) {
        fxDialog.setOpacity(0.0);
        fxDialog.show();
        fxDialog.hide();
        fxDialog.setOpacity(1.0);
        fxDialog.setX(swingParent.getBounds().getCenterX() - fxDialog.getWidth() / 2.0);
        fxDialog.setY(swingParent.getBounds().getCenterY() - fxDialog.getHeight() / 2.0);
        JFXHiddenApplication.fakeModalDialog(fxDialog, swingParent);
        fxDialog.setAlwaysOnTop(true);
        fxDialog.showAndWait();
    }

    public static void showAlert(@NotNull Alert alert, @NotNull JFrame swingParent) {
        DialogPane dialogPane = alert.getDialogPane();
        Scene scene = dialogPane.getScene();
        Stage alertStage = new Stage();
        alertStage.getIcons().add((Object)JFXHiddenApplication.getApplicationImage());
        alertStage.setTitle("MediathekView");
        alertStage.setScene(scene);
        alertStage.initModality(Modality.APPLICATION_MODAL);
        alertStage.initOwner((Window)JFXHiddenApplication.getPrimaryStage());
        Button btnFoo = (Button)dialogPane.lookupButton(ButtonType.OK);
        btnFoo.setOnAction(evt -> {
            alertStage.close();
            evt.consume();
        });
        JFXHiddenApplication.showJavaFXDialog(alertStage, swingParent);
    }

    private static void fakeModalDialog(Stage fxDialog, JFrame swingParent) {
        fxDialog.setOnShown(e -> SwingUtilities.invokeLater(() -> {
            swingParent.setEnabled(false);
            if (swingParent.getJMenuBar() != null) {
                swingParent.getJMenuBar().setEnabled(false);
            }
        }));
        fxDialog.setOnHidden(e -> SwingUtilities.invokeLater(() -> {
            swingParent.setEnabled(true);
            if (swingParent.getJMenuBar() != null) {
                swingParent.getJMenuBar().setEnabled(true);
            }
            swingParent.toFront();
        }));
    }
}

