/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool.sender_icon_cache;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.ImageIcon;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import mediathek.gui.messages.SenderIconStyleChangedEvent;
import mediathek.tool.ApplicationConfiguration;
import mediathek.tool.MessageBus;
import mediathek.tool.TimerPool;
import mediathek.tool.sender_icon_cache.SenderIconCacheLoader;
import net.engio.mbassy.listener.Handler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u000f\u001a\u00020\u0004H\u0087\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0003J\b\u0010\u0014\u001a\u00020\u0011H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lmediathek/tool/sender_icon_cache/MVSenderIconCache;", "", "()V", "CONFIG_USE_LOCAL_SENDER_ICONS", "", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "senderCache", "Lcom/google/common/cache/LoadingCache;", "Ljava/util/Optional;", "Ljavax/swing/ImageIcon;", "useLocalIcons", "Ljava/util/concurrent/atomic/AtomicBoolean;", "get", "sender", "handleSenderIconStyleChangedEvent", "", "e", "Lmediathek/gui/messages/SenderIconStyleChangedEvent;", "setupCleanupScheduler", "MediathekView"})
public final class MVSenderIconCache {
    @NotNull
    public static final MVSenderIconCache INSTANCE = new MVSenderIconCache();
    @NotNull
    private static final AtomicBoolean useLocalIcons = new AtomicBoolean(false);
    @NotNull
    private static final LoadingCache<String, Optional<ImageIcon>> senderCache;
    private static final Logger logger;
    @NotNull
    public static final String CONFIG_USE_LOCAL_SENDER_ICONS = "application.sender_icons.use_local";

    private MVSenderIconCache() {
    }

    @Handler
    private final void handleSenderIconStyleChangedEvent(SenderIconStyleChangedEvent e) {
        logger.trace("invalidating caches due to sender icon style change");
        useLocalIcons.set(ApplicationConfiguration.getConfiguration().getBoolean(CONFIG_USE_LOCAL_SENDER_ICONS, false));
        senderCache.invalidateAll();
    }

    private final void setupCleanupScheduler() {
        TimerPool.getTimerPool().scheduleAtFixedRate(MVSenderIconCache::setupCleanupScheduler$lambda-0, 5L, 5L, TimeUnit.MINUTES);
    }

    @JvmStatic
    @NotNull
    public static final Optional<ImageIcon> get(@NotNull String sender) {
        Optional<ImageIcon> optional;
        Intrinsics.checkNotNullParameter(sender, "sender");
        try {
            Optional<ImageIcon> optional2 = senderCache.get(sender);
            Intrinsics.checkNotNullExpressionValue(optional2, "{\n                senderCache[sender]\n        }");
            optional = optional2;
        }
        catch (CacheLoader.InvalidCacheLoadException ex) {
            Optional<ImageIcon> optional3 = Optional.empty();
            Intrinsics.checkNotNullExpressionValue(optional3, "{\n            Optional.empty()\n        }");
            optional = optional3;
        }
        catch (ExecutionException ex) {
            Optional optional4 = Optional.empty();
            Intrinsics.checkNotNullExpressionValue(optional4, "{\n            Optional.empty()\n        }");
            optional = optional4;
        }
        return optional;
    }

    private static final void setupCleanupScheduler$lambda-0() {
        logger.trace("Cleaning sender icon caches");
        senderCache.cleanUp();
    }

    static {
        logger = LogManager.getLogger();
        logger.trace("Initializing sender icon cache...");
        INSTANCE.setupCleanupScheduler();
        LoadingCache loadingCache = CacheBuilder.newBuilder().expireAfterAccess(2L, TimeUnit.HOURS).build(new SenderIconCacheLoader(useLocalIcons));
        Intrinsics.checkNotNullExpressionValue(loadingCache, "newBuilder()\n           \u2026cheLoader(useLocalIcons))");
        senderCache = loadingCache;
        MessageBus.getMessageBus().subscribe(INSTANCE);
        useLocalIcons.set(ApplicationConfiguration.getConfiguration().getBoolean(CONFIG_USE_LOCAL_SENDER_ICONS, false));
    }
}

