/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.openapidiff.core.compare;

import io.swagger.v3.oas.models.security.OAuthFlow;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openapitools.openapidiff.core.compare.OpenApiDiff;
import org.openapitools.openapidiff.core.model.ChangedOAuthFlow;
import org.openapitools.openapidiff.core.utils.ChangedUtils;

public class OAuthFlowDiff {
    private final OpenApiDiff openApiDiff;

    public OAuthFlowDiff(OpenApiDiff openApiDiff) {
        this.openApiDiff = openApiDiff;
    }

    private static Map<String, Object> getExtensions(OAuthFlow oAuthFlow) {
        return Optional.ofNullable(oAuthFlow).map(OAuthFlow::getExtensions).orElse(null);
    }

    public Optional<ChangedOAuthFlow> diff(OAuthFlow left, OAuthFlow right) {
        ChangedOAuthFlow changedOAuthFlow = new ChangedOAuthFlow(left, right);
        if (left != null && right != null) {
            changedOAuthFlow.setAuthorizationUrl(!Objects.equals(left.getAuthorizationUrl(), right.getAuthorizationUrl())).setTokenUrl(!Objects.equals(left.getTokenUrl(), right.getTokenUrl())).setRefreshUrl(!Objects.equals(left.getRefreshUrl(), right.getRefreshUrl()));
        }
        this.openApiDiff.getExtensionsDiff().diff(OAuthFlowDiff.getExtensions(left), OAuthFlowDiff.getExtensions(right)).ifPresent(changedOAuthFlow::setExtensions);
        return ChangedUtils.isChanged(changedOAuthFlow);
    }
}

