/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.painless.ir;

import org.opensearch.painless.ClassWriter;
import org.opensearch.painless.Location;
import org.opensearch.painless.MethodWriter;
import org.opensearch.painless.Operation;
import org.opensearch.painless.ir.UnaryNode;
import org.opensearch.painless.lookup.PainlessLookupUtility;
import org.opensearch.painless.lookup.def;
import org.opensearch.painless.phase.IRTreeVisitor;
import org.opensearch.painless.symbol.WriteScope;
import org.opensearch.repackage.org.objectweb.asm.Label;
import org.opensearch.repackage.org.objectweb.asm.Type;

public class UnaryMathNode
extends UnaryNode {
    private Operation operation;
    private Class<?> unaryType;
    private boolean cat;
    private boolean originallyExplicit;

    public void setOperation(Operation operation) {
        this.operation = operation;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public void setUnaryType(Class<?> unaryType) {
        this.unaryType = unaryType;
    }

    public Class<?> getUnaryType() {
        return this.unaryType;
    }

    public String getUnaryCanonicalTypeName() {
        return PainlessLookupUtility.typeToCanonicalTypeName(this.unaryType);
    }

    public void setCat(boolean cat) {
        this.cat = cat;
    }

    public boolean getCat() {
        return this.cat;
    }

    public void setOriginallyExplicit(boolean originallyExplicit) {
        this.originallyExplicit = originallyExplicit;
    }

    public boolean getOriginallyExplicit() {
        return this.originallyExplicit;
    }

    @Override
    public <Scope> void visit(IRTreeVisitor<Scope> irTreeVisitor, Scope scope) {
        irTreeVisitor.visitUnaryMath(this, scope);
    }

    @Override
    public <Scope> void visitChildren(IRTreeVisitor<Scope> irTreeVisitor, Scope scope) {
        this.getChildNode().visit(irTreeVisitor, scope);
    }

    public UnaryMathNode(Location location) {
        super(location);
    }

    @Override
    public void write(ClassWriter classWriter, MethodWriter methodWriter, WriteScope writeScope) {
        methodWriter.writeDebugInfo(this.getLocation());
        if (this.operation == Operation.NOT) {
            Label fals = new Label();
            Label end = new Label();
            this.getChildNode().write(classWriter, methodWriter, writeScope);
            methodWriter.ifZCmp(153, fals);
            methodWriter.push(false);
            methodWriter.goTo(end);
            methodWriter.mark(fals);
            methodWriter.push(true);
            methodWriter.mark(end);
        } else {
            this.getChildNode().write(classWriter, methodWriter, writeScope);
            int defFlags = 0;
            if (this.originallyExplicit) {
                defFlags |= 4;
            }
            Type actualType = MethodWriter.getType(this.getExpressionType());
            Type childType = MethodWriter.getType(this.getChildNode().getExpressionType());
            if (this.operation == Operation.BWNOT) {
                if (this.getUnaryType() == def.class) {
                    Type descriptor = Type.getMethodType(actualType, childType);
                    methodWriter.invokeDefCall("not", descriptor, 7, defFlags);
                } else {
                    if (this.getUnaryType() == Integer.TYPE) {
                        methodWriter.push(-1);
                    } else if (this.getUnaryType() == Long.TYPE) {
                        methodWriter.push(-1L);
                    } else {
                        throw new IllegalStateException("unexpected unary math operation [" + this.operation + "] for type [" + this.getExpressionCanonicalTypeName() + "]");
                    }
                    methodWriter.math(130, actualType);
                }
            } else if (this.operation == Operation.SUB) {
                if (this.getUnaryType() == def.class) {
                    Type descriptor = Type.getMethodType(actualType, childType);
                    methodWriter.invokeDefCall("neg", descriptor, 7, defFlags);
                } else {
                    methodWriter.math(116, actualType);
                }
            } else if (this.operation == Operation.ADD) {
                if (this.getUnaryType() == def.class) {
                    Type descriptor = Type.getMethodType(actualType, childType);
                    methodWriter.invokeDefCall("plus", descriptor, 7, defFlags);
                }
            } else {
                throw new IllegalStateException("unexpected unary math operation [" + this.operation + "] for type [" + this.getExpressionCanonicalTypeName() + "]");
            }
        }
    }
}

